#pragma once

typedef char utf8_t;

// TRANSACTION STRUCTS-------------------------------
typedef struct _StartReceipt
{
	//! \~polish ilo�� linii
	int numberOfLines;
	//! \~polish linia nr 1
	utf8_t line1[400];
	//! \~polish linia nr 2
	utf8_t line2[400];
	//! \~polish linia nr 3
	utf8_t line3[400];
	//! \~polish Symbol "PL" przed numerem NIP
	int symbolPL ;
	//! \~polish numer identyfikacyjny nabywcy
	utf8_t id[28];
} StartReceipt;

typedef struct _Item
{
	//! \~polish numer linii
	int numberOfLine;
	//! \~polish rodzaj rabatu
	int discountType;
	//! \~polish opis rabatu
	int discountDescription;
	//! \~polish flaga opis towaru
	int fItemDescription ;
	//! \~polish nazwa
	utf8_t name[121];
	//! \~polish kod PLU
	char plu[32] ;
	//! \~polish ilo��
	long long quantity ;
	//! \~polish ilo��
	char qtty[11];
	//! \~polish PTU
	char ptu[2];
	//! \~polish jednostka
	utf8_t unit[40];
	//! \~polish cena
	long long price;
	//! \~polish brutto
	long long brutto ;
	//! \~polish rabat
	long long discount;
	//! \~polish nazwa rabatu
	utf8_t discountName[81];
	//! \~polish opis towaru
	utf8_t itemDescription[400] ;
}Item;

typedef struct _EndReceipt{
	//! \~polish akcja
	int action;
	//! \~polish rabat
	int discount ;
	//! \~polish liczba linii dodatkowych w stopce paragonu
	int numberOfLines;
	//! \~polish rodzaj rabatu
	int discountType;
	//! \~polish nazwa kasjera
	utf8_t cashierName[66];
	//! \~polish linia 1
	char line1[41];
	//! \~polish linia 2
	char line2[41];
	//! \~polish linia 3
	char line3[41];
	//! \~polish wp�ata
	long long value ;
	//! \~polish razem
	long long total ;
	//! \~polish warto�� rabatu
	long long discountValue;
	
}EndReceipt;

typedef struct _EndReceiptWithPaymentMethods1
{
	//! \~polish rodzaj rabatu
	int DiscountType ;
	//! \~polish flaga wp�ata
	int fCash ;
	//! \~polish flaga karta
	int fCard ;
	//! \~polish flaga czek
	int fCheque ;
	//! \~polish flaga bon
	int fBon ;
	//! \~polish flaga przyj�cie
	int fContainerIn ;
	//! \~polish flaga wydanie
	int fContainerOut ;
	//! \~polish flaga reszta
	int fRest ;
	//! \~polish razem
	long long sum ;
	//! \~polish rabat
	long long discount ;
	//! \~polish wp�ata
	long long cash;
	//! \~polish karta
	long long card ;
	//! \~polish czek
	long long cheque ;
	//! \~polish bon
	long long bon ;
	//! \~polish linia nr 1
	char line1[41];
	//! \~polish linia nr 2
	char line2[41];
	//! \~polish linia nr 3
	char line3[41];
	//! \~polish linia nr 4
	char line4[41];
	//! \~polish linia nr 5
	char line5[41];
	//! \~polish nazwa karty
	utf8_t cardName[34];
	//! \~polish nazwa czeku
	utf8_t chequeName[34];
	//! \~polish nazwa bonu
	utf8_t bonName[34];
	//! \~polish kaucje zwr�cone
	long long containerIn ;
	//! \~polish kaucje wydane
	long long containerOut ;
	//! \~polish reszta
	long long rest ;
	//! \~polish nazwa kasjera
	char cashierName[33];
}EndReceiptWithPaymentMethods1;

typedef struct _BailInReceiptLine {
	//! \~polish rodzaj kaucji
	int bailType ;
	//! \~polish numer
	int number;
	//! \~polish ilo�� (liczba)
	long long quantity;
	//! \~polish ilo�� (napis)
	char qtty[11];
	//! \~polish cena
	long long price ;
	//! \~polish warto��
	long long value ;
}BailInReceiptLine;

typedef struct _BailIn {
	//! \~polish kwota
	long long amount ;
	//! \~polish numer opakowania
	int conteinerNumber ;
	//! \~polish ilo�� (liczba)
	long long quantity ;
	//! \~polish ilo�� (napis)
	char qtty[11];
}BailIn;

typedef struct _BailInStorno {
	//! \~polish kwota
	long long amount ;
	//! \~polish numer opakowania
	int conteinerNumber ;
	//! \~polish ilo�� (liczba)
	long long quantity ;
	//! \~polish ilo�� (napis)
	char qtty[11];
}BailInStorno;

typedef struct _BailOut {
	//! \~polish kwota
	long long amount ;
	//! \~polish numer opakowania
	int conteinerNumber ;
	//! \~polish ilo�� (liczba)
	long long quantity ;
	//! \~polish ilo�� (napis)
	char qtty[11];
}BailOut;

typedef struct _BailOutStorno {
	//! \~polish kwota
	long long amount ;
	//! \~polish numer opakowania
	int conteinerNumber ;
	//! \~polish ilo�� (liczba)
	long long quantity ;
	//! \~polish ilo�� (napis)
	char qtty[11];

}BailOutStorno;

typedef struct _AbortTransaction {
	//! \~polish numer kasy
	utf8_t tillNumber[18];
	//! \~polish kasjer
	utf8_t cashier[66];
}AbortTransaction;

typedef struct _Payment {
	// \~polish akcja
	int action ;
	// \~polish typ p�atno�ci
	int paymentMethod;
	//! \~polish kwota
	long long value;
	//! \~polish nazwa
	utf8_t name[50];
}Payment;

typedef struct _DiscountOrMarkupToTransaction {
	//! \~polish rodzaj rabatu
	int discountType ;
	//! \~polish nazwa
	utf8_t discountName[41];
	//! \~polish warto��
	long long value ;
}DiscountOrMarkupToTransaction;

typedef struct _DiscountOrMarkupToPTU
{
	//! \~polish numer stawki
	int PTUNumber ;
	//! \~polish rodzaj rabatu
	int discountType ;
	//! \~polish numer opisu
	int discountNumber ;
	//! \~polish sprzeda�
	long long sales ;
	//! \~polish rabat
	long long discount ;
	//! \~polish opis rabatu
	utf8_t discountDescription[41];
}DiscountOrMarkupToPTU;

typedef struct _DiscountOrMarkupToSubtotal {
	//! \~polish rodzaj rabatu
	int discountType ;
	//! \~polish numer opisu
	int discountNumber ;
	//! \~polish podsuma
	long long Subtotal ;
	//! \~polish rabat
	long long discount ;
	//! \~polish opis rabatu
	utf8_t discountDescription[41];
}DiscountOrMarkupToSubtotal;

typedef struct _StartInvoice {
	//! \~polish Ilo�� linii danych nabywcy faktury
	int numberOfLinesReceiverData;
	//! \~polish orygina�/kopia
	int originalAndCpy ;
	//! \~polish liczba dodatkowych kopii
	int additionalCopy ;
	//! \~polish numer faktury
	int invoiceNumber ;
	//! \~polish g�rny margines
	int upperMargin ;
	//! \~polish miejsce na podpisy 
	int sign ;
	//! \~polish symbol "PL" przed numerem NIP
	int symbolPL ;
	//! \~polish linia nr 1
	utf8_t line1[121];
	//! \~polish linia nr 2
	utf8_t line2[121];
	//! \~polish linia nr 3
	utf8_t line3[121];
	//! \~polish linia nr 4
	utf8_t line4[121];
	//! \~polish linia nr 5
	utf8_t line5[121];
	//! \~polish linia nr 6
	utf8_t line6[121];
	//! \~polish linia nr 7
	utf8_t line7[121];
	//! \~polish linia nr 8
	utf8_t line8[121];
	//! \~polish NIP nabywcy
	char NIP[15];
	//! \~polish termin p�atno�ci
	char paymentDate[18];
	//! \~polish forma p�atno�ci
	utf8_t paymentMethod[41];
	//! \~polish odbiorce
	utf8_t receiverName[56];
	//! \~polish wystawiaj�cy
	utf8_t senderName[56];
	//! \~polish numer systemowy
	utf8_t systemNumber[61];
	//! \~polish nazwa nabywcy
	utf8_t buyerName[56];
   //! \~polish numer faktury
	utf8_t invoiceNumberStr[114];

}StartInvoice;

typedef struct _EndInvoice{
	//! \~polish akcja
	int action;
	//! \~polish rabat
	int discount ;
	//! \~polish ilo�� linii w stopce
	int numberOfLinesFooter ;
	//! \~polish napis "Zap�acono"
	int wordPaid ;
	//! \~polish opcje dla nazwy kupuj�cego
	int receiverSettings ;
	//! \~polish rodzaj rabatu
	int discountType ;
	//! \~polish opcje nazwy dla sprzedaj�cego
	int senderSettings ;
	//! \~polish kod
	char code[9];
	//! \~polish linia nr 1
	utf8_t line1[121];
	//! \~polish linia nr 2
	utf8_t line2[121];
	//! \~polish linia nr 3
	utf8_t line3[121];
	//! \~polish zap�acono
	char paid[30];
	//! \~polish nazwa kupuj�cego
	utf8_t receiverName[121];
	//! \~polish nazwa sprzedaj�cego
	utf8_t senderName[121];
	//! \~polish wp�ata
	long long payment ;
	//! \~polish razem
	long long total ;
	//! \~polish warto�� rabatu
	int discountValue ;
}EndInvoice;

typedef struct _InvoiceOptions
{
	//! \~polish liczba dodatkowych kopii
	int additionalCopies ;
	//! \~polish opcje dla nazwy kupuj�cego
	int buyerNameOption ;
	//! \~polish opcje dla nazwy sprzedaj�cego
	int sellerNameOption ;
	//! \~polish napis "Zap�acono"
	int isPaid ;
	//! \~polish data sprzeda�y: Rok
	char saleDateYear[3];
	//! \~polish data sprzeda�y: Miesi�c
	char saleDateMonth[3];
	//! \~polish data sprzeda�y: Dzie�
	char saleDateDay[3];
	//! \~polish opcje wydruku podsumowania
	int printoutSummaryOption ;
	//! \~polish opcje wydruku 2
	int printoutOption2 ;
	//! \~polish typ numeru identyfikuj�cego kupuj�cego
	int buyerIDType ;
	//! \~polish opcje wydruku 3
	int printoutOption3 ;
	//! \~polish opcje wydruku etykiety "Nabywca"
	int isReceiver ;
	//! \~polish termin p�atno�ci
	char paymentDeadline[17];
	//! \~polish forma p�atno�ci
	utf8_t paymentMethod[41];
	//! \~polish odbiorca
	utf8_t customer[54];
	//! \~polish wystawiaj�cy
	utf8_t issuing[54];
	//! \~polish zap�acono
	char paid[30];
	//! \~polish nuer systemowy
	utf8_t systemNumber[61];
	//! \~polish informacje dodatkowe do faktury
	utf8_t additionalInfo[126];
	//! \~polish nazwa nabywcy
	utf8_t buyerName[514];
}InvoiceOptions;

typedef struct _EndReceiptWithPaymentMethods2 {
	//! \~polish ilo�� linii
	int numberOfLines ;
	//! \~polish zako�czenie
	int end ;
	//! \~polish podsumowanie
	int summary ;
	//! \~polish znak DSP
	int DSPSign ;
	//! \~polish rodzaj rabatu
	int discountType ;
	//! \~polish ilo�� kaucji pobrnych
	int bailInCount ;
	//! \~polish ilo�� kaucji zwr�conych
	int bailOutCount;
	//! \~polish flaga numer systemowy
	int fSystemNumber ;
	//! \~polish ilo�� form p�atno�ci
	int paymentMethodsCount ;
	//! \~polish flaga reszta
	int fRest ;
	//! \~polish flaga wp�ata
	int fPayment ;
	//! \~polish typ p�atno�ci nr 1
	int paymentMethodType1 ;
	//! \~polish typ p�atno�ci nr 2
	int paymentMethodType2 ;
	//! \~polish typ p�atno�ci nr 3
	int paymentMethodType3 ;
	//! \~polish typ p�atno�ci nr 4
	int paymentMethodType4 ;
	//! \~polish typ p�atno�ci nr 5
	int paymentMethodType5 ;
	//! \~polish typ p�atno�ci nr 6
	int paymentMethodType6 ;
	//! \~polish typ p�atno�ci nr 7
	int paymentMethodType7 ;
	//! \~polish typ p�atno�ci nr 8
	int paymentMethodType8 ;
	//! \~polish typ p�atno�ci nr 9
	int paymentMethodType9 ;
	//! \~polish typ p�atno�ci nr 10
	int paymentMethodType10 ;
	//! \~polish typ p�atno�ci nr 11
	int paymentMethodType11 ;
	//! \~polish typ p�atno�ci nr 12
	int paymentMethodType12 ;
	//! \~polish typ p�atno�ci nr 13
	int paymentMethodType13 ;
	//! \~polish typ p�atno�ci nr 14
	int paymentMethodType14 ;
	//! \~polish typ p�atno�ci nr 15
	int paymentMethodType15 ;
	//! \~polish typ p�atno�ci nr 16
	int paymentMethodType16 ;
	//! \~polish numer kasy
	utf8_t tillNumber[18];
	//! \~polish kasjer
	utf8_t cashier[66];
	//! \~polish numer systemowy
	utf8_t systemNumber[1026];
	//! \~polish linia nr 1
	utf8_t line1[41];
	//! \~polish linia nr 2
	utf8_t line2[41];
	//! \~polish linia nr 3
	utf8_t line3[41];
	//! \~polish nazwa formy p�atno�ci nr 1
	utf8_t paymentMethodName1[50];
	//! \~polish nazwa formy p�atno�ci nr 2
	utf8_t paymentMethodName2[50];
	//! \~polish nazwa formy p�atno�ci nr 3
	utf8_t paymentMethodName3[50];
	//! \~polish nazwa formy p�atno�ci nr 4
	utf8_t paymentMethodName4[50];
	//! \~polish nazwa formy p�atno�ci nr 5
	utf8_t paymentMethodName5[50];
	//! \~polish nazwa formy p�atno�ci nr 6
	utf8_t paymentMethodName6[50];
	//! \~polish nazwa formy p�atno�ci nr 7
	utf8_t paymentMethodName7[50];
	//! \~polish nazwa formy p�atno�ci nr 8
	utf8_t paymentMethodName8[50];
	//! \~polish nazwa formy p�atno�ci nr 9
	utf8_t paymentMethodName9[50];
	//! \~polish nazwa formy p�atno�ci nr 10
	utf8_t paymentMethodName10[50];
	//! \~polish nazwa formy p�atno�ci nr 11
	utf8_t paymentMethodName11[50];
	//! \~polish nazwa formy p�atno�ci nr 12
	utf8_t paymentMethodName12[50];
	//! \~polish nazwa formy p�atno�ci nr 13
	utf8_t paymentMethodName13[50];
	//! \~polish nazwa formy p�atno�ci nr 14
	utf8_t paymentMethodName14[50];
	//! \~polish nazwa formy p�atno�ci nr 15
	utf8_t paymentMethodName15[50];
	//! \~polish nazwa formy p�atno�ci nr 16
	utf8_t paymentMethodName16[50];
	//! \~polish numer kaucji pobranej nr 1
	char bailInNumber1[4];
	//! \~polish numer kaucji pobranej nr 2
	char bailInNumber2[4];
	//! \~polish numer kaucji pobranej nr 3
	char bailInNumber3[4];
	//! \~polish numer kaucji pobranej nr 4
	char bailInNumber4[4];
	//! \~polish numer kaucji pobranej nr 5
	char bailInNumber5[4];
	//! \~polish numer kaucji pobranej nr 6
	char bailInNumber6[4];
	//! \~polish numer kaucji pobranej nr 7
	char bailInNumber7[4];
	//! \~polish numer kaucji pobranej nr 8
	char bailInNumber8[4];
	//! \~polish numer kaucji pobranej nr 9
	char bailInNumber9[4];
	//! \~polish numer kaucji pobranej nr 10
	char bailInNumber10[4];
	//! \~polish numer kaucji pobranej nr 11
	char bailInNumber11[4];
	//! \~polish numer kaucji pobranej nr 12
	char bailInNumber12[4];
	//! \~polish numer kaucji pobranej nr 13
	char bailInNumber13[4];
	//! \~polish numer kaucji pobranej nr 14
	char bailInNumber14[4];
	//! \~polish numer kaucji pobranej nr 15
	char bailInNumber15[4];
	//! \~polish numer kaucji pobranej nr 16
	char bailInNumber16[4];
	//! \~polish numer kaucji pobranej nr 17
	char bailInNumber17[4];
	//! \~polish numer kaucji pobranej nr 18
	char bailInNumber18[4];
	//! \~polish numer kaucji pobranej nr 19
	char bailInNumber19[4];
	//! \~polish numer kaucji pobranej nr 20
	char bailInNumber20[4];
	//! \~polish numer kaucji pobranej nr 21
	char bailInNumber21[4];
	//! \~polish numer kaucji pobranej nr 22
	char bailInNumber22[4];
	//! \~polish numer kaucji pobranej nr 23
	char bailInNumber23[4];
	//! \~polish numer kaucji pobranej nr 24
	char bailInNumber24[4];
	//! \~polish numer kaucji pobranej nr 25
	char bailInNumber25[4];
	//! \~polish numer kaucji pobranej nr 26
	char bailInNumber26[4];
	//! \~polish numer kaucji pobranej nr 27
	char bailInNumber27[4];
	//! \~polish numer kaucji pobranej nr 28
	char bailInNumber28[4];
	//! \~polish numer kaucji pobranej nr 29
	char bailInNumber29[4];
	//! \~polish numer kaucji pobranej nr 30
	char bailInNumber30[4];
	//! \~polish numer kaucji pobranej nr 31
	char bailInNumber31[4];
	//! \~polish numer kaucji pobranej nr 32
	char bailInNumber32[4];
	//! \~polish ilo�� kaucji pobranej nr 1
	char bailInAmount1[16];
	//! \~polish ilo�� kaucji pobranej nr 2
	char bailInAmount2[16];
	//! \~polish ilo�� kaucji pobranej nr 3
	char bailInAmount3[16];
	//! \~polish ilo�� kaucji pobranej nr 4
	char bailInAmount4[16];
	//! \~polish ilo�� kaucji pobranej nr 5
	char bailInAmount5[16];
	//! \~polish ilo�� kaucji pobranej nr 6
	char bailInAmount6[16];
	//! \~polish ilo�� kaucji pobranej nr 7
	char bailInAmount7[16];
	//! \~polish ilo�� kaucji pobranej nr 8
	char bailInAmount8[16];
	//! \~polish ilo�� kaucji pobranej nr 9
	char bailInAmount9[16];
	//! \~polish ilo�� kaucji pobranej nr 10
	char bailInAmount10[16];
	//! \~polish ilo�� kaucji pobranej nr 11
	char bailInAmount11[16];
	//! \~polish ilo�� kaucji pobranej nr 12
	char bailInAmount12[16];
	//! \~polish ilo�� kaucji pobranej nr 13
	char bailInAmount13[16];
	//! \~polish ilo�� kaucji pobranej nr 14
	char bailInAmount14[16];
	//! \~polish ilo�� kaucji pobranej nr 15
	char bailInAmount15[16];
	//! \~polish ilo�� kaucji pobranej nr 16
	char bailInAmount16[16];
	//! \~polish ilo�� kaucji pobranej nr 17
	char bailInAmount17[16];
	//! \~polish ilo�� kaucji pobranej nr 18
	char bailInAmount18[16];
	//! \~polish ilo�� kaucji pobranej nr 19
	char bailInAmount19[16];
	//! \~polish ilo�� kaucji pobranej nr 20
	char bailInAmount20[16];
	//! \~polish ilo�� kaucji pobranej nr 21
	char bailInAmount21[16];
	//! \~polish ilo�� kaucji pobranej nr 22
	char bailInAmount22[16];
	//! \~polish ilo�� kaucji pobranej nr 23
	char bailInAmount23[16];
	//! \~polish ilo�� kaucji pobranej nr 24
	char bailInAmount24[16];
	//! \~polish ilo�� kaucji pobranej nr 25
	char bailInAmount25[16];
	//! \~polish ilo�� kaucji pobranej nr 26
	char bailInAmount26[16];
	//! \~polish ilo�� kaucji pobranej nr 27
	char bailInAmount27[16];
	//! \~polish ilo�� kaucji pobranej nr 28
	char bailInAmount28[16];
	//! \~polish ilo�� kaucji pobranej nr 29
	char bailInAmount29[16];
	//! \~polish ilo�� kaucji pobranej nr 30
	char bailInAmount30[16];
	//! \~polish ilo�� kaucji pobranej nr 31
	char bailInAmount31[16];
	//! \~polish ilo�� kaucji pobranej nr 32
	char bailInAmount32[16];
	//! \~polish numer kaucji zwr�conej nr 1
	char bailOutNumber1[4];
	//! \~polish numer kaucji zwr�conej nr 2
	char bailOutNumber2[4];
	//! \~polish numer kaucji zwr�conej nr 3
	char bailOutNumber3[4];
	//! \~polish numer kaucji zwr�conej nr 4
	char bailOutNumber4[4];
	//! \~polish numer kaucji zwr�conej nr 5
	char bailOutNumber5[4];
	//! \~polish numer kaucji zwr�conej nr 6
	char bailOutNumber6[4];
	//! \~polish numer kaucji zwr�conej nr 7
	char bailOutNumber7[4];
	//! \~polish numer kaucji zwr�conej nr 8
	char bailOutNumber8[4];
	//! \~polish numer kaucji zwr�conej nr 9
	char bailOutNumber9[4];
	//! \~polish numer kaucji zwr�conej nr 10
	char bailOutNumber10[4];
	//! \~polish numer kaucji zwr�conej nr 11
	char bailOutNumber11[4];
	//! \~polish numer kaucji zwr�conej nr 12
	char bailOutNumber12[4] ;
	//! \~polish numer kaucji zwr�conej nr 13
	char bailOutNumber13[4] ;
	//! \~polish numer kaucji zwr�conej nr 14
	char bailOutNumber14[4] ;
	//! \~polish numer kaucji zwr�conej nr 15
	char bailOutNumber15[4] ;
	//! \~polish numer kaucji zwr�conej nr 16
	char bailOutNumber16[4] ;
	//! \~polish numer kaucji zwr�conej nr 17
	char bailOutNumber17[4] ;
	//! \~polish numer kaucji zwr�conej nr 18
	char bailOutNumber18[4] ;
	//! \~polish numer kaucji zwr�conej nr 19
	char bailOutNumber19[4] ;
	//! \~polish numer kaucji zwr�conej nr 20
	char bailOutNumber20[4] ;
	//! \~polish numer kaucji zwr�conej nr 21
	char bailOutNumber21[4] ;
	//! \~polish numer kaucji zwr�conej nr 22
	char bailOutNumber22[4] ;
	//! \~polish numer kaucji zwr�conej nr 23
	char bailOutNumber23[4] ;
	//! \~polish numer kaucji zwr�conej nr 24
	char bailOutNumber24[4] ;
	//! \~polish numer kaucji zwr�conej nr 25
	char bailOutNumber25[4] ;
	//! \~polish numer kaucji zwr�conej nr 26
	char bailOutNumber26[4] ;
	//! \~polish numer kaucji zwr�conej nr 27
	char bailOutNumber27[4] ;
	//! \~polish numer kaucji zwr�conej nr 28
	char bailOutNumber28[4] ;
	//! \~polish numer kaucji zwr�conej nr 29
	char bailOutNumber29[4] ;
	//! \~polish numer kaucji zwr�conej nr 30
	char bailOutNumber30[4] ;
	//! \~polish numer kaucji zwr�conej nr 31
	char bailOutNumber31[4] ;
	//! \~polish numer kaucji zwr�conej nr 32
	char bailOutNumber32[4] ;
	//! \~polish ilo�� kaucji zwr�conej nr 1
	char bailOutAmount1[16];
	//! \~polish ilo�� kaucji zwr�conej nr 2
	char bailOutAmount2[16];
	//! \~polish ilo�� kaucji zwr�conej nr 3
	char bailOutAmount3[16];
	//! \~polish ilo�� kaucji zwr�conej nr 4
	char bailOutAmount4[16];
	//! \~polish ilo�� kaucji zwr�conej nr 5
	char bailOutAmount5[16];
	//! \~polish ilo�� kaucji zwr�conej nr 6
	char bailOutAmount6[16];
	//! \~polish ilo�� kaucji zwr�conej nr 7
	char bailOutAmount7[16];
	//! \~polish ilo�� kaucji zwr�conej nr 8
	char bailOutAmount8[16];
	//! \~polish ilo�� kaucji zwr�conej nr 9
	char bailOutAmount9[16];
	//! \~polish ilo�� kaucji zwr�conej nr 10
	char bailOutAmount10[16];
	//! \~polish ilo�� kaucji zwr�conej nr 11
	char bailOutAmount11[16];
	//! \~polish ilo�� kaucji zwr�conej nr 12
	char bailOutAmount12[16];
	//! \~polish ilo�� kaucji zwr�conej nr 13
	char bailOutAmount13[16];
	//! \~polish ilo�� kaucji zwr�conej nr 14
	char bailOutAmount14[16];
	//! \~polish ilo�� kaucji zwr�conej nr 15
	char bailOutAmount15[16];
	//! \~polish ilo�� kaucji zwr�conej nr 16
	char bailOutAmount16[16];
	//! \~polish ilo�� kaucji zwr�conej nr 17
	char bailOutAmount17[16];
	//! \~polish ilo�� kaucji zwr�conej nr 18
	char bailOutAmount18[16];
	//! \~polish ilo�� kaucji zwr�conej nr 19
	char bailOutAmount19[16];
	//! \~polish ilo�� kaucji zwr�conej nr 20
	char bailOutAmount20[16];
	//! \~polish ilo�� kaucji zwr�conej nr 21
	char bailOutAmount21[16];
	//! \~polish ilo�� kaucji zwr�conej nr 22
	char bailOutAmount22[16];
	//! \~polish ilo�� kaucji zwr�conej nr 23
	char bailOutAmount23[16];
	//! \~polish ilo�� kaucji zwr�conej nr 24
	char bailOutAmount24[16];
	//! \~polish ilo�� kaucji zwr�conej nr 25
	char bailOutAmount25[16];
	//! \~polish ilo�� kaucji zwr�conej nr 26
	char bailOutAmount26[16];
	//! \~polish ilo�� kaucji zwr�conej nr 27
	char bailOutAmount27[16];
	//! \~polish ilo�� kaucji zwr�conej nr 28
	char bailOutAmount28[16];
	//! \~polish ilo�� kaucji zwr�conej nr 29
	char bailOutAmount29[16];
	//! \~polish ilo�� kaucji zwr�conej nr 30
	char bailOutAmount30[16];
	//! \~polish ilo�� kaucji zwr�conej nr 31
	char bailOutAmount31[16];
	//! \~polish ilo�� kaucji zwr�conej nr 32
	char bailOutAmount32[16];
	//! \~polish razem
	long long total ;
	//! \~polish DSP
	long long DSP ;
	//! \~polish rabat
	long long discount ;
	//! \~polish wp�ata
	long long payment ;
	//! \~polish kwota formy p�atno�ci nr 1
	long long paymentMethod1 ;
	//! \~polish kwota formy p�atno�ci nr 2
	long long paymentMethod2 ;
	//! \~polish kwota formy p�atno�ci nr 3
	long long paymentMethod3 ;
	//! \~polish kwota formy p�atno�ci nr 4
	long long paymentMethod4 ;
	//! \~polish kwota formy p�atno�ci nr 5
	long long paymentMethod5 ;
	//! \~polish kwota formy p�atno�ci nr 6
	long long paymentMethod6 ;
	//! \~polish kwota formy p�atno�ci nr 7
	long long paymentMethod7 ;
	//! \~polish kwota formy p�atno�ci nr 8
	long long paymentMethod8 ;
	//! \~polish kwota formy p�atno�ci nr 9
	long long paymentMethod9 ;
	//! \~polish kwota formy p�atno�ci nr 10
	long long paymentMethod10 ;
	//! \~polish kwota formy p�atno�ci nr 11
	long long paymentMethod11 ;
	//! \~polish kwota formy p�atno�ci nr 12
	long long paymentMethod12 ;
	//! \~polish kwota formy p�atno�ci nr 13
	long long paymentMethod13 ;
	//! \~polish kwota formy p�atno�ci nr 14
	long long paymentMethod14 ;
	//! \~polish kwota formy p�atno�ci nr 15
	long long paymentMethod15 ;
	//! \~polish kwota formy p�atno�ci nr 16
	long long paymentMethod16 ;
	//! \~polish reszta
	long long rest ;
	//! \~polish kwota kaucji pobranej nr 1
	long long bailIn1 ;
	//! \~polish kwota kaucji pobranej nr 2
	long long bailIn2 ;
	//! \~polish kwota kaucji pobranej nr 3
	long long bailIn3 ;
	//! \~polish kwota kaucji pobranej nr 4
	long long bailIn4 ;
	//! \~polish kwota kaucji pobranej nr 5
	long long bailIn5 ;
	//! \~polish kwota kaucji pobranej nr 6
	long long bailIn6 ;
	//! \~polish kwota kaucji pobranej nr 7
	long long bailIn7 ;
	//! \~polish kwota kaucji pobranej nr 8
	long long bailIn8 ;
	//! \~polish kwota kaucji pobranej nr 9
	long long bailIn9 ;
	//! \~polish kwota kaucji pobranej nr 10
	long long bailIn10 ;
	//! \~polish kwota kaucji pobranej nr 11
	long long bailIn11 ;
	//! \~polish kwota kaucji pobranej nr 12
	long long bailIn12 ;
	//! \~polish kwota kaucji pobranej nr 13
	long long bailIn13 ;
	//! \~polish kwota kaucji pobranej nr 14
	long long bailIn14 ;
	//! \~polish kwota kaucji pobranej nr 15
	long long bailIn15 ;
	//! \~polish kwota kaucji pobranej nr 16
	long long bailIn16 ;
	//! \~polish kwota kaucji pobranej nr 17
	long long bailIn17 ;
	//! \~polish kwota kaucji pobranej nr 18
	long long bailIn18 ;
	//! \~polish kwota kaucji pobranej nr 19
	long long bailIn19 ;
	//! \~polish kwota kaucji pobranej nr 20
	long long bailIn20 ;
	//! \~polish kwota kaucji pobranej nr 21
	long long bailIn21 ;
	//! \~polish kwota kaucji pobranej nr 22
	long long bailIn22 ;
	//! \~polish kwota kaucji pobranej nr 23
	long long bailIn23 ;
	//! \~polish kwota kaucji pobranej nr 24
	long long bailIn24 ;
	//! \~polish kwota kaucji pobranej nr 25
	long long bailIn25 ;
	//! \~polish kwota kaucji pobranej nr 26
	long long bailIn26 ;
	//! \~polish kwota kaucji pobranej nr 27
	long long bailIn27 ;
	//! \~polish kwota kaucji pobranej nr 28
	long long bailIn28 ;
	//! \~polish kwota kaucji pobranej nr 29
	long long bailIn29 ;
	//! \~polish kwota kaucji pobranej nr 30
	long long bailIn30 ;
	//! \~polish kwota kaucji pobranej nr 31
	long long bailIn31 ;
	//! \~polish kwota kaucji pobranej nr 32
	long long bailIn32 ;
	//! \~polish kwota kaucji zwr�conej nr 1
	long long bailOut1 ;
	//! \~polish kwota kaucji zwr�conej nr 2
	long long bailOut2 ;
	//! \~polish kwota kaucji zwr�conej nr 3
	long long bailOut3 ;
	//! \~polish kwota kaucji zwr�conej nr 4
	long long bailOut4 ;
	//! \~polish kwota kaucji zwr�conej nr 5
	long long bailOut5 ;
	//! \~polish kwota kaucji zwr�conej nr 6
	long long bailOut6 ;
	//! \~polish kwota kaucji zwr�conej nr 7
	long long bailOut7 ;
	//! \~polish kwota kaucji zwr�conej nr 8
	long long bailOut8 ;
	//! \~polish kwota kaucji zwr�conej nr 9
	long long bailOut9 ;
	//! \~polish kwota kaucji zwr�conej nr 10
	long long bailOut10 ;
	//! \~polish kwota kaucji zwr�conej nr 11
	long long bailOut11 ;
	//! \~polish kwota kaucji zwr�conej nr 12
	long long bailOut12 ;
	//! \~polish kwota kaucji zwr�conej nr 13
	long long bailOut13 ;
	//! \~polish kwota kaucji zwr�conej nr 14
	long long bailOut14 ;
	//! \~polish kwota kaucji zwr�conej nr 15
	long long bailOut15 ;
	//! \~polish kwota kaucji zwr�conej nr 16
	long long bailOut16 ;
	//! \~polish kwota kaucji zwr�conej nr 17
	long long bailOut17 ;
	//! \~polish kwota kaucji zwr�conej nr 18
	long long bailOut18 ;
	//! \~polish kwota kaucji zwr�conej nr 19
	long long bailOut19 ;
	//! \~polish kwota kaucji zwr�conej nr 20
	long long bailOut20 ;
	//! \~polish kwota kaucji zwr�conej nr 21
	long long bailOut21 ;
	//! \~polish kwota kaucji zwr�conej nr 22
	long long bailOut22 ;
	//! \~polish kwota kaucji zwr�conej nr 23
	long long bailOut23 ;
	//! \~polish kwota kaucji zwr�conej nr 24
	long long bailOut24 ;
	//! \~polish kwota kaucji zwr�conej nr 25
	long long bailOut25 ;
	//! \~polish kwota kaucji zwr�conej nr 26
	long long bailOut26 ;
	//! \~polish kwota kaucji zwr�conej nr 27
	long long bailOut27 ;
	//! \~polish kwota kaucji zwr�conej nr 28
	long long bailOut28 ;
	//! \~polish kwota kaucji zwr�conej nr 29
	long long bailOut29 ;
	//! \~polish kwota kaucji zwr�conej nr 30
	long long bailOut30 ;
	//! \~polish kwota kaucji zwr�conej nr 31
	long long bailOut31 ;
	//! \~polish kwota kaucji zwr�conej nr 32
	long long bailOut32 ;
	//! \~polish druga wersja numeru systemowego (gdy *systemNumber == 0)
	utf8_t systemNumberLong[513];
}EndReceiptWithPaymentMethods2;

typedef struct _PrintEnd {
	//! \~polish zako�czenie
	int end ;
}PrintEnd;


//REPORT STRUCTS-------------------------------

typedef struct _ChangeReport
{
	//! \~polish rodaj raportu
	int type;
	//! \~polish zmiana
	utf8_t change[18];
	//! \~polish kasjer
	utf8_t cashier[66];
	//! \~polish numer kasy
	utf8_t cashNumber[18];
	//! \~polish nazwa karty nr 1
	utf8_t cardName1[34];
	//! \~polish nazwa karty nr 2
	utf8_t cardName2[34];
	//! \~polish nazwa karty nr 3
	utf8_t cardName3[34];
	//! \~polish nazwa karty nr 4
	utf8_t cardName4[34];
	//! \~polish nazwa karty nr 5
	utf8_t cardName5[34];
	//! \~polish nazwa karty nr 6
	utf8_t cardName6[34];
	//! \~polish nazwa karty nr 7
	utf8_t cardName7[34];
	//! \~polish nazwa karty nr 8
	utf8_t cardName8[34];
	//! \~polish nazwa czeku nr 1
	utf8_t chequeName1[34];
	//! \~polish nazwa czeku nr 2
	utf8_t chequeName2[34];
	//! \~polish nazwa czeku nr 3
	utf8_t chequeName3[34];
	//! \~polish nazwa czeku nr 4
	utf8_t chequeName4[34];
	//! \~polish nazwa bonu nr 1 
	utf8_t bonName1[34];
	//! \~polish nazwa bonu nr 2 
	utf8_t bonName2[34];
	//! \~polish nazwa bonu nr 3
	utf8_t bonName3[34];
	//! \~polish nazwa bonu nr 4
	utf8_t bonName4[34];
	//! \~polish pocz�tek
	char begin[16];
	//! \~polish koniec
	char end[16];
	//! \~polish przych�d
	long long income ;
	//! \~polish got�wka
	long long cash ;
	//! \~polish karta nr 1
	long long card1 ;
	//! \~polish karta nr 2
	long long card2 ;
	//! \~polish karta nr 3
	long long card3 ;
	//! \~polish karta nr 4
	long long card4 ;
	//! \~polish karta nr 5
	long long card5 ;
	//! \~polish karta nr 6
	long long card6 ;
	//! \~polish karta nr 7
	long long card7 ;
	//! \~polish karta nr 8
	long long card8 ;
	//! \~polish czek nr 1
	long long cheque1 ;
	//! \~polish czek nr 2
	long long cheque2 ;
	//! \~polish czek nr 3
	long long cheque3 ;
	//! \~polish czek nr 4
	long long cheque4 ;
	//! \~polish bon nr 1
	long long bon1 ;
	//! \~polish bon nr 2
	long long bon2 ;
	//! \~polish bon nr 3
	long long bon3 ;
	//! \~polish bon nr 4
	long long bon4 ;
	//! \~polish wp�aty
	long long cashIn ;
	//! \~polish przyjecia
	long long containersIn ;
	//! \~polish wyp�aty
	long long cashOut ;
	//! \~polish wydania
	long long containersOut ;
	//! \~polish stan kasy
	long long cashState ;
	//! \~polish ilo�� paragon�w
	char receiptQuantity[6];
	//! \~polish ilo�� anulowanych
	char abortQuantity[6];
	//! \~polish ilo�� STORNO
	char stornoQuantity[6];
}ChangeReport;

typedef struct _DailyReport
{
	//! \~polish rok
	char year[3];
	//! \~polish miesi�c
	char month[3];
	//! \~polish dzie�
	char day[3];
	//! \~polish numer kasy
	utf8_t cashNumber[18];
	//! \~polish kasjer
	utf8_t cashier[66];
}DailyReport;

typedef struct _PeriodicReport
{
	//! \~polish data pocz�tkowa: rok
	char beginYear[3];
	//! \~polish data pocz�tkowa: miesi�c
	char beginMonth[3];
	//! \~polish data pocz�tkowa: dzie�
	char beginDay[3];
	//! \~polish data ko�cowa: rok
	char endYear[3];
	//! \~polish data ko�cowa: miesi�c
	char endMonth[3];
	//! \~polish data ko�cowa: dzie�
	char endDay[3];
	//! \~polish rodzaj raportu
	int type ;
	//! \~polish kasjer
	utf8_t cashier[66];
	//! \~polish numer kasy
	utf8_t cashNumber[18];
	//! \~polish numer pocz�tkowy
	char beginNr[11];
	//! \~polish numer ko�cowy
	char endNr[11];
}PeriodicReport;

typedef struct _Cashier
{
	//! \~polish akcja
	int action ;
	//! \~polish kasjer
	utf8_t cashier[66];
	//! \~polish numer kasy
	utf8_t cashNumber[18];
}Cashier;

typedef struct _PrintoutFromPM
{
	//! \~polish typ zakresu
	int type ;
	//! \~polish filtr wydruk�w
	int printoutFilter ;
	//! \~polish zakres od
	char rangeFrom[20] ;
	//! \~polish zakres do
	char rangeTo[20] ;
}PrintoutFromPM;

typedef struct _ServiceReview
{
	//! \~polish serwisant
	utf8_t serviceman[32];
}ServiceReview;

typedef struct _FiscalMemory
{
	//! \~polish typ raportu
	int type ;
	//! \~polish numer pocz�tkowy
	long long beginNr ;
	//! \~polish numer ko�cowy
	long long endNr ;
	//! \~polish opcje raportu
	char options[3];
	//! \~polish data pocz�tkowa (format: "RRR-MM-DD)
	char beginDate[11];
	//! \~polish data ko�cowa (format: "RRR-MM-DD)
	char endDate[11];
}FiscalMemory;

typedef struct _JPK
{
	//! \~polish stan
	int state ;
	//! \~polish typ zakresu
	int rangeType;
	//! \~polish typ dokumentu
	int documentType ;
	//! \~polish zakres od
	char rangeFrom[20];
	//! \~polish zakres do
	char rangeTo[20];
	//! \~polish JPK ID
	long long jpkID ;
	//! \~polish czy z IDZ
	int isIDZ ;
	//! \~polish zawarto��
	int value ;
	//! \~polish numer raportu dobowego 
	int reportNr ;
	//! \~polish numer paragonu
	int receiptNr ;
}JPK;

typedef struct _ProtectedMemory
{
	//! \~polish stan
	int state ;
	//! \~polish numer raportu
	int reportNr ;
}ProtectedMemory;

typedef struct _CashState
{
	//! \~polish numer kasy
	utf8_t cashNumber[18];
	//! \~polish kasjer
	utf8_t cashier[66];
}CashState;

typedef struct _NonFiscalPrintout
{
	//! \~polish numer wydruku
	int printOutNumber ;
	//! \~polish numer nag��wka
	int headerNumber ;
	//! \~polish numer linii
	int lineNumber ;
	//! \~polish opcje wydruku
	int printOutOption ;
	//! \~polish formatowanie tekstu: pogrubienie
	int textBoldFormat ;
	//! \~polish formatowanie tekstu: inwers
	int textInversFormat ;
	//! \~polish czcionka
	int font ;
	//! \~polish formatowanie tekstu: wycentrowanie
	int textCenterFormat ;
	//! \~polish atrybuty czcionki
	int fontAtributes ;
	//! \~polish linia nr 1
	utf8_t line1[130];
	//! \~polish linia nr 2
	utf8_t line2[130];
	//! \~polish linia nr 3
	utf8_t line3[130];
	//! \~polish linia nr 4
	utf8_t line4[130];
	//! \~polish linia nr 5
	utf8_t line5[130];
	//! \~polish linia nr 6
	utf8_t line6[130];
	//! \~polish linia nr 7
	utf8_t line7[130];
	//! \~polish linia nr 8
	utf8_t line8[130];
	//! \~polish wyst�puje numer systemowy
	int isSystemNumber ;
	//! \~polish ilo�� linii dodatkowych
	int additionalLineNumber ;
	//! \~polish linia nr 1
	utf8_t additionalLine1[130];
	//! \~polish linia nr 2
	utf8_t additionalLine2[130];
	//! \~polish linia nr 3
	utf8_t additionalLine3[130];
	//! \~polish numer systemowy
	utf8_t systemNumber[34];
	//! \~polish id wydruku
	utf8_t idTransaction[200];
	//! \~polish czy id transakcji wyst�puje 
	int isIdTransaction;
	//! \~polish protok� eDokumentu 
	int protocol;
	//! \~polish wyst�puje tryb wysy�ania eDokument�w
	int isEDocumentSendMode;
	//! \~polish tryb wysy�ania eDokument�w
	int eDocumentSendMode;
}NonFiscalPrintout;

typedef struct _CashierStatus{
	utf8_t cashierName[66];
	utf8_t cashNumber[18];
	int state;

}CashierStatus;

typedef struct _ChangeReport2 {

	//! \~polish ilo�� kaucji pobranych
	int bailInCount ;
	//! \~polish ilo�� kaucji zwr�conych
	int bailOutCount ;
	//! \~polish ilo�� form p�atno�ci
	int paymentMethodsCount ;
	//! \~polish flaga got�wka
	int fCash ;
	//! \~polish typ p�atno�ci nr 1
	int paymentType1 ;
	//! \~polish typ p�atno�ci nr 2
	int paymentType2 ;
	//! \~polish typ p�atno�ci nr 3
	int paymentType3 ;
	//! \~polish typ p�atno�ci nr 4
	int paymentType4 ;
	//! \~polish typ p�atno�ci nr 5
	int paymentType5 ;
	//! \~polish typ p�atno�ci nr 6
	int paymentType6 ;
	//! \~polish typ p�atno�ci nr 7
	int paymentType7 ;
	//! \~polish typ p�atno�ci nr 8
	int paymentType8 ;
	//! \~polish typ p�atno�ci nr 9
	int paymentType9 ;
	//! \~polish typ p�atno�ci nr 10
	int paymentType10 ;
	//! \~polish typ p�atno�ci nr 11
	int paymentType11 ;
	//! \~polish typ p�atno�ci nr 12
	int paymentType12 ;
	//! \~polish typ p�atno�ci nr 13
	int paymentType13 ;
	//! \~polish typ p�atno�ci nr 14
	int paymentType14 ;
	//! \~polish typ p�atno�ci nr 15
	int paymentType15 ;
	//! \~polish typ p�atno�ci nr 16
	int paymentType16 ;
	//! \~polish zmiana
	char change[9];
	//! \~polish numer kasy
	utf8_t tillNumber[18];
	//! \~polish kasjer
	utf8_t cashier[66];
	//! \~polish pocz�tek
	char begin[16];
	//! \~polish koniec
	char end[16];
	//! \~polish nazwa formy p�atno�ci nr 1
	utf8_t paymentMethodName1[34];
	//! \~polish nazwa formy p�atno�ci nr 2
	utf8_t paymentMethodName2[34];
	//! \~polish nazwa formy p�atno�ci nr 3
	utf8_t paymentMethodName3[34];
	//! \~polish nazwa formy p�atno�ci nr 4
	utf8_t paymentMethodName4[34];
	//! \~polish nazwa formy p�atno�ci nr 5
	utf8_t paymentMethodName5[34];
	//! \~polish nazwa formy p�atno�ci nr 6
	utf8_t paymentMethodName6[34];
	//! \~polish nazwa formy p�atno�ci nr 7
	utf8_t paymentMethodName7[34];
	//! \~polish nazwa formy p�atno�ci nr 8
	utf8_t paymentMethodName8[34];
	//! \~polish nazwa formy p�atno�ci nr 9
	utf8_t paymentMethodName9[34];
	//! \~polish nazwa formy p�atno�ci nr 10
	utf8_t paymentMethodName10[34];
	//! \~polish nazwa formy p�atno�ci nr 11
	utf8_t paymentMethodName11[34];
	//! \~polish nazwa formy p�atno�ci nr 12
	utf8_t paymentMethodName12[34];
	//! \~polish nazwa formy p�atno�ci nr 13
	utf8_t paymentMethodName13[34];
	//! \~polish nazwa formy p�atno�ci nr 14
	utf8_t paymentMethodName14[34];
	//! \~polish nazwa formy p�atno�ci nr 15
	utf8_t paymentMethodName15[34];
	//! \~polish nazwa formy p�atno�ci nr 16
	utf8_t paymentMethodName16[34];
	//! \~polish nazwa kaucji pobranej nr 1
	utf8_t bailInName1[50];
	//! \~polish nazwa kaucji pobranej nr 
	utf8_t bailInName2[50];
	//! \~polish nazwa kaucji pobranej nr 
	utf8_t bailInName3[50];
	//! \~polish nazwa kaucji pobranej nr 
	utf8_t bailInName4[50];
	//! \~polish nazwa kaucji pobranej nr 
	utf8_t bailInName5[50];
	//! \~polish nazwa kaucji pobranej nr 
	utf8_t bailInName6[50];
	//! \~polish nazwa kaucji pobranej nr 
	utf8_t bailInName7[50];
	//! \~polish nazwa kaucji pobranej nr 
	utf8_t bailInName8[50];
	//! \~polish nazwa kaucji pobranej nr 
	utf8_t bailInName9[50];
	//! \~polish nazwa kaucji pobranej nr 10
	utf8_t bailInName10[50];
	//! \~polish nazwa kaucji pobranej nr 1
	utf8_t bailInName11[50];
	//! \~polish nazwa kaucji pobranej nr 1
	utf8_t bailInName12[50];
	//! \~polish nazwa kaucji pobranej nr 1
	utf8_t bailInName13[50];
	//! \~polish nazwa kaucji pobranej nr 1
	utf8_t bailInName14[50];
	//! \~polish nazwa kaucji pobranej nr 1
	utf8_t bailInName15[50];
	//! \~polish nazwa kaucji pobranej nr 1
	utf8_t bailInName16[50];
	//! \~polish nazwa kaucji pobranej nr 1
	utf8_t bailInName17[50];
	//! \~polish nazwa kaucji pobranej nr 1
	utf8_t bailInName18[50];
	//! \~polish nazwa kaucji pobranej nr 1
	utf8_t bailInName19[50];
	//! \~polish nazwa kaucji pobranej nr 20
	utf8_t bailInName20[50];
	//! \~polish nazwa kaucji pobranej nr 2
	utf8_t bailInName21[50];
	//! \~polish nazwa kaucji pobranej nr 2
	utf8_t bailInName22[50];
	//! \~polish nazwa kaucji pobranej nr 2
	utf8_t bailInName23[50];
	//! \~polish nazwa kaucji pobranej nr 2
	utf8_t bailInName24[50];
	//! \~polish nazwa kaucji pobranej nr 2
	utf8_t bailInName25[50];
	//! \~polish nazwa kaucji pobranej nr 2
	utf8_t bailInName26[50];
	//! \~polish nazwa kaucji pobranej nr 2
	utf8_t bailInName27[50];
	//! \~polish nazwa kaucji pobranej nr 2
	utf8_t bailInName28[50];
	//! \~polish nazwa kaucji pobranej nr 2
	utf8_t bailInName29[50];
	//! \~polish nazwa kaucji pobranej nr 30
	utf8_t bailInName30[50];
	//! \~polish nazwa kaucji pobranej nr 31
	utf8_t bailInName31[50];
	//! \~polish nazwa kaucji pobranej nr 32
	utf8_t bailInName32[50];
	//! \~polish nazwa kaucji zwr�conej nr 1
	utf8_t bailOutName1[50];
	//! \~polish nazwa kaucji zwr�conej nr 2
	utf8_t bailOutName2[50];
	//! \~polish nazwa kaucji zwr�conej nr 3
	utf8_t bailOutName3[50];
	//! \~polish nazwa kaucji zwr�conej nr 4
	utf8_t bailOutName4[50];
	//! \~polish nazwa kaucji zwr�conej nr 5
	utf8_t bailOutName5[50];
	//! \~polish nazwa kaucji zwr�conej nr 6
	utf8_t bailOutName6[50];
	//! \~polish nazwa kaucji zwr�conej nr 7
	utf8_t bailOutName7[50];
	//! \~polish nazwa kaucji zwr�conej nr 8
	utf8_t bailOutName8[50];
	//! \~polish nazwa kaucji zwr�conej nr 9
	utf8_t bailOutName9[50];
	//! \~polish nazwa kaucji zwr�conej nr 10
	utf8_t bailOutName10[50];
	//! \~polish nazwa kaucji zwr�conej nr 11
	utf8_t bailOutName11[50];
	//! \~polish nazwa kaucji zwr�conej nr 12
	utf8_t bailOutName12[50];
	//! \~polish nazwa kaucji zwr�conej nr 13
	utf8_t bailOutName13[50];
	//! \~polish nazwa kaucji zwr�conej nr 14
	utf8_t bailOutName14[50];
	//! \~polish nazwa kaucji zwr�conej nr 15
	utf8_t bailOutName15[50];
	//! \~polish nazwa kaucji zwr�conej nr 16
	utf8_t bailOutName16[50];
	//! \~polish nazwa kaucji zwr�conej nr 17
	utf8_t bailOutName17[50];
	//! \~polish nazwa kaucji zwr�conej nr 18
	utf8_t bailOutName18[50];
	//! \~polish nazwa kaucji zwr�conej nr 19
	utf8_t bailOutName19[50];
	//! \~polish nazwa kaucji zwr�conej nr 20
	utf8_t bailOutName20[50];
	//! \~polish nazwa kaucji zwr�conej nr 21
	utf8_t bailOutName21[50];
	//! \~polish nazwa kaucji zwr�conej nr 22
	utf8_t bailOutName22[50];
	//! \~polish nazwa kaucji zwr�conej nr 23
	utf8_t bailOutName23[50];
	//! \~polish nazwa kaucji zwr�conej nr 24
	utf8_t bailOutName24[50];
	//! \~polish nazwa kaucji zwr�conej nr 25
	utf8_t bailOutName25[50];
	//! \~polish nazwa kaucji zwr�conej nr 26
	utf8_t bailOutName26[50];
	//! \~polish nazwa kaucji zwr�conej nr 27
	utf8_t bailOutName27[50];
	//! \~polish nazwa kaucji zwr�conej nr 28
	utf8_t bailOutName28[50];
	//! \~polish nazwa kaucji zwr�conej nr 29
	utf8_t bailOutName29[50];
	//! \~polish nazwa kaucji zwr�conej nr 30
	utf8_t bailOutName30[50];
	//! \~polish nazwa kaucji zwr�conej nr 31
	utf8_t bailOutName31[50];
	//! \~polish nazwa kaucji zwr�conej nr 32
	utf8_t bailOutName32[50];
	//! \~polish przych�d
	long long income ;
	//! \~polish got�wka
	long long cash ;
	//! \~polish wp�aty
	long long payment ;
	//! \~polish rozch�d
	long long outcome;
	//! \~polish wyp�aty
	long long payout ;
	//! \~polish kwota formy p�atno�ci nr 1
	long long paymentMethod1 ;
	//! \~polish kwota formy p�atno�ci nr 2
	long long paymentMethod2 ;
	//! \~polish kwota formy p�atno�ci nr 3
	long long paymentMethod3 ;
	//! \~polish kwota formy p�atno�ci nr 4
	long long paymentMethod4 ;
	//! \~polish kwota formy p�atno�ci nr 5
	long long paymentMethod5 ;
	//! \~polish kwota formy p�atno�ci nr 6
	long long paymentMethod6 ;
	//! \~polish kwota formy p�atno�ci nr 7
	long long paymentMethod7 ;
	//! \~polish kwota formy p�atno�ci nr 8
	long long paymentMethod8 ;
	//! \~polish kwota formy p�atno�ci nr 9
	long long paymentMethod9 ;
	//! \~polish kwota formy p�atno�ci nr 10
	long long paymentMethod10 ;
	//! \~polish kwota formy p�atno�ci nr 11
	long long paymentMethod11 ;
	//! \~polish kwota formy p�atno�ci nr 12
	long long paymentMethod12 ;
	//! \~polish kwota formy p�atno�ci nr 13
	long long paymentMethod13 ;
	//! \~polish kwota formy p�atno�ci nr 14
	long long paymentMethod14 ;
	//! \~polish kwota formy p�atno�ci nr 15
	long long paymentMethod15 ;
	//! \~polish kwota formy p�atno�ci nr 16
	long long paymentMethod16 ;
	//! \~polish kaucja pobrana suma
	long long bailInSum ;
	//! \~polish kwota kaucji pobranej nr 1
	long long bailIn1 ;
	//! \~polish kwota kaucji pobranej nr 2
	long long bailIn2 ;
	//! \~polish kwota kaucji pobranej nr 3
	long long bailIn3 ;
	//! \~polish kwota kaucji pobranej nr 4
	long long bailIn4 ;
	//! \~polish kwota kaucji pobranej nr 5
	long long bailIn5 ;
	//! \~polish kwota kaucji pobranej nr 6
	long long bailIn6 ;
	//! \~polish kwota kaucji pobranej nr 7
	long long bailIn7 ;
	//! \~polish kwota kaucji pobranej nr 8
	long long bailIn8 ;
	//! \~polish kwota kaucji pobranej nr 9
	long long bailIn9 ;
	//! \~polish kwota kaucji pobranej nr 10
	long long bailIn10 ;
	//! \~polish kwota kaucji pobranej nr 11
	long long bailIn11 ;
	//! \~polish kwota kaucji pobranej nr 12
	long long bailIn12 ;
	//! \~polish kwota kaucji pobranej nr 13
	long long bailIn13 ;
	//! \~polish kwota kaucji pobranej nr 14
	long long bailIn14 ;
	//! \~polish kwota kaucji pobranej nr 15
	long long bailIn15 ;
	//! \~polish kwota kaucji pobranej nr 16
	long long bailIn16 ;
	//! \~polish kwota kaucji pobranej nr 17
	long long bailIn17 ;
	//! \~polish kwota kaucji pobranej nr 18
	long long bailIn18 ;
	//! \~polish kwota kaucji pobranej nr 19
	long long bailIn19 ;
	//! \~polish kwota kaucji pobranej nr 20
	long long bailIn20 ;
	//! \~polish kwota kaucji pobranej nr 21
	long long bailIn21 ;
	//! \~polish kwota kaucji pobranej nr 22
	long long bailIn22 ;
	//! \~polish kwota kaucji pobranej nr 23
	long long bailIn23 ;
	//! \~polish kwota kaucji pobranej nr 24
	long long bailIn24 ;
	//! \~polish kwota kaucji pobranej nr 25
	long long bailIn25 ;
	//! \~polish kwota kaucji pobranej nr 26
	long long bailIn26 ;
	//! \~polish kwota kaucji pobranej nr 27
	long long bailIn27 ;
	//! \~polish kwota kaucji pobranej nr 28
	long long bailIn28 ;
	//! \~polish kwota kaucji pobranej nr 29
	long long bailIn29 ;
	//! \~polish kwota kaucji pobranej nr 30
	long long bailIn30 ;
	//! \~polish kwota kaucji pobranej nr 31
	long long bailIn31 ;
	//! \~polish kwota kaucji pobranej nr 32
	long long bailIn32 ;
	//! \~polish kaucja zwr�cona suma
	long long bailOutSum ;
	//! \~polish kwota kaucji zwr�conej nr 1
	long long bailOut1 ;
	//! \~polish kwota kaucji zwr�conej nr 2
	long long bailOut2 ;
	//! \~polish kwota kaucji zwr�conej nr 3
	long long bailOut3 ;
	//! \~polish kwota kaucji zwr�conej nr 4
	long long bailOut4 ;
	//! \~polish kwota kaucji zwr�conej nr 5
	long long bailOut5 ;
	//! \~polish kwota kaucji zwr�conej nr 6
	long long bailOut6 ;
	//! \~polish kwota kaucji zwr�conej nr 7
	long long bailOut7 ;
	//! \~polish kwota kaucji zwr�conej nr 8
	long long bailOut8 ;
	//! \~polish kwota kaucji zwr�conej nr 9
	long long bailOut9 ;
	//! \~polish kwota kaucji zwr�conej nr 10
	long long bailOut10 ;
	//! \~polish kwota kaucji zwr�conej nr 11
	long long bailOut11 ;
	//! \~polish kwota kaucji zwr�conej nr 12
	long long bailOut12 ;
	//! \~polish kwota kaucji zwr�conej nr 13
	long long bailOut13 ;
	//! \~polish kwota kaucji zwr�conej nr 14
	long long bailOut14 ;
	//! \~polish kwota kaucji zwr�conej nr 15
	long long bailOut15 ;
	//! \~polish kwota kaucji zwr�conej nr 16
	long long bailOut16 ;
	//! \~polish kwota kaucji zwr�conej nr 17
	long long bailOut17 ;
	//! \~polish kwota kaucji zwr�conej nr 18
	long long bailOut18 ;
	//! \~polish kwota kaucji zwr�conej nr 19
	long long bailOut19 ;
	//! \~polish kwota kaucji zwr�conej nr 20
	long long bailOut20 ;
	//! \~polish kwota kaucji zwr�conej nr 21
	long long bailOut21 ;
	//! \~polish kwota kaucji zwr�conej nr 22
	long long bailOut22 ;
	//! \~polish kwota kaucji zwr�conej nr 23
	long long bailOut23 ;
	//! \~polish kwota kaucji zwr�conej nr 24
	long long bailOut24 ;
	//! \~polish kwota kaucji zwr�conej nr 25
	long long bailOut25 ;
	//! \~polish kwota kaucji zwr�conej nr 26
	long long bailOut26 ;
	//! \~polish kwota kaucji zwr�conej nr 27
	long long bailOut27 ;
	//! \~polish kwota kaucji zwr�conej nr 28
	long long bailOut28 ;
	//! \~polish kwota kaucji zwr�conej nr 29
	long long bailOut29 ;
	//! \~polish kwota kaucji zwr�conej nr 30
	long long bailOut30 ;
	//! \~polish kwota kaucji zwr�conej nr 31
	long long bailOut31 ;
	//! \~polish kwota kaucji zwr�conej nr 32
	long long bailOut32 ;
	//! \~polish stan kasy
	long long tillStatus ;
	//! \~polish ilo�� paragon�w
	char receiptCount[10];
	//! \~polish ilo�� anulowanych
	char receiptAbortCount[10];
	//! \~polish ilo�� STORNO
	char stornoCount[10];

}ChangeReport2;

//OTHER STRUCTS-------------------------------

typedef struct DrvVersion
{
	//! \~polish nazwa biblioteki
	char LibName[100];
	//! \~polish wersja biblioteki
	int LibVersion;
	//! \~polish pe�na wersja
	char FullVersion[100];

}DrvVersion;

typedef struct PrnVersion
{
	//! \~polish nazwa urz�dzenia
	char DeviceName[100] ;
	//! \~polish wersja urz�dzenia
	char DeviceVersion[10] ;
}PrnVersion;


typedef struct _DLEStatus
{
	//! \~polish stan "Online"
	int isOnline;
	//! \~polish stan "Brak Papieru" lub roz�adowany akumulator
	int isPaperOut;
	//! \~polish stan "B��d mechnizmu/sterownika"
	int isPrinterErr;
	//! \~polish jest po��czenie
	int isComm;
}DLEStatus;

typedef struct _DLE2Status
{
   //! \~polish ostatni kod b��du
   int lastError ;
   //! \~polish numer ostatniego wydruku
   int lastPrintoutNr ;
   //! \~polish numer ostatniego paragonu
   int lastReceiptNr ;
   //! \~polish brak mo�liwo�ci przetwarzania rozkaz�w
   int noPossibilityToProcessOrders ;
   //! \~polish drukarka w trakcie wykonywania raportu dobowego
   int printerDuringDailyReport ;
   //! \~polish trwa synchroniczna weryfikacja kopii e
   int syncVerificationOfTheCopyE ;
   //! \~polish drukarka oczekuje na interakcj� z uzytkownikiem
   int printerWaitsForInteractionWithTheUser ;
   //! \~polish drukarka w menu
   int printerInMenu ;
   //! \~polish brak papieru
   int paperOut ;
   //! \~polish b��d mechanizmu drukuj�cego
   int printMechanismError ;
   //! \~polish otwarta pokrywa drukarki
   int openPrinterCover ;
   //! \~polish ostatni rozkaz zako�czony b��dem
   int lastCommandError ;
   //! \~polish drukarka w trybie transakcji
   int transactionMode ;
   //! \~polish tryb dodatkowych linii na paragonie
   int additionalLinesInReceiptMode ;
   //! \~polish w trakcie wydruku
   int duringPrinting ;
   //! \~polish ko�cz�cy si� papier
   int endingPaper ;

}DLE2Status;

typedef struct _ENQStatus
{
	// \~polish tryb fiskalny
	int printerMode;
	//! \~polish ostatni rozkaz wykonany poprawnie
	int lastCommandOK;
	// \~polish drukarka w trybie transakcji
	int transactionMode;
	//! \~polish ostatnia transakcja zosta�a sfinalizowana poprawnie
	int lastTransactionOK;
} ENQStatus;



typedef struct _LastError
{
	//! \~polish kod b��du z urz�dzenia
   int errorCodeFromDevice ;
   //! \~polish kod b��du z biblioteki
   int errorCodeFromDriver ;

   //! \~polish opis b��du z urz�dzenia
   char errorDescriptionDevice[100];
   //! \~polish opis b��du z biblioteki
   char errorDescriptionDriver[100];

   //! \~polish status DLE
   DLEStatus dle;
   //! \~polish status DLE2
   DLE2Status dle2; 
   //! \~polish status ENQ
   ENQStatus enq;
}LastError;

/**/
typedef struct _SerialPortParameters
{
   //! \~polish nazwa portu
   char com_name[10];
   char ComName[255];
   //! \~polish pr�dko��
   int BaudRate;
   int ByteSize;
   int StopBits;
   int Parity;
   int ReadTimeout;
   int WriteTimeout;
   int FlowControl;
   //! \~polish czy ma dzia�a� na w�tkach
   int Thread;
   //! \~polish d�ugo�� timeout
   int mTimeout;
} SerialPortParameters;

typedef struct _TCPIPPortParameters
{
   //! \~polish adres IP
   char host[128];
   //! \~polish numer portu
   int port ;
   //! \~polish d�ugo�c timeout
   int mTimeout;
} TCPIPPortParameters;


typedef struct _ReadSTATUS
{
	//! \~polish ostatni b��d
	int lastError ;
	//! \~polish fiskalizacja
	int fiscal ;
	//! \~polish transakcja
	int transaction ;
	//! \~polish transakcja OK
	int transactionOK ;
	//! \~polish ilo�� zerowa�
	int resetNumber ;
	//! \~polish rok
	int Year ;
	//! \~polish miesi�c
	int Month ;
	//! \~polish dzie�
	int Day ;
	//! \~polish stawka PTU A
	int ptuA ;
	//! \~polish stawka PTU B
	int ptuB ;
	//! \~polish stawka PTU C
	int ptuC ;
	//! \~polish stawka PTU D
	int ptuD ;
	//! \~polish stawka PTU E
	int ptuE ;
	//! \~polish stawka PTU F
	int ptuF ;
	//! \~polish stawka PTU G
	int ptuG ;
	//! \~polish ilo�� paragon�w 
	int receiptAmount ;
	//! \~polish totalizer A
	int totalizerA ;
	//! \~polish totalizer B
	int totalizerB ;
	//! \~polish totalizer C
	int totalizerC ;
	//! \~polish totalizer D
	int totalizerD ;
	//! \~polish totalizer E
	int totalizerE ;
	//! \~polish totalizer F
	int totalizerF ;
	//! \~polish totalizer G
	int totalizerG ;
	//! \~polish got�wka
	int cash ;
	//! \~polish numer unikatowy
	char uniqueNumber[15];

}ReadSTATUS;

typedef struct _ErrorsControl
{
	//! \~polish tryb obs�ugi
	int mode ;
	//! \~polish kod b��du
	char errorID[5];
	//! \~polish identyfikator pakietu
	char packetID[10];
}ErrorsControl;

typedef struct _CashInfo
{
	// \~polish tryb
	int mode ;
}CashInfo;

typedef struct _CashInfo50
{
	// \~polish numer ostatnio wydrukowanego dokumentu
	int lastDocNumber;
	// \~polish zerowe totalizery drukarki
	int zeroTotalizers;
	// \~polish ilo�� faktur
	int invoiceCount;

}CashInfo50;


typedef struct _InfoType
{
	// \~polish typ informacji
	int infoType ;
}InfoType;

typedef struct _PM
{
	//! \~polish numer pami�ci chronionej
	char PMNumber[6];
	//! \~polish etykieta pami�ci chronionej
	char PMlable[25];
	//! \~polish ostatni JPKID
	long long JPKID;
	//! \~polish numer pierwszego raportu dobowego w pami�ci chronionej
	int firstDRNumber;
	//! \~polish ilo�� wolnego miejsca
	int freeSpaceAmount;
	//! \~polish ca�kowita ilo�� miejsca
	int totalSpaceAmount;
}PM;

typedef struct _FMRead
{
	//! \~polish rok
	char year[3];
	//! \~polish miesi�c
	char month[3];
	//! \~polish dzie�
	char day[3];
	//! \~polish godzina
	char hour[3];
	//! \~polish minuta
	char minute[3];
	//! \~polish sekunda
	char second[3];
	//! \~polish numer
	char nr[15];
	//! \~polish data pocz�tkowa
	char startDate[20];
	//! \~polish data ko�cowa
	char endDate[20];
	//! \~polish numer pocz�tkowy
	int startNumber;
	//! \~polish numer ko�cowy
	int endNumber;
	//! \~polish tryb
	int mode;
}FMRead;

typedef struct _LogInfo
{
	//! \~polish status
	int status ;
	//! \~polish data od
	char startDate[30];
	//! \~polish data do
	char endDate[30];
	//! \~polish poziom logowania
	char logLevel[15];
	//! \~polish modu�
	char module[15];
	//! \~polish dane
	char data[1024];
	//! \~polish ID pakietu
	char packetID[5];

}LogInfo;

typedef struct _RepositoryINFO
{
	//! \~polish data ostatniej wysy�ki
	char LastShipmentDate[25];
	//! \~polish data ostatniej poprawnej
	char LastCorrectShipmentDate[25];
	//! \~polish ilo�� JPK do wys�ania
	int JPKAmount ;
	//! \~polish ostatnio wys�any JPK
	int LastSendJPK ;
}RepositoryINFO;

typedef struct _DeviceTIME
{
	//! \~polish rok
	int year ;
	//! \~polish miesi�c
	int month ;
	//! \~polish dzie�
	int day ;
	//! \~polish godzina
	int hour ;
	//! \~polish minuta
	int minute ;
	//! \~polish sekunda
	int second ;

}DeviceTIME;


typedef struct _CommunicationPort
{
	//! \~polish typ informacji
	int infoType ;
	//! \~polish nazwa portu
	char portName[100];
}CommunicationPort;

typedef struct _VersionInfo
{
	//! \~polish nazwa
	char name[100];
	//! \~polish wersja
	char version[10];
}VersionInfo;

typedef struct _ReadError
{
	//! \~polish ostatni b��d
	int lastError ;
}ReadError;

typedef struct _DisplayCONTROL
{
	//! \~polish akcja
	int action;
	//! \~polish tekst do wy�wietlenia
	utf8_t text[500];
}DisplayCONTROL;

typedef struct _DateTIME
{
	//! \~polish rok
	int year ;
	//! \~polish miesi�c
	int month ;
	//! \~polish dzie�
	int day ;
	//! \~polish godzina
	int hour ;
	//! \~polish minuta
	int minute ;
	//! \~polish sekunda
	int second ;
	//! \~polish numer kasy
	utf8_t cashNumber[20];
	//! \~polish kasjer
	utf8_t cashier[80];
}DateTIME;

typedef struct _PTU
{
	//! \~polish ilo�� stawek
	int numberOfRates ;
	//! \~polish numer kasy
	utf8_t cashNumber[20];
	//! \~polish kasjer
	utf8_t cashier[70];
	//! \~polish PTU A
	int A ;
	//! \~polish PTU B
	int B ;
	//! \~polish PTU C
	int C ;
	//! \~polish PTU D
	int D ;
	//! \~polish PTU E
	int E ;
	//! \~polish PTU F
	int F ;
	//! \~polish PTU G
	int G ;
	//! \~polish rok
	int year ;
	//! \~polish miesi�c
	int month ;
	//! \~polish dzie�
	int day ;
	//! \~polish godzina
	int hour ;
	//! \~polish minuta
	int minute ;
	//! \~polish sekunda
	int second ;
	//! \~polish tryb
	int mode ;

}PTU;

typedef struct _IMG
{
	//! \~polish numer ID grafiki
   int imgId ;
   //! \~polish �cie�ka
   char bmpPath[256];
   //! \~polish ca�kowita d�ugo��
   int totalLen;
   //! \~polish suma kontrolna
   char crc[5];
}IMG;

typedef struct _Fiscal
{
	//! \~polish tryb
	int mode ;
	//! \~polish kategoria kasy
	int cashCategory ;
	//! \~polish spos�b u�ytkowania kasy
	int cashUsingType ;
	//! \~polish tp w�asno�ci
	int propertyType ;
	//! \~polish typ numeraji paragon�w
	int receiptNumerationType ;
	//! \~polish NIP
	char NIP[15];
	//! \~polish kod urz�du skarbowego
	char taxOfficeCode[15];
	//! \~polish dane urz�du skarbowego
	utf8_t taxOfficeData[30];
	//! \~polish dane punktu serwisowego
	char servicePointData[15];
	//! \~polish dane serwisanta
	utf8_t serviceManData[30];
	//! \~polish numer identyfikacyjny serwisanta
	char serviceManID[15];
	//! \~polish numer ewidencyjny
	char registrationNumber[15];
	//! \~polish NIP punktu serwisowego
	char servicePointNIP[15];

}Fiscal;

typedef struct _TotalizersMode
{
	//! \~polish tryb
	int mode ;
}TotalizersMode;

typedef struct _Packet
{
	//! \~polish pakiet do wys�ania
	utf8_t packetSend[2048];
	//! \~polish odebrany pakiet
	utf8_t packetRead[8192];
	//! \~polish czy sparadza� crc
	int isCrc;
}Packet;

typedef struct _EReceipt
{
	//! \~polish Identyfikator EParagonu
	char data[101];
	//! \~polish Typ
	int type;
	//! \~polish Flaga protok�
	int isProtocol;
	//! \~polish Flaga tryb dzia�ania
	int isMode;
	//! \~polish Protok�
	int protocol;
	//! \~polish Tryb dzia�ania
	int mode;


}EReceipt;

///////////////////////////////////////////////////////////////////////
typedef struct _ReceiptComplete
{
	//! \~polish flaga zako�czenie
	int fEnd ;
	//! \~polish ilo�� kaucji pobranej
	int bailInCount ;
	//! \~polish ilo�� kaucji wydanej
	int bailOutCount ;
	//! \~polish ilo�� pozycji
	int itemCount ;
	//! \~polish ilo�� linii niefiskalnych pod paragonem
	int nonFicalPrintoutCount ;
	//! \~polish pozycja rabatu/narzutu do podsumy
	int discountSubtotalPos ;
	//! \~polish rozpocz�cie paragonu
	StartReceipt startReceipt;
	//! \~polish pozycja paragonu
	Item item[200];
	//! \~polish zako�czenie paragonu bez form p�atno�ci
	EndReceipt endReceipt;
	//! \~polish zako�czenie paragonu z formami p�atno�ci(1)
	EndReceiptWithPaymentMethods1 endReceipt1;
	//! \~polish zako�czenie paragonu z formami p�atno�ci(2)
	EndReceiptWithPaymentMethods2 endReceipt2;
	//! \~polish linia niefiskalna pod paragonem
	NonFiscalPrintout nonFiscalPrintout[100];
	//! \~polish zako�czenie wydruku
	PrintEnd printEnd;
	//! \~polish kaucja pbrana
	BailIn bailIn[100];
	//! \~polish kaucja wydana
	BailOut bailOut[100];
	//! \~polish rabat/narzut do transakcji
	DiscountOrMarkupToTransaction discountOrMarkupToTransaction[2];
	//! \~polish rabat/narzut do danej stawki PTU
	DiscountOrMarkupToPTU discountOrMarkupToPTU[7];
	//! \~polish rabat/narzut do podsumy
	DiscountOrMarkupToSubtotal discountOrMarkupToSubtotal;
	//! \~polish p�atno��
	Payment payment;
	//! \~polish eParagon
	EReceipt eReceipt;

}ReceiptComplete;


typedef struct _InvoiceComplete
{
	//! \~polish opcje faktury
	int fInvoiceOptions ;
	//! \~polish ilo�� pozycji faktury
	int itemCount;
	//! \~polish rozpocz�cie faktury
	StartInvoice startInvoice;
	//! \~polish pozycja faktury
	Item item[200];
	//! \~polish zako�czenie faktury
	EndInvoice endInvoice;
	//! \~polish zako�czenie faktury z opcjami faktury
	EndReceipt endInvoiceWOpt;
	//! \~polish opcje faktury
	InvoiceOptions invoiceOptions;
	
}InvoiceComplete;

typedef struct _DocumentCompleteState {
	//! \~polish paragon
	int isRCP;
	//! \~polish faktura
	int isINV;
	//! \~polish czy aktywna kontrola stanu kasy
	int cashControlActive ;
	//! \~polish stan kasy przed transakcj�
	long long cashBefore;
	//! \~polish stan kasy po transakcji
	long long cashAfter;
	//! \~polish przewidywany stan kasy po wykonaniu paragonu
   long long cashExpected;
   //! \~polish ostatni b��d
	LastError lastError;
	//! \~polish paragon kompleksowy
	ReceiptComplete receiptComplete;
	//! \~polish faktura kompleksowa
	InvoiceComplete invoiceComplete;
}DocumentCompleteState;

typedef struct _CashInOut {
	//! \~polish parametr
	int param ;
	//! \~polish kwota do wp�aty/wyp�aty
	long long cash ;
	//! \~polish numer kasy
	utf8_t cashNumber[20];
	//! \~polish kasjer
	utf8_t cashier[70];
}CashInOut;

typedef struct _Prepayment
{
	//! \~polish akcja
	int action ;
	//! \~polish nazwa towaru
	utf8_t itemName[121];
	//! \~polish stawka PTU
	char ptu[2];
	//! \~polish warto�� zaliczki/rozliczenia zaliczki
	long long value ;
	//! \~polish do dop�aty
	long long extra ;
}Prepayment;

typedef struct _ConfigParam
{
   //! \~polish parametr
   int key;
   //! \~polish warto��
   char value[257];
}ConfigParam;

typedef struct _Animation
{
   //! \~polish funkcja
   int function;
   //! \~polish numer ID animacji
   char animName[13];
   //! \~polish �cie�ka
   char animPath[256];
}Animation;

typedef struct _BuyerID
{
   //! \~polish nip nabywcy
   char id[17];
}BuyerID;

// informacje og�lne

typedef struct _DeviceGeneralInfo
{
	////! \~polish typ informacji
	//int infoType;
	//! \~polish nazwa urz�dzenia
	char deviceName[60];
	//! \~polish wersja programu
	char programVersion[100];
	//! \~polish wersja modu�u drukuj�cego
	char printingModuleVersion[100];
	//! \~polish nazwa systemu
	char systemName[100];
	//! \~polish wersja systemu
	char systemVersion[100];
	//! \~polish liczba wy�wietlaczy
	int numberOfDisplays;
	//! \~polish szeroko�� wydruku
	int printWidth;
	//! \~polish kopia elektroniczna
	int electronicCopy;
	//! \~polish rozmiar pamieci fiskalnej
	int fiscalMemorySize;

}DeviceGeneralInfo;

//szczeg�owe dla pami�ci fiskalnej

typedef struct _DetailedForFMInfo
{
	////! \~polish typ informacji
	//int infoType;
	//! \~polish rozmiar pamieci fiskalnej
	int FMSize;
	//! \~polish rozmiar rekordu
	int recordSize;
	//! \~polish tryb dzia�ania
	int operatingMode;
	//! \~polish numer unikatowy
	char uniqueNumber[30];
	//! \~polish numer NIP
	char NIP[30];
	//! \~polish maksymalna liczba rekord�w
	int maxNumberOfRecords;
	//! \~polish liczba rekord�w
	int numberOfRecords;
	//! \~polish maksymalna liczba raport�w dobowych
	int maxNumberOfDailyReports;
	//! \~polish liczba raport�w dobowych
	int numberOfDailyReports;
	//! \~polish maksymalna liczba zerowa� RAM
	int maxNumberOfRAMResets;
	//! \~polish liczba zerowa� RAM
	int numebrOfRAMResets;
	//! \~polish  maksymalna liczba zmian stawek PTU
	int maxNumberOfPTUChanges;
	//! \~polish  liczba zmian stawek PTU
	int numberOfPTUChanges;
	//! \~polish  maksymalna liczba zmian waluty
	int maxNumberOfCurrencyChanges;
	//! \~polish  liczba zmian waluty
	int numberOfCurrencyChanges;
	//! \~polish  data fiskalizacji
	char dateOfFiscalisation[20];
	//! \~polish  data zamkni�cia trybu fiskalnego
	char dateOfClosingFiscalMode[20];
	//! \~polish  nazwa bie��cej waluty
	char currentCurrencyName[20];

}DetailedForFMInfo;

//szczego�y dotycz�ce stanu zasilania, akumulatora i baterii

typedef struct _DetailedAboutPower
{
	////! \~polish typ informacji
	//int infoType;
	//! \~polish pod��czony zasilacz 
	char powerSupplyConnected[20];
	//! \~polish napi�cie zasilacza
	char powerSupplyVoltage[20];
	//! \~polish napi�cie akumulatora
	char accumulatorVoltage[20];
	//! \~polish napi�cie bateryjki
	char batteryVlotage[20];

}DetailedAboutPower;

//informacje o stanie wydruku

typedef struct _PrintoutStatusInfo
{
	////! \~polish typ informacji
	//int infoType;
	//! \~polish wersja modu�u drukuj�cego
	char printoutModuleVersion[20];
	//! \~polish szeroko�c wydruku w znakach
	int printoutMaxNumberOfSigns;
	//! \~polish szeroko�� wydruku w mm
	int printoutWidth;
	//! \~polish czcionka
	int font;
	//! \~polish obcinacz papieru
	int paperCutter;
	//! \~polish ilo�� papieru
	int amountOfPaper;

}PrintoutStatusInfo;

//informacje o stanie szuflady

typedef struct _DrawerState
{
	////! \~polish typ informacji
	//int infoType;
	//! \~polish stan szuflady
	int drawerState;

}DrawerState;

//informacje o stanie pami�ci podr�cznej

typedef struct _CacheInfo
{
	////! \~polish typ informacji
	//int infoType;
	//! \~polish rozmiar ca�kowity w bajtach
	int fullByteSize;
	//! \~polish rozmiar ca�kowity w liniach wydruku
	int fullPrintoutLinesSize;
	//! \~polish rozmiar krytyczny w bajtach
	int criticalByteSize;
	//! \~polish rozmiar krytyczny w liniach wydruku
	int criticalPrintoutLinesSize;
	//! \~polish rozmiar zaj�ty w bajtach
	int occupiedSize;
	//! \~polish rozmiar zaj�ty w liniach wydruku
	int occupiedPrintoutLinesSize;
}CacheInfo;

//informacje o stanie bazy towar�w

typedef struct _StateOfGoodsBase
{
	//! \~polish ilo�� towart�w w bazie
	int goodsQuantity;
}StateOfGoodsBase;

// informacje szczeg�owe dla pami�ci fiskalnej wersja 2

typedef struct _DeviceFMInfoVersion2
{
	////! \~polish typ informacji
	//int infoType;
	//! \~polish rozmiar pami�ci fiskalnej
	int FMSize;
	//! \~polish rozmiar rekordu
	int recordSize;
	//! \~polish tryb dzia�ania
	int operatingMode;
	//! \~polish numer unikatowy
	char uniqueNumber[30];
	//! \~polish numer NIP
	char NIP[20];
	//! \~polish maksymalna liczba rekord�w
	int maxNumberOfRecords;
	//! \~polish liczba rekord�w
	int numberOfRecords;
	//! \~polish maksymalna liczba raport�w dobowych
	int maxNumberOfDailyReports;
	//! \~polish liczba raport�w dobowych
	int numberOfDailyReports;
	//! \~polish maksymalna liczba zerowa� RAM
	int maxNumberOfRAMResets;
	//! \~polish liczba zerowa� RAM
	int numberOfRAMResets;
	//! \~polish  maksymalna liczba zmian stawek PTU
	int maxNumberOfPTUChanges;
	//! \~polish  liczba zmian stawek PTU
	int numberOfPTUChanges;
	//! \~polish  maksymalna liczba zmian waluty
	int maxNumberOfCurrencyChanges;
	//! \~polish  liczba zmian waluty
	int numberOfCurrencyChanges;
	//! \~polish  data fiskalizacji
	char dateOfFiscalisation[20];
	//! \~polish  data zamkni�cia trybu fiskalnego
	char dateOfClosingFiscalMode[20];
	//! \~polish  nazwa bie��cej waluty
	char currentCurrencyName[20];
	//! \~polish data ostatniego raportu dobowego
	char lastDailyReportDate[20];
	//! \~polish data ostatniego zapisu do pami�ci fiskalnej
	char lastFMRecordDate[20];

}DeviceFMInfoVersion2;

//informacje szczeg�owe dla pami�ci fiskalnej wersja 3

typedef struct _DeviceFMInfoVersion3
{
	////! \~polish typ informacji
	//int infoType;
	//! \~polish liczba zdarze� og�lnych 
	int numberOfGeneralEvents;
	//! \~polish maksymalna liczba zdarze� og�lnych 
	int maxNumberOfGeneralEvents;
	//! \~polish liczba dokument�w fiskalnych
	int numberOfFiscalDocs;
	//! \~polish maksymalna liczba dokument�w fiskalnych
	int maxNumberOfFiscalDocs;
	//! \~polish liczba zmian klucza publicznego
	int numberOfPublicKeyChanges;
	//! \~polish liczba zmian tablicy stawek ulg
	int numberOfDiscountRatesChanges;
	//! \~polish liczba zmian tablicy grup ulg
	int numberOfDiscountGroupsChanges;
	//! \~polish liczba przegl�d�w serwisowych
	int numberOfServicesInspection;
	//! \~polish rozmiar danych zdarze�
	int eventsDataSize;
	//! \~polish maksymalny rozmiar danych zdarze�
	int maxEventsDataSize;
	//! \~polish numer ewidencyjny
	char registrationNumber[30];

}DeviceFMInfoVersion3;

//informacje dodatkowe dla pami�ci fiskalnej wersja 4

typedef struct _DeviceFMInfoVersion4
{
	//! \~polish liczba zapis�w 
	int numberOfRecords;
	//! \~polish maksymalna liczba zapis�w
	int maxNumberOfRecords;
	//! \~polish liczba zmian stawek ulg
	int numberOfDiscountRatesChanges;
	//! \~polish liczba zmian grup ulg
	int numberOfDiscountGroupsChanges;
	//! \~polish liczba przegl�d�w serwisowych
	int numberOfServicesInspection;
	//! \~polish maksymalna liczba przegl�d�w serwisowych
	int maxNumberOfServicesInspection;
	//! \~polish rozmiar zapisanych danych
	int dataSize;
	//! \~polish maksymalny rozmiar zapisanych danych
	int maxDataSize;
	//! \~polish opcje producenta
	int producerOptions;

}DeviceFMInfoVersion4;

// informacje o stanie akumulatora i zasilania

typedef struct _PowerSupplyInfo
{
	//! \~polish tryb zasilania
	int powerSupplyMode;
	//! \~polish napi�cie zasilacza [mV]
	int powerSupplyVoltage;
	//! \~polish napi�cie akumulatora
	int accumulatorVoltage;
	//! \~polish napi�cie baterii do podtrzymania RAM/Zegara [mV]
	int batteryVoltage;
	//! \~polish  stan akumulatora
	int accumulatorState;
	//! \~polish  status baterii do podtrzymania RAM/Zegara
	int batteryStatus;
	//! \~polish poziom na�adowania akumulatora
	int accumulatorLevel;

}PowerSupplyInfo;


typedef struct _FiscalizationInfo
{
	//! \~polish status fiskalizacji
	int status;
	//! \~polish data fiskalizacji
	char fiscalizationDate[19];
	//! \~polish numer nip
	char nip[14];
	//! \~polish numer ewidencyjny
	char registrationNumber[16];
	//! \~polish  identyfikator pami�ci chronionej
	char PMId[21];
	//! \~polish  typ urz�dzenia
	int deviceType;
	//! \~polish typ numeracji paragon�w
	int numberingType;
	//! \~polish typ w�asno�ci
	int ownershipType;

}FiscalizationInfo;

typedef struct _ServerInfo
{
	//! \~polish typ serwera
	int type;
	//! \~polish adres serwera
	char serverAdress[300];

}ServerInfo;


typedef struct _USBConfig
{
	//! \~polish usb ext typ
	int action;
	//! \~polish usb modem pid
	char usbModemPid[5];
	//! \~polish usb modem vid
	char usbModemVid[5];
	//! \~polish usb ext pid
	char usbExtPid[5];
	//! \~polish usb ext vid
	char usbExtVid[5];
	//! \~polish usb modem typ
	int usbModemType;
	//! \~polish usb ext typ
	int usbExtType;
	//! \~polish usb modem interfejs
	char usbModemInterface[4];
	//! \~polish usb ext interfejs
	char usbExternInterface[4];
	//! \~polish usb modem protok�
	char usbModemProtocol[4];
	//! \~polish usb ext protok�
	char usbExternProtocol[4];

}USBConfig;



typedef struct _CurrencyChange
{
	
	//! \~polish rok
	char year[3];
	//! \~polish miesi�c
	char month[3];
	//! \~polish dzie�
	char day[3];
	//! \~polish godzina
	char hour[3];
	//! \~polish minuta
	char minute[3];
	//! \~polish sekunda
	char second[3];
	//! \~polish nazwa waluty
	char currencyName[4];
	//! \~polish kurs waluty
	char exchangeRate[14];
	//! \~polish tryb wydruku
	int printoutMode;

}CurrencyChange;


typedef struct _EreceiptStatus
{
	//! \~polish status ostatniego e-paragonu
	int status;
	//! \~polish numer wydruku
	int printoutNumber;

}EreceiptStatus;

typedef struct _SalePossibility
{
	//! \~polish nazwa towaru
	utf8_t itemName[121];
	//! \~polish stawka PTU
	char PTU[2];
	//! \~polish rezultat
	int result;

}SalePossibility;

typedef struct _ServiceLock
{
	//! \~polish rok
	char year[3];
	//! \~polish miesi�c
	char month[3];
	//! \~polish dzie�
	char day[3];
	//! \~polish has�o
	utf8_t password[61];
	//! \~polish napis
	utf8_t text[61];

}ServiceLock;


typedef struct _DatabaseControl
{
	//! \~polish akcja
	int action;
	//! \~polish nazwa
	utf8_t name[81];
	//! \~polish stawka PTU
	char PTU[2];
	//! \~polish kasjer
	utf8_t cashier[66];
	//! \~polish numer kasy
	utf8_t cashNumber[18];

}DatabaseControl;


typedef struct _PaperEjection
{
	//! \~polish liczba linii
	int linesAmount;

}PaperEjection;

typedef struct _FiscalMemoryRecords
{
	//! \~polish data pocz�tkowa
	char startDate[18];
	//! \~polish data ko�cowa
	char endDate[18];
	//! \~polish numer pocz�tkowy
	int startNumber;
	//! \~polish numer ko�cowy
	int endNumber;

}FiscalMemoryRecords;

typedef struct _FMReadRecord
{

	//! \~polish Numer rekordu
	long long recordNumber;
	//! \~polish Identyfikator rekordu
	int recordID;
	//! \~polish Ca�kowity rozmiar danych
	int fullDataSize;
	//! \~polish Dane
	char data[40960];

}FMReadRecord;

typedef struct _JPKDocRequest
{
	//! \~polish Stan
	int state;
	//! \~polish JPK ID
	long long JPK_ID;
	//! \~polish Czy z IDZ
	int IDZ;
	//! \~polish Zawarto��
	int content;
	//! \~polish Typ dokumentu
	int docType;

}JPKDocRequest;

typedef struct _JPKDocRead
{
	//! \~polish Status
	int status;
	//! \~polish Typ dokumentu
	int docType;
	//! \~polish Rozmiar
	int size;
	//! \~polish Pozycja
	int position;
	//! \~polish JPK ID
	long long JPK_ID;
	//! \~polish Kod nabywcy
	char buyerCode[1024];
	//! \~polish Dane
	char data[262144];

}JPKDocRead;


typedef struct _EReceiptCfg
{
	//! \~polish Typ
	//! \~polish 1 � programowanie adresu serwera, 2 � rozszerzone ustawienia e-paragonu
	int type;
	//! \~polish Adres serwera eparagonu
	char addres[201];
	//! \~polish Szyfrowanie
	//! \~polish 0-Nie, 1 - Tak
	int encryption;
	//! \~polish Format danych
	//! \~polish 0-Obraz, 1-Dane, 2-Obraz + Dane
	int format;
	//! \~polish Protok�
	//! \~polish 0-Novitus, 1-PD
	int protocol;
	//! \~polish Klucz
	char key[65];
	//! \~polish Tryb dzia�ania
	//! \~ 0 � gdy brak potwierdzenia otrzymania e-paragonu przez serwer drukuj paragon I nie ponawiaj pr�b wys�ania e-paragonu,
	//! \~ 1 � gdy brak potwierdzenia otrzymania e - paragonu przez serwer ponawiaj pr�by wys�ania e - paragonu do skutku,
	//! \~ 2 - gdy brak potwierdzenia otrzymania e - paragonu przez serwer drukuj paragon I ponawiaj pr�by wys�ania e - paragonu do skutku,
	int mode;
	//! \~polish Timeout
	int timeout;
	//! \~polish Timeout komunikatu
	int messageTimeout;
	//! \~polish Sprawdzenie po�aczenia 
	//! \~ 1 � sprawdza�
	//! \~ 0 � nie sprawdza�
	int checkConnection;
	//! \~polish Wysylane typy dokumentow(ustawiane bitowo):
	//! \~ 0x0001 - paragon,
	 //! \~ 0x0002 - paragon anulowany,
	 //! \~ 0x0004 - faktura,
	 //! \~ 0x0008 - faktura anulowana,
	 //! \~ 0x0010 - wydruk niefiskalny,
	 //! \~ 0x0020 - rozliczenie opakowa�.
	int documentTypesAllowed;
	//! \~polish Zmiana adresu serwera z menu
	//! \~ 0 � zabroniona
	//! \~ 1 � dozwolona
	int changeAddressFromMenu;
	//! \~polish Zmiana adresu serwera po protokole 
	//! \~ 0 � zabroniona
	//! \~ 1 � dozwolona
	int changeAddressByPacket;
	//! \~polish Automatyczny id transakcji
	//! \~ 0 � nie
	//! \~ 1 � tak
	int autoId;
	//! \~polish Zezwalaj na tworzenie e-paragon�w
	//! \~ 0 � nie
	//! \~ 1 � tak
	int allowToCreateEReceipt;
	//! \~polish Zezwalaj na wysy�anie eparagon�w
	//! \~ 0 � nie
	//! \~ 1 � tak
	int allowToSendEReceipt;

}EReceiptCfg;


typedef struct _EDocumentCert
{
	//! \~polish Rodzej certyfikatu
	//! \~polish 1 - cacert.pem, 2 - client3 cert.pem, 3 - client3 key.pem, eParagon certyfikat 1 (format DER).
	int certType;
	//! \~polish Ca�kowity rozmiar danych
	int totalDataSize;
	//! \~polish Offset danych
	int dataOffset;
	//! \~polish Dane
	char data[2048];

}EDocumentCert;


typedef struct _EDocument
{
	//! \~polish Tryb
	//! \~polish 0 - pocz�tek wyszukiwania, 1 - kolejne dane, 2 - retransmisja,
	int mode;
	//! \~polish Typ wyszukiwania
	//! \~polish 0 - wyszukiwanie po JPKID, 1 - wyszukiwanie po numerze wydruku,
	int searchingType;
	//! \~polish Numer
	int number;
	//! \~polish Typ danych
	//! \~polish � 0 - JWS, 1 - Wizualizacja, 2 - Wizualizacja bez grafik, 3 - JWS + Wizualizacja, 4 - JWS + Wizualizacja bez grafik,
	int dataType;
	//! \~polish Status
	//! \~polish � 0 - wysy�anie danych, 1 - koniec danych, 2 - brak danych, 3 - w trakcie przetwarzania, 4 - niepoprawne parametry, 8 - b��d, nie mo�na rozpocz�� nowego generowania, najpierw musi zako�czy� si� poprzednie, 9 - b��d,
	int status;
	//! \~polish Ca�kowity rozmiar danych
	int totalSize;
	//! \~polish Pozycja - ca�kowita ilo�� przes�anych danych.
	int position;
	//! \~polish Rozmiar przesy�anej paczki.
	int size;
	//! \~polish Dane
	char data[262144];
}EDocument;


typedef struct _EDocumentBaseInfo
{
	//! \~polish Tryb
	//! \~polish 0 - ilo�� dokument�w w bazie, 1 - pocz�tek odczytu, 2 - kolejny rekord z bazy
	int mode;
	//! \~polish Protok�
	//! \~polish 0-Novitus, 1-MF, 2- dowolny,
	int protocol;
	//! \~polish Status
	//! \~polish 0 - oczekuj�cy na wys�anie i nie wydrukowany, 1 - oczekuj�cy na wys�anie	i wydrukowany, 2 - odrzucony przez serwer i nie wydrukowany, 3 - odrzucony przez serwer	i wydrukowany, 4 - oczekuj�cy na wys�anie, 5 - odrzucony przez serwer,	6 - dowolny.int status;
	int status;
	//! \~polish Ilo�� - ilo�� dokument�w w bazie,
	int count;
	//! \~polish JPKID - JPKID dokumentu,
	int JPKID;

	int responseMode;


}EDocumentBaseInfo;

typedef struct _EDocumentVisualization
{
	//! \~polish Strategia
	//! \~polish 0 - Z DEFAULT_STRATEGY, 1 - Z FILTERED, 2 - Z HUFFMAN_ONLY, 3 - Z RLE,	 4 - Z FIXED.
	int strategy;
	//! \~polish Poziom kompresji
	//! \~polish -1 - Z_DEFAULT_COMPRESSION, 0 - Z_NO_COMPRESSION, 1 - Z_BEST_COMPRESSION.
	int compression;
	//! \~polish Filtrowanie
	//! \~polish 0 � PNG_NO_FILTERS, 8 � PNG_FILTER_NONE, 16 � PNG_FILTER_SUB, 32 � PNG_FILTER_UP, 64 � PNG_FILTER_AVG,	128 � PNG_FILTER_PAETH.
	int filter;
}EDocumentVisualization;





typedef struct _MfHUBSettings
{
	//! \~polish Flaga - rodzaj certyfikatu
	//! \~polish 0 - nie, 1 - tak, 
	int isSizeField;
	//! \~polish Flaga - rodzaj wysy�anych eDokument�w
	//! \~polish 0 - nie, 1 - tak, 
	int isDocumentTypeField;
	//! \~polish Adres serwera
	char address[201];
	//! \~polish Rozmiar
	int size;
	//! \~polish Wysy�ane typy eDokument�w
	int eDocumentTypes;
	
}MfHUBSettings;

typedef struct _LastRcpSummary
{
   //! \~polish Stan paragonu
   //! \~ 0 � pusty
   //! \~ 1 � otwarty
   //! \~ 2 � zamkni�ty
   //! \~ 3 � anulowany
   int rcpState;
   //! \~polish Typ paragonu
   //! \~ 0 � nornalny
   //! \~ 1 � rozliczenie opakowa� zwrotnych
   int rcpType;
   //! \~polish Numer paragonu
   int rcpNumber;
   //! \~polish Data i czas paragonu format: rrrr-mm-dd hh:mm:ss
   char rcpDate[32];
   //! \~polish Numer wydruku
   int prnNumber;
   //! \~polish Numer systemowy
   char systemNumber[1024];
   //! \~polish Numer kasy
   utf8_t cashNumber[256];
   //! \~polish Nazwa kasjera
   utf8_t cashier[256];
   //! \~polish Ilo�� pozycji
   int itemsCount;
   //! \~polish Ilo�� kaucji
   int itemsDepositCount;
   //! \~polish Ilo�� p�atno�ci
   int itemsPaymentCount;
   //! \~polish Razem
   long long total;
   //! \~polish Typ rabatu
   //! \~polish 0 - brak
   //! \~polish 1 - rabat procentowy
   //! \~polish 2 - dop�ata procentowa
   //! \~polish 3 - rabat kwotowy
   //! \~polish 4 - dop�ata kwotowa
   int discountType;
   //! \~polish Rabat
   long long discount;
   //! \~polish Nazwa rabatu
   utf8_t discountName [256];
   //! \~polish Razem po rabacie
   long long discountTotal;
   //! \~polish Metoda rozliczenia rabatu
   int discountMethod;
   //! \~polish Kaucje przyj�te
   int inputDeposit;
   //! \~polish Kaucje wydane
   int outputDeposit;
   //! \~polish Do zap�aty
   long long toPay;
   //! \~polish Got�wka
   long long cash;
   //! \~polish Karta
   long long card;
   //! \~polish Czek
   long long cheque;
   //! \~polish Bon
   long long bon;
   //! \~polish Inna forma p�atno�ci
   long long otherPayment;
   //! \~polish Kredyt
   long long credit;
   //! \~polish Konto klienta
   long long clientAccount;
   //! \~polish Waluta obca
   long long currency;
   //! \~polish Przelew
   long long transfer;
   //! \~polish Got�wla EURO
   long long euroCash;
   //! \~polish Nazwa p�atno�ci kart�
   utf8_t cardName[256];
   //! \~polish Nazwa p�atno�ci czek
   utf8_t chequeName[256];
   //! \~polish Nazwa p�atno�ci bon
   utf8_t bonName[256];
   //! \~polish Nazwa p�atno�ci inna
   utf8_t otherName[256];
   //! \~polish Nazwa p�atno�ci kredyt
   utf8_t creditName[256];
   //! \~polish Nazwa p�atno�ci konto klienta
   utf8_t clientAccountName[256];
   //! \~polish Nazwa p�atno�ci konto klienta
   utf8_t transferName[256];
   //! \~polish Kurs EURO
   utf8_t euroExchangeRate[256];
   //! \~polish Reszta z�
   long long rest;
   //! \~polish Reszta Euro
   long long euroRest;
}LastRcpSummary;


typedef struct _LastRcpItem
{
   //! \~polish Numer pozycji
   int index;
   //! \~polish Nazwa
   utf8_t name[512];
   //! \~polish Kod towaru
   char code[256];
   //! \~polish Ilo��
   char quantity[128];
   //! \~polish PTU
   char ptu[2];
   //! \~polish Cena
   long long price;
   //! \~polish Brutto
   long long gross;
   //! \~polish Rodzaj rabatu
   int discountType;
   //! \~polish Opis rabatu
   utf8_t discountDescription[512];
   //! \~polish Rabat
   long long discount;
   //! \~polish Nazwa rabatu
   utf8_t discountName[512];
   //! \~polish Sumaryczny rabat procentowy
   long long percentTotalDiscount;
   //! \~polish Warto�� sumarycznych rabat�w
   long long valueTotalDiscount;
} LastRcpItem;

typedef struct _LastRcpDepositItem
{
   //! \~polish Numer pozycji
   int index;
   //! \~polish Kod opakowania zwrotnego
   char code[256];
   //! \~polish Ilo��
   char quantity[128];
   //! \~polish Cena
   long long price;
   //! \~polish Brutto
   long long gross;
} LastRcpDepositItem;

typedef struct _LastRcpPaymentItem
{
   //! \~polish Numer pozycji
   int index;
   //! \~polish Kod formy p�atno�ci
   //! \~polish 0 - Got�wka
   //! \~polish 1 - Karta
   //! \~polish 2 - Czek
   //! \~polish 3 - Bon
   //! \~polish 4 - Inna
   //! \~polish 5 - Kredyt
   //! \~polish 6 - Konto klienta
   //! \~polish 7 - Przelew
   //! \~polish 8 - Got�wka EURO
   //! \~polish 9 - Mobilna
   //! \~polish 10 - Voucher
   int code;
   //! \~polish Warto��
   long long value;
   //! \~polish Nazwa
   utf8_t name [512];
} LastRcpPaymentItem;



typedef struct _LastRcpSummaryEx
{
   //! \~polish Stan paragonu
   //! \~ 0 � pusty
   //! \~ 1 � otwarty
   //! \~ 2 � zamkni�ty
   //! \~ 3 � anulowany
   int rcpState;
   //! \~polish Typ paragonu
   //! \~ 0 � nornalny
   //! \~ 1 � rozliczenie opakowa� zwrotnych
   int rcpType;
   //! \~polish Numer paragonu
   int rcpNumber;
   //! \~polish Data i czas paragonu format: rrrr-mm-dd hh:mm:ss
   char rcpDate[32];
   //! \~polish Numer wydruku
   int prnNumber;
   //! \~polish Numer systemowy
   utf8_t systemNumber[2048];
   //! \~polish Numer kasy
   utf8_t cashNumber[256];
   //! \~polish Nazwa kasjera
   utf8_t cashier[256];
   //! \~polish Ilo�� pozycji
   int itemsCount;
   //! \~polish Ilo�� kaucji
   int itemsDepositCount;
   //! \~polish Ilo�� p�atno�ci
   int itemsPaymentCount;
   //! \~polish Razem
   long long Total;
   //! \~polish Typ rabatu
   //! \~polish 0 - brak
   //! \~polish 1 - rabat procentowy
   //! \~polish 2 - dop�ata procentowa
   //! \~polish 3 - rabat kwotowy
   //! \~polish 4 - dop�ata kwotowa
   int discountType;
   //! \~polish Rabat
   long long discount;
   //! \~polish Nazwa rabatu
   utf8_t discountName[256];
   //! \~polish Razem po rabacie
   long long discountTotal;
   //! \~polish Metoda rozliczenia rabatu
   int discountMethod;
   //! \~polish Kaucje przyj�te
   int inputDeposit;
   //! \~polish Kaucje wydane
   int outputDeposit;
   //! \~polish Do zap�aty
   long long toPay;
   //! \~polish Got�wka
   long long cash;
   //! \~polish Karta
   long long card;
   //! \~polish Czek
   long long cheque;
   //! \~polish Bon
   long long bon;
   //! \~polish Inna forma p�atno�ci
   long long otherPayment;
   //! \~polish Kredyt
   long long credit;
   //! \~polish Konto klienta
   long long clientAccount;
   //! \~polish Waluta obca
   long long currency;
   //! \~polish Przelew
   long long transfer;
   //! \~polish Got�wla EURO
   long long euroCash;
   //! \~polish Mobilna
   long long mobile;
   //! \~polish Voucher
   long long voucher;
   //! \~polish Nazwa p�atno�ci kart�
   utf8_t cardName[256];
   //! \~polish Nazwa p�atno�ci czek
   utf8_t chequeName[256];
   //! \~polish Nazwa p�atno�ci bon
   utf8_t bonName[256];
   //! \~polish Nazwa p�atno�ci inna
   utf8_t otherName[256];
   //! \~polish Nazwa p�atno�ci kredyt
   utf8_t creditName[256];
   //! \~polish Nazwa p�atno�ci konto klienta
   utf8_t clientAccountName[256];
   //! \~polish Nazwa p�atno�ci konto klienta
   utf8_t transferName[256];
   //! \~polish Nazwa p�atno�ci mobilnej
   utf8_t mobileName[256];
   //! \~polish Nazwa p�atno�ci voucher
   utf8_t voucherName[256];
   //! \~polish Kurs EURO
   char euroExchangeRate[128];
   //! \~polish Reszta z�
   long long rest;
   //! \~polish Reszta Euro
   long long euroRest;
}LastRcpSummaryEx;


typedef struct _LastRcpItemEx
{
   //! \~polish Numer pozycji
   int index;
   //! \~polish Nazwa
   utf8_t name[512];
   //! \~polish Kod towaru
   char code[256];
   //! \~polish Ilo��
   char quantity[128];
   //! \~polish PTU
   char ptu[2];
   //! \~polish Cena
   long long price;
   //! \~polish Brutto
   long long gross;
   //! \~polish Rodzaj rabatu
   int discountType;
   //! \~polish Opis rabatu
   utf8_t discountDescription[512];
   //! \~polish Rabat
   long long discount;
   //! \~polish Nazwa rabatu
   utf8_t discountName[512];
   //! \~polish Sumaryczny rabat procentowy
   long long percentTotalDiscount;
   //! \~polish Warto�� sumarycznych rabat�w
   long long valueTotalDiscount;
   //! \~polish Typ pozycji
   //! \~polish 0 - pozycja paragonu
   //! \~polish 1 - podsuma
   long long positionType;

} LastRcpItemEx;


typedef struct _LastRcpSummaryEx2
{
   //! \~polish Stan paragonu
   //! \~ 0 � pusty
   //! \~ 1 � otwarty
   //! \~ 2 � zamkni�ty
   //! \~ 3 � anulowany
   int rcpState;
   //! \~polish Typ paragonu
   //! \~ 0 � nornalny
   //! \~ 1 � rozliczenie opakowa� zwrotnych
   int rcpType;
   //! \~polish Numer paragonu
   int rcpNumber;
   //! \~polish Data i czas paragonu format: rrrr-mm-dd hh:mm:ss
   char rcpDate[32];
   //! \~polish Numer wydruku
   int prnNumber;
   //! \~polish Numer systemowy
   utf8_t systemNumber[2048];
   //! \~polish Numer kasy
   utf8_t cashNumber[256];
   //! \~polish Nazwa kasjera
   utf8_t cashier[256];
   //! \~polish Ilo�� pozycji
   int itemsCount;
   //! \~polish Ilo�� kaucji
   int itemsDepositCount;
   //! \~polish Ilo�� p�atno�ci
   int itemsPaymentCount;
   //! \~polish Razem
   long long Total;
   //! \~polish Typ rabatu
   //! \~polish 0 - brak
   //! \~polish 1 - rabat procentowy
   //! \~polish 2 - dop�ata procentowa
   //! \~polish 3 - rabat kwotowy
   //! \~polish 4 - dop�ata kwotowa
   int discountType;
   //! \~polish Rabat
   long long discount;
   //! \~polish Nazwa rabatu
   char discountName[256];
   //! \~polish Razem po rabacie
   long long discountTotal;
   //! \~polish Metoda rozliczenia rabatu
   int discountMethod;
   //! \~polish Kaucje przyj�te
   int inputDeposit;
   //! \~polish Kaucje wydane
   int outputDeposit;
   //! \~polish Do zap�aty
   long long toPay;
   //! \~polish Got�wka
   long long cash;
   //! \~polish Karta
   long long card;
   //! \~polish Czek
   long long cheque;
   //! \~polish Bon
   long long bon;
   //! \~polish Inna forma p�atno�ci
   long long otherPayment;
   //! \~polish Kredyt
   long long credit;
   //! \~polish Konto klienta
   long long clientAccount;
   //! \~polish Waluta obca
   long long currency;
   //! \~polish Przelew
   long long transfer;
   //! \~polish Got�wla EURO
   long long euroCash;
   //! \~polish Mobilna
   long long mobile;
   //! \~polish Voucher
   long long voucher;
   //! \~polish Nazwa p�atno�ci kart�
   utf8_t cardName[256];
   //! \~polish Nazwa p�atno�ci czek
   utf8_t chequeName[256];
   //! \~polish Nazwa p�atno�ci bon
   utf8_t bonName[256];
   //! \~polish Nazwa p�atno�ci inna
   utf8_t otherName[256];
   //! \~polish Nazwa p�atno�ci kredyt
   utf8_t creditName[256];
   //! \~polish Nazwa p�atno�ci konto klienta
   utf8_t clientAccountName[256];
   //! \~polish Nazwa p�atno�ci konto klienta
   utf8_t transferName[256];
   //! \~polish Nazwa p�atno�ci mobilnej
   utf8_t mobileName[256];
   //! \~polish Nazwa p�atno�ci voucher
   utf8_t voucherName[256];
   //! \~polish Kurs EURO
   char euroExchangeRate[128];
   //! \~polish Reszta z�
   long long rest;
   //! \~polish Reszta Euro
   long long euroRest;
   //! \~polish NIP Nabywcy
   long long acquirerNIP;
}LastRcpSummaryEx2;

typedef struct _LastEFTTransaction
{
   //! \~polish Agent
   char agent[255];
   //! \~polish Token karty p�atniczej
   char cardToken[255];
   //! \~polish ID Eparagonu
   char ereceiptID[255];
   //! \~polish ID Terminala
   char TID[255];
   //! \~polish ID Transakcji
   char TransactionID[255];
}LastEFTTransaction;

typedef struct _LastCashback
{
   //! \~polish Kwota cshback
   int cashback;
}LastCashback;