*****************************************************************************
*
*  Example program demonstrating use of OFPClipperLibrary functions
*  (c) 2002 S. Mezyk/Optimus IC SA
*
*  This program is a free software released under LGPL license.
*
*****************************************************************************

#include "ofpclipr.ch"
#include "box.ch"

// ---- main entry ----------------------------------------------------------


  use rcpitems new
  OpenConneciton(1)
  Menu()
  CloseConnection()

// ---- several stuff functions ---------------------------------------------

procedure Error(cMsg, bNoNative)
  Alert(cMsg, {'OK'})
  if GetProperty(propLastError) = ofpeCommunicationTimeout
    Alert('Printer does not respond to commands (not connected ?)')
    return
  endif
  bNoNative := IIF(bNoNative = NIL, .f., bNoNative)
  if !bNoNative
    Alert('Printer error code: ' + LTrim(Str(GetProperty(propLastNativeError), 0)))
  endif
return

function sPrompt(cStr)
local val := ''
    @22, 0 clear to 23, 79
    @22, 0 say replicate('-', 78)    
    @22, 0 say ''
    accept cStr to val
    return upper(val)
return val

function ShowTitle(cStr)
  clear screen
  ? 'results of function: ' + cStr
  ? replicate('-', 78)
  ?
return

// ---- main menu -----------------------------------------------------------

procedure Menu()
local x

  do while .t.
    clear screen
    ? 'MAIN MENU'
    ? replicate('-', 78)    
    ?

    ? '1. Cash pay in                A. Daily report'
    ? '2. Cash pay out               B. Periodical report by date'
    ? '3. Get clock                  C. Periodical report by number'
    ? '4. Set clock                  D. Cash report'
    ? '5. Synchronize clock          E. Cashier report'
    ? '6. Beep                       F. Print receipt sample #1'
    ? '7. Open drawer                G. Print receipt sample #2 (payment forms)'
    ? '8. Paper feed                 H. Print and cancel receipt'
    ? '9. Set sample tax rates       J. Login cashier'
    ? '0. Read tax rates             K. Logout cashier'
    ? '?. Get version information    L. Get status information'
    ? '                              M. Detect printer'
    ? 
    ? 'q. Quit'

    x := sPrompt('Select item: ')
    x := upper(x)

    do case
     case x = '1' 
       CashIn()
     case x = '2'
       CashOut()
     case x = '3'
       GetClock()
     case x = '4'
       Set_Clock()
     case x = '5'
       Sync_clock()
     case x = '6'
       Beep()
     case x = '7'
       OpenDrawer()
     case x = '8'
       Paper_Feed()
     case x = '9'
       SetSampleRates()
     case x = '0'
       ShowTaxRates()
     case x = 'A'
       DoDailyReport()
     case x = 'B'
       PerRepByDate()
     case x = 'C'
       PerRepByNo()
     case x = 'D'
       DoCashRep()
     case x = 'E'
       Cashier_Rep()
     case x = 'F'
       RcpSample1()
     case x = 'G'
       RcpSample3()
     case x = 'H'
       RcpSample4()
     case x = 'J'
       Login_cashier()
     case x = 'K'
       Logout_cashier()
     case x = '?'
       ShowVersion()
     case x = 'L'
       Status()
     case x = 'M'
       DoDetectPrinter()
     case x = 'Q'
       exit
    end
  end
return

// ---- job functions -------------------------------------------------------
  
function GetValue(cMessage, cPict)
local cBox, nX, nY, nX1, nY1, Val

  nX := (maxcol() - Len(cMessage) - 4 /*frame*/) / 2
  nX1 := nX + Len(cMessage) + 3
  nY := (maxrow() - 3 /*box height*/) / 2
  nY1 := nY + 3

  cBox := savescreen(nY, nX, nY1, nX1)

  @ nY, nX, nY1, nX1 BOX B_DOUBLE + ' ' color 'gr+/b,w/b'
  @ nY+1, nX+2 say cMessage color 'N/W'
  
  clear gets
  Val := space(Len(cMessage))
  @ nY + 2, nX + 2 get Val color 'W+/B'
  read

  restscreen(nY, nX, nY1, nX1, cBox)

return Val

procedure PrintReceipt()
local nTotal := 0

  use rcpitems new
  
  RcpOpen()
  go top
  do while !Eof()
    if RcpItem(Name, ;
  	       TaxRate, ;
               Price, ;
               Quantity, ;
               QtyUnit, ;
               Quantity * Price)
       nTotal += Quantity * Price
       skip
     else
       Error('Error while sending receipt item to the printer')
       RcpAbort()
       return
     endif    
  end
  RcpClose(nTotal, nTotal)
return

procedure CashIn()
  if !CashPaidIn(Val(sPrompt('Please enter an amount: ')))
    Error('Error (CashIn)')
    return
  endif
return

procedure CashOut()
  if !CashPaidOut(Val(sPrompt('Please enter an amount: ')))
    Error('Error (CashOut)')
    return
  endif
return

procedure Paper_Feed()
  if !PaperFeed(Val(sPrompt('Please enter line count: ')))
    Error('Error (PaperFeed)')
    return
  endif
return

procedure GetClock()
local dDate, cTime
  if !ReadClock(@dDate, @cTime)
    Error('Error reading clock')
    return
  endif
  ShowTitle('Read clock')
  ? '  Date: ' + dtoc(dDate)
  ? '  Time: ' + cTime
  sPrompt('Press ENTER')
return

procedure ShowVersion()
  ShowTitle('Library version')
  ? 'Version:   ' + Str(GetProperty(propVersionNumber), 5, 2)
  ? 'Signature:  ' + Left(GetProperty(propVersionStr), At(',', GetProperty(propVersionStr)))
  ? '            ' + Substr(GetProperty(propVersionStr), At(',', GetProperty(propVersionStr))+2)
  sPrompt('Press ENTER')
return

procedure Set_Clock()
local dDate, cTime
  cTime := sPrompt('Enter date (mm-dd-yyyy): ')
  dDate := ctod(cTime)
  cTime := sPrompt('Enter time (hh:mm): ')
  if !SetClock(dDate, cTime)
    Error('Error while programming printer clock')
  endif
return  

procedure SetSampleRates()
local aRates := {}
  AAdd(aRates, 22)
  AAdd(aRates, 12)
  AAdd(aRates, 3)
  AAdd(aRates, 7)
  if !SetTaxRates(aRates)
    Error('Error while programming sample tax rates')
  endif
return

procedure Sync_Clock()
  if !SyncClock()
    Error('Error while synchronizing printer clock')
  endif
return  

procedure ShowTaxRates()
local aRates := {}, x
  
  ShowTitle('Get tax rates')

  if GetTaxRates(@aRates)
    for x := 1 to Len(aRates)
    ? 'Rate ' + chr(asc('@') + x) + ':   '	            
      do case
        case valtype(aRates[x]) == 'U'
          ?? 'unused'
        case valtype(aRates[x]) == 'C'
          ?? 'free'
        otherwise
          ?? Str(aRates[x], 4, 1) + ' %'
      end
    end
  else
    Error('Cannot read tax rates from the printer.')
    return
  endif	     
  sPrompt('Press ENTER')
return

procedure DoDailyReport()
  if sPrompt('Do you want to confirm report on keyboard of printer? (Y/N): ') = 'Y'
    if DailyRep()
      return
    endif
  else
    if DailyRepEx(date())
      return
    endif
  endif
  Error('Daily report command failed.')
return

procedure PerRepByDate()
local dSt, dEd
   dSt := ctod(sPrompt('Start date (mm-dd-yyyy): '))
   dEd := ctod(sPrompt('End date (mm-dd-yyyy): '))
   if !ByDatePeriodicalRep(dSt, dEd)
     Error('Periodical report by dates could not be printed.')
   endif
return

procedure PerRepByNo()
local nSt, nEd
   dSt := Val(sPrompt('Start number: '))
   dEd := Val(sPrompt('End number: '))
   if !ByNumberPeriodicalRep(dSt, dEd)
     Error('Periodical report by numbers could not be printed.')
   endif
return

procedure DoCashRep()
   if !CashBalanceRep()     
     Error('Cash balance report could not be printed.')
   endif
return

function Login_cashier()
local cName, cNumber
  cName := sPrompt('Name of cashier: ')
  cNumber := sPrompt('Identificator of cashdesk: ')
   if !LoginCashier(cName, cNumber)     
     Error('Cashier login operation failed.')
   endif
return

function Logout_cashier()
local cName, cNumber
  cName := sPrompt('Name of cashier: ')
  cNumber := sPrompt('Identificator of cashdesk: ')
   if !LogoutCashier(cName, cNumber)     
     Error('Cashier logout operation failed.')
   endif
return

function Cashier_Rep()
local cShift, cCashier
  cCashier := sPrompt('Additional data about cashier: ')
  cShift := sPrompt('Additional data about shift: ')
   if !CashierRep(sPrompt('Erase report data from fiscal printer? (Y/N): ') = 'Y', ;
     cShift, cCashier)     
     Error('Cashier login operation failed.')
   endif
return

function SendReceipt(nSum)
  nSum := 0
  if !RcpOpen()
    Error('Cannot start new receipt.')
    return .f.
  endif
  select rcpitems
  go top
  do while !Eof()
    if !RcpItem(Name, TaxRate, Price, Quantity, QtyUnit, Quantity * Price)
      Error('Error while sending receipt item')
      RcpAbort()
      return .f.
    endif
    nSum += Quantity * Price
    skip
  end
return .t.

procedure RcpSample1()
local nSum
  if SendReceipt(@nSum)
    if !RcpClose(nSum, nSum, '0#A')
      Error('Cannot close receipt')
    endif
  endif
return

procedure RcpSample3()
local nSum
  if SendReceipt(@nSum)
    RcpPaymentItem(ofpatCard, 'VISA', 100)
    if !RcpClose(nSum, nSum-100)
      Error('Cannot close receipt')
    endif
  endif
return

procedure RcpSample4()
local nSum
  if SendReceipt(@nSum)
    if !RcpAbort()
      Error('Cannot cancel receipt')
    endif
  endif
return

procedure Status()
  Refresh()
  if RefreshEx()
    ShowTitle('Get status')
    ? 'Last library error : ' + LTrim(Str(GetProperty(propLastError), 0))
    ? 'Last printer error : ' + LTrim(Str(GetProperty(propLastNativeError), 0))
    ? 'Tax rates count    : ' + LTrim(Str(GetProperty(propTaxRatesCount), 0))
    ? 'Receipt is open    : ' + IIF(GetProperty(propReceiptIsOpen), 'Yes', 'No')
    ? 'Printer is fiscal  : ' + IIF(GetProperty(propPrinterIsFiscal), 'Yes', 'No')
    ? 'Last receipt OK    : ' + IIF(GetProperty(propLastReceiptOK), 'Yes', 'No')
    ? 'Supported printers : ' + GetProperty(propPrinterNames)
    ? 'Printer ID         : ' + GetProperty(propPrinterIDNo)
    ? 'Last record date   : ' + Dtoc(GetProperty(propLastFiscalRecordDate))
    ? 'Reset count        : ' + LTrim(Str(GetProperty(propResetCount), 0))
    ? 'Cash in drawer     : ' + LTrim(Str(GetProperty(propCashInDrawer), 10, 2))
    ? 'Currency in drawer : ' + LTrim(Str(GetProperty(propCashInDrawer2), 10, 2))
    ? 'Receipt count      : ' + LTrim(Str(GetProperty(propReceiptCount), 0))
    sPrompt('Press ENTER')  
  else
    Error('RefreshEx() failed.') 
  endif
return

procedure DoDetectPrinter()
  if DetectPrinter()
    ShowTitle('Detect printer')
    ? 'Printer type               : ' + GetProperty(propPrinterType)
    ? 'Printing mechanism         : ' + GetProperty(propPrintingMechanism)
    ? 'Printout line size         : ' + LTrim(Str(GetProperty(propPrintoutLineSize)))
    ? 'Fiscal module version      : ' + GetProperty(propFiscalModuleVer)
    ? 'Application module version : ' + GetProperty(propApplModuleVer)
    sPrompt('Press ENTER')
  else
    Error('DetectPrinter() failed.')
  endif
return
