#ifndef FORMAT_EXCEPTION_H
#define FORMAT_EXCEPTION_H

#if defined _WIN32 || defined _WIN64
#ifdef API_EXPORTS  
#define DLLEXPORT __declspec(dllexport)  
#else  
#define DLLEXPORT __declspec(dllimport)
#endif 
#else
#define DLLEXPORT
#endif

#include <iostream>
#include <exception>
#include <string>

using namespace std;

namespace CipherLab
{
	namespace DataConverter
	{
		class formatException : public exception
		{
		public:
			formatException(void){};
			~formatException(void) throw() {};
			formatException(string message, string info = "");

			string getMessage() 
			{
				string output = "";
				if(message != "")
					output += "Message: "  + message + "\n";

				if(info != "")
					output += " Extra Info: "  + info + "\n";

				return output; 
			}

		private:
			string message;
			string info;

		};

	}
}
#endif
