#ifndef TXT2PACKEDDBFCONVERTER_H
#define TXT2PACKEDDBFCONVERTER_H

#if defined _WIN32 || defined _WIN64
#ifdef API_EXPORTS
#define DLLEXPORT __declspec(dllexport)
#else
#define DLLEXPORT __declspec(dllimport)
#endif
#include <windows.h>
#include <tchar.h>
#include <strsafe.h>
#else
#define DLLEXPORT
#include <pthread.h>
#endif

#include "DataFormat.h"
#include "BasicProgDataFormat.h"
#include "CProgDataFormat.h"
#include "ForgeAgProgDataFormat.h"
#include "GeneralEnumeration.h"
#include "ProgressCallBack.h"
#include "ConversionResult.h"
#include <iostream>
#include <list>
#include <string.h>

using namespace std;

namespace CipherLab
{
	namespace DataConverter
	{
		class Txt2PackedDbfConverter
		{
		private:
			ProgrammingTool progTool;
			vector<DataFormat> dataFormatList;
			string target;
			WrongFormatAction actionTakenWhenWrong;
			ProgressCallBack* cbPtr;
		public:
			ConversionResult result;
			ConversionStatus status;
			DLLEXPORT Txt2PackedDbfConverter(BasicProgDataFormat& dataFormat, const char* target0, WrongFormatAction actionTakenWhenWrong);
			DLLEXPORT Txt2PackedDbfConverter(CProgDataFormat& dataFormat, const char* target0, WrongFormatAction actionTakenWhenWrong);
			DLLEXPORT Txt2PackedDbfConverter(ForgeAgProgDataFormat& dataFormat, const char* target0, WrongFormatAction actionTakenWhenWrong);

			DLLEXPORT Txt2PackedDbfConverter(BasicProgDataFormat* dataFormat_list, int n, const char* target0, WrongFormatAction actionTakenWhenWrong);
			DLLEXPORT Txt2PackedDbfConverter(CProgDataFormat* dataFormatList,  int n, const char* target0, WrongFormatAction actionTakenWhenWrong);
			DLLEXPORT Txt2PackedDbfConverter(ForgeAgProgDataFormat* dataFormatList, int n,  const char* target0, WrongFormatAction actionTakenWhenWrong);

			DLLEXPORT ConversionResult Convert(ProgressCallBack* cbPtr);
			DLLEXPORT ~Txt2PackedDbfConverter(){}

#if defined _WIN32 || defined _WIN64
			HANDLE  hThread;
			bool isCancel;
			void DoConvertAsyncWork();
			DLLEXPORT void ConvertAsync(ProgressCallBack* cb);
			DLLEXPORT void CancelAsync();
#else
			pthread_t thread;
			pthread_attr_t attr;
			bool isCancel;
			void *DoConvertAsyncWork();
			DLLEXPORT void ConvertAsync(ProgressCallBack* cbPtr);
			DLLEXPORT void CancelAsync();
#endif
		};

	}
}

#endif
