#ifndef ERRORRECORD_H
#define ERRORRECORD_H

#if defined _WIN32 || defined _WIN64
#ifdef API_EXPORTS  
#define DLLEXPORT __declspec(dllexport)  
#define EXPIMP_TEMPLATE
#else  
#define DLLEXPORT __declspec(dllimport)
#define EXPIMP_TEMPLATE extern
#endif 
#else
#define DLLEXPORT
#endif

#include <iostream>
#include <list>
#include <string>

using namespace std;

namespace CipherLab
{
	namespace DataConverter
	{
		class DLLEXPORT ErrorRecord
		{	
		private: 
			string fileName; 
			long recordNum; 
			string recordText; 
			bool skipped; 

		public:
			ErrorRecord(string fileName, long recordNum, string recordText, bool isSkip);
			inline const char* getFileName() { return fileName.c_str(); }
			inline long getRecordNum() { return recordNum; }
			inline const char* getRecordText() { return recordText.c_str();}
			inline bool isSkipped(){ return skipped; } 

			ErrorRecord(); 
			~ErrorRecord(); 
		};
	}
}

#endif
