#ifndef	__RTOS_H
#define	__RTOS_H
#include "type.h"


//***************************************************************************//
//                  EVENT CONTROL BLOCK                                      //
//***************************************************************************//

typedef struct os_event {
    U8             OSEventGrp;      // Group corresponding to tasks waiting for event to occur    //0
    U8             OSEventTbl[8];   // List of tasks waiting for event to occur                   //1
volatile    U16            OSEventCnt;      // Count of used when event is a semaphore                    //9
    void          *OSEventPtr;      // Pointer to message or queue structure                      //11
} OS_EVENT;                                                                                       //15 <-size

typedef	U32    OS_STACK;    /* Data type used for stack */
typedef	U8     OS_PRIORITY;
typedef	struct os_event	*OS_SEMAPHORE;

/*****************************************************************************/
/*		  uC/OS	FUNCTION PROTOTYPES				     */
/*****************************************************************************/

void		 OS_ENTER_CRITICAL(void);
void		 OS_EXIT_CRITICAL(void);

U8	         OSTaskCreate(void ( *task)(void *pd), void *pdata, OS_STACK *pstk, U32 stk_size, OS_PRIORITY prio);
U8	         OSTaskDel(OS_PRIORITY prio);
void		 OSTimeDly(U32 ticks);

OS_SEMAPHORE OSSemCreate(U16 value);
U8           OSSemPost(OS_SEMAPHORE semaphore);
void		 OSSemPend(OS_SEMAPHORE semaphore, U32 timeout, U8 *err);

#endif /* __RTOS_H */
