/*LD_VER   = 1.01     (8600) */
/*
*****************************************************************************
**
**  File        : User.ld
**
**  Abstract    : Linker script for 8600 Device 
**
**
*****************************************************************************
*/

/* Entry Point */

ENTRY(Startup)

/*======= for User modify START ======= */
GROUP(-lc -lm -lg "8600lib.a" 
        user.o
     )
/*======= for User modify END ========= */


EXTERN(HEADER)

/* Highest address of the user mode stack */
/* Generate a link error if heap and stack don't fit into RAM */
_Min_Heap_Size  = 0x200;     									 /* required amount of heap  */
_Min_Stack_Size = 0x2000; 	 									 /* required amount of stack */
size_sysram__   = 0x80000;
/* Specify the memory areas */
MEMORY
{
  FLASH (rx)      : ORIGIN = 0x14440000, LENGTH = 3840K
  RAM (xrw)       : ORIGIN = 0x1c160000, LENGTH = 512K 			 /* <--- size_sysram__   512K   */
  GVRAM (xrw)     : ORIGIN = 0x1C0F0000, LENGTH = 48K
  SARAM (xrw)     : ORIGIN = 0x1C0FC000, LENGTH = 16K
}

SECTIONS
{
   .text :  AT(0x14440000)
  {
    KEEP(*(.HEADER))
    . = ALIGN(4); 
    *(.start_code)
    *(.text .text.*)       
    . = ALIGN(4);      
  } >FLASH 
  
                /*===============================================================*/
                /* The program code and other data goes into FLASH */
                /*===============================================================*/  
  .text :
  {
     . = ALIGN(4); 
    KEEP(*(.version))
    *(.rodata)         
    *(.rodata*)      

    . = ALIGN(4);  
    _etext = .; 
  } >FLASH

    _data_LMA2 = .;
    
	
                /*===============================================================*/
                /* Initialized data sections goes into RAM, load LMA copy after code */
                /*===============================================================*/
    .data : AT ( _etext )
  {
        Ram_start = .;
          . = ALIGN(4); 
        _sdata = .;       
        *(.data)           
         . = ALIGN(4); 
        _edata = .;        
  } >RAM
  
    __size_of_data = SIZEOF(.data);
    __tail_address_cal = _etext + __size_of_data;

   .tail __tail_address_cal :  AT (((   LOADADDR(.data) + SIZEOF(.data)  + 3) &~ (0x03)) )
  {
        . = ALIGN(4); 
        _Tail_addr = .;
        _Tail_in_BIN = . - 0x14440000;
        PROVIDE (__tail = (. + SIZEOF(.data)));
        KEEP(*(.TAIL)) 
         . = ALIGN(4); 
  } /* >FLASH */
  
                /*==============================================*/
                /*    Information                               */
                /*==============================================*/
    _data_size  =  SIZEOF(.data);
  __region_init_ram = LOADADDR(.data);
  __init_size_ram = _edata - _sdata;
  
  
  
  _Real_Rom_End = _etext + SIZEOF(.data) + SIZEOF(.tail);
  _Real_Rom_size = _Real_Rom_End - 0x14440000;


  
                /*===============================================*/
                /* Uninitialized data section */
                /*===============================================*/
   .gram (NOLOAD):
  {        
        KEEP(*(.GVariables))    
  } >GVRAM
  
    .saram (NOLOAD):
  {        
        KEEP(*(.SettingArea))    
  } >SARAM
  
   .bss (NOLOAD):
  {
        _sbss = .;         
        *(.bss)
        *(.bss*)
        *(COMMON)      
        _ebss = .;                          
  } >RAM
  
    __cs3_region_size_ram = LENGTH(RAM);
  
  PROVIDE ( __cs3_heap_start = __heap_start );
  PROVIDE ( __cs3_heap_end = Ram_start + size_sysram__ );
  PROVIDE ( __estack = Ram_start + size_sysram__ );
    
   
                /*===============================================================*/
                /* User_heap_stack section, used to check that there is enough RAM left */
                /*===============================================================*/
    ._user_heap_stack (NOLOAD):
  {
        . = ALIGN(8); 
        __heap_start = .;
        . = . + _Min_Heap_Size;
        . = . + _Min_Stack_Size;
        . = ALIGN(8); 
        UsedRamEnd = .;
        ASSERT (. <= (Ram_start + size_sysram__ ), "System Ram out of range");
        PROVIDE ( RamStart = Ram_start );
        PROVIDE ( SysRamEnd = Ram_start + size_sysram__ );
        PROVIDE ( UserRamEnd = UsedRamEnd );
  } >RAM
    
  
                /*===============================================================*/
                /* Remove information from the standard libraries */
                /*===============================================================*/
   /DISCARD/ :
  {
    libc.a ( * )
    libm.a ( * )
    libgcc.a ( * )
  }

}
