#ifndef __NEPTUNE_LIB_H
#define __NEPTUNE_LIB_H

#include <CIPHER_UDF.h>
#ifndef __TYPE_H
#include <type.h>
#endif
/*============= 8600lib V1.06b ================== */

extern volatile U32  sys_sec, sys_msec;
extern U32   POWER_ON, AUTO_OFF;
extern U8  ScannerDesTbl[],ScannerDesTbl2[];
extern S32            BC_X,BC_Y;                 //battery icon position   
extern S32           AIMING_TIMEOUT;

extern U8 CodeType, CodeBuf[];
extern U8 OrgCodeType;
extern U16 CodeLen;

extern U8 AIMark[2], FsEAN128[2];
extern U16  *KEY_CLICK;
extern const U16  *SYSTEM_BEEP;
extern S32 ferrno;
extern U8  WakeUp_Event_Mask;
#define RS232_WakeUp            0x02
#define Charging_WakeUp         0x04 
#define ChargeDone_WakeUp       0x08 
#define PwrKey_WakeUp           0x10 
#define Alarm_WakeUp            0x20
#define USB_WakeUp              0x40
#define FASTV_WakeUp			0x80

void    _KeepAlive__(void);

extern U8 WedgeSetting[];
/***************** System **********************/

void    SetPwrKey(S32 state);
#define POWER_KEY_ENABLE        1
#define POWER_KEY_DISABLE       0

void    shut_down(void);
void    SysSuspend(void);
void    system_restart(void);
void    clear_bss(void);
U8 *itoa(U32 value, U8 *string, U32 radix);

U32    CheckWakeUp(void);
#define RS232_CABLE_DETECTED    0x02
#define CHARGING                0x04 
#define CHARGE_OK               0x08
#define POWER_KEY_PRESSED       0x10
#define TIME_IS_UP              0x20
#define USB_DETECTED            0x40
#define FASTV_DETECTED			0x80

#define POWERON_RESUME          0
#define POWERON_RESTART         1

/***************** Reader **********************/
typedef struct{
    U8 OffsetByte;	// target byte of setting table
    U8 MaskBit;	// used bit is 1, ex. 0x38 =bit5~3
    U8 Value;
}READER_CFG_SET;

U32    Decode(void);
void    InitScanner1(void);
void    HaltScanner1(void);

U32     ConfigureReader(void);
void    BCD2D_AIM(U32 mode);
U32 ConfigureReaderRAM(READER_CFG_SET *pReaderSet, U16 elements);
/***************** Font ************************/
//System Font                   
#define FONT_SYS_10X20         0       
#define FONT_SYS_12X24         1       
#define FONT_SYS_14X28         2
#define FONT_SYS_08X16         5
//Font Files                  
#define FONT_TC_10X20          10      
#define FONT_TC_12X24          11      
#define FONT_TC_14X28          12
#define FONT_TC_08X16          15
#define FONT_SC_10X20          20      
#define FONT_SC_12X24          21      
#define FONT_SC_14X28          22
#define FONT_SC_08X16          25
#define FONT_JP_10X20          30      
#define FONT_JP_12X24          31      
#define FONT_JP_14X28          32
#define FONT_JP_08X16          35
#define FONT_KR_10X20          40      
#define FONT_KR_12X24          41      
#define FONT_KR_14X28          42
#define FONT_KR_08X16          45
#define FONT_EU_10X20          50      
#define FONT_EU_12X24          51      
#define FONT_EU_14X28          52
#define FONT_EU_08X16          55
//Language of EU Font
#define STANDARD     0x10
#define FRENCH       0x11
#define HEBRAIC      0x12
#define LATIN        0x13
#define NODIC        0x14
#define PORTUGAL     0x15
#define RUSS         0x16
#define SLAVIC       0x17
#define POLISH       0x18
#define TURKISH      0x19
#define SLOVAK       0x1a
#define WIN1250      0x1b
#define ISO_28592    0x1c  
#define IBM_LATIN_II 0x1d
#define Greek_737    0x1e
#define CP_1252      0x1f
#define CP_1253      0x20  
#define CP_1254		 0x21

void  SetLanguage(U32 setting);
U32   GetLanguage(void);
U32   GetFont(void);
U32   SetFont(U32 font);
U32   CheckFont(void);
//
/**************** keypad ***********************/
void         clr_kb(void);
S32          kbhit(void);
S32          getchar(void);
void         en_alpha(S32);
#define      ALPHA_FIXED        1 
#define      ALPHA_ROLLING      2
void         dis_alpha();
void         LockAlphaState(S32 state);
#define      NUMERIC_KEYPAD      0
#define      UPPER_CASE          1
#define      LOWER_CASE          2
#define      FUNCTION_KEY        3
void         set_alpha_lock(S32);
S32          get_alpha_lock_state(void);
S32          get_alpha_enable_state(void);
S32          CheckKey(const S32 scan_code,...);
#define CHK_EXC      -1     //check exclusive
#define CHK_INC      -2     //check inclusive
void         SetKeyClick(S32 status);
S32          GetKeyClick(void);
void         putch(U8 c);
U32 GetKBDModifierStatus(void);
S32          TriggerStatus(void);
void         SetTrigger(S32 state);
U8 CheckKeyEnter(void);
void SetFuncToggle(U32 state);
U32 GetFuncToggle(void);
void SetFuncExtKey(U32);
U32 GetFuncExtKey(void);

//
//Configure Trigger Key
//

//trigger key scenario
#define TRIG_SET_READER_OFF          0  // trigger key action when all readers are off =  SetTrig2Key()
#define TRIG_SET_BARCODE_READER_ON   1  // trigger key action when barcode reader is on
#define TRIG_SET_RFID_READER_ON      2  // trigger key action when RFID reader is on
#define TRIG_SET_MULTI_READER_ON     3  // trigger key action when both barcode and RFID readers are on
//assign trigger key for specific reader
#define TRIGGER_BCR     0x0801
#define TRIGGER_RFID    0x0802
typedef struct          //                      Default trigger key setting:
{                       //   scenario:     0            1            2            3  
	S32 Main;           //            KEY_CR       TRIGGER_BCR  TRIGGER_RFID TRIGGER_BCR
	S32 Pistol;         //            KEY_PTRIG    TRIGGER_BCR  TRIGGER_RFID TRIGGER_BCR
	S32 Left;           //            KEY_LTRIG    TRIGGER_BCR  TRIGGER_RFID TRIGGER_RFID
	S32 Right;          //            KEY_RTRIG    TRIGGER_BCR  TRIGGER_RFID TRIGGER_RFID
}trigger_key_t;
U32 ConfigureTriggerKey(U32 scenario, trigger_key_t *keylist);                                 

// This function is out of use...
// parameter 1 for setTrig2Key
#define TRIG_MIDDLE     0	
#define TRIG_PISTOL     1
#define TRIG_LEFT	    2
#define TRIG_RIGHT   	3
void SetTrig2Key(U32 trig, U32 key);//just the same as ConfigureTriggerKey(TRIG_SET_READER_OFF, ...);

/*--------------- keypad ----------------*/
// for getchar() return value...
#define KEY_F1  0x80
#define KEY_F2  0x81
#define KEY_F3  0x82
#define KEY_F4  0x83
#define KEY_F5  0x84
#define KEY_F6  0x85
#define KEY_F7  0x86
#define KEY_F8  0x87
#define KEY_F9  0x88
#define KEY_F0  0x89
#define KEY_F10 0x89
#define KEY_F11 0x8a
#define KEY_F12 0x8b

#define KEY_F13 0x90
#define KEY_F14 0x91
#define KEY_F15 0x92
#define KEY_F16 0x93
#define KEY_F17 0x94
#define KEY_F18 0x95
#define KEY_F19 0x96
#define KEY_F20 0x97
#define KEY_F21 0x98
#define KEY_F22 0x99
#define KEY_F23 0x9a
#define KEY_F24 0x9c
#define KEY_CINC  0x9d        //Increase contrast of new 44 key keypad
#define KEY_CDEC  0x9e        //Decrease contrast of new 44 key keypad

#define KEY_SHIFT  0xf2
#define KEY_ALT    0xf1
#define KEY_FESC  0x9b
#define KEY_INS    0xa1
#define KEY_UP     0x8c
#define KEY_DOWN   0x8d
#define KEY_LEFT   0x8e
#define KEY_RIGHT  0x8f

#define KEY_MTRIG  0xaf
#define KEY_PTRIG  0xae
#define KEY_LTRIG  0xaa
#define KEY_RTRIG  0xa9

#define KEY_FUP    0x06
#define KEY_FDOWN  0x07
#define KEY_FLEFT  0x0e
#define KEY_FRIGHT 0x0f
#define KEY_BKLIT  0x04

#define KEY_ESC    0x1b
#define KEY_BS     0x08
#define KEY_CLEAR  0x01 
#define KEY_ALPHA  0x02
#define KEY_PWR    0x03
#define KEY_CR     0x0d
#define KEY_FN     0xf0
#define KEY_TAB    0xa0
#define KEY_DEL    0xa2
#define KEY_VINC	0xa3		// sound volume increase
#define KEY_VDEC	0xa4		// sound volume decrease

#define KEY_BUP    0xa5      // combination keycode of BKLIT key and UP key
#define KEY_BDOWN  0xa6      // combination keycode of BKLIT key and DOWN key
#define KEY_BLEFT  0xa7      // combination keycode of BKLIT key and LEFT key
#define KEY_BRIGHT 0xa8      // combination keycode of BKLIT key and RIGHT key

#define KEY_PLUS   0x2b
#define KEY_MINUS  0x2d
#define KEY_DOT    0x2e
#define KEY_STAR   0x2a
#define KEY_DIV    0x2f
#define KEY_NUM    0x23
#define KEY_SP     0x20

// for checkKey() parameters...
#define SC_0        0
#define SC_1        1
#define SC_2        2
#define SC_3        3
#define SC_4        4
#define SC_5        5
#define SC_6        6
#define SC_7        7
#define SC_8        8
#define SC_9        9

#define SC_LEFT     10
#define SC_RIGHT    11
#define SC_UP       12
#define SC_DOWN     13

#define SC_ALPHA    14
#define SC_BL       15

#define SC_BS       17
#define SC_ESC      18
#define SC_FUNC     19
#define SC_PWR      20
#define SC_TRIG     21
#define SC_SP       22

#define SC_MINUS    23
#define SC_DOT      24
#define SC_STAR     25
#define SC_CR       26

#define SC_PLUS     28
#define SC_DIV      29
#define SC_NUMBER   30

#define SC_F1       31
#define SC_F2       32
#define SC_F3       33
#define SC_F4       34
#define SC_F5       35
#define SC_F6       36
#define SC_F7       37
#define SC_F8       38
#define SC_F9       39
#define SC_F10      40

/***************** LCD Display ******************/
//Backlit Device: LCD or Keypad
#define BKLIT_DEV_LCD          0
#define BKLIT_DEV_KEY          1
//Backlit Profile
#define BKLIT_PROFILE_BATTERY  0
#define BKLIT_PROFILE_EXPOWER  1
//Backlit Level
#define BKLIT_LEVEL_1          1
#define BKLIT_LEVEL_2          2
#define BKLIT_LEVEL_3          3
#define BKLIT_LEVEL_4          4
#define BKLIT_LEVEL_5          5
U32 SetBacklitLevel(U32 device, U32 profile, U32 level);
U32 GetBacklitLevel(U32 device, U32 profile);
U32 SetBacklitTimeout(U32 device, U32 profile, U32 timeout);
U32 GetBacklitTimeout(U32 device, U32 profile);
//Backlit is on by pressing any key or backlit key
#define BKLIT_TRIG_ANY_KEY     1
#define BKLIT_TRIG_BKLIT_KEY   2
U32 SetBacklitTrigger(U32 device, U32 profile, U32 trigger);
U32 GetBacklitTrigger(U32 device, U32 profile);
//Force to turn on/off backlit
#define BKLIT_OFF              0
#define BKLIT_ON               1
void BacklitOn(U32 device, U32 OnOff);
//
//
// Color (24-bit)
//                                         //R   G   B
#define COLOR_BLACK     (U32)0x00000000    //000,000,000
#define COLOR_BLUE      (U32)0x000000FF    //000,000,255
#define COLOR_LIME      (U32)0x0000FF00    //000,255,000
#define COLOR_RED       (U32)0x00FF0000    //255,000,000
#define COLOR_YELLOW    (U32)0x00FFFF00    //255,255,000
#define COLOR_CYAN      (U32)0x0000FFFF    //000,255,255
#define COLOR_MAGENTA   (U32)0x00FF00FF    //255,000,255
#define COLOR_MAROON    (U32)0x00800000    //128,000,000
#define COLOR_GREEN     (U32)0x00008000    //000,128,000
#define COLOR_NAVY      (U32)0x00000080    //000,000,128
#define COLOR_OLIVE     (U32)0x00808000    //128,128,000
#define COLOR_TEAL      (U32)0x00008080    //000,128,128
#define COLOR_PURPLE    (U32)0x00800080    //128,000,128
#define COLOR_GRAY      (U32)0x00808080    //128,128,128
#define COLOR_SILVER    (U32)0x00C0C0C0    //192,192,192
#define COLOR_WHITE     (U32)0x00FFFFFF    //255,255,255
#define COLOR_NONE      (U32)0x80000000    //transparent

//
#define LCD_DRAWING_LAYER0       0
#define LCD_DRAWING_LAYER1       1
#define COLOR_ORDER_PRIMARY      1
#define COLOR_ORDER_SECONDARY    0
void          SetColor(S32 layer, S32 order, U32 color);
U32           GetColor(S32 layer, S32 order);
void          ShowPic(S32 layer, S32 pos_x, S32 pos_y, S32 size_x, S32 size_y, const Pixel *ColorBitmap);
void          GetPic(S32 layer, S32 pos_x, S32 pos_y, S32 size_x, S32 size_y, Pixel *ColorBitmap);
//---BMP error code
#define BMP_OPEN_FAIL	-1
#define BMP_ERR_INFO	-2
#define BMP_ERR_TYPE	-3
#define BMP_ERR_COLOR_TYPE	-4
#define BMP_ERR_SIZE	-5
#define BMP_ERR_READ	-6
S32           ShowBMP(S32 layer, S32 pos_x, S32 pos_y, const void *BMPFile, Pixel *outbuf);
//---JPG error code---------
#define JPG_OPEN_FAIL       -1
#define JPG_GET_INFO_FAIL   -2
#define JPG_SIZE_INPUT_OVER -4
#define JPG_SCALE_ERROR      -5
S32 		ShowJPG(S32 layer, S32 pos_x, S32 pos_y , char scale_ratio, const void *JPGFile);
S32 		ShowJPGBySz(S32 layer, S32 pos_x, S32 pos_y,S32 size_x, S32 size_y ,const void *JPGFile);
void 		PlayJPG(U8* DataPath,S32 DelaySec, S32 Zoom);

#define VIDEO_NORMAL    0
#define VIDEO_REVERSE   1
U32           GetVideoMode(void);
void          SetVideoMode(U32 mode);

void          fill_rect(S32 pos_x, S32 pos_y, S32 size_x, S32 size_y);
S32           printf(const S8 *format, ...);
S32           putchar(S32 c);
S32           puts(const S8 *s);

#define HOURGLASS_24x23    1
#define HOURGLASS_8x8      2
void          WaitHourglass(S32 UppLeftX,S32 UppLeftY,S32 type);

#define CURSOR_OFF      0
#define CURSOR_ON       1
U32           GetCursor(void);
void          SetCursor(U32 cursor);
void          gotoxy(U32 col, U32 row);
U32           wherex(void);
U32           wherey(void);
void          wherexy(U32* col, U32* row);

void          clr_eol(void);
void          clr_scr(void);
void          clr_icon(void);
void          clr_rect(S32 pos_x, S32 pos_y, S32 size_x, S32 size_y);

void          show_image(S32 pos_x, S32 pos_y, S32 size_x, S32 size_y, const void* bitmap);
void          get_image(S32 pos_x, S32 pos_y, S32 size_x, S32 size_y, void* bitmap);

/***************** Security ********************/
S32 CheckPasswordActive();
S32 CheckSysPassword(const char * psw);
S32 SaveSysPassword(const char * psw);
S32 InputPassword(char *psw);

//----------------GPS---------------------------/
typedef struct 
{
    U8 Status;// 1:valid data(positioned), 0:invalid data(not positioned)
    U32  Speed;//km/h
    U8 Latitude[11];//ddmm.mmmmN or ddmm.mmmmS
    U8 Longitude[12];//dddmm.mmmmE or dddmm.mmmmW
    U8 SNR;//average SNR
    U8 SatelliteNum;//satellite number
    S32           Altitude;//M  
}GPSINFO;

void            StartGps(void);
void            StopGps(void);
U8   GetGpsInfo(void *buf,U8 index);

#define GPS_STATUS          1
#define GPS_SPEED           2
#define GPS_LATITUDE        3
#define GPS_LONGITUDE       4
#define GPS_SNR             5
#define GPS_SATELLITE_NUM   6
#define GPS_ALTITUDE        7

/***************** buzzer **********************/
U8		on_beeper(const void *);
void	off_beeper(void);
S32		beeper_status(void);
void	play(const S8 *);
S32 	get_beeper_vol(void);
void	set_beeper_vol(S32 level);
#define MUTE_VOL    0
#define LOW_VOL     1
#define MEDIUM_VOL  2
#define HIGH_VOL    3
//----------------RFID-------------------------------------------------
// Support Tag type
#define    TAG_ISO15693         		'V'
#define    TAG_Tagit	       			'T'
#define    TAG_Icode	        		'I'
#define    TAG_MifareISO14443A  		'M'
#define    TAG_SR176            		'S'
#define    TAG_ISO14443B        		'Z'

// Key Type
#define KEYA         1
#define KEYB         2

typedef struct RFIDStruct
{
	U8 TagType[4];
	U32  StartByte;	
	U32  MaxLen;		
	U8 scanMode;
	U8 scanTimeout;
	U8 Reserve[18];	
}RFIDParameter;

// scan modes
#define RFID_TESTING_MODE	0
#define RFID_SINGLE_MODE	1

void RFIDReadFormat(RFIDParameter *);
void RFIDWriteFormat(RFIDParameter *);
void SetRFIDSecurityKey(U8 TagType, U8 *KeyString, U8 KeyType);
S32 GetRFIDSecurityKey(U8 TagType, U8 *KeyString, U8 *KeyType);

typedef struct{
    U16 LEN;
    U8 szSAMfbData[120];
    U8 SW1;
    U8 SW2;
}APDU_FEEDBACK;
extern APDU_FEEDBACK apdu_feedback;

U8 ResetSAM(void);
U8 ApduSAM(U8 *ApduData, U8 ApduLen);

/***************** LED *************************/
void         set_led(S32 led, S32 mode, S32 duration);
// led definition
#define LED_RED         0
#define LED_GREEN       1
#define LED_BLUE        2       //System 
#define LED_GREEN2      3       //System Green LED

// mode definition
#define LED_OFF         0
#define LED_ON          1
#define LED_FLASH       2
// mode definition : special for LED_BLUE & LED_GREEN2 control
#define LED_SYSTEM_CTRL     0xf0
#define LED_USER_CTRL       0xf1


/***************** Vibrator ********************/
void SetVibrator(S8 mode);
#define VIBR_OFF        0
#define VIBR_ON         1

S32 GetVibrator();

/***************** Calendar/Alarm **************/
S32 set_time(S8* time);
void get_time(S8* time);
S32 DayOfWeek(void);

void SetAlarm(const S8* time_buf);
void GetAlarm(S8* time_buf);
typedef struct {
    S8 MuteStart[15];         //yyyymmddhhmmss+0x00
    S8 MuteStop[15];          //yyyymmddhhmmss+0x00
    S8 Type;
} MUTE_TABLE;
#define APP_MUTE        0x01
#define NORMAL_MUTE     0x02

/*****************Battery***********************/
S32  get_vmain(void);
S32  get_vbackup(void);
U32  charger_status(void);
#define CHARGE_STANDBY     0x00
#define CHARGING_USB       0x11
#define CHARGING_5V        0x01
#define CHARGE_DONE        0x02
#define CHARGE_FAIL     0x03

U32 GetUSBChargeCurrent(void);
U32 SetUSBChargeCurrent(S32 current);
#define CURRENT_500mA       0x00
#define CURRENT_100mA       0x01
#define CURRENT_0mA         0x02

/************* Cradle Type Detect **************/
U16 GetIOPinStatus(void);
#define     NO_CRADLE                 0x00
#define     MODEM_CRADLE              0x01
#define     ETHERNET_CRADLE           0x02
#define     GPRS_CRADLE               0x03
#define     CHARGER_CRADLE            0x04
#define     RS232_CABLE_DISCONNECTED  0x00   //bit 4 is reset
#define     RS232_CABLE_CONNECTED     0x10   //bit 4 is set
#define     USB_CABLE_DISCONNECTED    0x00   //bit 5 is reset
#define     USB_CABLE_CONNECTED       0x20   //bit 5 is set
#define     ADAPTER_DISCONNECTED      0x00   //bit 6 is reset
#define     ADAPTER_CONNECTED         0x40   //bit 6 is set
#define 	FASTVPORT_CABLE_DISCONNECTED 0
#define		FASTVPORT_CABLE_CONNECTED		0x80	//bit 7 is set

/***************** Menu ************************/
struct SMENU {
    S32 total_entry;
    S32 selected_entry;
    S32 ReturnFlag;
    S8* title;
    struct SMENU_ENTRY* entry_list[14];
};

struct SMENU_ENTRY {
    S32 text_x;
    S32 text_y;
    S8* text;
    void (*func)(void);
    struct SMENU *sub_menu;
};

typedef struct SMENU MENU;
typedef struct SMENU_ENTRY MENU_ENTRY;
S32          prc_menu(MENU* menu);
void SetMenuPauseTime(U32 time);  // unit: 5 msec
U32 GetMenuPauseTime(void);

/***************** Communication ***************/

U32     SetCommType(U32 port, U32 type);
U32     open_com(U32 port, U32 setting);
U32     nwrite_com(U32 port,U8 *buf, U32 len);
U32     read_com(U32 port, U8 *buf);
U32     write_com(U32 port, U8 *buf);
U32     com_eot(U32 port);
U32     close_com(U32 port);
U32     com_overrun(U32 port);
U32     clear_com(U32 port);
void    com_rts(U32 port, U32 value);
U32     com_cts(U32 port);

// port
#define     PORT_RS232          1
#define     PORT_BLUETOOTH      2
#define		PORT_RFID			4
#define     PORT_USB            5
#define 	PORT_FASTVPORT		6		// type= USBVCOM_CDC, or USBVCOM

#define     COMM_DIRECT         0       /* port=1, RS232 */
#define     COMM_RF             4       /* port=2, Bluetooth */
#define     COMM_USBHID         7       /* port=5, USB HID */
#define     COMM_USBVCOM        8       /* port=5, USB Virtual COM */
#define     COMM_USBDISK        9       /* port=5, USB Mass Storage */
#define     COMM_USBVCOM_CDC   10       /* port=5, USB CDC Virtual COM */ 


#define BAUD_115200         	0x00	// baud rate, rs232 use table to convert value for baudrate...
#define BAUD_57600          	0x01
#define BAUD_38400          	0x02
#define BAUD_19200          	0x03
#define BAUD_9600           	0x04
#define BAUD_4800           	0x05
#define BAUD_460800           	0x06  // for FastVPort
#define BAUD_345600            	0x07  // for BT use

#define DATA_BIT9           	0x00/* number of data bits, parity bit at MSB */
#define DATA_BIT8           	0x08

#define PARITY_NONE         	0x00/* parity */
#define PARITY_ODD          	0x10
#define PARITY_EVEN         	0x30

#define HANDSHAKE_NONE      	0x00/* flow control */
#define HANDSHAKE_CTS   	    0x40
#define HANDSHAKE_XON  	        0xc0
/***************** USB ***********************/
typedef struct  {
    U16 Reservedflag:15;
    U16 CommBySerial:1;
} USB_FLAG1;

struct USBCONFIG {
    USB_FLAG1 Flag1;
    U8 ReservedByte[126];
};
#define P_USB_VCOM_BY_SN    80
#define USB_VCOM_FIXED      0  //default 
#define USB_VCOM_BY_SN      1

#define USB_SD_DISK         0x01
#define USB_RAM_DISK        0x02
/***************** System Information **********/
void * SerialNumber(void);
void * OriginalSerialNumber(void);
void * HardwareVersion(void);
void * ManufactureDate(void);
void * LibraryVersion(void);
void * BootloaderVersion(void);
void * KernelVersion(void);
void * FontVersion(void);
void * NetVersion(void);
void * PPPVersion(void);
void * DeviceType(void);
void * RFIDVersion(void);
//  "0xxx"    No reader
//  "1xxx"    CCD reader
//  "2xxx"    Laser reader
//  "3xxx"    2-D reader
//  "4xxx"    1-D Long Range
//  "x0xx"    No external Module exist
//  "x3xx"    GSM (+Bluetooth) Module    
//  "x4xx"    802.11b (+Bluetooth) Module    
//  "x5xx"    Bluetooth Module only
//  "x7xx"    802.11b+GSM (+Bluetooth) Module   
#define ENGINE_1D_C         1
#define ENGINE_1D_L         2
#define ENGINE_2D_S         3
#define ENGINE_1D_S         4

U16    KeypadLayout(void);
#define KEY_ID_29 0
#define KEY_ID_39 1

U32 GetRFmode(void);
#define NO_RF_MODEL         0x00
#define MODE_802DOT11       0x04
#define MODE_BLUETOOTH      0x05
#define MODE_802DOT11_BT    0x08

#define MODE_RFID           0x01
#define MODE_GPS            0x02
/***************** Graphic **********************/
// type
#define     SHAPE_NORMAL  0
#define     SHAPE_FILL    1
// mode
#define     DOT_MARK       1
#define     DOT_CLEAR      0
#define     DOT_REVERSE    -1

void         putpixel(S32 pos_x,S32 pos_y,S32 mode);
void         line(S32 X1,S32 Y1,S32 X2, S32 Y2,S32 mode);
void         rectangle(S32 X1,S32 Y1,S32 X2, S32 Y2,S32 type,S32 mode);
void         circle(S32 x, S32 y,S32 r,S32 type,S32 mode);


/***************** Memory **********************/
S32   WriteFlash(void* target_addr, void* source_addr, U32 size);
S32   EraseSector(void* sector_start_addr);
S32   FlashSize(void);

U32          RamSize(void);
S32          free_memory(void);
void         init_free_memory(void);

/***************** 36xx **********************/
S8 Set36xxParameter(void *nc, U32 index);
void Get36xxParameter(void *nc, U32 index);
//define config index
#define P_SET_TO_36XX       0       // update settings to 36xx
//;
#define P_ACL_TYPE          1       // ACL 36xx USB VCOM/HID Keyboard type
  #define ACL_CDCVCOM             95
  #define ACL_VCOM                96
  #define ACL_PCAT_US             97
  #define ACL_PCAT_French         98
  #define ACL_PCAT_German         99
  #define ACL_PCAT_Italy          100
  #define ACL_PCAT_Swedish        101
  #define ACL_PCAT_Norwegian      102
  #define ACL_PCAT_UK             103
  #define ACL_PCAT_Belgium        104
  #define ACL_PCAT_Spanish        105
  #define ACL_PCAT_Portuguese     106
  #define ACL_PS55A01_2_Japanese  107
  #define ACL_USER_Defined_KBD    108
  #define ACL_PCAT_Turkish        109
  #define ACL_PCAT_Hungarian      110
  #define ACL_PCAT_Swiss          111
  #define ACL_PCAT_Danish         112
  #define ACL_PCAT_End            112
//;
#define P_INTER_CHAR_DELAY  2
//;
#define P_36XXSN            3
//;
#define P_DIGITS_TRANS      4
  #define AlphaNumKeyPad          0
  #define NumericKeypad           1
//;
#define P_CAPSLOCK_TYPE     5
  #define CapLockNormal           0
  #define CapLockKbd              2
  #define SftLockKbd              3
//;
#define P_DIGITS_LAYOUT     6
  #define DigitsNormal            0
  #define DigitsLowerRow          2
  #define DigitsUpperRow          3
//;
#define P_ALPHABET_TRANS    7
  #define CaseSensitive           0
  #define IgnoreCase              1
//;
#define P_CAPSLOCK_MODE     8
  #define CapLockOff              0
  #define CapLockOn               1
  #define AutoDetection           2
//;
#define P_ALT_COMPOSE       9
  #define DisAltSending           0
  #define EnAltSending            1
//;
#define P_KBD_LAYOUT        11
  #define KBLayoutNormal          0
  #define KBLayoutAZERTY          1
  #define KBLayoutQWERTZ          2
//;
#define P_HID_CHAR_TRANS    12
#define HIDBatchMode              0
#define HIDByCharMode             1

/***************** Network **********************/
void GetNetParameter(void *nc, S16 index);
void SetNetParameter(void *nc, S16 index);
//define config index
#define P_LOCAL_IP            1
#define P_SUBNET_MASK         2
#define P_DEFAULT_GATEWAY     3
#define P_DNS_SERVER          4
#define P_LOCAL_NAME          5
#define P_SS_ID               6
#define P_WEPKEY_0            7
#define P_WEPKEY_1            8
#define P_WEPKEY_2            9
#define P_WEPKEY_3            10
#define P_DHCP_ENABLE         11
#define P_AUTHEN_ENABLE       12
#define P_WEP_LEN             13
#define P_SYSTEMSCALE         14
#define P_DEFAULTWEPKEY       15
#define P_DOMAINNAME          16
#define P_WEP_ENABLE          17
#define P_EAP_ENABLE          18
#define P_EAP_ID              19
#define P_EAP_PASSWORD        20
#define P_POWER_SAVE_ENABLE   21
#define P_PREAMBLE            22
#define P_MACID               23
#define P_ADHOC               30
#define P_FIRMWARE_VERSION    31
#define P_WPA_ENABLE          33
#define P_WPA_PSK_ENABLE      33
#define P_WPA_PASSPHRASE      34
#define P_BSSID               35
#define P_FIXED_BSSID         36
#define P_ROAM_TXRATE_11B     37
#define P_ROAM_TXRATE_11G     38
#define P_WPA2_PSK_ENABLE     39
#define P_SCAN_TIME           48
#define P_PROFILE_1           49
#define P_PROFILE_2           50
#define P_PROFILE_3           51
#define P_PROFILE_4           52
#define P_APPLY_PROFILE_1     53
#define P_APPLY_PROFILE_2     54
#define P_APPLY_PROFILE_3     55
#define P_APPLY_PROFILE_4     56
#define P_SCAN_CHANNEL        57
#define P_SCAN_CHANNEL_TIME   58
#define P_ROAM_RSSI_THRHOLD   91
#define P_ROAM_RSSI_DELTA     92
#define P_ROAM_PERIOD         93

// Bluetooth device
#define P_BT_MACID              24
#define P_BT_REMOTE_NAME        25
#define P_BT_SECURITY           26
#define P_BT_PIN_CODE           27 
#define P_BT_BROADCAST_ON       28
#define P_BT_POWER_SAVE_ON      29
#define P_BT_GPRS_APNAME        32

#define P_BT_FREQUENT_DEVICE1   40
#define P_BT_FREQUENT_DEVICE2   41
#define P_BT_FREQUENT_DEVICE3   42
#define P_BT_FREQUENT_DEVICE4   43
#define P_BT_FREQUENT_DEVICE5   44
#define P_BT_FREQUENT_DEVICE6   45
#define P_BT_FREQUENT_DEVICE7   46
#define P_BT_FREQUENT_DEVICE8   47

struct NETSTATUS {
    S16  State;             // 0:Disconnected, 1:connected
    S16  Quality;
    S16  Signal;
    S16  Noise;
    S16  Channel;
    S16  TxRate;            // 0~12
	S16  IPReady;           // 0: not ready, 1:ready
};

struct RADIOSTATUS {
    S16  SNR;                      // signal to noise ratio, positive dB
    S16  RSSI;                     // negative dBm
    S16  NoiseFloor;               // negative dBm
};

#define NET_DISCONNECTED    0
#define NET_CONNECTED       1

S16 CheckNetStatus(S16 index);
#define WLAN_State          0
#define WLAN_Channel        4
#define WLAN_TxRate         5
#define NET_IPReady         6
#define BT_State            7
#define BT_Signal           8
#define WLAN_SNR            14
#define WLAN_RSSI           15
#define WLAN_NOISEFLOOR     16

typedef struct  {
    U16 Reservedflag:5;                                            
    U16 SiteScan:1;                // SiteScan, 0:Normal operation, 1:Site Scan Only,not run MrvHandleTask
    U16 ScanTime:1;                // ScanTime, 0:Normal(default)-100ms, 1:Double-200ms
    U16 WPA2_PSK:1;                 // WPA2-PSK, 0:Disable 1: Enable, add for WPA2
    U16 WPA_PSK:1;                  // WPA-PSK, 0:Disable 1: Enable.  rename WPA to WPA_PSK
    U16 AdHoc:1;                   //AdHoc mode setting, 0:disable, 1:enable
    U16 Preamble:2;                //Preamble Setting, 0:disallow 1:long 2:short 3:both
    U16 PWRSave:1;                 //Power-Saving-Mode setting, 1:enable,0:disable
    U16 Eap:1;                     //EAP Setting,1:enable,0:disable
    U16 Wep:1;                     //WEP kEY Setting,1:enable,0:disable, also used to set Bluetooth PIN code 
    U16 Authen:1;                  //Authenication Setting, 1:open system 0:share key
} WLAN_FLAG;

// structure size 750 bytes
struct NETCONFIG {
    S16  DhcpEnable;                        // 0 : Disable, 1 : Enable
    U8 IpAddr[4];
    U8 SubnetMask[4];
    U8 DefaultGateway[4];
    U8 DnsServer[4];
    S8 DomainName[129];
    S8 LocalName[33];
    S8 SSID[33];
    S16  SystemScale;                       // AP Density, 1-low,2-medium,3-high
    WLAN_FLAG Flag;                         // flag setting        
    S16  WepLen;                            // 0 : 64 bits (5 bytes), 1 : 128 bits (13 bytes)
    S16  DefaultKey;                        // 0 V 3, Key to be used
    U8 WepKey[4][14];            // WEP Keys, also used to set bluetooth PIN code
    S8 EapID[33];
    S8 EapPassword[33];
    S8 WPAPassphrase[64];                 // Passphrase for both WPA and WPA2 
    U8 WPApmk[32];
    U8 WPAchk[2];
    U8 CurrentBSSID[6];
    U8 FixedBSSID[6];            // Fixed AP's MACID to connect
    S16  iRoamingTxLimit_11b; 
    S16 iRoamingTxLimit_11g;
    S16 RssiThreshold;             // -50 ~ -90   dBm   default -70
    S16 RssiDelta;                 // 0 ~ 20      dBm             5
    S16 RoamingPeriod;             // 3 ~ 10      sec             5
    S8 ReservedByte[287];
};

typedef struct{
    U8 SSID[32];
    U8 BSSType;    // 0: Ad-Hoc,    1:Infrastructure
    U8 Security;       // 0:None, 1:WEP OpenSystem, 2:WEP Share Key 3:WPAPSK, 4.WPA2PSK, 5.EAP
    
    union{
        struct WEP{
            S8 WepLen;         // 0 : 64 bits (5 bytes), 1 : 128 bits (13 bytes)
            S8 DefaultKey;     // 0 - 3, Key to be used
            S8 WepKey[4][14];  // WEP Keys
            }WEP;
        struct EAP{
            S8 EapID[33];
            S8 EapPassword[33];
            }EAP;
        S8 WPAPassphrase[64];
    }Keys;// 66 Bytes
}WIFIPROFILE;//size= 100 Bytes
struct WIFI_PROFILES{
    WIFIPROFILE pROfILE[4];    
}; 

typedef struct{
    U8 SSID[32];
    U8 BSSID[6];
    S8 Rssi;
    U8 Channel;
    U8 BandType;   // 0: 802.11b/g  1:802.11b
    U8 BSSType;    // 0: Ad-Hoc,    1:Infrastructure
//    U8 Security;   // bit0:WEP   bit1:WPA   bit2:WPA2 
    union{
        U8 Byte;
        struct{
            U8 wep     :1;
            U8 wpa     :1;
            U8 wpa2    :1;
            U8 reserved:5;
        }Bit;
    }Security;
}WifiDev;
/***************** Bluetooth********************/
typedef struct
{
    S16 State;                             
    S16 Signal;
    S16 Reserved[10];
}BTSTATUS;

// define State value
#define BT_DISCONNECTED    0
#define BT_CONNECTED       1

typedef struct
{
    U8  Machine;                  //machine type ,0:empty, 1:AP, 3:SPP 4:DUN, if bit7=1 means current connection
    U8  ADDR[6];
    U8  Name[32];
    U8  PINCode[16];
    U8  LinkKey[16];
}BTSearchInfo;                             //size=51 byte

S16 BTInquiryDevice(BTSearchInfo *Info, S16 maxnumber);
S16 BTPairingTest(BTSearchInfo *Info, S16 TargetMachine);
#define BTNetworkAccessPoint  1
#define BTSerialPort          3
#define BTDialUpNetworking    4
#define BTHIDDevice           5
#define BTOBEXFTPServer       7

typedef struct
{    
    U16 Reservedflag    :13;//size= 2 byte
    U16 BTBroadcastON   :1; //Bluetooth Broadcast 1: enable 0:disable
    U16 BTSecurity      :1; //Bluetooth Securtiy setting,1:enable,0:disable
    U16 BTPWRSaveON     :1; //Bluetooth Power-Saving-Mode setting, 1:enable,0:disable
}BT_FLAG;

//total=704 byte
typedef struct
{
    S8 BTRemoteName[20];
    U8  BTPINCode[16];
    U8  BTLinkKey[16];
    BTSearchInfo Dev[8];                    //8*51=408
    BT_FLAG Flag;                           // flag setting
    U8  BTGPRSAPname[20];         // the GPRS AP name for BT-GPRS connection
    U8  ACL36xx[16];
    S8  ReservedByte[204];
}BTCONFIG;

void  BTPairingTestMenu(void);              //simple application for user pairing
void  FreqDevListMenu(void);                //simple application for user listing devies


#define     BT_SERIALPORT_SLAVE     0x00
#define     BT_SERIALPORT_MASTER    0x03
#define     BT_DIALUP_NETWORKING    0x04
#define     BT_HID_DEVICE           0x05
#define     BT_ACL_36XX             0x09
/***************PPP Connection*********************/

#define     P_PPP_DIALUPHONE    70
#define     P_PPP_LOGINNAME     71
#define     P_PPP_LOGINPASSWORD 72
#define     P_PPP_BAUDRATE      73

//total=100 byte
typedef struct  {
    U8 DialUpPhone[20];                // ISP phone number
    U8 LoginName[41];                  // ISP login username
    U8 LoginPassword[20];              // ISP login password
    S32           ComBaudRate;                    // Baud rate, according to open_com: 
                                                  /* BAUD_115200: 0x00 ; BAUD_76800: 0x01
                                                     BAUD_57600 : 0x02 ; BAUD_38400: 0x03
                                                     BAUD_19200 : 0x04 ; BAUD_9600 : 0x05
                                                     BAUD_4800  : 0x06 ; BAUD_2400 : 0x07 */
    char ReservedByte[17];
} PPPCONFIG;

/********* Networking via GPRS Cradle *************/

//define config index
//#define P_GSM_PIN_CODE              61
//#define P_GPRS_AP                   62
#define P_GSM_NET                   63
#define P_GPRS_CHAP_ENABLE          65
#define P_GPRS_CHAP_PASSWORD        66
#define P_GPRS_CHAP_USERNAME        67

typedef struct  {
    U32 Reservedflag:15;          //reserved
    U32 CHAPEnable:1;             //PPP CHAP, 1:enable,0:disable
} GPRS_FLAG;


//total 256 byte
typedef struct  {
    U8 Reserved_1[51];
    U8 NET[21];
    U8 Reserved_2[21];
    GPRS_FLAG Flag;                           // flag setting
    S8 CHAPPassword[33];
    S8 CHAPUserName[33];
    S8 Reserved_3[95];
} GSMCONFIG;

/***************** Input ***********************/
S16 str_input(S8 *buf, S16 max_len);
S16 int_input(S16 max_data_size);

/************ File System ***********/
//Seek Origin
#undef       SEEK_SET
#define      SEEK_SET        1 
#undef       SEEK_CUR
#define      SEEK_CUR        0
#undef       SEEK_END
#define      SEEK_END        -1
//
// Legacy File API
//
// available for DAT & DBF in RAMDisk and SD Card
S32          access(const S8* file_name);
S32          read_error_code(void); //get fErrorCode 
S32          remove(const S8* file_name);
S32          rename(const S8* old_name, const S8* new_name);
//
// available for DAT & DBF in RAMDisk
S32          get_file_number(S32 type);//only support RAMDisk
//
// available for DAT in RAMDisk and SD Card
S32          append(S32 fd, S8* buffer, S32 count);
S32          appendln(S32 fd, S8* buffer);
S32          chsize(S32 fd, S32 size);
S32          close(S32 fd);
S32          eof(S32 fd);
S32          filelength(S32 fd);
S32          lseek(S32 fd, S32 offset, S32 origin);
S32          open(const S8* file_name);
S32          read(S32 fd, S8* buffer, S32 count);
S32          readln(S32 fd, S8* buffer, S32 max_count);
S32          tell(S32 fd);
S32          write(S32 fd, S8* buffer, S32 count);
S32          writeln(S32 fd, S8* buffer);
//
// available for DBF in RAMDisk and SD Card
S32          create_DBF(const S8* file_name, S16 member_len);
S32          open_DBF(const S8* file_name);
S32          close_DBF(S32 fd);
S32          create_index(S32 fd, S32 key_number, S16 key_offset, S16 key_len);
S32          remove_index(S32 fd, S32 key_number);
S32          rebuild_index(S32 fd, S32 key_number, S32 base_index, S16 key_offset, S16 key_len);
S32          add_member(S32 fd, S8* member);
S32          lseek_DBF(S32 fd, S32 key_number, S32 offset, S32 origin);
S32          tell_DBF(S32 fd, S32 key_number);
S32          has_member(S32 fd, S32 key_number, S8* key_value);
S32          get_member(S32 fd, S32 key_number, S8* buffer);
S32          member_in_DBF(S32 fd);
S32          update_member(S32 fd, S32 key_number, S8* member);
S32          delete_member(S32 fd, S32 key_number);
//
// fErrorCode got from read_error_code() 
#define F_ERR_ILLEGAL_FNAME         1      //
#define F_ERR_FILE_NOT_EXIST        2      //
#define F_ERR_FILE_NAME_REPEAT      3      //
#define F_ERR_ILLEGAL_FTYPE         4      //
#define F_ERR_ALREADY_OPENED        5      //
#define F_ERR_NO_AVAILABLE_FD       6      //
#define F_ERR_INVALID_FD            7      //
#define F_ERR_FILE_NOT_OPEN         8      //
#define F_ERR_NEGATIVE_COUNT        9
#define F_ERR_INVALID_ORIGIN        9      //
#define F_ERR_INVALID_MB_LEN        9
#define F_ERR_NOT_ENOUGH_SPACE      10     //
#define F_ERR_NO_TERMINALATOR       11
#define F_ERR_DBF_ALREADY_CREATED   12     //
#define F_ERR_INVALID_KEY_NUM       13     //
#define F_ERR_IDX_NOT_EXIST         14     //
#define F_ERR_FPTR_EXCEED_EOF       15     //
#define F_ERR_EMPTY_DBF             16
#define F_ERR_INVALID_KEY_PARA      17     //
#define F_ERR_DBF_NOT_EMPTY         18
#define F_ERR_IDX_ALREADY_EXIST     19     //
#define F_ERR_INVALID_BASE_IDX      20     //
#define F_ERR_BASE_IDX_NOT_EXIST    21
#define F_ERR_DIFFERENT_DISK        22     //
#define F_ERR_FTYPE_MISMATCH        23     //
#define F_ERR_INDEX_CORRUPTED       24     //

#define F_ERR_FAIL_OPEN_SOURCE      31     //
#define F_ERR_FAIL_CREAT_TARGET     32
#define F_ERR_FAIL_WR_TARGET        33     //

/****************** FAT File System ***********************/
//// File status structure
typedef struct  {
    U32  fsize;         // Size
    U16  fdate;	  	    // Date
    U16  ftime;	  	    // Time
    U8   fattrib; 	    // Attribute
    S8   fname[13];	    // Name (8.3 format)
} FILEINFO;

struct index_INFO {
    U16  key_len;
    U16  key_offset;
    U32  index_file_size;
};

typedef struct  {
    U8   file_type;                              // Valid for ALL    1-DAT, 2-DBF, 3-Index
    U8   open_status;                            // Valid for ALL    1-Open, 0-Close
    U32  fileSize;                               // Valid for ALL    File size in bytes

    U32  total_member;                           // Valid for DBF : number of total member
    U16  Member_len;                             // Valid for DBF : member length
    U8   IndexNumber;                            // Valid for DBF : number of index file
    struct index_INFO  index[8];                            // Valid for DBF : index[0] for Index file, index[0~7] for DBF file
} DEVICE_FILEINFO;


// File attribute
#define FA_NOR	0x00	    // Normal (no attriutes)
#define FA_RDO	0x01	    // Read only
#define FA_HID	0x02	    // Hidden
#define FA_SYS	0x04	    // System
#define FA_VOL	0x08	    // Volume label
#define FA_DIR	0x10	    // Directory
#define FA_ARC	0x20	    // Archive
#define FA_ERR  0x40        // Error if >= FA_ERR

S32     fopen(const S8* filename, const S8* mode);
S32     fread(void *ptr, S32 size, S32 count, S32 fd);
S32     fwrite(void *ptr, S32 size, S32 count, S32 fd);
S32     fgetc(S32 fd);
S8*     fgets(S8* string, S32 max_char, S32 fd);
S32     fputc(S32 c, S32 fd);
S32     fputs(const S8* string, S32 fd);
S32     fclose(S32 fd);
S32     fflush(S32 fd);
S32     fseek(S32 fd, S32 offset, S32 origin);
S32     fsetpos(S32 fd, const U32* newposition);
S32     fgetpos(S32 fd, U32* position);
S32     ftell(S32 fd);
S32     fremove(const S8* filename);
S32     mkdir(const S8* newdir);
S32     rmdir(const S8* dir);
S32     frename(const S8* oldname, const S8* newname);
S32     feof(S32 fd);
S32     chmodfp(S32 fd, S32 function, S32 attribute);
S32     chmod(const S8* filename, S32 attribute);
S32     ferror(S32 fd);//for fread()/fwrite()
void    clearerr(S32 fd);
S32     ffreebyte();
S32     fsize();
S32     fopendir(const S8* dirname);
S32     freaddir(S32 dir_handle, FILEINFO* fileinfo);
S32     fformat();
S32     fclosedir(S32 dir_hanle);
S32     fgetinfo(const S8* filename, FILEINFO* fileinfo);
S32     ftruncate(S32 fd);
S32     fcopy(const S8* srcfile, const S8* dstfile);
S32     fscan(void);

// files exchange between RAM and SD card
S32     RAMtoSD_DAT(const S8 *filenameRAM, const S8 *filenameSD, S32 mode);
S32     SDtoRAM_DAT(const S8 *filenameSD, const S8 *filenameRAM, S32 mode);
S32     RAMtoSD_DBF(const S8 *filenameRAM, const S8 *filenameSD, S32 mode);
S32     SDtoRAM_DBF(const S8 *filenameSD, const S8 *filenameRAM, S32 mode);

//misc
S32     GetFileInfo(const S8* FileName, DEVICE_FILEINFO* InfoBuf);
U8      GetMassStorageStatus(void);

// global FAT error code "ferrno"
#define E_OK                    0   /* No error                             */
#define E_SD_NOT_READY          1   /* SD is not ready                      */
#define	E_NO_FILESYSTEM         2   /* Unsupported File System              */
#define E_NO_OBJECT             3   /* Can't find object                    */
#define E_NO_PATH		        4   /* Can't find path                      */
#define	E_NOT_DIR               5   /* Not a directory                      */
#define	E_NOT_FILE              6   /* Not a file                           */
#define	E_DIR_NOT_EMPTY         7   /* Directory is not empty               */   
#define E_INVALID_NAME          8   /* Invalid Name                         */
#define E_INVALID_OBJECT        9   /* Object is not properly opend         */
#define	E_READ_ONLY             10  /* Object's attribute is read-only      */
#define	E_ACCESS_DENIED         11  /* Access doesn't match open method     */
#define	E_OBJECT_EXIST          12  /* Object already exists                */
#define E_DISK_FULL             13  /* Disk is full                         */
#define	E_RW_ERROR              14  /* Sector Read/write error              */
#define	E_INVALID_HANDLE        15  /* Invalid Handle                       */
#define E_NO_AVAILABLE_HANDLE   16  /* No available Handle                  */
#define E_INVALID_MODE          17  /* Unrecognized mode character          */
#define E_SD_OCCUPIED           18  /* SD is being used by MSDC             */

/***************** TCP/IP Interface ************/
typedef S16 SOCKET;

//**********************************************
//
//      TCP/IP Interface Functions
//
//**********************************************
S16     NetInit(U32 machine);
#define WLAN_NETWORKING         0L
#define BLUETOOTH_NETWORKING    1L
#define BT_GPRS_NETWORKING      3L
#define IR_PPP_NETWORKING       4L
#define CRADLE_PPP_NETWORKING   4L
#define RS232_PPP_NETWORKING    5L
#define IR_MODE_NETWORKING      6L
#define CRADLE_MODE_NETWORKING  6L
#define GPRS_CRADLE_NETWORKING  7L
S16     NetClose(void);
//S32     Ninit(void);
//S32     Nterm(void);
//S32     Portinit(const S8 *name);
//S32     Portterm(const S8 *name);

S16     DNS_resolver(const S8 *remote_host, U8 *remote_ip);
S16     Nopen(const S8 *to, const S8 *protoc, S16 myport, S16 herport, S16 flags);
// flags definition
#define S_NOCON       0x02      // no connection, for UDP
#define S_NOWA        0x04      // non-blocking
#define IPADDR        0x0100    // remote_ip is IP address (binary, 4 bytes) */

S16     Nclose(S16 conno);
S16     Nwrite(S16 conno, const S8 *mess, S16 len);
S16     Nread(S16 conno, S8 *mess, S16 len);

S16     Nportno(void);
S16     socket_noblock(S16 conn);
S16     socket_block(S16 conn);
S16     socket_ipaddr(S16 conn, U8 *ipaddr);
S16     socket_push(S16 conn);
S16     socket_fin(S16 conn);
S16     socket_testfin(S16 conn);
S16     socket_isopen(S16 conn);
S16     socket_hasdata(S16 conn);
S16     socket_cansend(S16 conno, U16 len);
S16     socket_rxtout(S16 conn, U32 val);
S16     socket_keepalive(S16 conn, U32 period);
//U8 MAC_ID(U8 *mac_id);    

//
// get connection transmit status
//
S16     socket_txstat(S16 conn);
#define S_PSH         0x01      // push
#define S_FIN_SENT    0x08      // FIN has been sent
#define S_FIN_ACKED   0x10      // my FIN has been ACKED
#define S_PASSIVEOPEN 0x20      // indicate that this is originally a passive open (for simultaneous active open)


//
// get connection receive status
//
S16     socket_rxstat(S16 conn);
#define S_EOF       0x01        // FIN has been received
#define S_UNREA     0x02        // destination unreachable ICMP
#define S_FATAL     0x04        // fatal error
#define S_RST       0x08        // restart message received
#define S_SHUTRECV  0x10        // receive has been shutdown (active, not by receiving FIN)


//
// get connection state
//
S8      socket_state(S16 conn);
#define ESTABLISHED     1
#define SYN_SENT        2
#define SYN_RECEIVED    3
#define LISTEN          4
#define CLOSING         5


//**********************************************
//
//      TCP/IP Error Codes
//
//**********************************************
#define NE_PARAM        -10     /* user parameter error */
#define EHOSTUNREACH    -11     /* host not reachable */
#define ETIMEDOUT       -12     /* timeout */
#define NE_HWERR        -13     /* hardware error */
#define ECONNABORTED    -14     /* protocol error */
#define ENOBUFS         -15     /* no buffer space */
#define EBADF           -16     /* connection block invalid */
#define EFAULT          -17     /* invalid pointer argument */
#define EWOULDBLOCK     -18     /* operation would block */
#define EMSGSIZE        -19     /* message too long */
#define ENOPROTOOPT     -20     /* Protocol not available */
#define ussErrInval     -21     /* this ioctl request not implemented */

#define EDESTADDRREQ    -50     /* Destination address required */
#define EPROTOTYPE      -52         /* Protocol wrong type for socket */
#define EPROTONOSUPPORT -54     /* Protocol not supported */
#define ESOCKTNOSUPPORT -55     /* Socket type not supported */
#define EOPNOTSUPP      -56     /* Operation not supported on socket */
#define EPFNOSUPPORT    -57     /* Protocol family not supported */
#define EAFNOSUPPORT    -58     /* Address family not supported by */

#define EADDRINUSE      -59     /* Address already in use */
#define EADDRNOTAVAIL   -60     /* Can't assign requested address */
#define ENETDOWN        -61     /* Network is down */
#define ENETUNREACH     -62     /* Network is unreachable */
#define ENETRESET       -63     /* Network dropped connection because */

#define ECONNRESET      -65     /* Connection reset by peer */
#define EISCONN         -67     /* Socket is already connected */
#define ENOTCONN        -68     /* Socket is not connected */
#define ESHUTDOWN       -69     /* Can't send after socket shutdown */
#define ECONNREFUSED    -72     /* Connection refused */
#define EHOSTDOWN       -73     /* Host is down */
#define EALREADY        -76     /* operation already in progress */
#define EINPROGRESS     -77     /* operation now in progress */

//********************************************************
//                DNS SERVICE ERROR CODE
//********************************************************
#define UNKNOWNAME                     -30
#define ErrRETCLASS                    -31
#define ErrRETTYPE                     -32
#define RemoteNameTooLong              -33        //parameter input error
#define remote_nameMax                  38


//********************************************************
//                SOCKET Library
//********************************************************
/* protocol family */

#define	PF_UNSPEC	0           /* unspecified protocol family */
#define	PF_INET		2           /* TCP/IP and related */
#define	AF_UNSPEC	0           /* unspecified address family */
#define	AF_INET		2           /* TCP/IP and related */

/* socket types */

#define	SOCK_STREAM	1           /* stream socket */
#define	SOCK_DGRAM	2           /* datagram socket */
#define	SOCK_RAW	3           /* raw-protocol interface */

/* options for getsockopt() and setsockopt() */

#define	SOL_SOCKET	0xffff      /* options for socket level */
#define	IPPROTO_TCP	0x0001      /* options for TCP level */
#define	IPPROTO_IP	0x0002      /* options for IP level */

#define SO_DEBUG        0x0001  /* turn on debugging info recording */
#define	SO_REUSEADDR	0x0004  /* allow local address reuse */
#define	SO_KEEPALIVE	0x0008  /* keep connections alive */
#define	SO_DONTROUTE	0x0010  /* just use interface addresses */
#define	SO_BROADCAST	0x0020  /* permit sending of broadcast msgs */
#define SO_BINDTODEVICE 0x0040  /* Bind a socket to an interface */
#define SO_LINGER       0x0080  /* linger on close if data present */
#define	SO_OOBINLINE	0x0100  /* leave received OOB data in line */
#define SO_SNDBUF       0x1001  /* send buffer size */
#define SO_RCVBUF       0x1002  /* receive buffer size */
#define SO_ERROR        0x1007  /* get error status and clear */
#define SO_TYPE         0x1008  /* get socket type */

#define	TCP_MAXSEG	0x2000      /* maximum segment size */
#define	TCP_NODELAY	0x2001      /* immediate send() */

#define	IP_OPTIONS	0x0001      /* IP header options */

/* options for recv and send */

#define MSG_OOB		0x01        /* send or receive out of band data */
#define MSG_PEEK	0x02        /* take data but leave it */
#define MSG_DONTROUTE	0x04    /* do not route */

/* options for fcntl */

#define O_NDELAY 	0x04        /* non-blocking */
#define FNDELAY O_NDELAY        /* synonym */
#define F_GETFL		3           /* get flags */
#define F_SETFL		4           /* set flags */

/* options for ioctl */

#define SIOCATMARK	7           /* check for out of bound data */
#define FIONBIO		126         /* set/clear non-blocking I/O */
#define FIONREAD	127         /* number of bytes to read */

/* structures */

struct sockaddr {               /* generic socket address */
    U16             sa_family;  /* address family */
    S8              sa_data[14];/* up to 14 bytes of direct address */
};
struct in_addr {                /* Internet address */
    U32             s_addr;
};
struct sockaddr_in {            /* Internet socket address */
    S16             sin_family; /* should be unsigned but this is BSD */
    U16             sin_port;   /* network order !!! */
    struct in_addr  sin_addr;
    S8              sin_zero[8];
};

struct hostent {                /* structure for gethostbyname */
    S8              *h_name;     /* official name of host */
    S8              **h_aliases;  /* alias list */
    S16             h_addrtype; /* host address type */
    S16             h_length;   /* length of address */
    S8              **h_addr_list;/* list of addresses from name server */
#define	h_addr      h_addr_list[0]   /* address, for backward compatiblity */
};

struct servent {                /* structure for getservbyname */
    S8              *s_name;     /* official service name */
    S8              **s_aliases;  /* alias list */
    S16             s_port;     /* port # */
    S8              *s_proto;    /* protocol to use */
};

struct linger {                 /* structure for the SO_LINGER option */
    S16             l_onoff;    /* zero=off, nonzero = on */
    S16             l_linger;   /* linger time, in seconds */
};

/*
** The maximum number of socket descriptors that can have is the same
**   as the number of possible connections (8)
*/
#define FD_SETSIZE 8
#define FD_SET(n, p) ((p)->fds_bits[(n)>>3] |= (1 << ((n) & 7)))
#define FD_CLR(n, p) ((p)->fds_bits[(n)>>3] &= ~(1 << ((n) & 7)))
#define FD_ISSET(n, p) ((p)->fds_bits[(n)>>3] & (1 << ((n) & 7)))
#define FD_ZERO(p) memset((void *)(p), 0, sizeof(*(p)))
typedef struct {
    U8              fds_bits [(FD_SETSIZE + 7) / 8];
} fd_set;

struct timeval {                /* Timeout format for select() */
    S32             tv_sec;     /* seconds */
    S32             tv_usec;    /* microseconds */
};

/* BSD socket error codes */
#define NE_PARAM	    -10         /* user parameter error */
#define EHOSTUNREACH	-11         /* host not reachable */
#define ETIMEDOUT	    -12         /* timeout */
#define ECONNABORTED	-14         /* protocol error */
#define ENOBUFS		    -15         /* no buffer space */
#define EBADF		    -16         /* connection block invalid */
#define EFAULT		    -17         /* invalid pointer argument */
#define	EWOULDBLOCK	    -18         /* operation would block */
#define	EMSGSIZE	    -19         /* message too long */
#define	ENOPROTOOPT	    -20         /* Protocol not available */

#define	EDESTADDRREQ	-50         /* Destination address required */
#define	EPROTOTYPE	    -52         /* Protocol wrong type for socket */
#define	EPROTONOSUPPORT	-54         /* Protocol not supported */
#define	ESOCKTNOSUPPORT	-55         /* Socket type not supported */
#define	EOPNOTSUPP	    -56         /* Operation not supported on socket */
#define	EPFNOSUPPORT	-57         /* Protocol family not supported */
#define	EAFNOSUPPORT	-58         /* Address family not supported by */
 /* protocol family */
#define	EADDRINUSE	    -59         /* Address already in use */
#define	EADDRNOTAVAIL	-60         /* Can't assign requested address */
#define	ENETDOWN	    -61         /* Network is down */
#define	ENETUNREACH	    -62         /* Network is unreachable */
#define	ENETRESET	    -63         /* Network dropped connection because */
 /* of reset */
#define	ECONNRESET	    -65         /* Connection reset by peer */
#define	EISCONN		    -67         /* Socket is already connected */
#define	ENOTCONN	    -68         /* Socket is not connected */
#define	ESHUTDOWN	    -69         /* Can't send after socket shutdown */
#define	ECONNREFUSED	-72         /* Connection refused */
#define	EHOSTDOWN	    -73         /* Host is down */
#define	EALREADY	    -76         /* operation already in progress */
#define	EINPROGRESS	    -77         /* operation now in progress */

/* byte swapping routines */

U16             htons(U16);
#define ntohs(val) htons(val)
U16             htonl(U32);
#define ntohl(val) htonl(val)

/* function prototypes */

S16             select(S16 nfds, fd_set *readfds, fd_set *writefds, fd_set *exceptfds, struct timeval *timeout);
S16             accept(S16 s, struct sockaddr *name, S16 *namelen);
S16             bind(S16 s, struct sockaddr *name, S16 namelen);
S16             connect(S16 s, struct sockaddr *name, S16 namelen);
S16             getsockname(S16 s, struct sockaddr *name, S16 *namelen);
S16             getpeername(S16 s, struct sockaddr *peer, S16 *addrlen);
S16             getsockopt(S16 s, S16 level, S16 optname, S8 *optval, S16 *optlen);
S16             setsockopt(S16 s, S16 level, S16 optname, S8 *optval, S16 optlen);
S16             listen(S16 s, S16 backlog);
S16             recv(S16 s, S8 *buf, S16 len, S16 flags);
S16             recvfrom(S16 s, S8 *buf, S16 len, S16 flags, struct sockaddr *from, S16 *fromlen);
S16             send(S16 s, const S8 *buf, S16 len, S16 flags);
S16             sendto(S16 s, const S8 *buf, S16 len, S16 flags, struct sockaddr *to, S16 tolen);
S16             shutdown(S16 s, S16 how);
S16             socket(S16 domain, S16 type, S16 protocol);
S16             closesocket(S16 conno);
//struct hostent *gethostbyname_r(const S8 *hnp, struct hostent *result, S8 *buffer, S16 buflen, S16 *h_errnop);
struct hostent *gethostbyname(const S8 *hnp);
//struct hostent *gethostbyaddr_r(S8 *addr, S16 len, S16 type, struct hostent *result, S8 *buffer, S16 buflen, S16 *h_errnop);
//struct hostent *gethostbyaddr(S8 *addr, S16 len, S16 type);
S16             fcntlsocket(S16 fildes, S16 cmd, S16 arg);
S16             ioctlsocket(S16 fildes, S16 request,...);
U32             inet_addr(S8 *dotted);
S8             *inet_ntoa(struct in_addr addr);
       
/***************MultiLoad Program*****************/
void ActivateProgram(U32 fn, U32 clear_file);
void LoadProgram(U32 fn);
void ProgramManager(void);
U32 ProgramInfo(U32 fn, S8 *type, S8 *prog_name);
U32 DownLoadProgram(S8* filename, U32 comport, U32 baudrate);
S32 UpdateBank(const S8 *filename);
U32 UpdateUser(const S8 *filename, U32 mode,...);
U32 UpdateKernel(const S8 *filename, U32 mode, U32 remove_src);
U32 DeleteBank(U32 slot);
#define KEEP_FILE_SYSTEM         0
#define CLEAR_FILE_SYSTEM        1

///***************** FTP Interface ************/
#define	SCRIPFILE		 "FTP.dat"
#define	DIRLISTFILE		 "DIRList"
#define RECEFILELIST	 "RCVList"

typedef struct
{
	S8  ServerIP[254];
	S8  FTPPort[8];
	S8  Username[65];
	S8  Password[65];
} FTP_SETTINGS;


extern const S8 *szFTPDirectVersion;
extern S8	szFTPReplyCode[256];		   
extern S8 szFTPResponseTbl[1024];        

S32  FTPRename( S8 *RemoteNewFile, S8 *RemoteOldFile, S8 *ProcessOption );
S32  FTPDelete( S8 *RemoteFile, S8 *ProcessOption );
S32  FTPDir( void );								
S32  FTPRecv( S8 *LocalFile, S8 *RemoteFile, S8 *ProcessOption );
S32  FTPSend( S8 *LocalFile, S8 *RemoteFile, S8 *ProcessOption );
S32  FTPAppend( S8 *LocalFile, S8 *RemoteFile, S8 *ProcessOption );
S32  FTPCwd( S8 *szNewDir );
void FTPClose( void );
S32	 FTPOpen(S8 *HostIPAddr, S8 *szUserID, S8 *szPasswd, U32 nPort);
S32  DoFTP(S32 IFMode, S8 *HostIP, S8 *Username, S8 *Password, S8 *Port);
S32  SetUserWildCard(S8 *UserString);
S8* GetUserWildCard(void);
//IFMode
extern FTP_SETTINGS	FtpConfig;
#define  via802dot11	 (S32)(WLAN_NETWORKING+1)
#define  viaEthernetCradle (S32)(CRADLE_MODE_NETWORKING+1)


/***************** Download ********************/
void         DownLoadPage();
#define NO_MENU 0xaa55

#endif /* NEPTUNE_LIB_H */
