#ifndef DATAFORMAT_H
#define DATAFORMAT_H

#if defined _WIN32 || defined _WIN64
#ifdef API_EXPORTS
#define DLLEXPORT __declspec(dllexport)
#else
#define DLLEXPORT __declspec(dllimport)
#endif
#else
#define DLLEXPORT
#endif

#include <iostream>
#include <vector>
#include "RecordField.h"

using namespace std;

#define MaxRecordFields 12

namespace CipherLab
{
	namespace DataConverter
	{
		class DLLEXPORT DataFormat
		{
		public:
			DataFormat(int maxFields, char delimiter = 0x00);
			~DataFormat(){}
			const char* getPath();
			void setPath(const char* path);

			void setTargetFileName(const char* name);
			const char* getTargetFileName();

			char getDelimiter();
			void setDelimiter(char ch);
			bool isRecordDelimited();

			const char* getDbfFileName();
			void setDbfFileName(const char* fileName);
			int getNumberOfRecordFields();
			int getMaxRecordFields();
			int getKeyCount();
			RecordField GetRecordFieldAt(int index);
			void EditRecordFieldPosition(int index, int position);
			void EditRecordFieldLength(int index, int length);
			void EditRecordFieldIsKey(int index, bool isKey);
			void ClearRecordFields() { RecordFields.clear(); }
			void AddRecordField(RecordField recordField);
			void ParseRecordFields(const char* inputFilePath);

		//protected:
		    vector<RecordField> RecordFields;
			string path;
			string targetFileName;
        protected:
			char delimiter;
			const char* dbfFileName;


			int maxRecordFields;
			int minFieldPosition;
			int maxFieldPosition;
			int minFieldLength;
			int maxFieldLength;

		private:
			int totalLength;

		};
	}
}

#endif
