#ifndef TXT2DBFCONVERTER_H
#define TXT2DBFCONVERTER_H

#if defined _WIN32 || defined _WIN64
#ifdef API_EXPORTS
#define DLLEXPORT __declspec(dllexport)
#else
#define DLLEXPORT __declspec(dllimport)
#endif
#include <windows.h>
#include <tchar.h>
#include <strsafe.h>
#else
#define DLLEXPORT
#endif

#include <iostream>
#include "BasicProgDataFormat.h"
#include "CProgDataFormat.h"
#include "ForgeAgProgDataFormat.h"
#include "ProgressCallBack.h"
#include "ConversionResult.h"

using namespace std;

namespace CipherLab
{
	namespace DataConverter
	{

		class Txt2DbfConverter
		{
		private:
			DataFormat dataFormat;
			ProgrammingTool progTool;
			WrongFormatAction actionTakenWhenFormatIsWrong;
			string targetDir;
			ProgressCallBack* cbPtr;

		public:
			ConversionResult result;
			ConversionStatus status;
			DLLEXPORT Txt2DbfConverter(BasicProgDataFormat& dataFormat,  const char* targetD, WrongFormatAction actionTakenWhenWrong);
			//DLLEXPORT Txt2DbfConverter(BasicProgDataFormat& format,  string targetDir, WrongFormatAction actionTakenWhenWrong);
			DLLEXPORT Txt2DbfConverter(CProgDataFormat& dataFormat, const char* targetD, WrongFormatAction actionTakenWhenWrong);
			DLLEXPORT Txt2DbfConverter(ForgeAgProgDataFormat& dataFormat,  const char* targetD, WrongFormatAction actionTakenWhenWrong);
			DLLEXPORT ~Txt2DbfConverter(){}
			DLLEXPORT ConversionResult Convert(ProgressCallBack* cb);
#if defined _WIN32 || defined _WIN64
			HANDLE  hThread;
			bool isCancel;
			DLLEXPORT void ConvertAsync(ProgressCallBack* cb);
			DLLEXPORT void CancelAsync();
			void DoConvertAsyncWork();
#else
			pthread_t thread;
			pthread_attr_t attr;
			bool isCancel;
			DLLEXPORT void ConvertAsync(ProgressCallBack* cbPtr);
			DLLEXPORT void CancelAsync();
			void *DoConvertAsyncWork();
#endif
		};
	}
}
#endif
