// OCXSampleDlg.cpp : implementation file
//

#include "stdafx.h"
#include "OCXSample.h"
#include "OCXSampleDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

LPCTSTR contype[4] = {"RS232/IrDA", "Cradle-IR", "Modem", "Ethernet"};
LPCTSTR baudrate[5] = {"115200", "57600", "38400", "19200", "9600"};

// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// COCXSampleDlg dialog




COCXSampleDlg::COCXSampleDlg(CWnd* pParent /*=NULL*/)
	: CDialog(COCXSampleDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void COCXSampleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_CipherAGBCTRL1, CipherAGB);
	DDX_Control(pDX, IDC_CipherAGBCTRL1, CipherAGB);
	DDX_Control(pDX, IDC_COMBO1, cmb1);
	DDX_Control(pDX, IDC_EDIT1, txt1);
	DDX_Control(pDX, IDC_COMBO2, cmb2);
	DDX_Control(pDX, IDC_EDIT2, txt2);
	DDX_Control(pDX, IDC_EDIT3, txt3);
	DDX_Control(pDX, IDC_EDIT4, txt4);
	DDX_Control(pDX, IDC_BUTTON2, btn1);
	DDX_Control(pDX, IDC_BUTTON1, btn2);
}

BEGIN_MESSAGE_MAP(COCXSampleDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BUTTON2, &COCXSampleDlg::OnBnClickedButton2)
	ON_BN_CLICKED(IDC_BUTTON3, &COCXSampleDlg::OnBnClickedButton3)
	ON_BN_CLICKED(IDC_BUTTON1, &COCXSampleDlg::OnBnClickedButton1)
	ON_BN_CLICKED(IDC_BUTTON4, &COCXSampleDlg::OnBnClickedButton4)
	ON_CBN_SELCHANGE(IDC_COMBO1, &COCXSampleDlg::OnCbnSelchangeCombo1)
END_MESSAGE_MAP()


// COCXSampleDlg message handlers

BOOL COCXSampleDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	int i;

	for (i=0; i<4; i++)
	{
		cmb1.AddString(contype[i]);
		cmb1.SetItemData(i, i);
	}
	cmb1.SetCurSel(0);

	for (i=0; i<5; i++)
	{
		cmb2.AddString(baudrate[i]);
		cmb2.SetItemData(i, i);
	}
	cmb2.SetCurSel(0);
	txt1.SetWindowTextA("1");
	txt2.SetWindowTextA("15");
	txt3.SetWindowTextA("C:\\test.txt");
	txt4.SetWindowTextA("C:\\test.txt");

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void COCXSampleDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void COCXSampleDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR COCXSampleDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void COCXSampleDlg::OnBnClickedButton2()
{
	CString tmp;
	long conchk;
	long sendchk;

	txt1.GetWindowTextA(tmp);
	CipherAGB.SetPort(atoi((LPCTSTR)tmp));                      // set port number
	tmp.Format("%s", baudrate[cmb2.GetCurSel()]);
	CipherAGB.SetBaudRate(atoi((LPCTSTR)tmp));                  // set baud rate
	txt2.GetWindowTextA(tmp);
	CipherAGB.SetTimeout(atoi((LPCTSTR)tmp));                   // set communication timeout
	BeginWaitCursor();
	conchk = CipherAGB.InitConnection(cmb1.GetCurSel());        // initialize communication
	if (conchk < 0)
	{
		switch (conchk)
		{
			case -1000:
				MessageBox ("Error: -1000 -- Initialize Communication Error", "Error",  MB_OK | MB_ICONEXCLAMATION);
			break;

			case -1004:
				MessageBox ("Error: -1004 -- Communication port is not exist", "Error",  MB_OK | MB_ICONEXCLAMATION);
			break;

			case -1005:
				MessageBox ("Error: -1005 -- Communication interface access denied", "Error",  MB_OK | MB_ICONEXCLAMATION);
			break;

			case -1006:
				MessageBox ("Error: -1006 -- Open Comm error", "Error",  MB_OK | MB_ICONEXCLAMATION);
			break;

			case -1201:
				MessageBox ("Error: -1201 -- Invalid communication port assigned", "Error",  MB_OK | MB_ICONEXCLAMATION);
			break;

			case -1202:
				MessageBox ("Error: -1202 -- Invalid Timeout value assigned", "Error",  MB_OK | MB_ICONEXCLAMATION);
			break;
		}

		CipherAGB.CloseConnection();
		EndWaitCursor();
		return;
	}

	txt3.GetWindowTextA(tmp);
	sendchk = CipherAGB.DownloadFile(tmp);                     // do send file to terminal
	if (sendchk > 0)
        MessageBox ("Send file complete", "Complete",  MB_OK | MB_ICONINFORMATION);
    else
	{
		switch (sendchk)
		{
			case -1003:
				MessageBox ("Error: -1003 -- Communication Timeout", "Error",  MB_OK | MB_ICONEXCLAMATION);
			break;

			case -1008:
				MessageBox ("Error: -1008 -- Cradle-IR Device error", "Error",  MB_OK | MB_ICONEXCLAMATION);
			break;

			case -1100:
				MessageBox ("Error: -1100 -- Open file error", "Error",  MB_OK | MB_ICONEXCLAMATION);
			break;

			case -1101:
				MessageBox ("Error: -1101 -- Communication error", "Error",  MB_OK | MB_ICONEXCLAMATION);
			break;

			case -1200:
				MessageBox ("Error: -1200 -- Communication type error", "Error",  MB_OK | MB_ICONEXCLAMATION);
			break;
		}
	}		

	CipherAGB.CloseConnection();
	EndWaitCursor();
}

void COCXSampleDlg::OnBnClickedButton3()
{
	CString tmp;
	long conchk;
	long recievechk;

	txt1.GetWindowTextA(tmp);
	CipherAGB.SetPort(atoi((LPCTSTR)tmp));                      // set port number

	tmp.Format("%s", baudrate[cmb2.GetCurSel()]);
	CipherAGB.SetBaudRate(atoi((LPCTSTR)tmp));                  // set baud rate

	txt2.GetWindowTextA(tmp);
	CipherAGB.SetTimeout(atoi((LPCTSTR)tmp));                   // set communication timeout

	BeginWaitCursor();
	conchk = CipherAGB.InitConnection(cmb1.GetCurSel());        // initialize communication
	if (conchk < 0)
	{
		switch (conchk)
		{
			case -1000:
				MessageBox ("Error: -1000 -- Initialize Communication Error", "Error",  MB_OK | MB_ICONEXCLAMATION);
			break;

			case -1004:
				MessageBox ("Error: -1004 -- Communication port is not exist", "Error",  MB_OK | MB_ICONEXCLAMATION);
			break;

			case -1005:
				MessageBox ("Error: -1005 -- Communication interface access denied", "Error",  MB_OK | MB_ICONEXCLAMATION);
			break;

			case -1006:
				MessageBox ("Error: -1006 -- Open Comm error", "Error",  MB_OK | MB_ICONEXCLAMATION);
			break;

			case -1201:
				MessageBox ("Error: -1201 -- Invalid communication port assigned", "Error",  MB_OK | MB_ICONEXCLAMATION);
			break;

			case -1202:
				MessageBox ("Error: -1202 -- Invalid Timeout value assigned", "Error",  MB_OK | MB_ICONEXCLAMATION);
			break;
		}

		CipherAGB.CloseConnection();
		EndWaitCursor();
		return;
	}

	txt4.GetWindowTextA(tmp);
	recievechk = CipherAGB.ReadFile(tmp);                      // do recieve file from terminal
	if (recievechk >= 0)
	{
		tmp.Format("Total %d records recieved", recievechk);
		MessageBox (tmp, "Complete",  MB_OK | MB_ICONINFORMATION);
	}
    else
	{
		switch (recievechk)
		{
			case -1001:
				MessageBox ("Error: -1001 -- Socket error", "Error",  MB_OK | MB_ICONEXCLAMATION);
			break;

			case -1002:
				MessageBox ("Error: -1002 -- Program error", "Error",  MB_OK | MB_ICONEXCLAMATION);
			break;

			case -1003:
				MessageBox ("Error: -1003 -- Communication Timeout", "Error",  MB_OK | MB_ICONEXCLAMATION);
			break;

			case -1008:
				MessageBox ("Error: -1008 -- Cradle-IR Device error", "Error",  MB_OK | MB_ICONEXCLAMATION);
			break;

			case -1100:
				MessageBox ("Error: -1100 -- Open file error", "Error",  MB_OK | MB_ICONEXCLAMATION);
			break;

			case -1101:
				MessageBox ("Error: -1101 -- Communication error", "Error",  MB_OK | MB_ICONEXCLAMATION);
			break;

			case -1200:
				MessageBox ("Error: -1200 -- Communication type error", "Error",  MB_OK | MB_ICONEXCLAMATION);
			break;
		}
	}

	CipherAGB.CloseConnection();
	EndWaitCursor();
}

void COCXSampleDlg::OnBnClickedButton1()
{
	static TCHAR BASED_CODE szFilter[] = "txt file(*.txt)|*.txt|";
	
	CFileDialog l_FileDlg(TRUE,NULL,NULL,OFN_FILEMUSTEXIST,szFilter);
	if(l_FileDlg.DoModal() == IDOK)
	{
        CString l_strFileName, DestFileName;
        CString	TmpStr, TmpExtName;

        l_strFileName = l_FileDlg.GetPathName();
		TmpExtName = l_FileDlg.GetFileExt();
		l_strFileName.TrimLeft();
		l_strFileName.TrimRight();

		txt3.SetWindowTextA(l_strFileName);
	}
}

void COCXSampleDlg::OnBnClickedButton4()
{
	static TCHAR BASED_CODE szFilter[] = "txt file(*.txt)|*.txt|";
	
	CFileDialog l_FileDlg(FALSE,NULL,NULL,OFN_HIDEREADONLY | OFN_PATHMUSTEXIST | OFN_OVERWRITEPROMPT,szFilter);
	if(l_FileDlg.DoModal() == IDOK)
	{
        CString l_strFileName, DestFileName;
        CString	TmpStr, TmpExtName;

        l_strFileName = l_FileDlg.GetPathName();
		TmpExtName = l_FileDlg.GetFileExt();
		l_strFileName.TrimLeft();
		l_strFileName.TrimRight();

		txt4.SetWindowTextA(l_strFileName);
	}
}

void COCXSampleDlg::OnCbnSelchangeCombo1()
{
	if (cmb1.GetCurSel() == 3)
	{
		cmb2.EnableWindow(0);
		btn1.EnableWindow(0);
		btn2.EnableWindow(0);
		txt3.EnableWindow(0);
	}
	else
	{
		cmb2.EnableWindow(1);
		btn1.EnableWindow(1);
		btn2.EnableWindow(1);
		txt3.EnableWindow(1);
	}
}
