#pragma once

// TRANSACTION STRUCTS-------------------------------
typedef struct _StartReceipt
{
	//! \~polish ilo linii
	int numberOfLines;
	//! \~polish linia nr 1
	char line1[200];
	//! \~polish linia nr 2
	char line2[200];
	//! \~polish linia nr 3
	char line3[200];
	//! \~polish Symbol "PL" przed numerem NIP
	int symbolPL ;
	//! \~polish numer identyfikacyjny nabywcy
	char id[14];
} StartReceipt;

typedef struct _Item
{
	//! \~polish numer linii
	int numberOfLine;
	//! \~polish rodzaj rabatu
	int discountType;
	//! \~polish opis rabatu
	int discountDescription;
	//! \~polish flaga opis towaru
	int fItemDescription ;
	//! \~polish nazwa
	char name[61];
	//! \~polish kod PLU
	char plu[32] ;
	//! \~polish ilo
	long long quantity ;
	//! \~polish ilo
	char qtty[11];
	//! \~polish PTU
	char ptu[2];
	//! \~polish jednostka
	char unit[20];
	//! \~polish cena
	long long price;
	//! \~polish brutto
	long long brutto ;
	//! \~polish rabat
	long long discount;
	//! \~polish nazwa rabatu
	char discountName[41];
	//! \~polish opis towaru
	char itemDescription[200] ;
}Item;

typedef struct _EndReceipt{
	//! \~polish akcja
	int action;
	//! \~polish rabat
	int discount ;
	//! \~polish liczba linii dodatkowych w stopce paragonu
	int numberOfLines;
	//! \~polish rodzaj rabatu
	int discountType;
	//! \~polish nazwa kasjera
	char cashierName[33];
	//! \~polish linia 1
	char line1[41];
	//! \~polish linia 2
	char line2[41];
	//! \~polish linia 3
	char line3[41];
	//! \~polish wpata
	long long value ;
	//! \~polish razem
	long long total ;
	//! \~polish warto rabatu
	long long discountValue;
	
}EndReceipt;

typedef struct _EndReceiptWithPaymentMethods1
{
	//! \~polish rodzaj rabatu
	int DiscountType ;
	//! \~polish flaga wpata
	int fCash ;
	//! \~polish flaga karta
	int fCard ;
	//! \~polish flaga czek
	int fCheque ;
	//! \~polish flaga bon
	int fBon ;
	//! \~polish flaga przyjcie
	int fContainerIn ;
	//! \~polish flaga wydanie
	int fContainerOut ;
	//! \~polish flaga reszta
	int fRest ;
	//! \~polish razem
	long long sum ;
	//! \~polish rabat
	long long discount ;
	//! \~polish wpata
	long long cash;
	//! \~polish karta
	long long card ;
	//! \~polish czek
	long long cheque ;
	//! \~polish bon
	long long bon ;
	//! \~polish linia nr 1
	char line1[41];
	//! \~polish linia nr 2
	char line2[41];
	//! \~polish linia nr 3
	char line3[41];
	//! \~polish linia nr 4
	char line4[41];
	//! \~polish linia nr 5
	char line5[41];
	//! \~polish nazwa karty
	char cardName[17];
	//! \~polish nazwa czeku
	char chequeName[17];
	//! \~polish nazwa bonu
	char bonName[17];
	//! \~polish kaucje zwrcone
	long long containerIn ;
	//! \~polish kaucje wydane
	long long containerOut ;
	//! \~polish reszta
	long long rest ;
	//! \~polish nazwa kasjera
	char cashierName[33];
}EndReceiptWithPaymentMethods1;

typedef struct _BailInReceiptLine {
	//! \~polish rodzaj kaucji
	int bailType ;
	//! \~polish numer
	int number;
	//! \~polish ilo (liczba)
	long long quantity;
	//! \~polish ilo (napis)
	char qtty[11];
	//! \~polish cena
	long long price ;
	//! \~polish warto
	long long value ;
}BailInReceiptLine;

typedef struct _BailIn {
	//! \~polish kwota
	long long amount ;
	//! \~polish numer opakowania
	int conteinerNumber ;
	//! \~polish ilo (liczba)
	long long quantity ;
	//! \~polish ilo (napis)
	char qtty[11];
}BailIn;

typedef struct _BailInStorno {
	//! \~polish kwota
	long long amount ;
	//! \~polish numer opakowania
	int conteinerNumber ;
	//! \~polish ilo (liczba)
	long long quantity ;
	//! \~polish ilo (napis)
	char qtty[11];
}BailInStorno;

typedef struct _BailOut {
	//! \~polish kwota
	long long amount ;
	//! \~polish numer opakowania
	int conteinerNumber ;
	//! \~polish ilo (liczba)
	long long quantity ;
	//! \~polish ilo (napis)
	char qtty[11];
}BailOut;

typedef struct _BailOutStorno {
	//! \~polish kwota
	long long amount ;
	//! \~polish numer opakowania
	int conteinerNumber ;
	//! \~polish ilo (liczba)
	long long quantity ;
	//! \~polish ilo (napis)
	char qtty[11];

}BailOutStorno;

typedef struct _AbortTransaction {
	//! \~polish numer kasy
	char tillNumber[9];
	//! \~polish kasjer
	char cashier[33];
}AbortTransaction;

typedef struct _Payment {
	// \~polish akcja
	int action ;
	// \~polish typ patnoci
	int paymentMethod;
	//! \~polish kwota
	long long value;
	//! \~polish nazwa
	char name[25];
}Payment;

typedef struct _DiscountOrMarkupToTransaction {
	//! \~polish rodzaj rabatu
	int discountType ;
	//! \~polish nazwa
	char discountName[21];
	//! \~polish warto
	long long value ;
}DiscountOrMarkupToTransaction;

typedef struct _DiscountOrMarkupToPTU
{
	//! \~polish numer stawki
	int PTUNumber ;
	//! \~polish rodzaj rabatu
	int discountType ;
	//! \~polish numer opisu
	int discountNumber ;
	//! \~polish sprzeda
	long long sales ;
	//! \~polish rabat
	long long discount ;
	//! \~polish opis rabatu
	char discountDescription[21];
}DiscountOrMarkupToPTU;

typedef struct _DiscountOrMarkupToSubtotal {
	//! \~polish rodzaj rabatu
	int discountType ;
	//! \~polish numer opisu
	int discountNumber ;
	//! \~polish podsuma
	long long Subtotal ;
	//! \~polish rabat
	long long discount ;
	//! \~polish opis rabatu
	char discountDescription[21];
}DiscountOrMarkupToSubtotal;

typedef struct _StartInvoice {
	//! \~polish Ilo linii danych nabywcy faktury
	int numberOfLinesReceiverData;
	//! \~polish orygina/kopia
	int originalAndCpy ;
	//! \~polish liczba dodatkowych kopii
	int additionalCopy ;
	//! \~polish numer faktury
	int invoiceNumber ;
	//! \~polish grny margines
	int upperMargin ;
	//! \~polish miejsce na podpisy 
	int sign ;
	//! \~polish symbol "PL" przed numerem NIP
	int symbolPL ;
	//! \~polish linia nr 1
	char line1[61];
	//! \~polish linia nr 2
	char line2[61];
	//! \~polish linia nr 3
	char line3[61];
	//! \~polish linia nr 4
	char line4[61];
	//! \~polish linia nr 5
	char line5[61];
	//! \~polish linia nr 6
	char line6[61];
	//! \~polish linia nr 7
	char line7[61];
	//! \~polish linia nr 8
	char line8[61];
	//! \~polish NIP nabywcy
	char NIP[15];
	//! \~polish termin patnoci
	char paymentDate[18];
	//! \~polish forma patnoci
	char paymentMethod[21];
	//! \~polish odbiorce
	char receiverName[28];
	//! \~polish wystawiajcy
	char senderName[28];
	//! \~polish numer systemowy
	char systemNumber[31];
	//! \~polish nazwa nabywcy
	char buyerName[28];
   //! \~polish numer faktury
   char invoiceNumberStr[57];

}StartInvoice;

typedef struct _EndInvoice{
	//! \~polish akcja
	int action;
	//! \~polish rabat
	int discount ;
	//! \~polish ilo linii w stopce
	int numberOfLinesFooter ;
	//! \~polish napis "Zapacono"
	int wordPaid ;
	//! \~polish opcje dla nazwy kupujcego
	int receiverSettings ;
	//! \~polish rodzaj rabatu
	int discountType ;
	//! \~polish opcje nazwy dla sprzedajcego
	int senderSettings ;
	//! \~polish kod
	char code[9];
	//! \~polish linia nr 1
	char line1[61];
	//! \~polish linia nr 2
	char line2[61];
	//! \~polish linia nr 3
	char line3[61];
	//! \~polish zapacono
	char paid[30];
	//! \~polish nazwa kupujcego
	char receiverName[41];
	//! \~polish nazwa sprzedajcego
	char senderName[41];
	//! \~polish wpata
	long long payment ;
	//! \~polish razem
	long long total ;
	//! \~polish warto rabatu
	int discountValue ;
}EndInvoice;

typedef struct _InvoiceOptions
{
	//! \~polish liczba dodatkowych kopii
	int additionalCopies ;
	//! \~polish opcje dla nazwy kupujcego
	int buyerNameOption ;
	//! \~polish opcje dla nazwy sprzedajcego
	int sellerNameOption ;
	//! \~polish napis "Zapacono"
	int isPaid ;
	//! \~polish data sprzeday: Rok
	char saleDateYear[3];
	//! \~polish data sprzeday: Miesic
	char saleDateMonth[3];
	//! \~polish data sprzeday: Dzie
	char saleDateDay[3];
	//! \~polish opcje wydruku podsumowania
	int printoutSummaryOption ;
	//! \~polish opcje wydruku 2
	int printoutOption2 ;
	//! \~polish typ numeru identyfikujcego kupujcego
	int buyerIDType ;
	//! \~polish opcje wydruku 3
	int printoutOption3 ;
	//! \~polish opcje wydruku etykiety "Nabywca"
	int isReceiver ;
	//! \~polish termin patnoci
	char paymentDeadline[17];
	//! \~polish forma patnoci
	char paymentMethod[21];
	//! \~polish odbiorca
	char customer[27];
	//! \~polish wystawiajcy
	char issuing[27];
	//! \~polish zapacono
	char paid[30];
	//! \~polish nuer systemowy
	char systemNumber[31];
	//! \~polish informacje dodatkowe do faktury
	char additionalInfo[513];
	//! \~polish nazwa nabywcy
	char buyerName[257];
}InvoiceOptions;

typedef struct _EndReceiptWithPaymentMethods2 {
	//! \~polish ilo linii
	int numberOfLines ;
	//! \~polish zakoczenie
	int end ;
	//! \~polish podsumowanie
	int summary ;
	//! \~polish znak DSP
	int DSPSign ;
	//! \~polish rodzaj rabatu
	int discountType ;
	//! \~polish ilo kaucji pobrnych
	int bailInCount ;
	//! \~polish ilo kaucji zwrconych
	int bailOutCount ;
	//! \~polish flaga numer systemowy
	int fSystemNumber ;
	//! \~polish ilo form patnoci
	int paymentMethodsCount ;
	//! \~polish flaga reszta
	int fRest ;
	//! \~polish flaga wpata
	int fPayment ;
	//! \~polish typ patnoci nr 1
	int paymentMethodType1 ;
	//! \~polish typ patnoci nr 2
	int paymentMethodType2 ;
	//! \~polish typ patnoci nr 3
	int paymentMethodType3 ;
	//! \~polish typ patnoci nr 4
	int paymentMethodType4 ;
	//! \~polish typ patnoci nr 5
	int paymentMethodType5 ;
	//! \~polish typ patnoci nr 6
	int paymentMethodType6 ;
	//! \~polish typ patnoci nr 7
	int paymentMethodType7 ;
	//! \~polish typ patnoci nr 8
	int paymentMethodType8 ;
	//! \~polish typ patnoci nr 9
	int paymentMethodType9 ;
	//! \~polish typ patnoci nr 10
	int paymentMethodType10 ;
	//! \~polish typ patnoci nr 11
	int paymentMethodType11 ;
	//! \~polish typ patnoci nr 12
	int paymentMethodType12 ;
	//! \~polish typ patnoci nr 13
	int paymentMethodType13 ;
	//! \~polish typ patnoci nr 14
	int paymentMethodType14 ;
	//! \~polish typ patnoci nr 15
	int paymentMethodType15 ;
	//! \~polish typ patnoci nr 16
	int paymentMethodType16 ;
	//! \~polish numer kasy
	char tillNumber[9];
	//! \~polish kasjer
	char cashier[33];
	//! \~polish numer systemowy
	char systemNumber[10];
	//! \~polish linia nr 1
	char line1[41];
	//! \~polish linia nr 2
	char line2[41];
	//! \~polish linia nr 3
	char line3[41];
	//! \~polish nazwa formy patnoci nr 1
	char paymentMethodName1[25];
	//! \~polish nazwa formy patnoci nr 2
	char paymentMethodName2[25];
	//! \~polish nazwa formy patnoci nr 3
	char paymentMethodName3[25];
	//! \~polish nazwa formy patnoci nr 4
	char paymentMethodName4[25];
	//! \~polish nazwa formy patnoci nr 5
	char paymentMethodName5[25];
	//! \~polish nazwa formy patnoci nr 6
	char paymentMethodName6[25];
	//! \~polish nazwa formy patnoci nr 7
	char paymentMethodName7[25];
	//! \~polish nazwa formy patnoci nr 8
	char paymentMethodName8[25];
	//! \~polish nazwa formy patnoci nr 9
	char paymentMethodName9[25];
	//! \~polish nazwa formy patnoci nr 10
	char paymentMethodName10[25];
	//! \~polish nazwa formy patnoci nr 11
	char paymentMethodName11[25];
	//! \~polish nazwa formy patnoci nr 12
	char paymentMethodName12[25];
	//! \~polish nazwa formy patnoci nr 13
	char paymentMethodName13[25];
	//! \~polish nazwa formy patnoci nr 14
	char paymentMethodName14[25];
	//! \~polish nazwa formy patnoci nr 15
	char paymentMethodName15[25];
	//! \~polish nazwa formy patnoci nr 16
	char paymentMethodName16[25];
	//! \~polish numer kaucji pobranej nr 1
	char bailInNumber1[4];
	//! \~polish numer kaucji pobranej nr 2
	char bailInNumber2[4];
	//! \~polish numer kaucji pobranej nr 3
	char bailInNumber3[4];
	//! \~polish numer kaucji pobranej nr 4
	char bailInNumber4[4];
	//! \~polish numer kaucji pobranej nr 5
	char bailInNumber5[4];
	//! \~polish numer kaucji pobranej nr 6
	char bailInNumber6[4];
	//! \~polish numer kaucji pobranej nr 7
	char bailInNumber7[4];
	//! \~polish numer kaucji pobranej nr 8
	char bailInNumber8[4];
	//! \~polish numer kaucji pobranej nr 9
	char bailInNumber9[4];
	//! \~polish numer kaucji pobranej nr 10
	char bailInNumber10[4];
	//! \~polish numer kaucji pobranej nr 11
	char bailInNumber11[4];
	//! \~polish numer kaucji pobranej nr 12
	char bailInNumber12[4];
	//! \~polish numer kaucji pobranej nr 13
	char bailInNumber13[4];
	//! \~polish numer kaucji pobranej nr 14
	char bailInNumber14[4];
	//! \~polish numer kaucji pobranej nr 15
	char bailInNumber15[4];
	//! \~polish numer kaucji pobranej nr 16
	char bailInNumber16[4];
	//! \~polish numer kaucji pobranej nr 17
	char bailInNumber17[4];
	//! \~polish numer kaucji pobranej nr 18
	char bailInNumber18[4];
	//! \~polish numer kaucji pobranej nr 19
	char bailInNumber19[4];
	//! \~polish numer kaucji pobranej nr 20
	char bailInNumber20[4];
	//! \~polish numer kaucji pobranej nr 21
	char bailInNumber21[4];
	//! \~polish numer kaucji pobranej nr 22
	char bailInNumber22[4];
	//! \~polish numer kaucji pobranej nr 23
	char bailInNumber23[4];
	//! \~polish numer kaucji pobranej nr 24
	char bailInNumber24[4];
	//! \~polish numer kaucji pobranej nr 25
	char bailInNumber25[4];
	//! \~polish numer kaucji pobranej nr 26
	char bailInNumber26[4];
	//! \~polish numer kaucji pobranej nr 27
	char bailInNumber27[4];
	//! \~polish numer kaucji pobranej nr 28
	char bailInNumber28[4];
	//! \~polish numer kaucji pobranej nr 29
	char bailInNumber29[4];
	//! \~polish numer kaucji pobranej nr 30
	char bailInNumber30[4];
	//! \~polish numer kaucji pobranej nr 31
	char bailInNumber31[4];
	//! \~polish numer kaucji pobranej nr 32
	char bailInNumber32[4];
	//! \~polish ilo kaucji pobranej nr 1
	char bailInAmount1[16];
	//! \~polish ilo kaucji pobranej nr 2
	char bailInAmount2[16];
	//! \~polish ilo kaucji pobranej nr 3
	char bailInAmount3[16];
	//! \~polish ilo kaucji pobranej nr 4
	char bailInAmount4[16];
	//! \~polish ilo kaucji pobranej nr 5
	char bailInAmount5[16];
	//! \~polish ilo kaucji pobranej nr 6
	char bailInAmount6[16];
	//! \~polish ilo kaucji pobranej nr 7
	char bailInAmount7[16];
	//! \~polish ilo kaucji pobranej nr 8
	char bailInAmount8[16];
	//! \~polish ilo kaucji pobranej nr 9
	char bailInAmount9[16];
	//! \~polish ilo kaucji pobranej nr 10
	char bailInAmount10[16];
	//! \~polish ilo kaucji pobranej nr 11
	char bailInAmount11[16];
	//! \~polish ilo kaucji pobranej nr 12
	char bailInAmount12[16];
	//! \~polish ilo kaucji pobranej nr 13
	char bailInAmount13[16];
	//! \~polish ilo kaucji pobranej nr 14
	char bailInAmount14[16];
	//! \~polish ilo kaucji pobranej nr 15
	char bailInAmount15[16];
	//! \~polish ilo kaucji pobranej nr 16
	char bailInAmount16[16];
	//! \~polish ilo kaucji pobranej nr 17
	char bailInAmount17[16];
	//! \~polish ilo kaucji pobranej nr 18
	char bailInAmount18[16];
	//! \~polish ilo kaucji pobranej nr 19
	char bailInAmount19[16];
	//! \~polish ilo kaucji pobranej nr 20
	char bailInAmount20[16];
	//! \~polish ilo kaucji pobranej nr 21
	char bailInAmount21[16];
	//! \~polish ilo kaucji pobranej nr 22
	char bailInAmount22[16];
	//! \~polish ilo kaucji pobranej nr 23
	char bailInAmount23[16];
	//! \~polish ilo kaucji pobranej nr 24
	char bailInAmount24[16];
	//! \~polish ilo kaucji pobranej nr 25
	char bailInAmount25[16];
	//! \~polish ilo kaucji pobranej nr 26
	char bailInAmount26[16];
	//! \~polish ilo kaucji pobranej nr 27
	char bailInAmount27[16];
	//! \~polish ilo kaucji pobranej nr 28
	char bailInAmount28[16];
	//! \~polish ilo kaucji pobranej nr 29
	char bailInAmount29[16];
	//! \~polish ilo kaucji pobranej nr 30
	char bailInAmount30[16];
	//! \~polish ilo kaucji pobranej nr 31
	char bailInAmount31[16];
	//! \~polish ilo kaucji pobranej nr 32
	char bailInAmount32[16];
	//! \~polish numer kaucji zwrconej nr 1
	char bailOutNumber1[4];
	//! \~polish numer kaucji zwrconej nr 2
	char bailOutNumber2[4];
	//! \~polish numer kaucji zwrconej nr 3
	char bailOutNumber3[4];
	//! \~polish numer kaucji zwrconej nr 4
	char bailOutNumber4[4];
	//! \~polish numer kaucji zwrconej nr 5
	char bailOutNumber5[4];
	//! \~polish numer kaucji zwrconej nr 6
	char bailOutNumber6[4];
	//! \~polish numer kaucji zwrconej nr 7
	char bailOutNumber7[4];
	//! \~polish numer kaucji zwrconej nr 8
	char bailOutNumber8[4];
	//! \~polish numer kaucji zwrconej nr 9
	char bailOutNumber9[4];
	//! \~polish numer kaucji zwrconej nr 10
	char bailOutNumber10[4];
	//! \~polish numer kaucji zwrconej nr 11
	char bailOutNumber11[4];
	//! \~polish numer kaucji zwrconej nr 12
	char bailOutNumber12[4] ;
	//! \~polish numer kaucji zwrconej nr 13
	char bailOutNumber13[4] ;
	//! \~polish numer kaucji zwrconej nr 14
	char bailOutNumber14[4] ;
	//! \~polish numer kaucji zwrconej nr 15
	char bailOutNumber15[4] ;
	//! \~polish numer kaucji zwrconej nr 16
	char bailOutNumber16[4] ;
	//! \~polish numer kaucji zwrconej nr 17
	char bailOutNumber17[4] ;
	//! \~polish numer kaucji zwrconej nr 18
	char bailOutNumber18[4] ;
	//! \~polish numer kaucji zwrconej nr 19
	char bailOutNumber19[4] ;
	//! \~polish numer kaucji zwrconej nr 20
	char bailOutNumber20[4] ;
	//! \~polish numer kaucji zwrconej nr 21
	char bailOutNumber21[4] ;
	//! \~polish numer kaucji zwrconej nr 22
	char bailOutNumber22[4] ;
	//! \~polish numer kaucji zwrconej nr 23
	char bailOutNumber23[4] ;
	//! \~polish numer kaucji zwrconej nr 24
	char bailOutNumber24[4] ;
	//! \~polish numer kaucji zwrconej nr 25
	char bailOutNumber25[4] ;
	//! \~polish numer kaucji zwrconej nr 26
	char bailOutNumber26[4] ;
	//! \~polish numer kaucji zwrconej nr 27
	char bailOutNumber27[4] ;
	//! \~polish numer kaucji zwrconej nr 28
	char bailOutNumber28[4] ;
	//! \~polish numer kaucji zwrconej nr 29
	char bailOutNumber29[4] ;
	//! \~polish numer kaucji zwrconej nr 30
	char bailOutNumber30[4] ;
	//! \~polish numer kaucji zwrconej nr 31
	char bailOutNumber31[4] ;
	//! \~polish numer kaucji zwrconej nr 32
	char bailOutNumber32[4] ;
	//! \~polish ilo kaucji zwrconej nr 1
	char bailOutAmount1[16];
	//! \~polish ilo kaucji zwrconej nr 2
	char bailOutAmount2[16];
	//! \~polish ilo kaucji zwrconej nr 3
	char bailOutAmount3[16];
	//! \~polish ilo kaucji zwrconej nr 4
	char bailOutAmount4[16];
	//! \~polish ilo kaucji zwrconej nr 5
	char bailOutAmount5[16];
	//! \~polish ilo kaucji zwrconej nr 6
	char bailOutAmount6[16];
	//! \~polish ilo kaucji zwrconej nr 7
	char bailOutAmount7[16];
	//! \~polish ilo kaucji zwrconej nr 8
	char bailOutAmount8[16];
	//! \~polish ilo kaucji zwrconej nr 9
	char bailOutAmount9[16];
	//! \~polish ilo kaucji zwrconej nr 10
	char bailOutAmount10[16];
	//! \~polish ilo kaucji zwrconej nr 11
	char bailOutAmount11[16];
	//! \~polish ilo kaucji zwrconej nr 12
	char bailOutAmount12[16];
	//! \~polish ilo kaucji zwrconej nr 13
	char bailOutAmount13[16];
	//! \~polish ilo kaucji zwrconej nr 14
	char bailOutAmount14[16];
	//! \~polish ilo kaucji zwrconej nr 15
	char bailOutAmount15[16];
	//! \~polish ilo kaucji zwrconej nr 16
	char bailOutAmount16[16];
	//! \~polish ilo kaucji zwrconej nr 17
	char bailOutAmount17[16];
	//! \~polish ilo kaucji zwrconej nr 18
	char bailOutAmount18[16];
	//! \~polish ilo kaucji zwrconej nr 19
	char bailOutAmount19[16];
	//! \~polish ilo kaucji zwrconej nr 20
	char bailOutAmount20[16];
	//! \~polish ilo kaucji zwrconej nr 21
	char bailOutAmount21[16];
	//! \~polish ilo kaucji zwrconej nr 22
	char bailOutAmount22[16];
	//! \~polish ilo kaucji zwrconej nr 23
	char bailOutAmount23[16];
	//! \~polish ilo kaucji zwrconej nr 24
	char bailOutAmount24[16];
	//! \~polish ilo kaucji zwrconej nr 25
	char bailOutAmount25[16];
	//! \~polish ilo kaucji zwrconej nr 26
	char bailOutAmount26[16];
	//! \~polish ilo kaucji zwrconej nr 27
	char bailOutAmount27[16];
	//! \~polish ilo kaucji zwrconej nr 28
	char bailOutAmount28[16];
	//! \~polish ilo kaucji zwrconej nr 29
	char bailOutAmount29[16];
	//! \~polish ilo kaucji zwrconej nr 30
	char bailOutAmount30[16];
	//! \~polish ilo kaucji zwrconej nr 31
	char bailOutAmount31[16];
	//! \~polish ilo kaucji zwrconej nr 32
	char bailOutAmount32[16];
	//! \~polish razem
	long long total ;
	//! \~polish DSP
	long long DSP ;
	//! \~polish rabat
	long long discount ;
	//! \~polish wpata
	long long payment ;
	//! \~polish kwota formy patnoci nr 1
	long long paymentMethod1 ;
	//! \~polish kwota formy patnoci nr 2
	long long paymentMethod2 ;
	//! \~polish kwota formy patnoci nr 3
	long long paymentMethod3 ;
	//! \~polish kwota formy patnoci nr 4
	long long paymentMethod4 ;
	//! \~polish kwota formy patnoci nr 5
	long long paymentMethod5 ;
	//! \~polish kwota formy patnoci nr 6
	long long paymentMethod6 ;
	//! \~polish kwota formy patnoci nr 7
	long long paymentMethod7 ;
	//! \~polish kwota formy patnoci nr 8
	long long paymentMethod8 ;
	//! \~polish kwota formy patnoci nr 9
	long long paymentMethod9 ;
	//! \~polish kwota formy patnoci nr 10
	long long paymentMethod10 ;
	//! \~polish kwota formy patnoci nr 11
	long long paymentMethod11 ;
	//! \~polish kwota formy patnoci nr 12
	long long paymentMethod12 ;
	//! \~polish kwota formy patnoci nr 13
	long long paymentMethod13 ;
	//! \~polish kwota formy patnoci nr 14
	long long paymentMethod14 ;
	//! \~polish kwota formy patnoci nr 15
	long long paymentMethod15 ;
	//! \~polish kwota formy patnoci nr 16
	long long paymentMethod16 ;
	//! \~polish reszta
	long long rest ;
	//! \~polish kwota kaucji pobranej nr 1
	long long bailIn1 ;
	//! \~polish kwota kaucji pobranej nr 2
	long long bailIn2 ;
	//! \~polish kwota kaucji pobranej nr 3
	long long bailIn3 ;
	//! \~polish kwota kaucji pobranej nr 4
	long long bailIn4 ;
	//! \~polish kwota kaucji pobranej nr 5
	long long bailIn5 ;
	//! \~polish kwota kaucji pobranej nr 6
	long long bailIn6 ;
	//! \~polish kwota kaucji pobranej nr 7
	long long bailIn7 ;
	//! \~polish kwota kaucji pobranej nr 8
	long long bailIn8 ;
	//! \~polish kwota kaucji pobranej nr 9
	long long bailIn9 ;
	//! \~polish kwota kaucji pobranej nr 10
	long long bailIn10 ;
	//! \~polish kwota kaucji pobranej nr 11
	long long bailIn11 ;
	//! \~polish kwota kaucji pobranej nr 12
	long long bailIn12 ;
	//! \~polish kwota kaucji pobranej nr 13
	long long bailIn13 ;
	//! \~polish kwota kaucji pobranej nr 14
	long long bailIn14 ;
	//! \~polish kwota kaucji pobranej nr 15
	long long bailIn15 ;
	//! \~polish kwota kaucji pobranej nr 16
	long long bailIn16 ;
	//! \~polish kwota kaucji pobranej nr 17
	long long bailIn17 ;
	//! \~polish kwota kaucji pobranej nr 18
	long long bailIn18 ;
	//! \~polish kwota kaucji pobranej nr 19
	long long bailIn19 ;
	//! \~polish kwota kaucji pobranej nr 20
	long long bailIn20 ;
	//! \~polish kwota kaucji pobranej nr 21
	long long bailIn21 ;
	//! \~polish kwota kaucji pobranej nr 22
	long long bailIn22 ;
	//! \~polish kwota kaucji pobranej nr 23
	long long bailIn23 ;
	//! \~polish kwota kaucji pobranej nr 24
	long long bailIn24 ;
	//! \~polish kwota kaucji pobranej nr 25
	long long bailIn25 ;
	//! \~polish kwota kaucji pobranej nr 26
	long long bailIn26 ;
	//! \~polish kwota kaucji pobranej nr 27
	long long bailIn27 ;
	//! \~polish kwota kaucji pobranej nr 28
	long long bailIn28 ;
	//! \~polish kwota kaucji pobranej nr 29
	long long bailIn29 ;
	//! \~polish kwota kaucji pobranej nr 30
	long long bailIn30 ;
	//! \~polish kwota kaucji pobranej nr 31
	long long bailIn31 ;
	//! \~polish kwota kaucji pobranej nr 32
	long long bailIn32 ;
	//! \~polish kwota kaucji zwrconej nr 1
	long long bailOut1 ;
	//! \~polish kwota kaucji zwrconej nr 2
	long long bailOut2 ;
	//! \~polish kwota kaucji zwrconej nr 3
	long long bailOut3 ;
	//! \~polish kwota kaucji zwrconej nr 4
	long long bailOut4 ;
	//! \~polish kwota kaucji zwrconej nr 5
	long long bailOut5 ;
	//! \~polish kwota kaucji zwrconej nr 6
	long long bailOut6 ;
	//! \~polish kwota kaucji zwrconej nr 7
	long long bailOut7 ;
	//! \~polish kwota kaucji zwrconej nr 8
	long long bailOut8 ;
	//! \~polish kwota kaucji zwrconej nr 9
	long long bailOut9 ;
	//! \~polish kwota kaucji zwrconej nr 10
	long long bailOut10 ;
	//! \~polish kwota kaucji zwrconej nr 11
	long long bailOut11 ;
	//! \~polish kwota kaucji zwrconej nr 12
	long long bailOut12 ;
	//! \~polish kwota kaucji zwrconej nr 13
	long long bailOut13 ;
	//! \~polish kwota kaucji zwrconej nr 14
	long long bailOut14 ;
	//! \~polish kwota kaucji zwrconej nr 15
	long long bailOut15 ;
	//! \~polish kwota kaucji zwrconej nr 16
	long long bailOut16 ;
	//! \~polish kwota kaucji zwrconej nr 17
	long long bailOut17 ;
	//! \~polish kwota kaucji zwrconej nr 18
	long long bailOut18 ;
	//! \~polish kwota kaucji zwrconej nr 19
	long long bailOut19 ;
	//! \~polish kwota kaucji zwrconej nr 20
	long long bailOut20 ;
	//! \~polish kwota kaucji zwrconej nr 21
	long long bailOut21 ;
	//! \~polish kwota kaucji zwrconej nr 22
	long long bailOut22 ;
	//! \~polish kwota kaucji zwrconej nr 23
	long long bailOut23 ;
	//! \~polish kwota kaucji zwrconej nr 24
	long long bailOut24 ;
	//! \~polish kwota kaucji zwrconej nr 25
	long long bailOut25 ;
	//! \~polish kwota kaucji zwrconej nr 26
	long long bailOut26 ;
	//! \~polish kwota kaucji zwrconej nr 27
	long long bailOut27 ;
	//! \~polish kwota kaucji zwrconej nr 28
	long long bailOut28 ;
	//! \~polish kwota kaucji zwrconej nr 29
	long long bailOut29 ;
	//! \~polish kwota kaucji zwrconej nr 30
	long long bailOut30 ;
	//! \~polish kwota kaucji zwrconej nr 31
	long long bailOut31 ;
	//! \~polish kwota kaucji zwrconej nr 32
	long long bailOut32 ;
	//! \~polish druga wersja numeru systemowego (gdy *systemNumber == 0)
   char systemNumberLong[513];
}EndReceiptWithPaymentMethods2;

typedef struct _PrintEnd {
	//! \~polish zakoczenie
	int end ;
}PrintEnd;


//REPORT STRUCTS-------------------------------

typedef struct _ChangeReport
{
	//! \~polish rodaj raportu
	int type;
	//! \~polish zmiana
	char change[9];
	//! \~polish kasjer
	char cashier[33];
	//! \~polish numer kasy
	char cashNumber[9];
	//! \~polish nazwa karty nr 1
	char cardName1[17];
	//! \~polish nazwa karty nr 2
	char cardName2[17];
	//! \~polish nazwa karty nr 3
	char cardName3[17];
	//! \~polish nazwa karty nr 4
	char cardName4[17];
	//! \~polish nazwa karty nr 5
	char cardName5[17];
	//! \~polish nazwa karty nr 6
	char cardName6[17];
	//! \~polish nazwa karty nr 7
	char cardName7[17];
	//! \~polish nazwa karty nr 8
	char cardName8[17];
	//! \~polish nazwa czeku nr 1
	char chequeName1[17];
	//! \~polish nazwa czeku nr 2
	char chequeName2[17];
	//! \~polish nazwa czeku nr 3
	char chequeName3[17];
	//! \~polish nazwa czeku nr 4
	char chequeName4[17];
	//! \~polish nazwa bonu nr 1 
	char bonName1[17];
	//! \~polish nazwa bonu nr 2 
	char bonName2[17];
	//! \~polish nazwa bonu nr 3
	char bonName3[17];
	//! \~polish nazwa bonu nr 4
	char bonName4[17];
	//! \~polish pocztek
	char begin[16];
	//! \~polish koniec
	char end[16];
	//! \~polish przychd
	long long income ;
	//! \~polish gotwka
	long long cash ;
	//! \~polish karta nr 1
	long long card1 ;
	//! \~polish karta nr 2
	long long card2 ;
	//! \~polish karta nr 3
	long long card3 ;
	//! \~polish karta nr 4
	long long card4 ;
	//! \~polish karta nr 5
	long long card5 ;
	//! \~polish karta nr 6
	long long card6 ;
	//! \~polish karta nr 7
	long long card7 ;
	//! \~polish karta nr 8
	long long card8 ;
	//! \~polish czek nr 1
	long long cheque1 ;
	//! \~polish czek nr 2
	long long cheque2 ;
	//! \~polish czek nr 3
	long long cheque3 ;
	//! \~polish czek nr 4
	long long cheque4 ;
	//! \~polish bon nr 1
	long long bon1 ;
	//! \~polish bon nr 2
	long long bon2 ;
	//! \~polish bon nr 3
	long long bon3 ;
	//! \~polish bon nr 4
	long long bon4 ;
	//! \~polish wpaty
	long long cashIn ;
	//! \~polish przyjecia
	long long containersIn ;
	//! \~polish wypaty
	long long cashOut ;
	//! \~polish wydania
	long long containersOut ;
	//! \~polish stan kasy
	long long cashState ;
	//! \~polish ilo paragonw
	char receiptQuantity[6];
	//! \~polish ilo anulowanych
	char abortQuantity[6];
	//! \~polish ilo STORNO
	char stornoQuantity[6];
}ChangeReport;

typedef struct _DailyReport
{
	//! \~polish rok
	char year[3];
	//! \~polish miesic
	char month[3];
	//! \~polish dzie
	char day[3];
	//! \~polish numer kasy
	char cashNumber[9];
	//! \~polish kasjer
	char cashier[33];
}DailyReport;

typedef struct _PeriodicReport
{
	//! \~polish data pocztkowa: rok
	char beginYear[3];
	//! \~polish data pocztkowa: miesic
	char beginMonth[3];
	//! \~polish data pocztkowa: dzie
	char beginDay[3];
	//! \~polish data kocowa: rok
	char endYear[3];
	//! \~polish data kocowa: miesic
	char endMonth[3];
	//! \~polish data kocowa: dzie
	char endDay[3];
	//! \~polish rodzaj raportu
	int type ;
	//! \~polish kasjer
	char cashier[33];
	//! \~polish numer kasy
	char cashNumber[9];
	//! \~polish numer pocztkowy
	char beginNr[11];
	//! \~polish numer kocowy
	char endNr[11];
}PeriodicReport;

typedef struct _Cashier
{
	//! \~polish akcja
	int action ;
	//! \~polish kasjer
	char cashier[33];
	//! \~polish numer kasy
	char cashNumber[9];
}Cashier;

typedef struct _PrintoutFromPM
{
	//! \~polish typ zakresu
	int type ;
	//! \~polish filtr wydrukw
	int printoutFilter ;
	//! \~polish zakres od
	char rangeFrom[20] ;
	//! \~polish zakres do
	char rangeTo[20] ;
}PrintoutFromPM;

typedef struct _ServiceReview
{
	//! \~polish serwisant
	char serviceman[16];
}ServiceReview;

typedef struct _FiscalMemory
{
	//! \~polish typ raportu
	int type ;
	//! \~polish numer pocztkowy
	long long beginNr ;
	//! \~polish numer kocowy
	long long endNr ;
	//! \~polish opcje raportu
	char options[3];
	//! \~polish data pocztkowa (format: "RRR-MM-DD)
	char beginDate[11];
	//! \~polish data kocowa (format: "RRR-MM-DD)
	char endDate[11];
}FiscalMemory;

typedef struct _JPK
{
	//! \~polish stan
	int state ;
	//! \~polish typ zakresu
	int rangeType;
	//! \~polish typ dokumentu
	int documentType ;
	//! \~polish zakres od
	char rangeFrom[20];
	//! \~polish zakres do
	char rangeTo[20];
	//! \~polish JPK ID
	long long jpkID ;
	//! \~polish czy z IDZ
	int isIDZ ;
	//! \~polish zawarto
	int value ;
	//! \~polish numer raportu dobowego 
	int reportNr ;
	//! \~polish numer paragonu
	int receiptNr ;
}JPK;

typedef struct _ProtectedMemory
{
	//! \~polish stan
	int state ;
	//! \~polish numer raportu
	int reportNr ;
}ProtectedMemory;

typedef struct _CashState
{
	//! \~polish numer kasy
	char cashNumber[9];
	//! \~polish kasjer
	char cashier[33];
}CashState;

typedef struct _NonFiscalPrintout
{
	//! \~polish numer wydruku
	int printOutNumber ;
	//! \~polish numer nagwka
	int headerNumber ;
	//! \~polish numer linii
	int lineNumber ;
	//! \~polish opcje wydruku
	int printOutOption ;
	//! \~polish formatowanie tekstu: pogrubienie
	int textBoldFormat ;
	//! \~polish formatowanie tekstu: inwers
	int textInversFormat ;
	//! \~polish czcionka
	int font ;
	//! \~polish formatowanie tekstu: wycentrowanie
	int textCenterFormat ;
	//! \~polish atrybuty czcionki
	int fontAtributes ;
	//! \~polish linia nr 1
	char line1[49];
	//! \~polish linia nr 2
	char line2[49];
	//! \~polish linia nr 3
	char line3[49];
	//! \~polish linia nr 4
	char line4[49];
	//! \~polish linia nr 5
	char line5[49];
	//! \~polish linia nr 6
	char line6[49];
	//! \~polish linia nr 7
	char line7[49];
	//! \~polish linia nr 8
	char line8[49];
	//! \~polish wystpuje numer systemowy
	int isSystemNumber ;
	//! \~polish ilo linii dodatkowych
	int additionalLineNumber ;
	//! \~polish linia nr 1
	char additionalLine1[49];
	//! \~polish linia nr 2
	char additionalLine2[49];
	//! \~polish linia nr 3
	char additionalLine3[49];
	//! \~polish numer systemowy
	char systemNumber[17];
	//! \~polish id wydruku
	char idTransaction[100];
	//! \~polish czy id transakcji wystpuje 
	int isIdTransaction;
}NonFiscalPrintout;

typedef struct _CashierStatus{
	char cashierName[33];
	char cashNumber[9];
	int state;

}CashierStatus;

typedef struct _ChangeReport2 {

	//! \~polish ilo kaucji pobranych
	int bailInCount ;
	//! \~polish ilo kaucji zwrconych
	int bailOutCount ;
	//! \~polish ilo form patnoci
	int paymentMethodsCount ;
	//! \~polish flaga gotwka
	int fCash ;
	//! \~polish typ patnoci nr 1
	int paymentType1 ;
	//! \~polish typ patnoci nr 2
	int paymentType2 ;
	//! \~polish typ patnoci nr 3
	int paymentType3 ;
	//! \~polish typ patnoci nr 4
	int paymentType4 ;
	//! \~polish typ patnoci nr 5
	int paymentType5 ;
	//! \~polish typ patnoci nr 6
	int paymentType6 ;
	//! \~polish typ patnoci nr 7
	int paymentType7 ;
	//! \~polish typ patnoci nr 8
	int paymentType8 ;
	//! \~polish typ patnoci nr 9
	int paymentType9 ;
	//! \~polish typ patnoci nr 10
	int paymentType10 ;
	//! \~polish typ patnoci nr 11
	int paymentType11 ;
	//! \~polish typ patnoci nr 12
	int paymentType12 ;
	//! \~polish typ patnoci nr 13
	int paymentType13 ;
	//! \~polish typ patnoci nr 14
	int paymentType14 ;
	//! \~polish typ patnoci nr 15
	int paymentType15 ;
	//! \~polish typ patnoci nr 16
	int paymentType16 ;
	//! \~polish zmiana
	char change[9];
	//! \~polish numer kasy
	char tillNumber[9];
	//! \~polish kasjer
	char cashier[33];
	//! \~polish pocztek
	char begin[16];
	//! \~polish koniec
	char end[16];
	//! \~polish nazwa formy patnoci nr 1
	char paymentMethodName1[17];
	//! \~polish nazwa formy patnoci nr 2
	char paymentMethodName2[17];
	//! \~polish nazwa formy patnoci nr 3
	char paymentMethodName3[17];
	//! \~polish nazwa formy patnoci nr 4
	char paymentMethodName4[17];
	//! \~polish nazwa formy patnoci nr 5
	char paymentMethodName5[17];
	//! \~polish nazwa formy patnoci nr 6
	char paymentMethodName6[17];
	//! \~polish nazwa formy patnoci nr 7
	char paymentMethodName7[17];
	//! \~polish nazwa formy patnoci nr 8
	char paymentMethodName8[17];
	//! \~polish nazwa formy patnoci nr 9
	char paymentMethodName9[17];
	//! \~polish nazwa formy patnoci nr 10
	char paymentMethodName10[17];
	//! \~polish nazwa formy patnoci nr 11
	char paymentMethodName11[17];
	//! \~polish nazwa formy patnoci nr 12
	char paymentMethodName12[17];
	//! \~polish nazwa formy patnoci nr 13
	char paymentMethodName13[17];
	//! \~polish nazwa formy patnoci nr 14
	char paymentMethodName14[17];
	//! \~polish nazwa formy patnoci nr 15
	char paymentMethodName15[17];
	//! \~polish nazwa formy patnoci nr 16
	char paymentMethodName16[17];
	//! \~polish nazwa kaucji pobranej nr 1
	char bailInName1[25];
	//! \~polish nazwa kaucji pobranej nr 
	char bailInName2[25];
	//! \~polish nazwa kaucji pobranej nr 
	char bailInName3[25];
	//! \~polish nazwa kaucji pobranej nr 
	char bailInName4[25];
	//! \~polish nazwa kaucji pobranej nr 
	char bailInName5[25];
	//! \~polish nazwa kaucji pobranej nr 
	char bailInName6[25];
	//! \~polish nazwa kaucji pobranej nr 
	char bailInName7[25];
	//! \~polish nazwa kaucji pobranej nr 
	char bailInName8[25];
	//! \~polish nazwa kaucji pobranej nr 
	char bailInName9[25];
	//! \~polish nazwa kaucji pobranej nr 10
	char bailInName10[25];
	//! \~polish nazwa kaucji pobranej nr 1
	char bailInName11[25];
	//! \~polish nazwa kaucji pobranej nr 1
	char bailInName12[25];
	//! \~polish nazwa kaucji pobranej nr 1
	char bailInName13[25];
	//! \~polish nazwa kaucji pobranej nr 1
	char bailInName14[25];
	//! \~polish nazwa kaucji pobranej nr 1
	char bailInName15[25];
	//! \~polish nazwa kaucji pobranej nr 1
	char bailInName16[25];
	//! \~polish nazwa kaucji pobranej nr 1
	char bailInName17[25];
	//! \~polish nazwa kaucji pobranej nr 1
	char bailInName18[25];
	//! \~polish nazwa kaucji pobranej nr 1
	char bailInName19[25];
	//! \~polish nazwa kaucji pobranej nr 20
	char bailInName20[25];
	//! \~polish nazwa kaucji pobranej nr 2
	char bailInName21[25];
	//! \~polish nazwa kaucji pobranej nr 2
	char bailInName22[25];
	//! \~polish nazwa kaucji pobranej nr 2
	char bailInName23[25];
	//! \~polish nazwa kaucji pobranej nr 2
	char bailInName24[25];
	//! \~polish nazwa kaucji pobranej nr 2
	char bailInName25[25];
	//! \~polish nazwa kaucji pobranej nr 2
	char bailInName26[25];
	//! \~polish nazwa kaucji pobranej nr 2
	char bailInName27[25];
	//! \~polish nazwa kaucji pobranej nr 2
	char bailInName28[25];
	//! \~polish nazwa kaucji pobranej nr 2
	char bailInName29[25];
	//! \~polish nazwa kaucji pobranej nr 30
	char bailInName30[25];
	//! \~polish nazwa kaucji pobranej nr 31
	char bailInName31[25];
	//! \~polish nazwa kaucji pobranej nr 32
	char bailInName32[25];
	//! \~polish nazwa kaucji zwrconej nr 1
	char bailOutName1[25];
	//! \~polish nazwa kaucji zwrconej nr 2
	char bailOutName2[25];
	//! \~polish nazwa kaucji zwrconej nr 3
	char bailOutName3[25];
	//! \~polish nazwa kaucji zwrconej nr 4
	char bailOutName4[25];
	//! \~polish nazwa kaucji zwrconej nr 5
	char bailOutName5[25];
	//! \~polish nazwa kaucji zwrconej nr 6
	char bailOutName6[25];
	//! \~polish nazwa kaucji zwrconej nr 7
	char bailOutName7[25];
	//! \~polish nazwa kaucji zwrconej nr 8
	char bailOutName8[25];
	//! \~polish nazwa kaucji zwrconej nr 9
	char bailOutName9[25];
	//! \~polish nazwa kaucji zwrconej nr 10
	char bailOutName10[25];
	//! \~polish nazwa kaucji zwrconej nr 11
	char bailOutName11[25];
	//! \~polish nazwa kaucji zwrconej nr 12
	char bailOutName12[25];
	//! \~polish nazwa kaucji zwrconej nr 13
	char bailOutName13[25];
	//! \~polish nazwa kaucji zwrconej nr 14
	char bailOutName14[25];
	//! \~polish nazwa kaucji zwrconej nr 15
	char bailOutName15[25];
	//! \~polish nazwa kaucji zwrconej nr 16
	char bailOutName16[25];
	//! \~polish nazwa kaucji zwrconej nr 17
	char bailOutName17[25];
	//! \~polish nazwa kaucji zwrconej nr 18
	char bailOutName18[25];
	//! \~polish nazwa kaucji zwrconej nr 19
	char bailOutName19[25];
	//! \~polish nazwa kaucji zwrconej nr 20
	char bailOutName20[25];
	//! \~polish nazwa kaucji zwrconej nr 21
	char bailOutName21[25];
	//! \~polish nazwa kaucji zwrconej nr 22
	char bailOutName22[25];
	//! \~polish nazwa kaucji zwrconej nr 23
	char bailOutName23[25];
	//! \~polish nazwa kaucji zwrconej nr 24
	char bailOutName24[25];
	//! \~polish nazwa kaucji zwrconej nr 25
	char bailOutName25[25];
	//! \~polish nazwa kaucji zwrconej nr 26
	char bailOutName26[25];
	//! \~polish nazwa kaucji zwrconej nr 27
	char bailOutName27[25];
	//! \~polish nazwa kaucji zwrconej nr 28
	char bailOutName28[25];
	//! \~polish nazwa kaucji zwrconej nr 29
	char bailOutName29[25];
	//! \~polish nazwa kaucji zwrconej nr 30
	char bailOutName30[25];
	//! \~polish nazwa kaucji zwrconej nr 31
	char bailOutName31[25];
	//! \~polish nazwa kaucji zwrconej nr 32
	char bailOutName32[25];
	//! \~polish przychd
	long long income ;
	//! \~polish gotwka
	long long cash ;
	//! \~polish wpaty
	long long payment ;
	//! \~polish rozchd
	long long outcome;
	//! \~polish wypaty
	long long payout ;
	//! \~polish kwota formy patnoci nr 1
	long long paymentMethod1 ;
	//! \~polish kwota formy patnoci nr 2
	long long paymentMethod2 ;
	//! \~polish kwota formy patnoci nr 3
	long long paymentMethod3 ;
	//! \~polish kwota formy patnoci nr 4
	long long paymentMethod4 ;
	//! \~polish kwota formy patnoci nr 5
	long long paymentMethod5 ;
	//! \~polish kwota formy patnoci nr 6
	long long paymentMethod6 ;
	//! \~polish kwota formy patnoci nr 7
	long long paymentMethod7 ;
	//! \~polish kwota formy patnoci nr 8
	long long paymentMethod8 ;
	//! \~polish kwota formy patnoci nr 9
	long long paymentMethod9 ;
	//! \~polish kwota formy patnoci nr 10
	long long paymentMethod10 ;
	//! \~polish kwota formy patnoci nr 11
	long long paymentMethod11 ;
	//! \~polish kwota formy patnoci nr 12
	long long paymentMethod12 ;
	//! \~polish kwota formy patnoci nr 13
	long long paymentMethod13 ;
	//! \~polish kwota formy patnoci nr 14
	long long paymentMethod14 ;
	//! \~polish kwota formy patnoci nr 15
	long long paymentMethod15 ;
	//! \~polish kwota formy patnoci nr 16
	long long paymentMethod16 ;
	//! \~polish kaucja pobrana suma
	long long bailInSum ;
	//! \~polish kwota kaucji pobranej nr 1
	long long bailIn1 ;
	//! \~polish kwota kaucji pobranej nr 2
	long long bailIn2 ;
	//! \~polish kwota kaucji pobranej nr 3
	long long bailIn3 ;
	//! \~polish kwota kaucji pobranej nr 4
	long long bailIn4 ;
	//! \~polish kwota kaucji pobranej nr 5
	long long bailIn5 ;
	//! \~polish kwota kaucji pobranej nr 6
	long long bailIn6 ;
	//! \~polish kwota kaucji pobranej nr 7
	long long bailIn7 ;
	//! \~polish kwota kaucji pobranej nr 8
	long long bailIn8 ;
	//! \~polish kwota kaucji pobranej nr 9
	long long bailIn9 ;
	//! \~polish kwota kaucji pobranej nr 10
	long long bailIn10 ;
	//! \~polish kwota kaucji pobranej nr 11
	long long bailIn11 ;
	//! \~polish kwota kaucji pobranej nr 12
	long long bailIn12 ;
	//! \~polish kwota kaucji pobranej nr 13
	long long bailIn13 ;
	//! \~polish kwota kaucji pobranej nr 14
	long long bailIn14 ;
	//! \~polish kwota kaucji pobranej nr 15
	long long bailIn15 ;
	//! \~polish kwota kaucji pobranej nr 16
	long long bailIn16 ;
	//! \~polish kwota kaucji pobranej nr 17
	long long bailIn17 ;
	//! \~polish kwota kaucji pobranej nr 18
	long long bailIn18 ;
	//! \~polish kwota kaucji pobranej nr 19
	long long bailIn19 ;
	//! \~polish kwota kaucji pobranej nr 20
	long long bailIn20 ;
	//! \~polish kwota kaucji pobranej nr 21
	long long bailIn21 ;
	//! \~polish kwota kaucji pobranej nr 22
	long long bailIn22 ;
	//! \~polish kwota kaucji pobranej nr 23
	long long bailIn23 ;
	//! \~polish kwota kaucji pobranej nr 24
	long long bailIn24 ;
	//! \~polish kwota kaucji pobranej nr 25
	long long bailIn25 ;
	//! \~polish kwota kaucji pobranej nr 26
	long long bailIn26 ;
	//! \~polish kwota kaucji pobranej nr 27
	long long bailIn27 ;
	//! \~polish kwota kaucji pobranej nr 28
	long long bailIn28 ;
	//! \~polish kwota kaucji pobranej nr 29
	long long bailIn29 ;
	//! \~polish kwota kaucji pobranej nr 30
	long long bailIn30 ;
	//! \~polish kwota kaucji pobranej nr 31
	long long bailIn31 ;
	//! \~polish kwota kaucji pobranej nr 32
	long long bailIn32 ;
	//! \~polish kaucja zwrcona suma
	long long bailOutSum ;
	//! \~polish kwota kaucji zwrconej nr 1
	long long bailOut1 ;
	//! \~polish kwota kaucji zwrconej nr 2
	long long bailOut2 ;
	//! \~polish kwota kaucji zwrconej nr 3
	long long bailOut3 ;
	//! \~polish kwota kaucji zwrconej nr 4
	long long bailOut4 ;
	//! \~polish kwota kaucji zwrconej nr 5
	long long bailOut5 ;
	//! \~polish kwota kaucji zwrconej nr 6
	long long bailOut6 ;
	//! \~polish kwota kaucji zwrconej nr 7
	long long bailOut7 ;
	//! \~polish kwota kaucji zwrconej nr 8
	long long bailOut8 ;
	//! \~polish kwota kaucji zwrconej nr 9
	long long bailOut9 ;
	//! \~polish kwota kaucji zwrconej nr 10
	long long bailOut10 ;
	//! \~polish kwota kaucji zwrconej nr 11
	long long bailOut11 ;
	//! \~polish kwota kaucji zwrconej nr 12
	long long bailOut12 ;
	//! \~polish kwota kaucji zwrconej nr 13
	long long bailOut13 ;
	//! \~polish kwota kaucji zwrconej nr 14
	long long bailOut14 ;
	//! \~polish kwota kaucji zwrconej nr 15
	long long bailOut15 ;
	//! \~polish kwota kaucji zwrconej nr 16
	long long bailOut16 ;
	//! \~polish kwota kaucji zwrconej nr 17
	long long bailOut17 ;
	//! \~polish kwota kaucji zwrconej nr 18
	long long bailOut18 ;
	//! \~polish kwota kaucji zwrconej nr 19
	long long bailOut19 ;
	//! \~polish kwota kaucji zwrconej nr 20
	long long bailOut20 ;
	//! \~polish kwota kaucji zwrconej nr 21
	long long bailOut21 ;
	//! \~polish kwota kaucji zwrconej nr 22
	long long bailOut22 ;
	//! \~polish kwota kaucji zwrconej nr 23
	long long bailOut23 ;
	//! \~polish kwota kaucji zwrconej nr 24
	long long bailOut24 ;
	//! \~polish kwota kaucji zwrconej nr 25
	long long bailOut25 ;
	//! \~polish kwota kaucji zwrconej nr 26
	long long bailOut26 ;
	//! \~polish kwota kaucji zwrconej nr 27
	long long bailOut27 ;
	//! \~polish kwota kaucji zwrconej nr 28
	long long bailOut28 ;
	//! \~polish kwota kaucji zwrconej nr 29
	long long bailOut29 ;
	//! \~polish kwota kaucji zwrconej nr 30
	long long bailOut30 ;
	//! \~polish kwota kaucji zwrconej nr 31
	long long bailOut31 ;
	//! \~polish kwota kaucji zwrconej nr 32
	long long bailOut32 ;
	//! \~polish stan kasy
	long long tillStatus ;
	//! \~polish ilo paragonw
	char receiptCount[10];
	//! \~polish ilo anulowanych
	char receiptAbortCount[10];
	//! \~polish ilo STORNO
	char stornoCount[10];

}ChangeReport2;

//OTHER STRUCTS-------------------------------

typedef struct DrvVersion
{
	//! \~polish nazwa biblioteki
	char LibName[100];
	//! \~polish wersja biblioteki
	int LibVersion;
	//! \~polish pena wersja
	char FullVersion[100];

}DrvVersion;

typedef struct PrnVersion
{
	//! \~polish nazwa urzdzenia
	char DeviceName[100] ;
	//! \~polish wersja urzdzenia
	char DeviceVersion[10] ;
}PrnVersion;


typedef struct _DLEStatus
{
	//! \~polish stan "Online"
	int isOnline;
	//! \~polish stan "Brak Papieru" lub rozadowany akumulator
	int isPaperOut;
	//! \~polish stan "Bd mechnizmu/sterownika"
	int isPrinterErr;
	//! \~polish jest poczenie
	int isComm;
}DLEStatus;

typedef struct _DLE2Status
{
   //! \~polish ostatni kod bdu
   int lastError ;
   //! \~polish numer ostatniego wydruku
   int lastPrintoutNr ;
   //! \~polish numer ostatniego paragonu
   int lastReceiptNr ;
   //! \~polish brak moliwoci przetwarzania rozkazw
   int noPossibilityToProcessOrders ;
   //! \~polish drukarka w trakcie wykonywania raportu dobowego
   int printerDuringDailyReport ;
   //! \~polish trwa synchroniczna weryfikacja kopii e
   int syncVerificationOfTheCopyE ;
   //! \~polish drukarka oczekuje na interakcj z uzytkownikiem
   int printerWaitsForInteractionWithTheUser ;
   //! \~polish drukarka w menu
   int printerInMenu ;
   //! \~polish brak papieru
   int paperOut ;
   //! \~polish bd mechanizmu drukujcego
   int printMechanismError ;
   //! \~polish otwarta pokrywa drukarki
   int openPrinterCover ;
   //! \~polish ostatni rozkaz zakoczony bdem
   int lastCommandError ;
   //! \~polish drukarka w trybie transakcji
   int transactionMode ;
   //! \~polish tryb dodatkowych linii na paragonie
   int additionalLinesInReceiptMode ;
   //! \~polish w trakcie wydruku
   int duringPrinting ;
   //! \~polish koczcy si papier
   int endingPaper ;

}DLE2Status;

typedef struct _ENQStatus
{
	// \~polish tryb fiskalny
	int printerMode;
	//! \~polish ostatni rozkaz wykonany poprawnie
	int lastCommandOK;
	// \~polish drukarka w trybie transakcji
	int transactionMode;
	//! \~polish ostatnia transakcja zostaa sfinalizowana poprawnie
	int lastTransactionOK;
} ENQStatus;



typedef struct _LastError
{
	//! \~polish kod bdu z urzdzenia
   int errorCodeFromDevice ;
   //! \~polish kod bdu z biblioteki
   int errorCodeFromDriver ;

   //! \~polish opis bdu z urzdzenia
   char errorDescriptionDevice[100];
   //! \~polish opis bdu z biblioteki
   char errorDescriptionDriver[100];

   //! \~polish status DLE
   DLEStatus dle;
   //! \~polish status DLE2
   DLE2Status dle2; 
   //! \~polish status ENQ
   ENQStatus enq;
}LastError;

/**/
typedef struct _SerialPortParameters
{
   //! \~polish nazwa portu
   char com_name[10];
   //! \~polish prdko
   int BaudRate;
   int ByteSize;
   int StopBits;
   int Parity;
   int ReadTimeout;
   int WriteTimeout;
   int FlowControl;
   //! \~polish czy ma dziaa na wtkach
   int Thread;
   //! \~polish dugo timeout
   int mTimeout;

   //! \~polish duga nazwa portu, wykorzystywane w przypadku gdy com_name nieuzupenione
   char ComName[256];
} SerialPortParameters;

typedef struct _TCPIPPortParameters
{
   //! \~polish adres IP
   char host[128];
   //! \~polish numer portu
   int port ;
   //! \~polish dugoc timeout
   int mTimeout;
} TCPIPPortParameters;


typedef struct _ReadSTATUS
{
	//! \~polish ostatni bd
	int lastError ;
	//! \~polish fiskalizacja
	int fiscal ;
	//! \~polish transakcja
	int transaction ;
	//! \~polish transakcja OK
	int transactionOK ;
	//! \~polish ilo zerowa
	int resetNumber ;
	//! \~polish rok
	int Year ;
	//! \~polish miesic
	int Month ;
	//! \~polish dzie
	int Day ;
	//! \~polish stawka PTU A
	int ptuA ;
	//! \~polish stawka PTU B
	int ptuB ;
	//! \~polish stawka PTU C
	int ptuC ;
	//! \~polish stawka PTU D
	int ptuD ;
	//! \~polish stawka PTU E
	int ptuE ;
	//! \~polish stawka PTU F
	int ptuF ;
	//! \~polish stawka PTU G
	int ptuG ;
	//! \~polish ilo paragonw 
	int receiptAmount ;
	//! \~polish totalizer A
	int totalizerA ;
	//! \~polish totalizer B
	int totalizerB ;
	//! \~polish totalizer C
	int totalizerC ;
	//! \~polish totalizer D
	int totalizerD ;
	//! \~polish totalizer E
	int totalizerE ;
	//! \~polish totalizer F
	int totalizerF ;
	//! \~polish totalizer G
	int totalizerG ;
	//! \~polish gotwka
	int cash ;
	//! \~polish numer unikatowy
	char uniqueNumber[15];

}ReadSTATUS;

typedef struct _ErrorsControl
{
	//! \~polish tryb obsugi
	int mode ;
	//! \~polish kod bdu
	char errorID[5];
	//! \~polish identyfikator pakietu
	char packetID[10];
}ErrorsControl;

typedef struct _CashInfo
{
	// \~polish tryb
	int mode ;
}CashInfo;

typedef struct _InfoType
{
	// \~polish typ informacji
	int infoType ;
}InfoType;

typedef struct _PM
{
	//! \~polish numer pamici chronionej
	char PMNumber[6];
	//! \~polish etykieta pamici chronionej
	char PMlable[25];
	//! \~polish ostatni JPKID
	long long JPKID;
	//! \~polish numer pierwszego raportu dobowego w pamici chronionej
	int firstDRNumber;
	//! \~polish ilo wolnego miejsca
	int freeSpaceAmount;
	//! \~polish cakowita ilo miejsca
	int totalSpaceAmount;
}PM;

typedef struct _FMRead
{
	//! \~polish rok
	char year[3];
	//! \~polish miesic
	char month[3];
	//! \~polish dzie
	char day[3];
	//! \~polish godzina
	char hour[3];
	//! \~polish minuta
	char minute[3];
	//! \~polish sekunda
	char second[3];
	//! \~polish numer
	char nr[15];
	//! \~polish data pocztkowa
	char startDate[20];
	//! \~polish data kocowa
	char endDate[20];
	//! \~polish numer pocztkowy
	int startNumber;
	//! \~polish numer kocowy
	int endNumber;
	//! \~polish tryb
	int mode;
}FMRead;

typedef struct _LogInfo
{
	//! \~polish status
	int status ;
	//! \~polish data od
	char startDate[30];
	//! \~polish data do
	char endDate[30];
	//! \~polish poziom logowania
	char logLevel[15];
	//! \~polish modu
	char module[15];
	//! \~polish dane
	char data[1024];
	//! \~polish ID pakietu
	char packetID[5];

}LogInfo;

typedef struct _RepositoryINFO
{
	//! \~polish data ostatniej wysyki
	char LastShipmentDate[25];
	//! \~polish data ostatniej poprawnej
	char LastCorrectShipmentDate[25];
	//! \~polish ilo JPK do wysania
	int JPKAmount ;
	//! \~polish ostatnio wysany JPK
	int LastSendJPK ;
}RepositoryINFO;

typedef struct _DeviceTIME
{
	//! \~polish rok
	int year ;
	//! \~polish miesic
	int month ;
	//! \~polish dzie
	int day ;
	//! \~polish godzina
	int hour ;
	//! \~polish minuta
	int minute ;
	//! \~polish sekunda
	int second ;

}DeviceTIME;


typedef struct _CommunicationPort
{
	//! \~polish typ informacji
	int infoType ;
	//! \~polish nazwa portu
	char portName[100];
}CommunicationPort;

typedef struct _VersionInfo
{
	//! \~polish nazwa
	char name[100];
	//! \~polish wersja
	char version[10];
}VersionInfo;

typedef struct _ReadError
{
	//! \~polish ostatni bd
	int lastError ;
}ReadError;

typedef struct _DisplayCONTROL
{
	//! \~polish akcja
	int action;
	//! \~polish tekst do wywietlenia
	char text[500];
}DisplayCONTROL;

typedef struct _DateTIME
{
	//! \~polish rok
	int year ;
	//! \~polish miesic
	int month ;
	//! \~polish dzie
	int day ;
	//! \~polish godzina
	int hour ;
	//! \~polish minuta
	int minute ;
	//! \~polish sekunda
	int second ;
	//! \~polish numer kasy
	char cashNumber[10];
	//! \~polish kasjer
	char cashier[40];
}DateTIME;

typedef struct _PTU
{
	//! \~polish ilo stawek
	int numberOfRates ;
	//! \~polish numer kasy
	char cashNumber[10];
	//! \~polish kasjer
	char cashier[35];
	//! \~polish PTU A
	int A ;
	//! \~polish PTU B
	int B ;
	//! \~polish PTU C
	int C ;
	//! \~polish PTU D
	int D ;
	//! \~polish PTU E
	int E ;
	//! \~polish PTU F
	int F ;
	//! \~polish PTU G
	int G ;
	//! \~polish rok
	int year ;
	//! \~polish miesic
	int month ;
	//! \~polish dzie
	int day ;
	//! \~polish godzina
	int hour ;
	//! \~polish minuta
	int minute ;
	//! \~polish sekunda
	int second ;
	//! \~polish tryb
	int mode ;

}PTU;

typedef struct _IMG
{
	//! \~polish numer ID grafiki
   int imgId ;
   //! \~polish cieka
   char bmpPath[256];
   //! \~polish cakowita dugo
   int totalLen;
   //! \~polish suma kontrolna
   char crc[5];
}IMG;

typedef struct _Fiscal
{
	//! \~polish tryb
	int mode ;
	//! \~polish kategoria kasy
	int cashCategory ;
	//! \~polish sposb uytkowania kasy
	int cashUsingType ;
	//! \~polish tp wasnoci
	int propertyType ;
	//! \~polish typ numeraji paragonw
	int receiptNumerationType ;
	//! \~polish NIP
	char NIP[15];
	//! \~polish kod urzdu skarbowego
	char taxOfficeCode[15];
	//! \~polish dane urzdu skarbowego
	char taxOfficeData[15];
	//! \~polish dane punktu serwisowego
	char servicePointData[15];
	//! \~polish dane serwisanta
	char serviceManData[15];
	//! \~polish numer identyfikacyjny serwisanta
	char serviceManID[15];
	//! \~polish numer ewidencyjny
	char registrationNumber[15];
	//! \~polish NIP punktu serwisowego
	char servicePointNIP[15];

}Fiscal;

typedef struct _TotalizersMode
{
	//! \~polish tryb
	int mode ;
}TotalizersMode;

typedef struct _Packet
{
	//! \~polish pakiet do wysania
	char packetSend[1024];
	//! \~polish odebrany pakiet
	char packetRead[1024];
	//! \~polish czy sparadza crc
	int isCrc ;
}Packet;

///////////////////////////////////////////////////////////////////////
typedef struct _ReceiptComplete
{
	//! \~polish flaga zakoczenie
	int fEnd ;
	//! \~polish ilo kaucji pobranej
	int bailInCount ;
	//! \~polish ilo kaucji wydanej
	int bailOutCount ;
	//! \~polish ilo pozycji
	int itemCount ;
	//! \~polish ilo linii niefiskalnych pod paragonem
	int nonFicalPrintoutCount ;
	//! \~polish pozycja rabatu/narzutu do podsumy
	int discountSubtotalPos ;
	//! \~polish rozpoczcie paragonu
	StartReceipt startReceipt;
	//! \~polish pozycja paragonu
	Item item[200];
	//! \~polish zakoczenie paragonu bez form patnoci
	EndReceipt endReceipt;
	//! \~polish zakoczenie paragonu z formami patnoci(1)
	EndReceiptWithPaymentMethods1 endReceipt1;
	//! \~polish zakoczenie paragonu z formami patnoci(2)
	EndReceiptWithPaymentMethods2 endReceipt2;
	//! \~polish linia niefiskalna pod paragonem
	NonFiscalPrintout nonFiscalPrintout[200];
	//! \~polish zakoczenie wydruku
	PrintEnd printEnd;
	//! \~polish kaucja pbrana
	BailIn bailIn[100];
	//! \~polish kaucja wydana
	BailOut bailOut[100];
	//! \~polish rabat/narzut do transakcji
	DiscountOrMarkupToTransaction discountOrMarkupToTransaction[2];
	//! \~polish rabat/narzut do danej stawki PTU
	DiscountOrMarkupToPTU discountOrMarkupToPTU[7];
	//! \~polish rabat/narzut do podsumy
	DiscountOrMarkupToSubtotal discountOrMarkupToSubtotal;
	//! \~polish patno
	Payment payment;

}ReceiptComplete;


typedef struct _InvoiceComplete
{
	//! \~polish opcje faktury
	int fInvoiceOptions ;
	//! \~polish ilo pozycji faktury
	int itemCount;
	//! \~polish rozpoczcie faktury
	StartInvoice startInvoice;
	//! \~polish pozycja faktury
	Item item[200];
	//! \~polish zakoczenie faktury
	EndInvoice endInvoice;
	//! \~polish zakoczenie faktury z opcjami faktury
	EndReceipt endInvoiceWOpt;
	//! \~polish opcje faktury
	InvoiceOptions invoiceOptions;
	
}InvoiceComplete;

typedef struct _DocumentCompleteState {
	//! \~polish paragon
	int isRCP;
	//! \~polish faktura
	int isINV;
	//! \~polish czy aktywna kontrola stanu kasy
	int cashControlActive ;
	//! \~polish stan kasy przed transakcj
	long long cashBefore;
	//! \~polish stan kasy po transakcji
	long long cashAfter;
	//! \~polish przewidywany stan kasy po wykonaniu paragonu
   long long cashExpected;
   //! \~polish ostatni bd
	LastError lastError;
	//! \~polish paragon kompleksowy
	ReceiptComplete receiptComplete;
	//! \~polish faktura kompleksowa
	InvoiceComplete invoiceComplete;
}DocumentCompleteState;

typedef struct _CashInOut {
	//! \~polish parametr
	int param ;
	//! \~polish kwota do wpaty/wypaty
	long long cash ;
	//! \~polish numer kasy
	char cashNumber[10];
	//! \~polish kasjer
	char cashier[35];
}CashInOut;

typedef struct _Prepayment
{
	//! \~polish akcja
	int action ;
	//! \~polish nazwa towaru
	char itemName[61];
	//! \~polish stawka PTU
	char ptu[2];
	//! \~polish warto zaliczki/rozliczenia zaliczki
	long long value ;
	//! \~polish do dopaty
	long long extra ;
}Prepayment;

typedef struct _ConfigParam
{
   //! \~polish parametr
   int key;
   //! \~polish warto
   char value[257];
}ConfigParam;

typedef struct _Animation
{
   //! \~polish funkcja
   int function;
   //! \~polish numer ID animacji
   char animName[13];
   //! \~polish cieka
   char animPath[256];
}Animation;

typedef struct _BuyerID
{
   //! \~polish nip nabywcy
   char id[17];
}BuyerID;

// informacje oglne

typedef struct _DeviceGeneralInfo
{
	////! \~polish typ informacji
	//int infoType;
	//! \~polish nazwa urzdzenia
	char deviceName[60];
	//! \~polish wersja programu
	char programVersion[100];
	//! \~polish wersja moduu drukujcego
	char printingModuleVersion[100];
	//! \~polish nazwa systemu
	char systemName[100];
	//! \~polish wersja ssystemu
	char systemVersion[100];
	//! \~polish liczba wywietlaczy
	int numberOfDisplays;
	//! \~polish szeroko wydruku
	int printWidth;
	//! \~polish kopia elektroniczna
	int electronicCopy;
	//! \~polish rozmiar pamieci fiskalnej
	int fiscalMemorySize;

}DeviceGeneralInfo;

//szczegowe dla pamici fiskalnej

typedef struct _DetailedForFMInfo
{
	////! \~polish typ informacji
	//int infoType;
	//! \~polish rozmiar pamieci fiskalnej
	int FMSize;
	//! \~polish rozmiar rekordu
	int recordSize;
	//! \~polish tryb dziaania
	int operatingMode;
	//! \~polish numer unikatowy
	char uniqueNumber[30];
	//! \~polish numer NIP
	char NIP[30];
	//! \~polish maksymalna liczba rekordw
	int maxNumberOfRecords;
	//! \~polish liczba rekordw
	int numberOfRecords;
	//! \~polish maksymalna liczba raportw dobowych
	int maxNumberOfDailyReports;
	//! \~polish liczba raportw dobowych
	int numberOfDailyReports;
	//! \~polish maksymalna liczba zerowa RAM
	int maxNumberOfRAMResets;
	//! \~polish liczba zerowa RAM
	int numebrOfRAMResets;
	//! \~polish  maksymalna liczba zmian stawek PTU
	int maxNumberOfPTUChanges;
	//! \~polish  liczba zmian stawek PTU
	int numberOfPTUChanges;
	//! \~polish  maksymalna liczba zmian waluty
	int maxNumberOfCurrencyChanges;
	//! \~polish  liczba zmian waluty
	int numberOfCurrencyChanges;
	//! \~polish  data fiskalizacji
	char dateOfFiscalisation[20];
	//! \~polish  data zamknicia trybu fiskalnego
	char dateOfClosingFiscalMode[20];
	//! \~polish  nazwa biecej waluty
	char currentCurrencyName[20];

}DetailedForFMInfo;

//szczegoy dotyczce stanu zasilania, akumulatora i baterii

typedef struct _DetailedAboutPower
{
	////! \~polish typ informacji
	//int infoType;
	//! \~polish podczony zasilacz 
	char powerSupplyConnected[20];
	//! \~polish napicie zasilacza
	char powerSupplyVoltage[20];
	//! \~polish napicie akumulatora
	char accumulatorVoltage[20];
	//! \~polish napicie bateryjki
	char batteryVlotage[20];

}DetailedAboutPower;

//informacje o stanie wydruku

typedef struct _PrintoutStatusInfo
{
	////! \~polish typ informacji
	//int infoType;
	//! \~polish wersja moduu drukujcego
	char printoutModuleVersion[20];
	//! \~polish szerokoc wydruku w znakach
	int printoutMaxNumberOfSigns;
	//! \~polish szeroko wydruku w mm
	int printoutWidth;
	//! \~polish czcionka
	int font;
	//! \~polish obcinacz papieru
	int paperCutter;
	//! \~polish ilo papieru
	int amountOfPaper;

}PrintoutStatusInfo;

//informacje o stanie szuflady

typedef struct _DrawerState
{
	////! \~polish typ informacji
	//int infoType;
	//! \~polish stan szuflady
	int drawerState;

}DrawerState;

//informacje o stanie pamici podrcznej

typedef struct _CacheInfo
{
	////! \~polish typ informacji
	//int infoType;
	//! \~polish rozmiar cakowity w bajtach
	int fullByteSize;
	//! \~polish rozmiar cakowity w liniach wydruku
	int fullPrintoutLinesSize;
	//! \~polish rozmiar krytyczny w bajtach
	int criticalByteSize;
	//! \~polish rozmiar krytyczny w liniach wydruku
	int criticalPrintoutLinesSize;
	//! \~polish rozmiar zajty w bajtach
	int occupiedSize;
	//! \~polish rozmiar zajty w liniach wydruku
	int occupiedPrintoutLinesSize;
}CacheInfo;

//informacje o stanie bazy towarw

typedef struct _StateOfGoodsBase
{
	//! \~polish ilo towartw w bazie
	int goodsQuantity;
}StateOfGoodsBase;

// informacje szczegowe dla pamici fiskalnej wersja 2

typedef struct _DeviceFMInfoVersion2
{
	////! \~polish typ informacji
	//int infoType;
	//! \~polish rozmiar pamici fiskalnej
	int FMSize;
	//! \~polish rozmiar rekordu
	int recordSize;
	//! \~polish tryb dziaania
	int operatingMode;
	//! \~polish numer unikatowy
	char uniqueNumber[30];
	//! \~polish numer NIP
	char NIP[20];
	//! \~polish maksymalna liczba rekordw
	int maxNumberOfRecords;
	//! \~polish liczba rekordw
	int numberOfRecords;
	//! \~polish maksymalna liczba raportw dobowych
	int maxNumberOfDailyReports;
	//! \~polish liczba raportw dobowych
	int numberOfDailyReports;
	//! \~polish maksymalna liczba zerowa RAM
	int maxNumberOfRAMResets;
	//! \~polish liczba zerowa RAM
	int numberOfRAMResets;
	//! \~polish  maksymalna liczba zmian stawek PTU
	int maxNumberOfPTUChanges;
	//! \~polish  liczba zmian stawek PTU
	int numberOfPTUChanges;
	//! \~polish  maksymalna liczba zmian waluty
	int maxNumberOfCurrencyChanges;
	//! \~polish  liczba zmian waluty
	int numberOfCurrencyChanges;
	//! \~polish  data fiskalizacji
	char dateOfFiscalisation[20];
	//! \~polish  data zamknicia trybu fiskalnego
	char dateOfClosingFiscalMode[20];
	//! \~polish  nazwa biecej waluty
	char currentCurrencyName[20];
	//! \~polish data ostatniego raportu dobowego
	char lastDailyReportDate[20];
	//! \~polish data ostatniego zapisu do pamici fiskalnej
	char lastFMRecordDate[20];

}DeviceFMInfoVersion2;

//informacje szczegowe dla pamici fiskalnej wersja 3

typedef struct _DeviceFMInfoVersion3
{
	////! \~polish typ informacji
	//int infoType;
	//! \~polish liczba zdarze oglnych 
	int numberOfGeneralEvents;
	//! \~polish maksymalna liczba zdarze oglnych 
	int maxNumberOfGeneralEvents;
	//! \~polish liczba dokumentw fiskalnych
	int numberOfFiscalDocs;
	//! \~polish maksymalna liczba dokumentw fiskalnych
	int maxNumberOfFiscalDocs;
	//! \~polish liczba zmian klucza publicznego
	int numberOfPublicKeyChanges;
	//! \~polish liczba zmian tablicy stawek ulg
	int numberOfDiscountRatesChanges;
	//! \~polish liczba zmian tablicy grup ulg
	int numberOfDiscountGroupsChanges;
	//! \~polish liczba przegldw serwisowych
	int numberOfServicesInspection;
	//! \~polish rozmiar danych zdarze
	int eventsDataSize;
	//! \~polish maksymalny rozmiar danych zdarze
	int maxEventsDataSize;
	//! \~polish numer ewidencyjny
	char registrationNumber[30];

}DeviceFMInfoVersion3;

//informacje dodatkowe dla pamici fiskalnej wersja 4

typedef struct _DeviceFMInfoVersion4
{
	//! \~polish liczba zapisw 
	int numberOfRecords;
	//! \~polish maksymalna liczba zapisw
	int maxNumberOfRecords;
	//! \~polish liczba zmian stawek ulg
	int numberOfDiscountRatesChanges;
	//! \~polish liczba zmian grup ulg
	int numberOfDiscountGroupsChanges;
	//! \~polish liczba przegldw serwisowych
	int numberOfServicesInspection;
	//! \~polish maksymalna liczba przegldw serwisowych
	int maxNumberOfServicesInspection;
	//! \~polish rozmiar zapisanych danych
	int dataSize;
	//! \~polish maksymalny rozmiar zapisanych danych
	int maxDataSize;
	//! \~polish opcje producenta
	int producerOptions;

}DeviceFMInfoVersion4;

// informacje o stanie akumulatora i zasilania

typedef struct _PowerSupplyInfo
{
	//! \~polish tryb zasilania
	int powerSupplyMode;
	//! \~polish napicie zasilacza [mV]
	int powerSupplyVoltage;
	//! \~polish napicie akumulatora
	int accumulatorVoltage;
	//! \~polish napicie baterii do podtrzymania RAM/Zegara [mV]
	int batteryVoltage;
	//! \~polish  stan akumulatora
	int accumulatorState;
	//! \~polish  status baterii do podtrzymania RAM/Zegara
	int batteryStatus;
	//! \~polish poziom naadowania akumulatora
	int accumulatorLevel;

}PowerSupplyInfo;


typedef struct _FiscalizationInfo
{
	//! \~polish status fiskalizacji
	int status;
	//! \~polish data fiskalizacji
	char fiscalizationDate[19];
	//! \~polish numer nip
	char nip[14];
	//! \~polish numer ewidencyjny
	char registrationNumber[16];
	//! \~polish  identyfikator pamici chronionej
	char PMId[21];
	//! \~polish  typ urzdzenia
	int deviceType;
	//! \~polish typ numeracji paragonw
	int numberingType;
	//! \~polish typ wasnoci
	int ownershipType;

}FiscalizationInfo;

typedef struct _ServerInfo
{
	//! \~polish typ serwera
	int type;
	//! \~polish adres serwera
	char serverAdress[300];

}ServerInfo;


typedef struct _USBConfig
{
	//! \~polish usb ext typ
	int action;
	//! \~polish usb modem pid
	char usbModemPid[5];
	//! \~polish usb modem vid
	char usbModemVid[5];
	//! \~polish usb ext pid
	char usbExtPid[5];
	//! \~polish usb ext vid
	char usbExtVid[5];
	//! \~polish usb modem typ
	int usbModemType;
	//! \~polish usb ext typ
	int usbExtType;
	//! \~polish usb modem interfejs
	char usbModemInterface[4];
	//! \~polish usb ext interfejs
	char usbExternInterface[4];
	//! \~polish usb modem protok
	char usbModemProtocol[4];
	//! \~polish usb ext protok
	char usbExternProtocol[4];

}USBConfig;



typedef struct _CurrencyChange
{
	
	//! \~polish rok
	char year[3];
	//! \~polish miesic
	char month[3];
	//! \~polish dzie
	char day[3];
	//! \~polish godzina
	char hour[3];
	//! \~polish minuta
	char minute[3];
	//! \~polish sekunda
	char second[3];
	//! \~polish nazwa waluty
	char currencyName[4];
	//! \~polish kurs waluty
	char exchangeRate[14];
	//! \~polish tryb wydruku
	int printoutMode;

}CurrencyChange;


typedef struct _EreceiptStatus
{
	//! \~polish status ostatniego e-paragonu
	int status;
	//! \~polish numer wydruku
	int printoutNumber;

}EreceiptStatus;

typedef struct _SalePossibility
{
	//! \~polish nazwa towaru
	char itemName[61];
	//! \~polish stawka PTU
	char PTU[2];
	//! \~polish rezultat
	int result;

}SalePossibility;

typedef struct _ServiceLock
{
	//! \~polish rok
	char year[3];
	//! \~polish miesic
	char month[3];
	//! \~polish dzie
	char day[3];
	//! \~polish haso
	char password[31];
	//! \~polish napis
	char text[31];

}ServiceLock;


typedef struct _DatabaseControl
{
	//! \~polish akcja
	int action;
	//! \~polish nazwa
	char name[41];
	//! \~polish stawka PTU
	char PTU[2];
	//! \~polish kasjer
	char cashier[33];
	//! \~polish numer kasy
	char cashNumber[9];

}DatabaseControl;


typedef struct _PaperEjection
{
	//! \~polish liczba linii
	int linesAmount;

}PaperEjection;

typedef struct _FiscalMemoryRecords
{
	//! \~polish data pocztkowa
	char startDate[18];
	//! \~polish data kocowa
	char endDate[18];
	//! \~polish numer pocztkowy
	int startNumber;
	//! \~polish numer kocowy
	int endNumber;

}FiscalMemoryRecords;

typedef struct _FMReadRecord
{

	//! \~polish Numer rekordu
	long long recordNumber;
	//! \~polish Identyfikator rekordu
	int recordID;
	//! \~polish Cakowity rozmiar danych
	int fullDataSize;
	//! \~polish Dane
	char data[40960];

}FMReadRecord;

typedef struct _JPKDocRequest
{
	//! \~polish Stan
	int state;
	//! \~polish JPK ID
	long long JPK_ID;
	//! \~polish Czy z IDZ
	int IDZ;
	//! \~polish Zawarto
	int content;
	//! \~polish Typ dokumentu
	int docType;

}JPKDocRequest;

typedef struct _JPKDocRead
{
	//! \~polish Status
	int status;
	//! \~polish Typ dokumentu
	int docType;
	//! \~polish Rozmiar
	int size;
	//! \~polish Pozycja
	int position;
	//! \~polish JPK ID
	long long JPK_ID;
	//! \~polish Kod nabywcy
	char buyerCode[1024];
	//! \~polish Dane
	char data[262144];

}JPKDocRead;

typedef struct _EReceipt
{
   //! \~polish Identyfikator EParagonu
   char data[101];

}EReceipt;

typedef struct _EReceiptCfg
{
   //! \~polish Typ
   //! \~polish 1  programowanie adresu serwera, 2  rozszerzone ustawienia e-paragonu
	int type;
   //! \~polish Adres serwera eparagonu
   char addres[201];
   //! \~polish Szyfrowanie
   //! \~polish 0-Nie, 1 - Tak
   int encryption;
   //! \~polish Format danych
   //! \~polish 0-Obraz, 1-Dane, 2-Obraz + Dane
   int format;
   //! \~polish Protok
   //! \~polish 0-Novitus, 1-PD
   int protocol;
   //! \~polish Klucz
   char key[65];
   //! \~polish Tryb dziaania
   //! \~ 0  gdy brak potwierdzenia otrzymania e-paragonu przez serwer drukuj paragon I nie ponawiaj prb wysania e-paragonu,
   //! \~ 1  gdy brak potwierdzenia otrzymania e - paragonu przez serwer ponawiaj prby wysania e - paragonu do skutku,
   //! \~ 2 - gdy brak potwierdzenia otrzymania e - paragonu przez serwer drukuj paragon I ponawiaj prby wysania e - paragonu do skutku,
   int mode;
   //! \~polish Timeout
   int timeout;
   //! \~polish Timeout komunikatu
   int messageTimeout;
   //! \~polish Sprawdzenie poaczenia 
   //! \~ 1  sprawdza
   //! \~ 0  nie sprawdza
   int checkConnection;
   //! \~polish Zmiana adresu serwera z menu
   //! \~ 0  zabroniona
   //! \~ 1  dozwolona
   int changeAddressFromMenu;
   //! \~polish Zmiana adresu serwera po protokole 
   //! \~ 0  zabroniona
   //! \~ 1  dozwolona
   int changeAddressByPacket;
   //! \~polish Automatyczny id transakcji
   //! \~ 0  nie
   //! \~ 1  tak
   int autoId;
   //! \~polish Zezwalaj na tworzenie e-paragonw
   //! \~ 0  nie
   //! \~ 1  tak
   int allowToCreateEReceipt;
   //! \~polish Zezwalaj na wysyanie eparagonw
   //! \~ 0  nie
   //! \~ 1  tak
   int allowToSendEReceipt;

}EReceiptCfg;


typedef struct _LastRcpSummary
{
   //! \~polish Stan paragonu
   //! \~ 0  pusty
   //! \~ 1  otwarty
   //! \~ 2  zamknity
   //! \~ 3  anulowany
   int rcpState;
   //! \~polish Typ paragonu
   //! \~ 0  nornalny
   //! \~ 1  rozliczenie opakowa zwrotnych
   int rcpType;
   //! \~polish Numer paragonu
   int rcpNumber;
   //! \~polish Data i czas paragonu format: rrrr-mm-dd hh:mm:ss
   char rcpDate[32];
   //! \~polish Numer wydruku
   int prnNumber;
   //! \~polish Numer systemowy
   char systemNumber[1024];
   //! \~polish Numer kasy
   char cashNumber[128];
   //! \~polish Nazwa kasjera
   char cashier[128];
   //! \~polish Ilo pozycji
   int itemsCount;
   //! \~polish Ilo kaucji
   int itemsDepositCount;
   //! \~polish Ilo patnoci
   int itemsPaymentCount;
   //! \~polish Razem
   long long total;
   //! \~polish Typ rabatu
   //! \~polish 0 - brak
   //! \~polish 1 - rabat procentowy
   //! \~polish 2 - dopata procentowa
   //! \~polish 3 - rabat kwotowy
   //! \~polish 4 - dopata kwotowa
   int discountType;
   //! \~polish Rabat
   long long discount;
   //! \~polish Nazwa rabatu
   char discountName [128];
   //! \~polish Razem po rabacie
   long long discountTotal;
   //! \~polish Metoda rozliczenia rabatu
   int discountMethod;
   //! \~polish Kaucje przyjte
   int inputDeposit;
   //! \~polish Kaucje wydane
   int outputDeposit;
   //! \~polish Do zapaty
   long long toPay;
   //! \~polish Gotwka
   long long cash;
   //! \~polish Karta
   long long card;
   //! \~polish Czek
   long long cheque;
   //! \~polish Bon
   long long bon;
   //! \~polish Inna forma patnoci
   long long otherPayment;
   //! \~polish Kredyt
   long long credit;
   //! \~polish Konto klienta
   long long clientAccount;
   //! \~polish Waluta obca
   long long currency;
   //! \~polish Przelew
   long long transfer;
   //! \~polish Gotwla EURO
   long long euroCash;
   //! \~polish Nazwa patnoci kart
   char cardName[128];
   //! \~polish Nazwa patnoci czek
   char chequeName[128];
   //! \~polish Nazwa patnoci bon
   char bonName[128];
   //! \~polish Nazwa patnoci inna
   char otherName[128];
   //! \~polish Nazwa patnoci kredyt
   char creditName[128];
   //! \~polish Nazwa patnoci konto klienta
   char clientAccountName[128];
   //! \~polish Nazwa patnoci konto klienta
   char transferName[128];
   //! \~polish Kurs EURO
   char euroExchangeRate[128];
   //! \~polish Reszta z
   long long rest;
   //! \~polish Reszta Euro
   long long euroRest;
}LastRcpSummary;


typedef struct _LastRcpItem
{
   //! \~polish Numer pozycji
   int index;
   //! \~polish Nazwa
   char name[256];
   //! \~polish Kod towaru
   char code[256];
   //! \~polish Ilo
   char quantity[128];
   //! \~polish PTU
   char ptu[2];
   //! \~polish Cena
   long long price;
   //! \~polish Brutto
   long long gross;
   //! \~polish Rodzaj rabatu
   int discountType;
   //! \~polish Opis rabatu
   char discountDescription[256];
   //! \~polish Rabat
   long long discount;
   //! \~polish Nazwa rabatu
   int discountName[256];
   //! \~polish Sumaryczny rabat procentowy
   long long percentTotalDiscount;
   //! \~polish Warto sumarycznych rabatw
   long long walueTotalDiscount;
} LastRcpItem;

typedef struct _LastRcpDepositItem
{
   //! \~polish Numer pozycji
   int index;
   //! \~polish Kod opakowania zwrotnego
   char code[256];
   //! \~polish Ilo
   char quantity[128];
   //! \~polish Cena
   long long price;
   //! \~polish Brutto
   long long gross;
} LastRcpDepositItem;

typedef struct _LastRcpPaymentItem
{
   //! \~polish Numer pozycji
   int index;
   //! \~polish Kod formy patnoci
   //! \~polish 0 - Gotwka
   //! \~polish 1 - Karta
   //! \~polish 2 - Czek
   //! \~polish 3 - Bon
   //! \~polish 4 - Inna
   //! \~polish 5 - Kredyt
   //! \~polish 6 - Konto klienta
   //! \~polish 7 - Przelew
   //! \~polish 8 - Gotwka EURO
   //! \~polish 9 - Mobilna
   //! \~polish 10 - Voucher
   int code;
   //! \~polish Warto
   long long value;
   //! \~polish Nazwa
   char name [256];
} LastRcpPaymentItem;



typedef struct _LastRcpSummaryEx
{
   //! \~polish Stan paragonu
   //! \~ 0  pusty
   //! \~ 1  otwarty
   //! \~ 2  zamknity
   //! \~ 3  anulowany
   int rcpState;
   //! \~polish Typ paragonu
   //! \~ 0  nornalny
   //! \~ 1  rozliczenie opakowa zwrotnych
   int rcpType;
   //! \~polish Numer paragonu
   int rcpNumber;
   //! \~polish Data i czas paragonu format: rrrr-mm-dd hh:mm:ss
   char rcpDate[32];
   //! \~polish Numer wydruku
   int prnNumber;
   //! \~polish Numer systemowy
   char systemNumber[1024];
   //! \~polish Numer kasy
   char cashNumber[128];
   //! \~polish Nazwa kasjera
   char cashier[128];
   //! \~polish Ilo pozycji
   int itemsCount;
   //! \~polish Ilo kaucji
   int itemsDepositCount;
   //! \~polish Ilo patnoci
   int itemsPaymentCount;
   //! \~polish Razem
   long long Total;
   //! \~polish Typ rabatu
   //! \~polish 0 - brak
   //! \~polish 1 - rabat procentowy
   //! \~polish 2 - dopata procentowa
   //! \~polish 3 - rabat kwotowy
   //! \~polish 4 - dopata kwotowa
   int discountType;
   //! \~polish Rabat
   long long discount;
   //! \~polish Nazwa rabatu
   int discountName;
   //! \~polish Razem po rabacie
   long long discountTotal;
   //! \~polish Metoda rozliczenia rabatu
   int discountMethod;
   //! \~polish Kaucje przyjte
   int inputDeposit;
   //! \~polish Kaucje wydane
   int outputDeposit;
   //! \~polish Do zapaty
   long long toPay;
   //! \~polish Gotwka
   long long cash;
   //! \~polish Karta
   long long card;
   //! \~polish Czek
   long long cheque;
   //! \~polish Bon
   long long bon;
   //! \~polish Inna forma patnoci
   long long otherPayment;
   //! \~polish Kredyt
   long long credit;
   //! \~polish Konto klienta
   long long clientAccount;
   //! \~polish Waluta obca
   long long currency;
   //! \~polish Przelew
   long long transfer;
   //! \~polish Gotwla EURO
   long long euroCash;
   //! \~polish Mobilna
   long long mobile;
   //! \~polish Voucher
   long long voucher;
   //! \~polish Nazwa patnoci kart
   char cardName[128];
   //! \~polish Nazwa patnoci czek
   char chequeName[128];
   //! \~polish Nazwa patnoci bon
   char bonName[128];
   //! \~polish Nazwa patnoci inna
   char otherName[128];
   //! \~polish Nazwa patnoci kredyt
   char creditName[128];
   //! \~polish Nazwa patnoci konto klienta
   char clientAccountName[128];
   //! \~polish Nazwa patnoci konto klienta
   char transferName[128];
   //! \~polish Nazwa patnoci mobilnej
   long long mobileName;
   //! \~polish Nazwa patnoci voucher
   long long voucherName;
   //! \~polish Kurs EURO
   char euroExchangeRate[128];
   //! \~polish Reszta z
   long long rest;
   //! \~polish Reszta Euro
   long long euroRest;
}LastRcpSummaryEx;


typedef struct _LastRcpItemEx
{
   //! \~polish Numer pozycji
   int index;
   //! \~polish Nazwa
   char name[256];
   //! \~polish Kod towaru
   char code[256];
   //! \~polish Ilo
   char quantity[128];
   //! \~polish PTU
   char ptu[2];
   //! \~polish Cena
   long long price;
   //! \~polish Brutto
   long long gross;
   //! \~polish Rodzaj rabatu
   int discountType;
   //! \~polish Opis rabatu
   char discountDescription[256];
   //! \~polish Rabat
   long long discount;
   //! \~polish Nazwa rabatu
   int discountName[256];
   //! \~polish Sumaryczny rabat procentowy
   long long percentTotalDiscount;
   //! \~polish Warto sumarycznych rabatw
   long long walueTotalDiscount;
   //! \~polish Typ pozycji
   //! \~polish 0 - pozycja paragonu
   //! \~polish 1 - podsuma
   long long positionType;

} LastRcpItemEx;


typedef struct _LastRcpSummaryEx2
{
   //! \~polish Stan paragonu
   //! \~ 0  pusty
   //! \~ 1  otwarty
   //! \~ 2  zamknity
   //! \~ 3  anulowany
   int rcpState;
   //! \~polish Typ paragonu
   //! \~ 0  nornalny
   //! \~ 1  rozliczenie opakowa zwrotnych
   int rcpType;
   //! \~polish Numer paragonu
   int rcpNumber;
   //! \~polish Data i czas paragonu format: rrrr-mm-dd hh:mm:ss
   char rcpDate[32];
   //! \~polish Numer wydruku
   int prnNumber;
   //! \~polish Numer systemowy
   char systemNumber[1024];
   //! \~polish Numer kasy
   char cashNumber[128];
   //! \~polish Nazwa kasjera
   char cashier[128];
   //! \~polish Ilo pozycji
   int itemsCount;
   //! \~polish Ilo kaucji
   int itemsDepositCount;
   //! \~polish Ilo patnoci
   int itemsPaymentCount;
   //! \~polish Razem
   long long Total;
   //! \~polish Typ rabatu
   //! \~polish 0 - brak
   //! \~polish 1 - rabat procentowy
   //! \~polish 2 - dopata procentowa
   //! \~polish 3 - rabat kwotowy
   //! \~polish 4 - dopata kwotowa
   int discountType;
   //! \~polish Rabat
   long long discount;
   //! \~polish Nazwa rabatu
   int discountName;
   //! \~polish Razem po rabacie
   long long discountTotal;
   //! \~polish Metoda rozliczenia rabatu
   int discountMethod;
   //! \~polish Kaucje przyjte
   int inputDeposit;
   //! \~polish Kaucje wydane
   int outputDeposit;
   //! \~polish Do zapaty
   long long toPay;
   //! \~polish Gotwka
   long long cash;
   //! \~polish Karta
   long long card;
   //! \~polish Czek
   long long cheque;
   //! \~polish Bon
   long long bon;
   //! \~polish Inna forma patnoci
   long long otherPayment;
   //! \~polish Kredyt
   long long credit;
   //! \~polish Konto klienta
   long long clientAccount;
   //! \~polish Waluta obca
   long long currency;
   //! \~polish Przelew
   long long transfer;
   //! \~polish Gotwla EURO
   long long euroCash;
   //! \~polish Mobilna
   long long mobile;
   //! \~polish Voucher
   long long voucher;
   //! \~polish Nazwa patnoci kart
   char cardName[128];
   //! \~polish Nazwa patnoci czek
   char chequeName[128];
   //! \~polish Nazwa patnoci bon
   char bonName[128];
   //! \~polish Nazwa patnoci inna
   char otherName[128];
   //! \~polish Nazwa patnoci kredyt
   char creditName[128];
   //! \~polish Nazwa patnoci konto klienta
   char clientAccountName[128];
   //! \~polish Nazwa patnoci konto klienta
   char transferName[128];
   //! \~polish Nazwa patnoci mobilnej
   long long mobileName;
   //! \~polish Nazwa patnoci voucher
   long long voucherName;
   //! \~polish Kurs EURO
   char euroExchangeRate[128];
   //! \~polish Reszta z
   long long rest;
   //! \~polish Reszta Euro
   long long euroRest;
   //! \~polish NIP Nabywcy
   long long acquirerNIP;
}LastRcpSummaryEx2;

typedef struct _LastEFTTransaction
{
   //! \~polish Nabywca
   char acquirer [255];
   //! \~polish Token karty patniczej
   char cardToken[255];
   //! \~polish ID Eparagonu
   char ereceiptID[255];
   //! \~polish Indeks
   int index;
   //! \~polish ID Terminala
   char TID[255];
   //! \~polish ID Transakcji
   char TransactionID[255];
}LastEFTTransaction;

typedef struct _LastCashback
{
   //! \~polish Kwota cshback
   char cashback[255];
}LastCashback;