#pragma once

#if defined(__GNUC__)
	#define DLL __attribute__((visibility("default")))
#else
	#ifdef LIB_EXPORTS
	#define DLL __declspec(dllexport)
	#else
	#define DLL  
				/*__declspec(dllimport)*/
	#endif

#endif

#include "FDTypes.h"

/**
 * \~polish @defgroup Urzdzenia Urzdzenia obsugiwane przez sterownik
 * \~english @defgroup Devices Supported devices
 * @{
 */

 /** \~polish Typ urzadzenia: drukarki online */
 /// \~polish Przekazywany jako parametr w funkcji ndrv_init(). Ustawia typ urzdzenia dla drukarek Online.

#define DEV_TYPE_PRN_ONLINE     1
 /**  \~polish Typ urzadzenia: drukarka HD online */
 ///  \~polish Przekazywany jako parametr w funkcji ndrv_init(). Ustawia typ urzdzenia dla drukarki HD Online.

#define DEV_TYPE_HD_ONLINE      2

 /** 
  * @} 
  */

/**
 * @defgroup Flagi Flagi obsugiwane przez sterownik
 *
 * @{
 */
///Sprawdza status drukarki(DLE oraz ENQ).
#define NFLAGS_CHECK_STATUS        0x0001
///Sprawdza czy ostatnie polecenie zostao wykonane poprawnie. Jeeli ostatnie polecenie nie jest poprawne pobierany jest numer ostatniego bdu.
#define NFLAGS_CHECK_LAST_ERROR    0x0002
///Sprawdza status drukarki i porwnuje stan gotwki przed transakcja i po transakcji.
#define NFLAGS_CASH_CONTROL        0x0004
///Dodaje znak koca pakietu w przypadku komendy NDRV_SEND_PACKET
#define NFLAGS_APPEND_FF		   0x0008
 /** @} */

/**
 * @defgroup Zadania Lista komend obsugiwanych przez sterownik
 *
 * @{
 */
///Odczytuje wersje sterownika.
#define NDRV_DRV_VERSION        1
///Przekazywany jako parametr w funkcji ndrv_ioctrl() wysya do urzdzenia zapytanie o status DLE.
#define NDRV_SEND_DLE_REQ       2
///Odczytuje z urzdzenia status DLE. Naley wysa struktur DLEStatus.
#define NDRV_READ_DLE           3
///Wysya do urzdzenia zapytanie o status ENQ. 
#define NDRV_SEND_ENQ_REQ       4
///Odczytuje z urzdzenia status ENQ. Naley wysa struktur ENQStatus.
#define NDRV_READ_ENQ           5
///Wysya do urzdzenia zapytanie o wersje.
#define NDRV_PRN_VERSION        6
///Odczytuje z urzdzenia informacje o wersji. Naley wysa struktur VersionInfo.
#define NDRV_READ_PRN_VERSION   7
///Wysya do urzdzenia zapytanie o status dla paragonw od ostatniego raportu dobowego.
#define NDRV_STATUS             8
///Odczytuje z urzdzenia informacje o statusie dla paragonw od ostatniego raportu dobowego. Naley wysa struktur ReadSTATUS.
#define NDRV_READ_STATUS        9
///Wysya do urzdzenia zapytanie o kod bdu ostatniego rozkazu.
#define NDRV_LAST_ERROR         10
///Odczytuje z urzdzenia kod bdu ostatniego rozkazu. Naley wysa struktur ReadError.
#define NDRV_READ_LAST_ERROR    11
///Wysya do urzdzenia zapytanie o czas.
#define NDRV_DEVICE_TIME        12
///Odczytuje z urzdzenia jego czas. Naley wysa struktur DeviceTIME.
#define NDRV_READ_DEVICE_TIME   13
///Wysya do urzdzenia zapytanie o informacje o porcie komunikacyjnym. 
#define NDRV_COMMUNICATION_PORT 14
///Odczytuje z urzdzenia informacje o porcie komunikacyjnym. Naley wysa struktur CommunicationPort.
#define NDRV_READ_COMMUNICATION_PORT   15
///Wysya zapytanie o informacje na temat pamici chronionej.
#define NDRV_PM_INFO                   16
///Odczytuje z urzdzenia informacje na temat pamici chronionej. Naley wysa struktur PM.
#define NDRV_READ_PM_INFO              17
///Wysya do urzdzenia zapytanie o informacje o logach procesw. Naley wysa struktur LogInfo.
#define NDRV_PROCESS_LOG_INFO          18
///Odczytuje z urzdzenia informacje o logach procesw. Naley wysa struktur LogInfo.
#define NDRV_READ_PROCESS_LOG_INFO     19
///Wysya do urzdzenia zapytanie o informacje na temat wysyek z repozytorium. 
#define NDRV_REPOSITORY_INFO           20
///Odczytuje z urzdzenia informacje na temat wysyek z repozytorium. Naley wysa struktur RepositoryINFO.
#define NDRV_READ_REPOSITORY_INFO      21
///Wysya do urzdzenia pakiet programujcy dat i godzin. Naley wysa struktur DateTIME.
#define NDRV_SET_DATE                  22
///Wysya do urzdzenia pakiet programujcy stawki PTU. Naley wysa struktur PTU.
#define NDRV_SET_PTU                   23
///Wysya do urzdzenia pakiet programujcy automatyczna zmiane stawek PTU. Naley wysa struktur PTU.
#define NDRV_AUTO_SET_PTU              24
///Wysya do urzdzenia pakiet ustawiajacy tryb odsyania totalizerw. Naley wysa struktur TotalizersMode.
#define NDRV_SET_TOTALIZERS_MODE       25
///Wysya do urzdzenia zapytanie o status ostatniej transakcji lub status dla faktur od ostatniego raportu dobowego w zalenoci od ustawionego trybu odsyania totalizerw.
#define NDRV_CURRENT_TRANSACTION_STATUS        26
///Odczytuje z urzadzenia status ostatniej transakcji lub status dla faktur od ostatniego raportu dobowego w zalenoci od ustawionego trybu odsyania totalizerw. Naley wysa struktur ReadSTATUS.
#define NDRV_READ_CURRENT_TRANSACTION_STATUS   27
///Wysya do urzdzenia dowolny pakiet. Naley wysa struktur Packet.
#define NDRV_SEND_PACKET   28
///Odczytuje z urzdzenia ostatni odesany pakiet. Naley wysa struktur Packet.
#define NDRV_READ_PACKET   29
///Wysya do urzdzenia zapytanie o status DLE2.
#define NDRV_SEND_DLE2	   30
///Odczytuje z urzdzenia status DLE2. Naley wysa strukture DLE2Status
#define NDRV_READ_DLE2	   31
///Sprawdza statusy ENQ DLE
#define NDRV_CHECK_STATUS 32
///Wysya rozkaz kasowania grafiki
#define NDRV_SEND_IMG_CLEAR 33
///Wysya rozkaz programowania grafiki
#define NDRV_SEND_IMG 34
///Wysya zapytanie o CRC grafiki
#define NDRV_SEND_IMG_CRC 35
///Odczytuje CRC grafiki
#define NDRV_READ_IMG_CRC 36
///Liczy CRC grafiki
#define NDRV_CALC_IMG_CRC 37
///Programuje parametr drukarki
#define NDRV_SEND_CONFIG_PARAM 38
///Programuje aniacj
#define NDRV_SEND_ANIMATION 39
///Usuwa animacj
#define NDRV_FUNCTION_ANIMATION 40
///Wysya nip nabywcy
#define NDRV_RCP_BUYER_ID 41
///Informacje o urzadzeniu
#define NDRV_DEVICE_INFO 42
///Odczyt informacji o urzdzeniu Wersja 4
#define NDRV_READ_DEVICE_INFO_VERSION4 43
///Ustawia zdarzenie pocztkowe i kocowe wedug daty
#define NDRV_SET_START_AND_END_FM_EVENT_DATE 44
///Ustawia zdarzenie pocztkowe i kocowe wedug numerw
#define NDRV_SET_START_AND_END_FM_EVENT_NUMBER 45
///Zapytanie o biece zdarzenie
#define NDRV_SEND_FM_EVENT_REQUEST 46
///Odczyt biecego zdarzenia
#define NDRV_READ_FM_EVENT 47
///Zapytanie o dane dokumentu  JPK
#define NDRV_SEND_JPK_DOC_REQUEST 48
///Odczyt danych dokumentu  JPK
#define NDRV_READ_JPK_DOC 49
///Wysanie ustawie eparagonu
#define NDRV_SEND_ERECEIPT_CFG 50
///Zapytanie o dane EParagonu
#define NDRV_SEND_ERECEIPT_CFG_REQUEST 51
///Odczyt danych EParagonu
#define NDRV_READ_ERECEIPT 52
///Odczyt informacji oglnych  o urzdzeniu
#define NDRV_READ_GENERAL_DEVICE_INFO 53
///Odczyt informacji szczegowych dla pamici fiskalnej
#define NDRV_READ_DETAILED_FOR_FM_INFO 54
///Odczyt informacji szczegowych dotyczcych stanu zasilania, akumulatora i baterii
#define NDRV_READ_DETAILED_ABOUT_POWER 55
///Odczyt informacji o stanie wydruku
#define NDRV_READ_PRINTOUT_STATUS_INFO 56
///Odczyt informacji o stanie szuflady
#define NDRV_READ_DRAWER_STATE 57
///Odczyt informacji o stanie pamici podrcznej
#define NDRV_READ_CACHE_INFO 58
///Odczyt informacji o stanie bazy towarw
#define NDRV_READ_STATE_OF_GOODS_BASE 59
///Odczyt informacji szczegowych o pamici fiskalnej versja 2.
#define NDRV_READ_DEVICE_INFO_VERSION2 60
///Odczyt informacji szczegowych o pamici fiskalnej versja 3.
#define NDRV_READ_DEVICE_INFO_VERSION3 61
///Odczyt informacji o stanie akumulatora i zasilania
#define NDRV_READ_POWER_SUPPLY_INFO 62
///Wysanie ustawie eparagonu
#define NDRV_SEND_EXTENDED_ERECEIPT_CFG 63
///Odczyt informacji o parametrach fiskalizacji
#define NDRV_READ_FISCALIZATION_INFO 64
///Odczyt zapytanie o informacje o serwerze
#define NDRV_ASK_SERVER_INFO 65
///Odczyt informacji o serwerze
#define NDRV_READ_SERVER_INFO 66
///Programowanie/kasowanie konfiguracji usb
#define NDRV_SEND_USB_CONFIG 67
///Odczyt konfiguracji usb
#define NDRV_ASK_USB_CONFIG 68
///Odczyt konfiguracji usb
#define NDRV_READ_USB_CONFIG 69
///Programowanie zmiany waluty
#define NDRV_CHANGE_CURRENCY 70
///danie odesania statusu ostatniego e-paragonu
#define NDRV_ASK_LAST_ERECEIPT_STATUS 71
///Odczyt statusu ostatniego e-paragonu
#define NDRV_READ_LAST_ERECEIPT_STATUS 72
///Zapytanie o moliwo sprzeday
#define NDRV_ASK_SALE_POSSIBILITY 73
///Odczyt moliwosci sprzeday
#define NDRV_READ_SALE_POSSIBILITY 74
///Wejcie do menu
#define NDRV_DISPLAY_MENU 75
///Wydruk przeliczenia do waluty
#define NDRV_PRINT_RECOUNT_MODE 76
///Wydruk Zapytanie o date blokady serwisowej 
#define NDRV_ASK_SERVICE_LOCK 77
///Wydruk Odczyt daty blokady serwiswej 
#define NDRV_READ_SERVICE_LOCK 78
///Kontrola bazy danych
#define NDRV_DATABASE_CONTROL 79
///wysunicie papieru
#define NDRV_PAPER_EJECTION 80
///ustawienie adresu serwera
#define NDRV_SET_SERVER_ADDRESS 81
///programowanie certyfikatu eDokumentw
#define NDRV_EDOCUMENT_CERT_PROGRAM 82
///ustawienia HUBa ministerstwa dla eDokumentw
#define NDRV_EDOCUMENT_MF_HUB_SETTINGS 83
///zapytanie o ustawienia HUBa ministerstwa dla eDokumentw
#define NDRV_EDOCUMENT_REQUEST_MF_HUB_SETTINGS 84
///odczyt ustawie HUBa ministerstwa dla eDokumentw
#define NDRV_EDOCUMENT_READ_MF_HUB_SETTINGS 85
///zapytanie o dane eDokumentw
#define NDRV_REQUEST_EDOCUMENT_DATA 86
///odczyt danych eDokumentw
#define NDRV_READ_EDOCUMENT_DATA 87
///danie odesania informacji z bazy eDokumentw
#define NDRV_REQUEST_EDOCUMENT_BASE_INFO 88
///odczyt informacji z bazy eDokumentw
#define NDRV_READ_EDOCUMENT_BASE_INFO 89
///odczyt informacji z bazy eDokumentw
#define NDRV_REMOVE_EDOCUMENT_FROM_BASE 90
///programowanie parametrw wizualizaci eDokumentu 
#define NDRV_SET_EDOCUMENT_VISUALIZATION_PARAMS 91
///zapytanie o parametry wizualizaci eDokumentu 
#define NDRV_REQUEST_EDOCUMENT_VISUALIZATION_PARAMS 92
///odczyt parametrw wizualizaci eDokumentu 
#define NDRV_READ_EDOCUMENT_VISUALIZATION_PARAMS 93
///zapytanie o informacji kasowych typ
#define NDRV_REQUEST_CASH_INFO 94
///odczyt informacji kasowych typ 50
#define NDRV_READ_CASH_INFO50 95


///Wysya do urzdzenia pakiet drukujcy raport dobowy. Naley wysa struktur DailyReport.
#define NDRV_RUN_DAILY_REPORT			     100
///Wysya do urzdzenia pakiet drukujcy raport zmiany bez form patnoci. Naley wysa struktur ChangeReport.
#define NDRV_CHANGE_REPORTWITHOUT_PAYMENTS	 101
///Wysya do urzdzenia pakiet drukujcy raport zmiany z formami patnoci. Naley wysa struktur ChangeReport.
#define NDRV_CHANGE_REPORTWITH_PAYMENTS      102
///Wysya do urzdzenia pakiet drukujcy raport okresowy wedug dat. Naley wysa struktur PeriodicReport.
#define NDRV_PERIODIC_REPORT_BY_DATE	     103
///Wysya do urzdzenia pakiet drukujcy raport okresowy wedug numerw. Naley wysa struktur PeriodicReport.
#define NDRV_PERIODIC_REPORT_BY_NR		     104
///Wysya do urzdzenia pakiet drukujcy raport zapisw pamici fiskalnej wedug dat. Naley wysa struktur FiscalMemory.
#define NDRV_REPORT_OF_ENTRIES_IN_FM_BY_DATE 105
///Wysya do urzdzenia pakiet drukujcy raport zapisw pamici fiskalnej wedug numerw. Naley wysa struktur FiscalMemory.
#define NDRV_REPORT_OF_ENTRIES_IN_FM_BY_NR	 106
///Wysya do urzdzenia pakiet drukujcy raport z przegldw serwisowych.
#define NDRV_SERVICE_REVIEW_REPORT			 107
///Wysya do urzdzenia pakiet drukujcy stan kasy. Naley wysa struktur CashState.
#define NDRV_CASH_STATE						 108
///Wysya do urzdzenia pakiet drukujcy wydruk z pamici chronionej. Naley wysa struktur PrintoutFromPM.
#define NDRV_PRINTOUT_FROM_PM				 109
///Wysya do urzdzenia pakiet drukujcy dane dokumentu - JPK. Naley wysa struktur JPK.
#define NDRV_PRINTOUT_DATA_JPK				 110
///Wysya do urzdzenia pakiet drukujcy raport zmiany z formami patnoci(2). Naley wysa struktur ChangeReport2.
#define NDRV_CHANGE_REPORTWITH_PAYMENTS2     111
///Wpata do kasy. Naley wysa struktur CashInOut.
#define NDRV_CASHIN							 112
///Wypata do kasy. Naley wysa struktur CashInOut.
#define NDRV_CASHOUT						 113

///Wysya do urzdzenia pakiet rozpoczcia paragonu online. Naley wysa struktur StartReceipt.
#define NDRV_RCP_START        200
///Wysya do urzdzenia pakiet dodania pozycji paragonu. Naley wysa struktur Item.
#define NDRV_RCP_ITEM		  201
///Wysya do urzdzenia pakiet zakoczenia paragonu. Naley wysa struktur EndReceipt.
#define NDRV_RCP_END          202
///Wysya do urzdzenia pakiet anulowania transakcji. Naley wysa struktur AbortTransaction.
#define NDRV_ABORT        203
///Wysya do urzdzenia pakiet obniki do paragonu. Naley wysa struktur DiscountOrMarkupToTransaction.
#define NDRV_RCP_DISCOUNT     204
///Wysya do urzdzenia pakiet obniki w danej stawce PTU. Naley wysa struktur DiscountOrMarkupToPTU.
#define NDRV_RCP_DISCOUNTPTU  205
///Wysya do urzdzenia pakiet obniki do podsumy. Naley wysa struktur DiscountOrMarkupToSubtotal.
#define NDRV_RCP_DISCOUNTSUB  206
///Wysya do urzdzenia pakiet kaucji pobranej(za sprzeda opakowania). Naley wysa struktur BailIn.
#define NDRV_RCP_BAILIN		  207
///Wysya do urzdzenia pakiet storno kaucji pobranej. Naley wysa struktur BailInStorno.
#define NDRV_RCP_BAILINST     208
///Wysya do urzdzenia pakiet kaucji wydanej(za zwrot opakowania). Naley wysa struktur BailOut.
#define NDRV_RCP_BAILOUT      209
///Wysya do urzdzenia pakiet storno kaucji wydanej. Naley wysa struktur BailOutStorno.
#define NDRV_RCP_BAILOUTST	  210
///Wysya do urzdzenia pakiet zakoczenia paragonu z formami patnoci 1. Naley wysa struktur EndReceiptWithPaymentMethods1.
#define NDRV_RCP_END1         211
///Wysya do urzdzenia pakiet dodania formy patnoci. Naley wysa struktur Payment.
#define NDRV_RCP_PAYMENT      212
///Wysya do urzdzenia pakiet zakoczenia paragonu z formami patnoci 2. Naley wysa struktur EndReceiptWithPaymentMethods2.
#define NDRV_RCP_END2         213
///Wysya do urzdzenia peny pakiet paragonu(rozpoczcie, pozycje, zakoczenie). Naley wysa struktur ReceiptComplete.
#define NDRV_RCP_COMPLETE	  214
///Sprawdza status kasy.
#define NDRV_COMPLETE_CHECK 215
///Wysya do urzdzenia pakiet zaliczki. Naley wysa struktur Prepayment.
#define NDRV_PREPAYMENT		216
///Wysya do urzdzenia pakiet obsugi kaucji w linii paragonu. Naley wysa struktur BailInReceiptLine.
#define NDRV_RCP_BAIL		217
///Wysya do urzdzenia pakiet opisu eparagonu
#define NDRV_ERECEIPT    	218
///Wysya do urzdzenia pakiet rozpoczcia paragonu online. Naley wysa struktur StartReceipt.
#define NDRV_RCP_ONLINE_START        200
///Wysya do urzdzenia pakiet rozpoczcia paragonu offline. Naley wysa struktur StartReceipt.
#define NDRV_RCP_OFFLINE_START        219

///Wysya do urzdzenia pakiet rozpoczcia faktury offline. Naley wysa struktur StartInvoice.
#define NDRV_INV_START        300
///Wysya do urzdzenia pakiet dodania pozycji do faktury. Naley wysa struktur Item.
#define NDRV_INV_ITEM         301
///Wysya do urzdzenia pakiet zakoczenia faktury. Sprawdza totalizery przed i po zakoczeniu transakcji. Naley wysa struktur EndInvoice.
#define NDRV_INV_END          302
///Wysya do urzdzenia pakiet z opcjami faktury. Naley wysa struktur InvoiceOptions.
#define NDRV_INV_OPTIONS	  303
///Wysya do urzdzenia peny pakiet faktury(rozpoczcie, pozycje, zakoczenie). Naley wysa struktur InvoiceComplete.
#define NDRV_INV_COMPLETE	  304
///Wysya do urzdzenia pakiet zakoczenia faktury, gdzy zostay zdefiniowane opcje faktury. Naley wysa struktur EndReceipt.
#define NDRV_INV_ENDWO 306
///Wysya do urzdzenia pakiet zakoczenia faktury, gdzy zostay zdefiniowane opcje faktury. Naley wysa struktur EndReceiptWithPaymentMethods1.
#define NDRV_INV_ENDWO_PAYMENT_METHOD 307
///Wysya do urzdzenia pakiet rozpoczcia faktury online. Naley wysa struktur StartInvoice.
#define NDRV_INV_ONLINE_START 308
///Wysya do urzdzenia pakiet rozpoczcia faktury offline. Naley wysa struktur StartInvoice.
#define NDRV_INV_OFFLINE_START        300

///Wysya do urzdzenia pakiet otwierajcy szuflad.
#define NDRV_OPEN_DRAVER           400
///Wysya do urzdzenia pakiet sterujcy wywietlaczem. Naley wysa struktur DisplayCONTROL.
#define NDRV_DISPLAY_STRING        401
///Wysya do urzdzenia pakiet ustawiajcy tryb obsugi bdw. Naley wysa struktur ErrorsControl.
#define NDRV_ERRORS_CONTROL        402
///Odczytuje automatyczn odpowied na pakiet ustawiajcy tryb obsugi bdw( tylko dla trybw 2 i 3). Naley wysa struktur ErrorsControl.
#define NDRV_READ_ERRORS_CONTROL   403
///Wysya do urzdzenia pakiet sterujcy wywietlaczem w trybie poza paragonem. Naley wysa struktur DisplayCONTROL.
#define NDRV_DISPLAY_STRING2       404

///Wysya do urzdzenia pakiet zalogowania kasjera. Naley wysa struktur Cashier.
#define NDRV_CASHIER_LOGIN	  500
///Wysya do urzdzenia pakiet wylogowania kasjera. Naley wysa struktur Cashier.
#define NDRV_CASHIER_LOGOFF	  501
///Wysya do urzdzenia zapytanie o status kasjera.
#define NDRV_CASHIER_STATE	  502
///Odczytuje odpowied na pakiet zapytania o status kasjera
#define NDRV_READ_CASHIER_STATE	  503

///Wysya do urzdzenia pakiet rozpoczcia wydruku niefiskalnego. Naley wysa struktur NonFiscalPrintout.
#define NDRV_NONFISCAL_PRINTOUT_OPEN		600
///Wysya do urzdzenia pakiet dodania linii niefiskalnej. Naley wysa struktur NonFiscalPrintout.
#define NDRV_NONFISCAL_PRINTOUT_LINE		601
///Wysya do urzdzenia pakiet zakoczenia wydruku niefiskalnego. Naley wysa struktur NonFiscalPrintout.
#define NDRV_NONFISCAL_PRINTOUT_CLOSE		602

///Wysya do urzdzenia pakiet zakoczenia wydruku. Naley wysa struktur PrintEnd.
#define NDRV_PRINT_END		700

#define NDRV_WINDOWS_1250 800
#define NDRV_UTF_8 801

 /** @} */

//bedy sterownika

/*#define ERR_OPEN_PORT			1
#define ERR_CRC_READ_PACKET		2
*/

#define NDRV_OK 0
#define NDRV_ERROR -1


#ifdef __cplusplus
extern "C" {
#endif

//DLL void test();

//!Funkcja przyjmuje jeden argument i zwraca warto integer.
/*!
\brief Wybiera model drukarki.
\param devType suy do ustawienia typu urzdzenia - przyjmuje wartoci DEV_TYPE_PRN_ONLINE lub DEV_TYPE_HD_ONLINE
\return Warto 1

*/
DLL int ndrv_init(int devType);

//!Funkcja nie przyjmuje argumentw i zwraca warto integer.
/*!
\brief Wcza logi.
\return Warto 1 jeli logi zostay wczone, 0 jeli logi nie zostay wczone.
*/
DLL int ndrv_enable_log(const char* dir);

//!Funkcja nie przyjmuje argumentw i zwraca warto integer.
/*!
\brief Wycza logi.
\return Warto 1 jeli logi zostay wyczone, 0 jeli logi nie zostay wyczone.
*/
DLL int ndrv_disable_log();

//!Funkcja wpisuje informacj do logu komunikacyjnego. Log komunikacyjny wczeniej trzeba wczy.
/*!
\brief Dodaje wiadomo do logu komunikacji 
\param msg jest wiadomoci, jak chcemy zapisa do logw.
\param len jest to dugo przesyanej wiadomoci.
\return Warto 1 jeli wiadomo dodano, 0 jeli logowanie nie jest aktywne.
*/
DLL int ndrv_log_msg(const char *msg, int len);

//!Funkcja nie przyjmuje argumentw i zwraca warto integer.
/*!
\brief 
\return Warto 0.
*/
DLL int ndrv_auto_test();

//!Funkcja przyjmuje jeden argument i zwraca warto integer.
/*!
\brief Sprawdza wersj sterownika.
\param version jest wskanikiem do struktury DrvVersion.
\return Wersja sterownika.
*/
DLL int ndrv_drv_version(DrvVersion *version);

//!Funkcja przyjmuje jeden argument i zwraca warto integer.
/*!
\brief Sprawdza wersj drukarki.
\param version jest wskanikiem do struktury PrnVersion.
\return Wersja drukarki.
*/
DLL int ndrv_prn_version(PrnVersion *version);

//!Funkcja przyjmuje trzy argumenty i zwraca warto integer.
/*!
\brief Otwiera serial port. Timeot na odczyt jest domylnie ustawiony na 5s.
\param name jest to nazwa portu komunikacyjnego np."COM1".
\param baudrate jest to prdko.
\param thread jest to flaga oznaczajca czy wysyanie i odczytywanie ma si odbywa na osobnych wtkach.
\return Rezultat otwarcia serial portu. 0 - gdy nie otwarto portu, 1 - gdy otwarto port.
*/
DLL int ndrv_open_serial(char*name, int baudrate,int thread);

//!Funkcja przyjmuje jeden argument i zwraca warto integer.
/*!
\brief Otwiera serial port.
\param params jest argumentem typu strukturalnego SerialPortParameters.
\return Rezultat otwarcia serial portu. 0 - gdy nie otwarto portu, 1 - gdy otwarto port.
*/
DLL int ndrv_open_serial_ex(SerialPortParameters *params);

//!Funkcja przyjmuje dwa argumenty i zwraca warto integer.
/*!
\brief Otwiera port TCP/IP.
\param host jest adresem IP urzdzenia.
\param port jest numerem portu TCP.
\result Rezultat otwarcia portu TCP/IP.  0 - gdy nie otwarto portu, 1 - gdy otwarto port.
*/
DLL int ndrv_open_tcpip(char* host, int port);

//!Funkcja przyjmuje jeden i zwraca warto integer.
/*!
\brief Otwiera port TCP/IP.
\param params jest argumentem typu strukturalnego TCPIPPortParameters.
\result Rezultat otwarcia portu TCP/IP. 0 - gdy nie otwarto portu, 1 - gdy otwarto port.
*/
DLL int ndrv_open_tcpip_ex(TCPIPPortParameters *params);

//!Funkcja nie przyjmuje argumentw i zwraca warto integer.
/*!
\brief Zamyka port komunikacyjny.
\return Rezultat zamknicia portu komunikacyjnego. 0 - gdy nie otwarto portu, 1 - gdy otwarto port.
*/
DLL int ndrv_close();

//!Funkcja przyjmuje cztery argumenty i zwraca warto integer.
/*!
\brief Wysya pakiety na port komunikacyjny i odbiera dane z portu komunikacyjnego.
\param id jest to ID pakietu.
\param data jest wskanikiem na dane pakietu.
\param len jest to dugo danych.
\param flags jest to argument oznaczajcy flag do sprawdzania statusu lub kodu bdu.
\return dla flagi NFLAGS_CHECK_LAST_ERROR kod bdu z urzdzenia, <BR>dla flagi NFLAGS_CHECK_STATUS, -1 jesli wystpi problem ze statusem drukarki, 0 jeli nie wystpi problem ze statusem, <BR>dla flagi NFLAGS_CASH_CONTROL, -1 jesli wystpi problem ze statusem drukarki lub porwnaniem stanu gotwki przed i po transakcji, 0 jeli nie wystpi, <BR> jeli flaga zostaa pominita(ustawiona na 0) to -1 jeli pakiet nie zosta poprawnie wysane do drukarki, 0 jeli zosta wysany poprawnie.
*/
DLL int ndrv_ioctrl(int id, void *data, int len, int flags);

//!Funkcja przyjmuje jeden argument i zwraca warto integer.
/*!
\brief Pobiera informacj o ostatnim bdzie.
\param lastError jest wskanikiem na struktur LastError.
\return Kod bdu ostatniego rozkazu
*/
DLL int ndrv_get_last_error(LastError *lastError);


#ifdef __cplusplus
} //extern C
#endif


/**
@mainpage Dokumentacja sterownika
<H3>Podstawowe informacje: </H3>
Sterownik suy do komunikacji z drukarkami fiskalnymi NOVITUS w wersji online. Moe by wykorzystywany do realizacji zada na porcie: <BR>
- PC w penym zakresie moliwoci jakie daje sterownik<BR>
- PC2 z wyczeniem pakietw transakcji<BR>

<H3>API Sterownika: </H3>

- \ref ndrv_init(int devType); <BR>
- \ref ndrv_enable_log(const char* dir); <BR>
- \ref ndrv_disable_log(); <BR>
- \ref ndrv_log_msg(const char *data, int len); <BR>
- \ref ndrv_auto_test(); <BR>
- \ref ndrv_drv_version(DrvVersion *version); <BR>
- \ref ndrv_prn_version(PrnVersion *version); <BR>
- \ref ndrv_open_serial(char*name, int baudrate,int thread); <BR>
- \ref ndrv_open_serial_ex(SerialPortParameters *params); <BR>
- \ref ndrv_open_tcpip(char* host, int port); <BR>
- \ref ndrv_open_tcpip_ex(TCPIPPortParameters *params); <BR>
- \ref ndrv_close(); <BR>
- \ref ndrv_ioctrl(int id, void *data, int len, int flags); <BR>
- \ref ndrv_get_last_error(LastError *lastError); <BR>

Rozmiar 
 
Kwoty podawane/odczytywane w strukturach sterownika s wartociami w groszach np:
\code{.cpp}
{
      Item item;
      item.price = 200; // = 2PLN
      (...)
}
\endcode

Iloci podawane w strukturach s wartociami w gramach np:
\code{.cpp}
{
      Item item;
      item.quantity = 123400000;  // = 1.234kg
      strcpy(item.unit, "kg");
      (...)
}
\endcode

Lub ilo mona poda jako string:

\code{.cpp}
{
      Item item;
      strcpy(item.qtty, "1.234567");  // = 1.234567
      strcpy(item.unit, "kg");
      (...)
}
\endcode

Najprostszy przykad wykorzystujacy sterownik wyglda nastpujaco:
\code{.cpp}
{
      ndrv_init(DEV_TYPE_PRN_ONLINE);
      ndrv_enable_log("C:\\Log");

      if (ndrv_open_tcpip((char *)"192.168.1.1", 6001) == 0)
      {
         printf("Bd otwarcia portu komunikacyjnego!");
         exit(1);
      }

      DrvVersion version = {0};
      if(ndrv_drv_version(&version) == NDRV_OK)
      {
         printf(version.LibName); //drv name
         printf(version.FullVersion); //drv version
      }

      PrnVersion prnVer;
	  if(ndrv_prn_version(&prnVer) == NDRV_OK)
      {
         printf(version.DeviceName); //prn name
         printf(version.DeviceVersion); //prn version
      }

      ndrv_close();
}
\endcode

Najprostszy przykad realizujcy transakcj wyglda nastpujaco:
\code{.cpp}
{
      ndrv_init(DEV_TYPE_PRN_ONLINE);
      ndrv_enable_log("C:\\Log");
   
      if (ndrv_open_tcpip((char *)"192.168.1.1", 6001) == 0)
      {
         printf("Bd otwarcia portu komunikacyjnego!");
         exit(1);
      }
   
      StartReceipt startReceipt = {0};
   
      Item item = {0};
      item.numberOfLine = 1;
      strcpy(item.name, "Sok owocowy");
      strcpy(item.qtty,"1");
      strcpy(item.ptu, "A");
      item.price = 200;
      item.brutto = 200;
   
      EndReceiptWithPaymentMethods1 endReceipt1 = {0};
      endReceipt1.sum = 200;
      endReceipt1.fCash = 1;
      endReceipt1.cash = 200;
   
      if(ndrv_ioctrl(NDRV_RCP_START, &startReceipt, sizeof(StartReceipt), NFLAGS_CHECK_STATUS|NFLAGS_CASH_CONTROL) == NDRV_ERROR)
      {
         check_error(); //funkcja opisana poniej
         return -1; //bd otwarcia
      }
      ndrv_ioctrl(NDRV_RCP_ITEM, &item, sizeof(Item), 0);
      if (ndrv_ioctrl(NDRV_RCP_END, &endReceipt1, sizeof(EndReceiptWithPaymentMethods1), NFLAGS_CHECK_STATUS) == NDRV_ERROR)
      {
         //ERROR
         if(handle_error() == NDRV_ERROR) ; //funkcja opisana poniej
            return -1; //nie kontynuujemy
      }
      ndrv_close();
}
\endcode

Funkcja sprawdza poprawno rozpoczcia paragonu.

\code{.cpp}

int TestLib::check_error(void)
{
   LastError lastError = { 0 };

   //bd otwarcia paragonu - nie kontynuujemy, pobieramy stan drukarki
   printf("check_error\n");

   ndrv_ioctrl(NDRV_CHECK_STATUS, 0, 0, NFLAGS_CHECK_STATUS);
   ndrv_get_last_error(&lastError);

   if (lastError.dle.isPaperOut)
   {
	  //poka informacj: brak papieru
	  printf("poka informacj: brak papieru\n");
	  Sleep(1000);
   }
   else if (lastError.dle.isOnline == 0)
   {
	  //drukarka jest offline
	  printf("drukarka jest offline\n");
	  Sleep(1000);
   }
   else if (lastError.dle.isPrinterErr)
   {
	  //bd mechanizmu drukujcego
	  printf("bd mechanizmu drukujcego\n");
	  Sleep(1000);
   }
   else if (lastError.errorCodeFromDevice != 0)
   {
	  printf(lastError.errorDescriptionDevice);
   }
   else
   {
	  printf("nieznany bd\n");
	  //diagnostyk bdu naley przeprowadzi samodzielnie
   }

   AbortTransaction abortTransaction = { 0 };
   ndrv_ioctrl(NDRV_ABORT, &abortTransaction, sizeof(AbortTransaction), 0);

   return NDRV_ERROR; //bd nie otwarto paragonu - nie kontynuujemy

}

\endcode


Funkcja sprawdza poprawno wydrukowania paragonu/faktury w przypadku wykrycia bdu poczas drukowania:
- Jeeli jest wykryty brak papieru to sprawdza poprawno licznikw sprzeday i prbuje dokoczy paragon,
- Jeeli wykryje bd zwizany z wysyanymi danymi - anuluje operacj. <BR>
Oczywicie obsug bdw naley dostosowa do wasnych potrzeb, ponisza funkcja jest tylko przykadowa.

\code{.cpp}

int TestLib::handle_error(void)
{
   //obsuga bdw
   int result;
   do
   {
	  result = ndrv_ioctrl(NDRV_COMPLETE_CHECK, 0, 0, 0);

	  if (result == 0)
		 break; //paragon zakoczony

	  if (result != 0)
	  {
		 LastError lastError;

		 ndrv_get_last_error(&lastError);
		 if (lastError.dle.isPaperOut)
		 {
			// poka informacj: brak papieru
			printf(" poka informacj: brak papieru\n");
			Sleep(1000);
		 }
		 else if (lastError.dle.isOnline == 0)
		 {
			// drukarka jest w menu
			printf("drukarka jest offline\n");
			Sleep(1000);
		 }
		 else if (lastError.dle.isPrinterErr)
		 {
			// bd mechanizmu drukujcego
			printf("bd mechanizmu drukujcego\n");
			Sleep(1000);
		 }
		 else if (lastError.errorCodeFromDevice != 0)
		 {
			//programista decyduje zo zrobi z bdem
			printf(lastError.errorDescriptionDevice);

			//anulujemy paragon
			AbortTransaction abortTransaction{ 0 };
			ndrv_ioctrl(NDRV_ABORT, &abortTransaction, sizeof(AbortTransaction), 0);

			return NDRV_ERROR;
		 }
		 else
		 {
			printf("nieznany bd\n");

			//anulujemy paragon
			AbortTransaction abortTransaction = { 0 };
			ndrv_ioctrl(NDRV_ABORT, &abortTransaction, sizeof(AbortTransaction), 0);

			return NDRV_ERROR; // diagnostyk bdu naley przeprowadzi samodzielnie
		 }
	  }
   } while (result != 0);
   return NDRV_OK;
}
\endcode


Wczenie logu komunikacyjnego odbywa si przez wywoanie funkcji "ndrv_enable_log()". Logi komunikacyjne skadowane s w folderze: C:\\Log

\code{.cpp}
{
      ndrv_enable_log("C:\\Log");
}
\endcode


<H3>Tabela przykadw: </H3>

<div class="maintable">
<table width=100% class="doxtable">
<tr>
  <th>Rodzaj operacji</th>
  <th>Opis</th>
  <th>Przykad</th>
</tr>

<tr>
<th></th>
<th>Szybki start</th>
<th></th>
</tr>

<tr>
   <td>Import sterownika <BR> do rodowiska <BR> programistycznego</td>
   <td>
	  <B>Przykadowe projekty z zaimportowanymi bibliotekami znajduj si w pliku instalacyjnym w folderze Templates.</B><BR><BR>
   <B>Przykady: C/CPP:</B> Do folderu Debug naley wklei plik NFPDrv.dll.<BR>
	<BR> Naley doczy take pliki nagwkowe FDTypes.h i BaseLib.h.
	<BR>Do plikw zasobw dodajemy plik NFPDrv.lib.<BR><BR>
	
   <B>Przykady: C#:</B> Do folderu Debug naley wklei plik NFPDrv.dll oraz NFPDrvcs.dll.<BR>
   <BR> Nastpnie naley doda odwoanie do biblioteki NFPDrvcs.dll.<BR>

   <BR>

   <B>Przykady: Java:</B> Do folderu z projektem w jzyku Java naley doczy pliki JNFPDrv.dll, NFPDrv.dll oraz JNFPDrv.jar.<BR>
   <BR>W przypadku uycia biblioteki w jzyku Java konieczne jest take ustawienie kodowania pl tekstowych na UTF-8. Przedstawia to poniszy kod: <BR>

   \code{.java}
	{
		jnfpdrv.ndrv_ioctrl(jnfpdrv.NDRV_UTF_8, null, jnfpdrv.NDRV_LEN_IGNORE, 0);
	}
	\endcode
   <BR>Biblioteka jest dostpna na platform Windows.

   <BR>
   <B>Przykady: Python:</B> Do folderu z projektem w jzyku Python naley doczy pliki nfpdrv.py, NFPDrv.dll oraz _nfpdrv.pyd.<BR>
   <BR>W przypadku uycia biblioteki w jzyku Python konieczne jest take ustawienie kodowania pl tekstowych na UTF-8. Przedstawia to poniszy kod: <BR>

   \code{.python}
   {
		nfpdrv.ndrv_ioctrl(nfpdrv.NDRV_UTF_8, None,0,0)	
   }
   \endcode

   <BR>Dodatkowo pliki rdowe powinny by w kodowaniu UTF8 i na pocztku pliku naley doda: # -*- coding: utf-8 -*-
   <BR>Biblioteka jest dostpna na platform Windows.

   <BR><B>Przykady: Android:</B> Do projektu Android Studio naley doczy plik jnfpdrv.aar(File -> New -> New Module -> Import .JAR/.AAR Package). Nastepnie do build.gradle(Module: App) dependencies dodajemy lini: <BR><BR>
   <B>implementation project(":jnfpdrv")</B><BR>
   <BR>Naley take wywoa nazw "hello-libs", jak poniej: <BR><BR>
   <B>System.loadLibrary("hello-libs");</B><BR>
   
   <BR>W przypadku uycia biblioteki w projekcie Androidowym konieczne jest take ustawienie kodowania pl tekstowych na UTF-8. Przedstawia to poniszy kod: <BR>

   \code{.java}
	{
		jnfpdrv.ndrv_ioctrl(jnfpdrv.NDRV_UTF_8, null, jnfpdrv.NDRV_LEN_IGNORE, 0);
	}
	\endcode

	<BR>Logi mog by przechowywane na karcie SD. Poniej przykadowy kod wczenia zapisu logw: <BR>

	\code{.java}
	{
		String root = Environment.getExternalStorageDirectory().toString()+"/Android/data/pl.novitus.myapplicationa/log";
		jnfpdrv.ndrv_enable_log(root);
	}
	\endcode

   </td>
   <td>
  </td>
</tr>



<tr>
<th></th>
<th>Transakcje</th>
<th></th>
</tr>

<tr>
   <td>Bazowy paragon</td>
   <td>
   Kady paragon powinien skada si z przynajmniej trzech czci:<BR>
   <ul>
   <li>Rozpoczcie paragonu, w ktrym moemy doda :</li>
   <ul>
   <li>numberOfLines - ilo linii dodatkowych w stopce paragonu - maksymalnie 3</li>
   <li>line1..line3 - w zalenoci ile linii zostao podane w argumencie numberOfLines</li>
   <li>symbolPL - symbol PL przy numerze NIP</li>
   <li>id - numer identyfikacyjny nabywcy NIP</li>
   </ul>
   <li>Paragon moemy rozpocz w dwch trybach:</li>
   <ul>
   <li>offline - wydruk nastpuje po zakoczeniu paragonu - naley wysa ID pakietu NDRV_RCP_OFFLINE_START</li>
   <li>online - linie drukowane s na bieco - naley wysa ID pakietu NDRV_RCP_ONLINE_START lub NDRV_RCP_START</li>
   </ul>
   <BR>
   <li>Pozycje paragonu (przynajmniej jedna pozycja), w ktrych musimy poda:</li>
   <ul>
   <li>name - nazw pozycji</li>
   <li>quantity(liczba, 100000000=1szt) dla long long / qtty(napis np. 1.5) -ilo</li>
   <li>price - cena w groszach za sztuk</li>
   <li>brutto - suma w groszach [ilo*cena]</li>
   <li>PTU - stawka PTU</li>
   </ul>
	Moemy doda opcje takie jak: 

   <ul>
   <li>unit - jednostka np. szt, kg</li>
   <li>discountType -<a href="#discountTypes">rodzaj rabatu</a></li>
   <li>discountDescription -<a href="#discountNumbers">opis rabatu</a></li>
   <li>discountName - nazw rabatu, gdy discountDescription ustawione jest na 16</li>
   <li>fItemDescription - flaga opisu towaru</li>
   <li>itemDescription - opis towaru, gdy fItemDescription ustawione na 1</li>
   <li>PLU - kod PLU towaru, gdy fItemDescription ustaione na 0</li>
   </ul>
   <BR>
   <li>Zakoczenie paragonu, w podstawowym pakiecie musimy poda:</li>
   <ul>
   <li>action - 0-anulowanie transakcji, 1-zatwierdzenie transakcji</li>
   <li>total - sum wszystkich pozycji paragonu</li>
   <li>value - kwota wpacona</li>
   </ul>
   <li>Opcjonalne pola do uzupenienia:</li>
   <ul>
   <li>cashierName - nazwa kasjera(31-znakw)</li>
   <li>discout - opcjonalny rabat procentowy dla caej transakcji. Parametr ten jest ignorowany gdy rabat jest definiowany za pomoc pl discountType i discountValue.</li>
   <li>discoutType:
   <ul><li>0-brak,</li><li>1-rabat procentowy,</li><li>2-dopata procentowa</li></ul></li>
   <li>discoutValue - rabat lub dopata procentowa dla caej transakcji, stopa jest zadana z dokadnoci do 0.01 jeeli parametr Rodzaj rabatu rny od 0</li>
   <li>numberOfLines - ilo dodatkowych linii umieszczanych w stopce paragonu, za logo fiskalnym, do ktrych ma dostp aplikacja</li>
   <li>line1... line3 - zawarto linii dodatkowych</li>
   </ul>
   </ul><BR>

   </td>
   <td>  
   \code{.cpp}
   TestLib::testRCP
   \endcode
	\image{inline} html ./images/wydruki/testRCP.png width=70%, height=60%<BR><BR>
  </td>
</tr>

<tr>
   <td>Paragon z NIP nabywcy i numerem systemowym(dedykowany rozkaz $z)</td>
   <td>
   Nip nabywcy moe by przesany w dowolnym momencie po rozpoczciu paragonu i przed jego zakoczeniem.
   </td>
   <td>
   \code{.cpp}
   TestLib::testRCPWithBuyerID
   \endcode
   \image{inline} html ./images/wydruki/testRCPWithBuyerID.png width=70%, height=60%<BR><BR>
  </td>
</tr>

<tr>
   <td>Paragon z patnocia kart</td>
   <td>
   W rozszerzonej wersji zakoczenia paragonu, poza podaniem kwoty do zapaty moemy poda inn form patnoci ni gotwka. 
   Aby doda patno kart naley ustawi flag patnoci kart (fCard) na 1 i wpisa kwot patnoci kart (card).
   </td>
   <td>
   \code{.cpp}
   TestLib::testRCPCardPayment
   \endcode
   \image{inline} html ./images/wydruki/testRCPCardPayment.png width=70%, height=60%<BR><BR>
  </td>
</tr>

<tr>
   <td>Paragon z wieloma patnociami</td>
   <td>
   Formy patnoci mona zdefiniowa przed zakoczeniem paragonu. 
   Aby doda patno naley poda informacje takie jak:
   <ul>
   <li>action - akcja (1 - dodanie formy patnoci, 2 - anulowanie formy patnoci)</li>
   <li>paymentMethod - typ patnoci:</li>
   <ul>
	<li>1 - karta</li>
	<li>2 - czek</li>
	<li>3 - bon</li>
	<li>4 - inna</li>
	<li>5 - kredyt</li>
	<li>6 - z konta klienta</li>
	<li>7 - waluta</li>
	<li>8 - przelew</li>
	</ul>
   <li>value - kwota</li>
   <li>name - nazwa patnoci</li>
   </td>
   <td>
   \code{.cpp}
   TestLib::testRCPMultiplePayments
   \endcode
   \image{inline} html ./images/wydruki/testRCPMultiplePayments.png width=70%, height=60%<BR><BR>
  </td>
</tr>

<tr>
   <td id="flags">Paragon z wieloma patnociami w zakoczeniu</td>
   <td>
   W rozszerzonej wersji zakoczenia paragonu moemy wprowadzic wiele form patnoci
   na przykad patno kart, czekiem, bonem i gotwk w jednej transakcji. <BR>
   Rodzaje flag:
   <ul>
   <li>fCash = 1 - dodanie formy patnoci gotwk</li>
   <li>fCard = 1 - dodanie formy patnoci kart</li>
   <li>fCheque = 1 - dodanie formy patnoci czekiem</li>
   <li>fBon = 1 - dodanie formy patnoci bonem</li>
   <li>fContainerIn = 1 - dodanie kaucji pobranej(za sprzeda opakowania)</li>
   <li>fContainerOut = 1 - dodanie kaucji wydanej(za zwrot opakowania)</li>
   </ul>
   </td>
   <td>
   \code{.cpp}
   TestLib::testRCPMultiplePaymentsInEnd
   \endcode
   \image{inline} html ./images/wydruki/testRCPMultiplePaymentsInEnd.png width=70%, height=60%<BR><BR>
  </td>
</tr>

<tr>
   <td>Anulowanie transakcji</td>
   <td>
   Przy anulowaniu transakcji moemy poda wartoci takie jak: numer kasy (tillNumber) i nazw kasjera (cashier). 
   Parametry te s opcjonalne, bez podawania ich dane zostan pobrane z urzdzenia.
   </td>
   <td>
   \code{.cpp}
   TestLib::testRCPAbort
   \endcode
   \image{inline} html ./images/wydruki/testRCPAbort.png width=70%, height=60%<BR><BR>
  </td>
</tr>

<tr>
   <td>Paragon z kaucj pobran(za sprzeda opakowania)</td>
   <td>
   W zakoczeniu naley ustawi flag kaucji(fContainerIn) i wpisa kwot kaucji pobranej(containerIn).
   </td>
   <td>
   \code{.cpp}
   TestLib::testRCPWithBailIn
   \endcode
   \image{inline} html ./images/wydruki/testRCPWithBailIn.png width=70%, height=60%<BR><BR>
  </td>
</tr>

<tr>
   <td>Paragon z kaucj wydan(za zwrot opakowania)</td>
   <td>
   W zakoczeniu naley ustawi flag kaucji(fConuainerOut) i wpisa kwot kaucji wydanej(conainerOut).
   </td>
   <td>
   \code{.cpp}
   TestLib::testRCPWithBailOut
   \endcode
   \image{inline} html ./images/wydruki/testRCPWithBailOut.png width=70%, height=60%<BR><BR>
  </td>
</tr>

<tr>
   <td>Paragon z kaucj pobran(za sprzeda opakowania) i wydan(za zwrot opakowania)</td>
   <td>
   W zakoczeniu naley wpisa kwot kaucji porbanej i wydanej.
   </td>
   <td>
   \code{.cpp}
   TestLib::testRCPWithBail
   \endcode
   \image{inline} html ./images/wydruki/testRCPWithBail.png width=70%, height=60%<BR><BR>
  </td>
</tr>

<tr>
   <td>Paragon z wieloma patnociami oraz kaucj pobran(za sprzeda opakowania) i wydan(za zwrot opakowania)</td>
   <td>
   W zakoczeniu naley wpisa <a href="#flags">flagi</a>, kwot form patnoci oraz kwot kaucji pobranej i wydanej.
   </td>
   <td>
   \code{.cpp}
   TestLib::testRCPMultiplePaymentsAndBail
   \endcode
   \image{inline} html ./images/wydruki/testRCPMultiplePaymentsAndBail.png width=70%, height=60%<BR><BR>
  </td>
</tr>

<tr>
   <td id="discTransaction">Paragon z rabatem procentowym do transakcji</td>
   <td id="discountTypes">
   Aby doda rabat naley poda rodzaj rabatu, nazw i warto.<BR>
   Rodzaje rabatw (discountType):
   <ul>
   <li>1 - Rabat procentowy</li>
   <li>2 - Narzut procentowy</li>
   <li>3 - Rabat kwotowy</li>
   <li>4 - Narzut kwotowy</li>
   </ul><BR>
   Przykadowy kod:
    \code
		DiscountOrMarkupToTransaction discountOrMarkupToTransaction;
		discountOrMarkupToTransaction.discountType = 1;
		strcpy(discountOrMarkupToTransaction.discountName, "Nazwa rabatu");
		discountOrMarkupToTransaction.value = 1000; // warto rabatu 10PLN lub 10%
   \endcode
   </td>
   <td>
   \code{.cpp}
   TestLib::testRCPDiscountPercent
   \endcode
   \image{inline} html ./images/wydruki/testRCPDiscountPercent.png width=70%, height=60%<BR><BR>
  </td>
</tr>


<tr>
   <td>Paragon z narzutem procentowym do transakcji</td>
   <td>
	Struktura zostaa ju wczeniej omwiona(<a href="#discTransaction">link</a>).<BR>
	Rni si jedynie rodzajem rabatu.
	</td>
   <td>
   \code{.cpp}
   TestLib::testRCPMarkupPercent
   \endcode
   \image{inline} html ./images/wydruki/testRCPMarkupPercent.png width=70%, height=60%<BR><BR>
  </td>
</tr>


<tr>
   <td>Paragon z rabatem kwotowym do transakcji</td>
   <td>
	Struktura zostaa ju wczeniej omwiona(<a href="#discTransaction">link</a>).<BR>
	Rni si jedynie rodzajem rabatu.
   </td>
   <td>
   \code{.cpp}
   TestLib::testRCPDiscountAmount
   \endcode
   \image{inline} html ./images/wydruki/testRCPDiscountAmount.png width=70%, height=60%<BR><BR>
  </td>
</tr>

<tr>
   <td>Paragon z narzutem kwotowym do transakcji</td>
   <td>
	Struktura zostaa ju wczeniej omwiona(<a href="#discTransaction">link</a>).<BR>
	Rni si jedynie rodzajem rabatu.
   </td>
   <td>
   \code{.cpp}
   TestLib::testRCPMarkupAmount
   \endcode
   \image{inline} html ./images/wydruki/testRCPMarkupAmount.png width=70%, height=60%<BR><BR>
  </td>
</tr>


<tr>
   <td id="subtotal">Paragon z rabat procentowy do podsumy</td>
   <td id="discountNumbers">
   Aby doda narzut kwotowy naley poda rodzaj rabatu (<a href="#discountTypes">discountType</a>),
   numer opisu(<a href="#discountNumbers">discountNumber</a>), nazw(jeeli podany numer jest rwny 16) 
   i warto podsumy(subtotal).
   <BR>   Przy dodawaniu kilku rabatw do podsumy naley uwzgldni 
   kwot do zapaty po odliczeniu wczeniejszego rabatu do posumy.
   <BR>Numer opisu(discountNumber):
   <ul>
   <li>0 - brak opisu</li>
   <li>1 - "specjalny"</li>
   <li>2 - "okolicznociowy"</li>
   <li>3 - "okazja"</li>
   <li>4 - "witeczny"</li>
   <li>5 - "stay klient"</li>
   <li>6 - "jubileuszowy"</li>
   <li>7 - "urodzinowy"</li>
   <li>8 - "dla pracownika"</li>
   <li>9 - "promocja"</li>
   <li>10 - "nagroda"</li>
   <li>11 - "wyprzeda"</li>
   <li>12 - "przecena"</li>
   <li>13 - "sezonowy"</li>
   <li>14 - "nocny"</li>
   <li>15 - "obsuga"</li>
   <li>16 - opis definiowany przez uytkownika</li>
   </ul>
   
   <BR>Przykadowy kod:
   \code
	DiscountOrMarkupToSubtotal discountOrMarkupToSubtotal;
	discountOrMarkupToSubtotal.discountType = 1;
	discountOrMarkupToSubtotal.discountNumber = 0;
	discountOrMarkupToSubtotal.Subtotal = 10000; //podsuma 100PLN
	discountOrMarkupToSubtotal.discount = 1000; //warto rabatu 10PLN lub 10%
   \endcode
 </td>
   <td>
   \code{.cpp}
   TestLib::testRCPDiscountPercentSubtotal
   \endcode
   \image{inline} html ./images/wydruki/testRCPDiscountPercentSubtotal.png width=70%, height=60%<BR><BR>
  </td>
</tr>

<tr>
<td>Paragon z narzutem procentowy do podsumy</td>
   <td>
	Struktura zostaa ju wczeniej omwiona(<a href="#subtotal">link</a>).<BR>
	Rni si jedynie rodzajem rabatu.
   <td>
   \code{.cpp}
   TestLib::testRCPMarkupPercentSubtotal
   \endcode
   \image{inline} html ./images/wydruki/testRCPMarkupPercentSubtotal.png width=70%, height=60%<BR><BR>
  </td>
</tr>

<tr>
<td>Paragon z rabatem kwotowym do podsumy</td>
   <td>
	Struktura zostaa ju wczeniej omwiona(<a href="#subtotal">link</a>).<BR>
	Rni si jedynie rodzajem rabatu.
   <td>
   \code{.cpp}
   TestLib::testRCPDiscountAmountSubtotal
   \endcode
   \image{inline} html ./images/wydruki/testRCPDiscountAmountSubtotal.png width=70%, height=60%<BR><BR>
  </td>
</tr>

<tr>
<td>Paragon z narzutem kwotowym do podsumy</td>
   <td>
	Struktura zostaa ju wczeniej omwiona(<a href="#subtotal">link</a>).<BR>
	Rni si jedynie rodzajem rabatu.
  </td>
   <td>
   \code{.cpp}
   TestLib::testRCPMarkupAmountSubtotal
   \endcode
   \image{inline} html ./images/wydruki/testRCPMarkupAmountSubtotal.png width=70%, height=60%<BR><BR>
  </td>
</tr>

<tr>
<td>Paragon z wieloma rabatami i narzutami do podsumy</td>
  <td>
  Struktura zostaa ju wczeniej omwiona(<a href="#subtotal">link</a>).<BR>
  Po kadym rabacie lub narzucie naley dokadnie przeliczy podsum.<BR>
  </td>
   <td>
   \code{.cpp}
   TestLib::testRCPMultipleSubtotal
   \endcode
   \image{inline} html ./images/wydruki/testRCPMultipleSubtotal.png width=70%, height=60% <BR><BR>
  </td>
</tr>

<tr>
<td>Paragon z wieloma rabatami i narzutami do podsumy oraz rabatem do transakcji</td>
  <td>
	Struktura zostaa ju wczeniej omwiona(<a href="#subtotal">link</a>).
  Po kadym rabacie lub narzucie naley dokadnie przeliczy podsum.<BR>
  W zakoczeniu naley wpisa kwot/procent rabatu/narzutu.
  </td>
   <td>
   \code{.cpp}
   TestLib::testRCPMultipleSubtotalAndDiscountToTransaction
   \endcode
   \image{inline} html ./images/wydruki/testRCPMultipleSubtotalAndDiscountToTransaction.png width=70%, height=60%<BR><BR>
  </td>
</tr>

<tr>
<td>Paragon z rabatem procentowym do towarw w podanej stawce PTU</td>
  <td id="PTU">
  Aby doda rabat do towarw w danej stawce naley poda: rodzaj rabatu
  (<a href="#discountTypes">discountType</a>), 
  numer rabatu(<a href="#discountNumbers">discountNumber</a>)
  ,nazw(jeeli numer rabatu jest rwny 16), stawk PTU, sprzeda w danej stawce(sales), warto rabatu(discount).<BR>
  Stawki PTU (PTUNumber):
	<ul>
	<li>0 - stawka A</li>
	<li>1 - stawka B</li>
	<li>2 - stawka C</li>
	<li>3 - stawka D</li>
	<li>4 - stawka E</li>
	<li>5 - stawka F</li>
	<li>6 - stawka G</li>
	</ul>
	<BR> Przykadowy kod:
	\code
	 DiscountOrMarkupToPTU discountOrMarkupToPTU;
	 discountOrMarkupToPTU.discountType = 1;
	 discountOrMarkupToPTU.discountNumber = 0;
	 discountOrMarkupToPTU.PTUNumber = 0;
	 discountOrMarkupToPTU.sales = 3000;
	 discountOrMarkupToPTU.discount = 1000;
	\endcode

  </td>
   <td>
   \code{.cpp}
   TestLib::testRCPDiscountPercentPTU
   \endcode
   \image{inline} html ./images/wydruki/testRCPDiscountPercentPTU.png width=70%, height=60%<BR><BR>
  </td>
</tr>


<tr>
<td>Paragon z narzutem procentowym do towarw w podanej stawce PTU</td>  
<td>
	Struktura zostaa ju wczeniej omwniona ( <a href="#PTU">link</a> ).<BR>
	Rni si jedynie rodzajem rabatu.<BR>
	
  </td>
   <td>
   \code{.cpp}
   TestLib::testRCPMarkupPercentPTU
   \endcode
   \image{inline} html ./images/wydruki/testRCPMarkupPercentPTU.png width=70%, height=60%<BR><BR>
  </td>
</tr>


<tr>
<td>Paragon z rabatem kwotowym do towarw w podanej stawce PTU</td>  
<td>
	Struktura zostaa ju wczeniej omwniona ( <a href="#PTU">link</a> ).<BR>
	Rni si jedynie rodzajem rabatu.<BR>
  </td>
   <td>
   \code{.cpp}
   TestLib::testRCPDiscountAmountPTU
   \endcode
   \image{inline} html ./images/wydruki/testRCPDiscountAmountPTU.png width=70%, height=60%<BR><BR>
  </td>
</tr>

<tr>
<td>Paragon z narzutem kwotowym do towarw w podanej stawce PTU</td> 
<td>
	Struktura zostaa ju wczeniej omwniona ( <a href="#PTU">link</a> ). <BR>
	Rni si jedynie rodzajem rabatu.<BR>
  </td>
   <td>
   \code{.cpp}
   TestLib::testRCPMarkupAmountPTU
   \endcode
   \image{inline} html ./images/wydruki/testRCPMarkupAmountPTU.png width=70%, height=60%<BR><BR>
  </td>
</tr>

<tr>
<td>Paragon z wieloma rabatami/narzutami do towarw w rnych stawkach PTU</td>
<td>
	Struktura zostaa ju wczeniej omwniona ( <a href="#PTU">link</a> ).<BR>
	Rni si jedynie rodzajem rabatu.<BR>
  </td>
   <td>
   \code{.cpp}
   TestLib::testRCPMultipleDiscountMarkupPTU
   \endcode
   \image{inline} html ./images/wydruki/testRCPMultipleDiscountMarkupPTU.png width=70%, height=60%<BR><BR>
  </td>
</tr>


<tr>
<td>Obsuga kaucji w linii paragonu.</td>
<td>
	Aby doda kaucj naley poda:
	
	<ul>
	<li>rodzaj kaucji(bailType),</li> 
	<li>numer opakowania(number),</li> 
	<li>ilo kaucji(quantity/qtty),</li> 
	<li>cen(price),</li>
	<li>warto(value)- parametr ignorowany.</li>
	Rodzaje kaucji:
	<ul>
		<li>6 - kaucja pobrana</li>
		<li>7 - storno kaucji pobranej</li>
		<li>10 - kaucja wydana</li>
		<li>11 - storno kaucji wydanej</li>
	</ul>
</td>
<td>
	\code{.cpp}
	TestLib::testRCPBail
	\endcode
	\image{inline} html ./images/wydruki/testRCPBail.png width=70%, height=60%<BR><BR>
</td>

<tr>
<td id="bailIn">Kaucja pobrana (za sprzeda opakowania)</td>
<td>
 Aby doda kaucj naley poda warto kaucji w groszach(amount), ilo kaucji(quantity/qtty) oraz numer opakowania(zakres od 1 - 127 lub brak)
<BR>
Przykadowy kod:
\code
	BailIn bailIn;
	bailIn.amount = 100;
	strcpy(bailIn.qtty,"1");
	bailIn.conteinerNumber = 3;
\endcode

  </td>
   <td>
   \code{.cpp}
   TestLib::testBailIn
   \endcode
   \image{inline} html ./images/wydruki/testBailIn.png width=70%, height=60%<BR><BR>
  </td>
</tr>

<tr>
<td>Storno kaucji pobranej (za sprzeda opakowania)</td>
<td>
 Przed dodaniem storno kaucji pobranej naley doda przynajmniej jedn kaucje pobran.<BR>
 Struktura jest taka sama jak w przypadku kaucji  pobranej (za sprzeda opakowania)(<a href="#bailIn">link</a>).

 </td>
   <td>
   \code{.cpp}
   TestLib::testBailInStorno
   \endcode
   \image{inline} html ./images/wydruki/testBailInStorno.png width=70%, height=60%<BR><BR>
  </td>
</tr>

<tr>
<td>Kaucja  wydana (za zwrot opakowania)</td>
<td>
 Struktura jest taka sama jak w przypadku kaucji pobranej(<a href="#bailIn">link</a>).
  </td>
   <td>
   \code{.cpp}
   TestLib::testBailOut
   \endcode
   \image{inline} html ./images/wydruki/testBailOut.png width=70%, height=60%<BR><BR>
  </td>
</tr>

<tr>
<td>Storno kaucji wydanej</td>
<td>
 Przed dodaniem storno kaucji wydanej naley doda przynajmniej jedn kaucje wydan.<BR>
 Struktura jest taka sama jak w przypadku kaucji pobranej(<a href="#bailIn">link</a>).
  </td>
   <td>
   \code{.cpp}
   TestLib::testBailOutStorno
   \endcode
   \image{inline} html ./images/wydruki/testBailOutStorno.png width=70%, height=60%<BR><BR>
  </td>
</tr>

<tr>
<td>Paragon z kaucjami wydanymi i przyjtymi </td>
<td>
	Naley rozpocz paragon i sprzeda produkt. Nastpnie doda kaucj.<BR>
	Struktura kaucji jest taka sama jak w przypadku kaucji pobranej(<a href="#bailIn">link</a>).
	<BR>W zakoczeniu nie uwzgldnia kwoty kaucji(jedynie kwoty produktw).
  </td>
   <td>
   \code{.cpp}
   TestLib::testBailInReceipt
   \endcode
   \image{inline} html ./images/wydruki/testBailInReceipt.png width=70%, height=60%<BR><BR>
  </td>
</tr>

<tr>
<td>Paragon z zaliczk</td>
<td>
	Naley rozpocz paragon i sprzeda produkt. Nastpnie doda zaliczke.<BR>
	Struktura zaliczki:<BR>
	<ul>
	<li>action:</li><BR> 0 - zaliczka; <BR>1 - rozliczenie zaliczki; <BR>2 - STORNO zaliczki; <BR>3 - STORNO rozliczenia zaliczki
	<li>itemName: nazwa towaru, do ktrego udzialana jest zaliczka lub rozliczenie zaliczki</li>
	<li>ptu: litera okrelajca dan stawk podatkow</li>
	<li>value: warto zaliczki lub rozliczenia zaliczki</li>
	<li>extra: suma do dopaty po odliczeniu zaliczki (pole ignorowane, drukarka automatycznie wylicza warto do dopaty)</li>
	</ul>
	<BR>Uwagi:<BR>
	<ul>
	<li>Rozkaz naley wysa po rozpoczciu lub przed zakoczeniem paragonu.</li>
	<li>Rozliczenie zaliczki udzielane jest do pierwszego odnalezionego towaru na paragonie. </li>
	<li> Nie mona wykona operacji STORNO na towarze, do ktrego zrobiono rozliczenie zaliczki, dopki rozliczenia zaliczek wczeniej nie zostan usunite.</li>
	</ul>
  </td>
   <td>
   \code{.cpp}
   TestLib::testRCPWithPrepayment
   TestLib::testRCPWithSettlementPrepayment
   TestLib::testRCPWithStornoPrepayment   
   TestLib::testRCPWithStornoSettlementPrepayment
   \endcode
   <BR>
   Zaliczka:
   <BR>
   \image{inline} html ./images/wydruki/testRCPWithPrepayment.png width=70%, height=60%<BR><BR>
   <BR>
   Rozliczenie zaliczki:
   <BR>
   \image{inline} html ./images/wydruki/testRCPWithSettlementPrepayment.png width=70%, height=60%<BR><BR>
   <BR>
   Storno zaliczki:
   <BR>
   \image{inline} html ./images/wydruki/testRCPWithStornoPrepayment.png width=70%, height=60%<BR><BR>
   <BR>
   Storno rozliczenia zaliczki:
   <BR>
   \image{inline} html ./images/wydruki/testRCPWithStornoSettlementPrepayment.png width=70%, height=60%<BR><BR>
  </td>
</tr>

<tr>
<td>Paragon kompletny</td>
<td>
	Paragon kompletny skada si z wczeniej omwionych struktur, takich jak:
	<ul>
	<li>rozpoczcia paragonu,</li>
	<li>pozycje paragonu,</li>
	<li>rabat w trakcie transakcji,</li>
	<li>rabat do podsumy (maksymalnie 1 rabat),</li>
	<li>rabat do danej stawki,</li>
	<li>zakoczenie paragonu( podstawowe, z formami patnoci (1), z formami patnoci (2) ),</li>
	<li>kaucje pobrane,</li>
	<li>kaucje wydane,</li>
	</ul>
	<BR>
	Paragon kompletny przyjmuje wartoci takie jak:
	<ul>
	<li>fEnd:
		<ul>
		<li> 0 - zakoczenie paragonu podstawowe,</li>
		<li> 1 - zakoczenie paragonu z formami patnoci (1),</li>
		<li> 2 - zakoczenie paragonu z formami patnoci (2),</li>
		</ul>
		</li>
	<li>bailInCount - okrela liczb kaucji pobranych (za sprzeda opakowania),</li>
	<li>bailOutCount - okrela liczb kaucji  wydanych (za zwrot opakowania),</li>
	<li>nonFicalPrintoutCount - okrela liczb linii niefiskalnych po paragonie,</li>
	<li>itemCount - okrela liczb pozycji paragonu,</li>
	<li>discountSubtotalPos - okrela po ktrej pozycji paragonu doda rabat/narzut do podsumy</li>
	</ul>
  </td>
   <td>
   \code{.cpp}
   TestLib::testRCPComplete
   \endcode
   \image{inline} html ./images/wydruki/testRCPComplete.png width=70%, height=60%<BR><BR>
  </td>
</tr>





<tr>
<td id="startInvoice">Przykadowa faktura</td>
<td>
Aby rozpocz faktur naley poda informacje takie jak:
<ul>
<li>ilo kopii(additionalCopy - 255- brak kopii,0- jedna kopia),</li>
<li>ilo linii danych nabywcy(numberOfLinesReceiverData - minimalnie 1 linia, maksymalnie 8 linii),</li>
<li>miejsce na podpisy(sign - 1-pola nie s drukowane,0-pola s drukkowane),</li>
<li>symbol "PL" przed numerem NIP(symbolPL),</li>
<li>numer fakruty(invoiceNumber),</li>
<li>numer NIP nabywcy(NIP),</li>
<li>numer systemowy(systemNumber),</li>
<li>nazwa nabywcy(receiverName),</li>
<li>nazwa odbiorcy(senderName),</li>
<li>nazwa wystawiajcego faktur(buyerName - pole wymagane)</li>
</ul>
<li>Faktur moemy rozpocz w dwch trybach:
   <ul>
   <li>offline - wydruk nastpuje po zakoczeniu faktury - naley wysa ID pakietu NDRV_INV_OFFLINE_START lub NDRV_INV_START </li>
   <li>online - linie drukowane s na bieco - naley wysa ID pakietu NDRV_INV_ONLINE_START </li>
   </ul>
</li>
<BR>
Przykadowy kod rozpoczcia faktury:
\code
	StartInvoice startInvoice;
	startInvoice.additionalCopy = 255;
	startInvoice.numberOfLinesReceiverData = 1;
	startInvoice.sign = 1;
	startInvoice.invoiceNumber = 123;
	strcpy(startInvoice.line1, "linia 1");
	strcpy(startInvoice.NIP, "1234567890");
	strcpy(startInvoice.systemNumber, "123456");
	strcpy(startInvoice.receiverName, "Jan");
	strcpy(startInvoice.senderName, "Jakub");
	strcpy(startInvoice.buyerName, "Artur");
\endcode

<BR>
<BR>
Aby zakoczyc faktur naley poda informacje takie jak:
<ul>
<li>akcja(action- 0-anulowanie,1-zatwierdzenie),</li>
<li>linia zapacono(wordPaid - 1 - drukowana linia "Zapacono", 0 - nie drukowana),</li>
</li>opcje nabywcy(receiverSettings) :
<ul><li>0  drukowany jest tylko blok informacyjny </li>
<li>1  s drukowane nazwa kupujcego  92 oraz blok informacyjny </li>
<li>2  brak informacji o kupujcym (bloku informacyjnego i nazwy kupujcego) </li></ul></li>
<li>opcje sprzedajcego(senderSettings) :
<ul><li>0  drukowany jest tylko blok informacyjny </li>
<li>1  s drukowane nazwa sprzedajcego oraz blok informacyjny </li>
<li>2  brak informacji o sprzedajcym (bloku informacyjnego i nazwy sprzedajcego)</li></ul></li>
<li>ilo linii w stopce(numberOfLinesFooter - Ilo dodatkowych linii w stopce),</li>
<li>napis w linii "Zapacono" - drukowany jeli wordPaid ustawiono na 1</li>
<li>nazwa kupujcego(receiverName),</li>
<li>nazwa sprzedajcego(senderName),</li>
<li>wpata(payment - w groszach),</li>
<li>razem(total - w groszach),</li>
<li>warto rabatu(discountValue)</li>
</ul>
Przykadowy kod zakoczenia faktury:
\code

	EndInvoice endInvoice;
	endInvoice.action = 1;
	endInvoice.wordPaid = 0;
	endInvoice.receiverSettings = 1;
	endInvoice.senderSettings = 1;
	endInvoice.numberOfLinesFooter = 0;
	strcpy(endInvoice.paid, "Zaplacono");
	strcpy(endInvoice.receiverName, startInvoice.receiverName);
	strcpy(endInvoice.senderName, startInvoice.senderName);
	endInvoice.payment = 50000;
	endInvoice.total = 50000;
	endInvoice.discountValue = 0;

\endcode

  </td>
   <td>
   \code{.cpp}
   TestLib::testINV
   \endcode
  </td>
  \image{inline} html ./images/wydruki/testINV.png width=70%, height=60%<BR><BR>
</tr>

<tr>
<td id="invoiceOptions">Opcje faktury</td>
<td>
Aby doda opcje faktury naley poda:
<ul>
<li>liczb dodatkowych kopii (additionalCopies - 255- brak kopii),</li>
<li>opcje dla nazwy kupujcego (buyerNameOption) : 
<ul><li>0  drukowany jest tylko blok informacyjny </li>
<li>1  s drukowane nazwa kupujcego oraz blok informacyjny </li>
<li>2  brak informacji o kupujcym (bloku informacyjnego i nazwy kupujcego) </li></ul></li>
<li>opcje dla nazwy sprzedajcego(sellerNameOption) :
<ul><li>0  drukowany jest tylko blok informacyjny</li>
<li>1  s drukowane nazwa sprzedajcego oraz blok informacyjny </li>
<li>2  brak informacji o sprzedajcym (bloku informacyjnego i nazwy sprzedajcego)</li></ul></li>
<li>napis "Zapacono"(isPaid),</li>
<li>rok sprzday(saleDateYear - zakres 00-99(2 ostatnie cyfry)),</li>
<li>miesic sprzeday(saleDateMonth - zakres 1-12),</li>
<li>dzie sprzeday(saleDateDay - zakres 1-31),</li>
<li>opcje wydruku podsumowania(printoutSummaryOption),</li>
<li>opcje wydruku 2(printoutOption2),</li>
<li>typ numeru identyfikujcego kupujcego(buyerIDType),</li>
<li>opcje wydruku 3(printoutOption3),</li>
<li>nazwa nabywcy(buyerName)</li>
</ul>
<BR>
<b>printoutSummaryOption</b>:
<ul>
<li>1 - pomin opis sowny kwoty do zapaty</li>
<li>2 - pomin blok kwot brutto w rozliczeniu podatku</li>
<li>4 - pogrubiona etykieta "Nabywca"</li>
<li>8 - pogrubiona etykieta "Sprzedawca"</li>
<li>16 - pogrubiony NIP nabywcy</li>
<li>32 - pogrubiony NIP sprzedawcy</li>
</ul>
<BR>
Opcje te mona czy sumujc ich wartoci np. podajc liczb 48 bdzie pogrubiony NIP nabywcy i sprzedawcy.
<BR>
<BR>
<b>printoutOption2</b>:
<ul>
<li>1 - wydruk etykiety "opis/symbol" w nagwku faktury przed pozycjami faktury</li>
<li>2 - wydruk numeru pozycji w pozycji faktury</li>
<li>4 - etykieta "Do zapaty" drukowana przed blokiem rozliczenia podatkw</li>
<li>8 - wydruk iloci groszy w postaci sownej</li>
<li>16 - nie drukuj daty sprzeday jeeli jest taka sama jak data wystawienia faktury</li>
<li>32 - nie drukuj danych sprzedawcy</li>
<li>64 - nie drukuj danych opisw do pozycji faktury(informacji opisujcych zawarto pl w pozycjach faktury)</li>
<li>128 - wczona obsuga patnoci(tak jak w paragonach)</li>
</ul>
<BR>
Opcje te mona czy.
<BR>
<BR>
<b>printoutOption3</b>:
<ul>
<li>1 - nie drukuj danych odbiorcy(nie obejmuje pola z nimerem NIP)</li>
<li>2 - drukuj napis "Zapacono gotwk"</li>
<li>4 - pomi etykiet "Sprzedawca"</li>
<li>8 - pomi etykiet "ORYGINA"</li>
<li>16 - drukuj etykiet "FAKTURA VAT"</li>
</ul>
Opcje te mona czy.
<BR>
<BR>
<b>Zakoczenie jest takie jak w przypadku zakoczenia paragonu. Naley wysa struktur EndReceipt lub EndReceiptWithPaymentMethods1.</b>
<BR>
<BR>
Przykadowy kod:
\code

	InvoiceOptions invoiceOpions;
	invoiceOpions.additionalCopies = 255;
	invoiceOpions.buyerNameOption = 0;
	invoiceOpions.sellerNameOption = 0;
	strcpy(invoiceOpions.saleDateYear, "19");
	strcpy(invoiceOpions.saleDateMonth, "09");
	strcpy(invoiceOpions.saleDateDay, "16");
	invoiceOpions.isPaid = 0;
	invoiceOpions.printoutSummaryOption = 0;
	invoiceOpions.printoutOption2 = 0;
	invoiceOpions.printoutOption3 = 1;
	invoiceOpions.buyerIDType = 0;
	strcpy(invoiceOpions.systemNumber, "12345");
	strcpy(invoiceOpions.buyerName, "CCCCCCC");

\endcode

</td>
   <td>

  </td>
</tr>

<tr>
<td>Faktura - pomi opis sowny kwoty do zapaty</td>
<td>
	Struktura rozpoczcia faktury zostaa ju wczeniej omwiona (<a href="#startInvoice">link</a>).
	<BR>Opcje faktury take zostay omwione ( <a href="#invoiceOptions">link</a> )
  </td>
   <td>
   \code{.cpp}
   TestLib::testINVIgnoreAmountDescription
   \endcode
   \image{inline} html ./images/wydruki/testINVIgnoreAmountDescription.png width=70%, height=60%<BR><BR>
  </td>
</tr>

<tr>
<td>Faktura - pomi blok kwot brutto w rozliczeniu podatku</td>
<td>
	Struktura rozpoczcia faktury zostaa ju wczeniej omwiona (<a href="#startInvoice">link</a>).
	<BR>Opcje faktury take zostay omwione ( <a href="#invoiceOptions">link</a> )
  </td>
   <td>
   \code{.cpp}
   TestLib::testINVIgnoreBrutto
   \endcode
   \image{inline} html ./images/wydruki/testINVIgnoreBrutto.png width=70%, height=60%<BR><BR>
  </td>
</tr>

<tr>
<td>Faktura - pogrubiona etykieta "Nabywca"</td>
<td>
	Struktura rozpoczcia faktury zostaa ju wczeniej omwiona (<a href="#startInvoice">link</a>).
	<BR>Opcje faktury take zostay omwione ( <a href="#invoiceOptions">link</a> )
  </td>
   <td>
   \code{.cpp}
   TestLib::testINVBoldReceiver
   \endcode
   \image{inline} html ./images/wydruki/testINVBoldReceiver.png width=70%, height=60%<BR><BR>
  </td>
</tr>

<tr>
<td>Faktura - pogrubiona etykieta "Sprzedawca"</td>
<td>
	Struktura rozpoczcia faktury zostaa ju wczeniej omwiona (<a href="#startInvoice">link</a>).
	<BR>Opcje faktury take zostay omwione ( <a href="#invoiceOptions">link</a> )
  </td>
   <td>
   \code{.cpp}
   TestLib::testINVBoldSender
   \endcode
   \image{inline} html ./images/wydruki/testINVBoldSender.png width=70%, height=60%<BR><BR>
  </td>
</tr>


<tr>
<td>Faktura - pogrubiony NIP nabywcy</td>
<td>
	Struktura rozpoczcia faktury zostaa ju wczeniej omwiona (<a href="#startInvoice">link</a>).
	<BR>Opcje faktury take zostay omwione ( <a href="#invoiceOptions">link</a> )
  </td>
   <td>
   \code{.cpp}
   TestLib::testINVBoldReceiverNIP
   \endcode
   \image{inline} html ./images/wydruki/testINVBoldReceiverNIP.png width=70%, height=60%<BR><BR>
  </td>
</tr>


<tr>
<td>Faktura - pogrubiony NIP sprzedawcy</td>
<td>
	Struktura rozpoczcia faktury zostaa ju wczeniej omwiona (<a href="#startInvoice">link</a>).
	<BR>Opcje faktury take zostay omwione ( <a href="#invoiceOptions">link</a> )
  </td>
   <td>
   \code{.cpp}
   TestLib::testINVBoldSenderNIP
   \endcode
   \image{inline} html ./images/wydruki/testINVBoldSenderNIP.png width=70%, height=60%<BR><BR>
  </td>
</tr>

<tr>
<td>Faktura - wydruk wtykiety "opis symbol" w nagwku faktury przed pozycjami faktury</td>
<td>
	Struktura rozpoczcia faktury zostaa ju wczeniej omwiona (<a href="#startInvoice">link</a>).
	<BR>Opcje faktury take zostay omwione ( <a href="#invoiceOptions">link</a> )
  </td>
   <td>
   \code{.cpp}
   TestLib::testINVDescriptionOrSymbol
   \endcode
   \image{inline} html ./images/wydruki/testINVDescriptionOrSymbol.png width=70%, height=60%<BR><BR>
  </td>
</tr>

<tr>
<td>Faktura - wydruk numeru pozycji w pozycji faktury</td>
<td>
	Struktura rozpoczcia faktury zostaa ju wczeniej omwiona (<a href="#startInvoice">link</a>).
	<BR>Opcje faktury take zostay omwione ( <a href="#invoiceOptions">link</a> )
  </td>
   <td>
   \code{.cpp}
   TestLib::testINVPositionNumber
   \endcode
   \image{inline} html ./images/wydruki/testINVPositionNumber.png width=70%, height=60%<BR><BR>
  </td>
</tr>

<tr>
<td>Faktura - etykieta "Do zapaty" przed blokiem rozliczenia podatkw</td>
<td>
	Struktura rozpoczcia faktury zostaa ju wczeniej omwiona (<a href="#startInvoice">link</a>).
	<BR>Opcje faktury take zostay omwione ( <a href="#invoiceOptions">link</a> )
  </td>
   <td>
   \code{.cpp}
   TestLib::testINVLabelToPayBeforeSettlement
   \endcode
   \image{inline} html ./images/wydruki/testINVLabelToPayBeforeSettlement.png width=70%, height=60%<BR><BR>
  </td>
</tr>


<tr>
<td>Faktura - wydruk iloci groszy w postaci sownej</td>
<td>
	Struktura rozpoczcia faktury zostaa ju wczeniej omwiona (<a href="#startInvoice">link</a>).
	<BR>Opcje faktury take zostay omwione ( <a href="#invoiceOptions">link</a> )
  </td>
   <td>
   \code{.cpp}
   TestLib::testINVPennyInWords
   \endcode
   \image{inline} html ./images/wydruki/testINVPennyInWords.png width=70%, height=60%<BR><BR>
  </td>
</tr>

<tr>
<td>Faktura - nie drukuj daty sprzeday, jeeli jest taka sama jak data wystawienia faktury</td>
<td>
	Struktura rozpoczcia faktury zostaa ju wczeniej omwiona (<a href="#startInvoice">link</a>).
	<BR>Opcje faktury take zostay omwione ( <a href="#invoiceOptions">link</a> )
  </td>
   <td>
   \code{.cpp}
   TestLib::testINVNoSellDateIfSameDate
   \endcode
   \image{inline} html ./images/wydruki/testINVNoSellDateIfSameDate.png width=70%, height=60%<BR><BR>
  </td>
</tr>

<tr>
<td>Faktura - nie drukuj danych sprzedawcy</td>
<td>
	Struktura rozpoczcia faktury zostaa ju wczeniej omwiona (<a href="#startInvoice">link</a>).
	<BR>Opcje faktury take zostay omwione ( <a href="#invoiceOptions">link</a> )
  </td>
   <td>
   \code{.cpp}
   TestLib::testINVNoSenderInformations
   \endcode
   \image{inline} html ./images/wydruki/testINVNoSenderInformations.png width=70%, height=60%<BR><BR>
  </td>
</tr>


<tr>
<td>Faktura - nie drukuj opisw do pozycji faktury</td>
<td>
	Struktura rozpoczcia faktury zostaa ju wczeniej omwiona (<a href="#startInvoice">link</a>).
	<BR>Opcje faktury take zostay omwione ( <a href="#invoiceOptions">link</a> )
  </td>
   <td>
   \code{.cpp}
   TestLib::testINVNoDescriptionToPositions
   \endcode
   \image{inline} html ./images/wydruki/testINVNoDescriptionToPositions.png width=70%, height=60%<BR><BR>
  </td>
</tr>


<tr>
<td>Faktura - wczona obsuga patnoci</td>
<td>
	Struktura rozpoczcia faktury zostaa ju wczeniej omwiona (<a href="#startInvoice">link</a>).
	<BR>Opcje faktury take zostay omwione ( <a href="#invoiceOptions">link</a> )
  </td>
   <td>
   \code{.cpp}
   TestLib::testINVEnablePaymentMethods
   \endcode
   \image{inline} html ./images/wydruki/testINVEnablePaymentMethods.png width=70%, height=60%<BR><BR>
  </td>
</tr>


<tr>
<td>Faktura - nie drukuj danych odbiorcy</td>
<td>
	Struktura rozpoczcia faktury zostaa ju wczeniej omwiona (<a href="#startInvoice">link</a>).
	<BR>Opcje faktury take zostay omwione ( <a href="#invoiceOptions">link</a> )
  </td>
   <td>
   \code{.cpp}
   TestLib::testINVNoReceiverInformation
   \endcode
   \image{inline} html ./images/wydruki/testINVNoReceiverInformation.png width=70%, height=60%<BR><BR>
  </td>
</tr>


<tr>
<td>Faktura - drukuj napis "Zapacono gotwk"</td>
<td>
	Struktura rozpoczcia faktury zostaa ju wczeniej omwiona (<a href="#startInvoice">link</a>).
	<BR>Opcje faktury take zostay omwione ( <a href="#invoiceOptions">link</a> )
  </td>
   <td>
   \code{.cpp}
   TestLib::testINVPrintCashPaid
   \endcode
   \image{inline} html ./images/wydruki/testINVPrintCashPaid.png width=70%, height=60%<BR><BR>
  </td>
</tr>

<tr>
<td>Faktura - pomi etykiet "Sprzedawca"</td>
<td>
	Struktura rozpoczcia faktury zostaa ju wczeniej omwiona (<a href="#startInvoice">link</a>).
	<BR>Opcje faktury take zostay omwione ( <a href="#invoiceOptions">link</a> )
  </td>
   <td>
   \code{.cpp}
   TestLib::testINVIgnoreSenderLabel
   \endcode
   \image{inline} html ./images/wydruki/TestINVIgnoreSenderLabel.png width=70%, height=60%<BR><BR>
  </td>
</tr>

<tr>
<td> Faktura - pomi etykiet Orygina </td>
<td>
Struktura faktury startowej zostaa ju opisana wczeniej (<a href="#startInvoice"> link </a>).
<BR> Opcje faktur rwnie zostay opisane (<a href="#invoiceOptions"> link </a>)
    </td>
     <td>
     \ code {.cpp}
     TestLib :: testINVIgnoreOriginalLabel
     \ endcode
     <!--
     \ image {inline} html ./images/wydruki/testINVIgnoreOriginalLabel.png width = 70%, height = 60% <BR> <BR>
     -->
    </td>
</tr>

<tr>
<td>Faktura - drukuj etykiet "Faktura VAT"</td>
<td>
	Struktura rozpoczcia faktury zostaa ju wczeniej omwiona (<a href="#startInvoice">link</a>).
	<BR>Opcje faktury take zostay omwione ( <a href="#invoiceOptions">link</a> )
  </td>
   <td>
   \code{.cpp}
   TestLib::testINVInvoiceVAT
   \endcode
   \image{inline} html ./images/wydruki/testINVInvoiceVAT.png width=70%, height=60%<BR><BR>
  </td>
</tr>

<tr>
<td>Faktura kompletna</td>
<td>
	Faktura kompletna skada si z:
	<ul>
	<li>rozpoczcia faktury,</li>
	<li>pozycji faktury,</li>
	<li>zakoczenia faktury,</li>
	<li>opcji faktury,</li>
	</ul>
	<BR>
	Parametr fInvoiceOptions przyjmuje wartoci (0 - brak opcji faktury, 1 - opcje faktury s drukowane).<BR>
	Parametr itemCount okrela iloc pozycji faktury<BR>

  </td>
   <td>
   \code{.cpp}
   TestLib::testINVComplete
   \endcode
   \image{inline} html ./images/wydruki/testINVComplete.png width=70%, height=60%<BR><BR>
  </td>
</tr>

<tr>
<td>Wpata do kasy</td>
<td>
	Aby dokona wpaty do kasy naley wysa funkcj wpaty do kasy.<BR>
	Funkcja ta przyjmuje jako argument struktur CashInOut:
	<ul>
	<li>param: liczba 0..255, gdy 99 - wpata w walucie </li>
	<li>cash: kwota wpaty</li>
	<li>cashNumber: numer kasy, zastpuje podany podczas logowanie kasjera (parametr opcjonalny)</li>
	<li>cashier: nazwa kasjera, zastpuje podany podczas logowanie kasjera (parametr opcjonalny)</li>
	</ul>
  </td>
   <td>
   \code{.cpp}
   TestLib::testCashIn
   \endcode
   \image{inline} html ./images/wydruki/testCashIn.png width=70%, height=60%<BR><BR>
  </td>
</tr>

<tr>
<td>Wypata z kasy</td>
<td>
	Aby dokona wypaty z kasy naley wysa funkcj wypaty z kasy.<BR>
	Funkcja ta przyjmuje jako argument struktur CashInOut:
	<ul>
	<li>param: liczba 0..255, gdy 99 - wypata w walucie </li>
	<li>cash: kwota wpaty</li>
	<li>cashNumber: numer kasy, zastpuje podany podczas logowanie kasjera (parametr opcjonalny)</li>
	<li>cashier: nazwa kasjera, zastpuje podany podczas logowanie kasjera (parametr opcjonalny)</li>
	</ul>
  </td>
   <td>
   \code{.cpp}
   TestLib::testCashOut
   \endcode
   \image{inline} html ./images/wydruki/testCashOut.png width=70%, height=60%<BR><BR>
  </td>
</tr>


<tr>
<th></th>
<th>Status drukarki</th>
<th></th>
</tr>

<tr>
<td>Status DLE</td>
<td>
	Aby odczyta status DLE urzdzenia naley w pierwszej kolejnoci wywoa funkcj dajc odesania statusu DLE.
	<BR>Nastpnie wywoujemy funkcje odczytujc status DLE. Dane odczytywane s do struktury DLEStatus i s to:
	<ul>
	<li>isOnline - warto 1 jeli stan "On-Line" </li>
	<li>isPaperOut - warto 1 jeli "Brak Papieru"</li>
	<li>isPrinterErr -warto 1 jeli "Bd Mechanizmu/Sterownika"</li>
	</ul>
  </td>
   <td>
   \code{.cpp}
   TestLib::statusDLE
   \endcode
  </td>
</tr>

<tr>
<td>Status DLE2</td>
<td>
	Aby odczyta status DLE2 urzdzenia naley w pierwszej kolejnoci wywoa funkcj dajc odesania statusu DLE2.
	<BR>Nastpnie wywoujemy funkcje odczytujc status DLE2. Dane odczytywane s do struktury DLE2Status i s to:
	<ul>
	<li>lastError - ostatni kod bdu,</li>
	<li>lastPrintoutNr - numer ostatniego wydruku,</li>
	<li>lastReceiptNr - numer ostatniego paragonu,</li>
	<li>noPossibilityToProcessOrders - 1 jeli brak moliwoci przetwarzania rozkazw,</li>
	<li>printerDuringDailyReport - 1 jeli drukarka w trakcie wykonywania raportu dobowego,</li>
	<li>syncVerificationOfTheCopyE - 1 jeli trwa synchroniczna weryfikacja kopii e,</li>
	<li>printerWaitsForInteractionWithTheUser - 1 jeli drukarka oczekuje na interakcj z uytkownikiem,</li>
	<li>printerInMenu - 1 jeli drukarka w menu,</li>
	<li>paperOut - 1 jeli brak papieru,</li>
	<li>printMechanismError - 1 jeli bd mechanizmu drukujcego,</li>
	<li>openPrinterCover - 1 jeli otwarta pokrywa drukarki,</li>
	<li>lastCommandError - 1 jeli ostatni rozkaz zakoczony,</li>
	<li>transactionMode - 1 jeli drukarka w trybie transakcji,</li>
	<li>additionalLinesReceiptMode - 1 jeli tryb dodatkowych linii na paragonie,</li>
	<li>duringPrinting - 1 jeli w trakcie wydruku,</li>
	<li>endingPaper - 1 jeli koczcy si papier.</li>
	</ul>
  </td>
   <td>
   \code{.cpp}
   TestLib::statusDLE2
   \endcode
  </td>
</tr>

<tr>
<td>Status ENQ</td>
<td>
	Aby odczyta status ENQ urzdzenia naley w pierwszej kolejnoci wywoa funkcj dajc odesania statusu ENQ.
	<BR>Nastpnie wywoujemy funkcje odczytujc status ENQ. Dane odczytywane s do struktury ENQStatus i s to:
	<ul>
	<li>printerMode - warto 0 gdy drukarka w trybie szkoleniowym, 1 gdy drukarka w trybie fiskalnym </li>
	<li>lastCommandOK - warto 1 gdy ostatni rozkaz wykonany poprawnie </li>
	<li>transactionMode - warto 1 gdy drukarka jest w trybie transakcji</li>
	<li>lastTransactionOK - warto 1 gdy ostatnia transakcja zostaa sfinalizowana poprawnie</li>
	</ul>
 </td>
   <td>
   \code{.cpp}
   TestLib::statusENQ
   \endcode
  </td>
</tr>

<tr>
<td>Status - Informacje kasowe dla trybu 23</td>
<td>
	Aby odczyta status dla paragonw od ostatniego raportu dobowego naley w pierwszej kolejnoci wywoa funkcj dajc odesania statusu.
	<BR>Nastpnie wywoujemy funkcje odczytujc status. Dane odczytywane s do struktury READStatus i s to:
	<ul>
	<li>lastError - kod bdu wykonania poprzedniej sekwencji, 0 jeeli sekwencja wykonana poprawnie lub nie rozpoznana</li>
	<li>fiscal - 0 szkoleniowy tryb pracy, 1 fiskalny tryb pracy</li>
	<li>transaction - 1 drukarka w trybie transakcji</li>
	<li>transactionOK - 1 ostatnia transakcja zostaa zakoczona poprawnie</li>
	<li>resetNumber - ilo zerowa RAM zapisanych w pamici fiskalnej</li>
	<li>Year, Month, Day - data ostatniego zapisu do pamici fiskalnej</li>
	<li>ptuA... ptuG - stawki podatkowe PTU. Jeeli stawka jest zwolniona, to odsyana jako 9899, gdy nieuywana, to jako 9999</li>
	<li>receiptAmount -	ilo wydrukowanych paragonw fiskalnych, licznik jest zerowany w trakcie fiskalizacji i zerowania RAM)</li>
	<li>totalizerA... totalizerG - stany totalizerw dla poszczeglnych stawek PTU (kwoty brutto)</li>
	<li>cash - stan gotwki w kasie</li>
	<li>uniqueNumber - numer unikatowy</li>
	</ul>
	<BR>Odesane informacje o totalizerach zawieraj sumaryczne wartoci od ostatniego raportu dobowego.
 </td>
   <td>
   \code{.cpp}
   TestLib::Status
   \endcode
  </td>
</tr>

<tr>
<td>Informacje kasowe dla ostatniej/biecej transakcji(informacje kasowe tryb 22)</td>
<td>
	Aby odczyta informacje kasowe dla ostatniej/biecej transakcji naley w pierwszej kolejnoci ustawi tryb odsyania totalizerw na dane totalizerw ostatniej/biecej transakcji.
	Uywamy do tego funkcji przyjmujcej struktur TotalizersMode z ustawion wartoci mode na 0.
	<BR>Nastepnie wywoujemy funkcj dajc odesania informacji kasowych dla ostatniej/biecej transakcji.
	<BR>Kolejno wywoujemy funkcje odczytujc informacje kasowe dla ostatniej/biecej transakcji. Dane odczytywane s do struktury READStatus i s to:
	<ul>
	<li>lastError - kod bdu wykonania poprzedniej sekwencji, 0 jeeli sekwencja wykonana poprawnie lub nie rozpoznana</li>
	<li>fiscal - 0 szkoleniowy tryb pracy, 1 fiskalny tryb pracy</li>
	<li>transaction - 1 drukarka w trybie transakcji</li>
	<li>transactionOK - 1 ostatnia transakcja zostaa zakoczona poprawnie</li>
	<li>resetNumber - ilo zerowa RAM zapisanych w pamici fiskalnej</li>
	<li>Year, Month, Day - data ostatniego zapisu do pamici fiskalnej</li>
	<li>ptuA... ptuG - stawki podatkowe PTU. Jeeli stawka jest zwolniona, to odsyana jako 9899, gdy nieuywana, to jako 9999</li>
	<li>receiptAmount -	ilo wydrukowanych paragonw fiskalnych, licznik jest zerowany w trakcie fiskalizacji i zerowania RAM)</li>
	<li>totalizerA... totalizerG - stany totalizerw dla poszczeglnych stawek PTU (kwoty brutto)</li>
	<li>cash - stan gotwki w kasie</li>
	<li>uniqueNumber - numer unikatowy</li>
	</ul>
	<BR>Odesane informacje o totalizerach dotycz ostatniej/biecej transakcji.
 </td>
   <td>
   \code{.cpp}
   TestLib::LastRCPCashInfo
   \endcode
  </td>
</tr>

<tr>
<td>Informacje kasowe dla faktur od ostatniego raportu dobowego(informacje kasowe tryb 22)</td>
<td>
	Aby odczyta informacje kasowe dla faktur od ostatniego raportu dobowego naley w pierwszej kolejnoci ustawi tryb odsyania totalizerw na dane totalizerw faktur od ostatniego raportu dobowego.
	Uywamy do tego funkcji przyjmujcej struktur TotalizersMode z ustawion wartoci mode na 1.
	<BR>Nastepnie wywoujemy funkcj dajc odesania informacji kasowych dla faktur od ostatniego raportu dobowego.
	<BR>Kolejno wywoujemy funkcje odczytujc informacje kasowe dla faktur od ostatniego raportu dobowego. Dane odczytywane s do struktury READStatus i s to:
	<ul>
	<li>lastError - kod bdu wykonania poprzedniej sekwencji, 0 jeeli sekwencja wykonana poprawnie lub nie rozpoznana</li>
	<li>fiscal - 0 szkoleniowy tryb pracy, 1 fiskalny tryb pracy</li>
	<li>transaction - 1 drukarka w trybie transakcji</li>
	<li>transactionOK - 1 ostatnia transakcja zostaa zakoczona poprawnie</li>
	<li>resetNumber - ilo zerowa RAM zapisanych w pamici fiskalnej</li>
	<li>Year, Month, Day - data ostatniego zapisu do pamici fiskalnej</li>
	<li>ptuA... ptuG - stawki podatkowe PTU. Jeeli stawka jest zwolniona, to odsyana jako 9899, gdy nieuywana, to jako 9999</li>
	<li>receiptAmount -	ilo wydrukowanych paragonw fiskalnych, licznik jest zerowany w trakcie fiskalizacji i zerowania RAM)</li>
	<li>totalizerA... totalizerG - stany totalizerw dla poszczeglnych stawek PTU (kwoty brutto)</li>
	<li>cash - stan gotwki w kasie</li>
	<li>uniqueNumber - numer unikatowy</li>
	</ul>
	<BR>Odesane informacje o totalizerach dotycz faktur od ostatniego raportu dobowego.
 </td>
   <td>
   \code{.cpp}
   TestLib::LastINVCashInfo
   \endcode
  </td>
</tr>

<tr>
<td>Typ urzdzenia i wersja oprogramowania</td>
<td>
	Aby odczyta typ urzdzenia i wersje oprogramowania wywoujemy funkcje do tego przeznaczon.
	Dane odczytywane s do struktury PrnVersion i s to:
	<ul>
	<li>DeviceName - nazwa urzdzenia</li>
	<li>DeviceVersion - wersja oprogramowania</li>
	</ul>
 </td>
   <td>
   \code{.cpp}
   TestLib::printerVersion
   \endcode
  </td>
</tr>


<tr>
<td>Tryb obsugi bdw</td>
<td>
	Aby ustawi tryb obsugi bdw uywamy funkcji przyjmujcej struktur ErrorsControl.
	Tryb obsugi wybieramy poprzez ustawienie wartoci mode w tej strukturze:
	<ul>
	<li>0 - wystpienie bdu w trakcie realizacji sekwencji powoduje wywietlenie komunikatu i zatrzymanie
	przetwarzania, a do nacinicia klawisza OK</li>
	<li>1 - wystpienie bdu nie daje komunikatu i nie zawiesza przetwarzania</li>
	<li>2 - wystpienie bdu w trakcie realizacji sekwencji powoduje wywietlenie komunikatu i zatrzymanie
	przetwarzania a do nacinicia klawisza OK. Kod bdu po wykonaniu rozkazu jest automatycznie wysyany do interfejsu</li>
	<li>3 - wystpienie bdu nie daje komunikatu i nie zawiesza przetwarzania. Kod bdu po wykonaniu rozkazu jest automatycznie wysyany do interfejsu</li>
	</ul>
	<BR>Dla trybu 2 i 3 moliwe jest odczytanie automatycznie wysyanego kodu bdu. Uywamy do tego funkcji odczytu odsyajcej strukture ErrorsControl, wywoujc j po funkcji ustawiajacej tryb obsugi bdw na tryb 2 lub 3.
	<BR>Odsyane dane to:
	<ul>
	<li>errorID - kod bdu (2 - bd bajtu kontrolnego, 4 - bd parametru)</li>
	<li>packetID - identyfikator pakietu dla ktrego wystpi bd</li>
	</ul>
 </td>
   <td>
   \code{.cpp}
   TestLib::ErrorsControlMode
   \endcode
  </td>
</tr>

<tr>
<td>Informacje o pamici chronionej</td>
<td>
	Aby odczyta informacje o pamici chronionej w pierwszej kolejnoci wywoujemy funkcje dajac odesania informacji o pamici chronionej.
	<BR>Nastepnie wywoujemy funkcje odczytujc informacje o pamici chronionej. Odczytane dane zapisywane s w strukturze PM i s to:
	<ul>
	<li>PMNumber - numer pamici chronionej w formacie "0001"</li>
	<li>PMlable - etykieta pamici chronionej w formacie "ABC0123456789.0001"</li>
	<li>JPKID - ostatni JPKID </li>
	<li>firstDRNumber - numer pierwszego raportu dobowego w pamici chronionej</li>
	<li>freeSpaceAmount - ilo wolnego miejsca w pamici chronionej</li>
	<li>totalSpaceAmount - ilo oglnie dostpnego miejsca w pamici chronionej</li>
	</ul>
 </td>
   <td>
   \code{.cpp}
   TestLib::PMInfo
   \endcode
  </td>
</tr>

<tr>
<td>Kod bdu ostatniego rozkazu</td>
<td>
	Aby odczyta kod bdu ostatniego rozkazu naley najpierw wywoa funkcje dajc odesanie kodu ostatniego bdu.
	<BR>Nastepnie wywoujemy funkcje odczytujc kod bdu ostatniego rozkazu. Odczytany kod bdu zapisywany jest w strukturze ReadError w polu lastError.
 </td>
   <td>
   \code{.cpp}
   TestLib::DeviceLastError
   \endcode
  </td>
</tr>

<tr>
<td>Data ustawiona na urzdzeniu</td>
<td>
	Aby odczyta date ustawion na urzdzeniu w pierwszej kolejnoci wywoujemy funkcje dajc odesania daty ustawionej na urzdzeniu.
	<BR>Nastepnie wywoujemy funkcje odzcytujc t dat. Odczytana data zapisywana jest w strukturze DeviceTIME w polach:
	<ul>
	<li>year</li>
	<li>month</li>
	<li>day</li>
	<li>hour</li>
	<li>minute</li>
	<li>second</li>
	</ul>
 </td>
   <td>
   \code{.cpp}
   TestLib::DeviceTime
   \endcode
  </td>
</tr>

<tr>
<th></th>
<th>Raporty</th>
<th></th>
</tr>
<tr>
<td>Raport dobowy</td>
<td>
Funkcja drukowania raportu dobowego przyjmuje nastpujce argumenty:
<ul>
<li>cashier - nazwa kasjera (parametr opcjonalny, zatpuje podany podczas logowania kasjera)</li>
<li>cashNumber - numer kasy (parametr opcjonalny, zatpuje podany podczas logowania kasjera)</li>
<li>year - dwie ostatnie cyfry roku</li>
<li>month - dwie ostatnie cyfry miesica</li>
<li>day - dwie ostatnie cyfry dnia</li>
</ul>
<BR>Jeli nie podano obecnej daty to operacja wymaga potwierdzenia z klawiatury drukarki.
<BR>W przypadku braku sprzeday drukarka wysya informacj na wywietlacz "Brak sprzeday!", a nastpnie prosi o potwierdzenie z klawiatury.
</td>
<td>
\code{.cpp}
TestLib::dailyReport
\endcode
\image{inline} html ./images/wydruki/dailyReport.png width=70%, height=60%<BR><BR>
</td>

</tr>
<tr>
<td>Raport kasy/zmiany bez form patnoci</td>
<td>
Funkcja drukowania raportu kasy/zmiany bez form patnoci przyjmuje nastpujce argumenty:
<ul>
<li>type - rodzaj raportu, <BR>0(lub brak): raport zmianowy zerujcy,<BR>23:raport zmianowy niezerujcy</li>
<li>change - napis odpowiadajcy oznaczeniu zmiany</li>
<li>cashier - nazwa kasjera</li>
<li>cashNumber - numer kasy (parametr opcjonalny, zatpuje podany podczas logowania kasjera)</li>
</ul>
</td>
<td>
\code{.cpp}
TestLib::changeReportWithoutPayments
\endcode
\image{inline} html ./images/wydruki/changeReportWithoutpayments.png width=70%, height=60% <BR><BR>
</td>
</tr>

<tr>
<td>Raport kasy/zmiany z formami patnoci (1)</td>
<td>
Funkcja drukowania raportu kasy/zmiany z formami patnoci (1) przyjmuje nastpujce argumenty:
<ul>
<li>change - napis odpowiadajcy oznaczeniu zmiany</li>
<li>cashier - nazwa kasjera</li>
<li>cardName... - nazwa karty numer 1...8, <BR>ilo tych parametrw wynosi 8</li>
<li>chequeName... - nazwa czeku numer 1...8, <BR>ilo tych parametrw wynosi 4</li>
<li>bonName... - nazwa bonu numer 1...8, <BR>ilo tych parametrw wynosi 4</li>
<li>begin - parametr okrelajcy pocztek zmiany</li>
<li>end - parametr okrelajcy koniec zmiany</li>
<li>income - parametr okrelajcy czn sprzeda w trakcie zmiany</li>
<li>cash - parametr okrelajcy warto sprzeday gotwkowej</li>
<li>card... - parametr okrelajcy warto sprzeday dla poszczeglnych kart patnoci</li>
<li>cheque... - parametr okrelajcy warto sprzeday dla poszczeglnych czekw</li>
<li>bon... - parametr okrelajcy warto sprzeday dla poszczeglnych bonw</li>
<li>cashIn - suma wpat do kasy w trakcie zmiany</li>
<li>containersIn - suma kaucji pobranej (za sprzeda opakowania) w trakcie zmiany</li>
<li>cashOut - suma wypat do kasy w trakcie zmiany</li>
<li>containersOut - suma kaucji wydanej (za zwrot opakowania) w trakcie zmiany</li>
<li>cashState - ilo gotwki w kasie po zakoczeniu zmiany</li>
<li>receiptQuantity - ilo paragonw wydrukowanych w trakcie zmiany</li>
<li>abortQuantity - ilo paragonw anulowanych w trakcie zmiany</li>
<li>stornoQuantity - ilo stornowanych pozycji w trakcie zmiany</li>
<li>cashNumber - numer kasy (parametr opcjonalny, zatpuje podany podczas logowania kasjera)</li>
</ul>
</td>
<td>
\code{.cpp}
TestLib::changeReportWithPayments
\endcode
\image{inline} html ./images/wydruki/changeReportWithPayments.png width=70%, height=60%<BR><BR>
</td>
</tr>

<tr>
<td>Raport kasy/zmiany z formami patnoci (2)</td>
<td>
Funkcja drukowania raportu kasy/zmiany z formami patnoci (2) przyjmuje nastpujce argumenty:
<ul>
<li>cashier - nazwa kasjera</li>
<li>tillNumber - numer kasy</li>
<li>change - oznaczenie zmiany</li>
<li>begin - pocztkowa godzina zmiany np 8:00</li>
<li>end - kocowa godzina zmiany</li>
<li>bailInCount - ilo kaucji pobranych(za sprzeda opakowania) z zakresu 0..32</li>
<li>bailOutCount - ilo kaucji wydanych(za zwrot opakowania) z zakresu 0..32</li>
<li>paymentMethodsCount - ilo form patnoci z zakresu 0..16</li>
<li>paymentType1..16 -ilo taka jak w paymentMethodsCount, przyjmuje wartoci:</li>
<ul>
<li>1 - karta</li>
<li>2 - czek</li>
<li>3 - bon</li>
<li>4 - inna</li>
<li>5 - kredyt</li>
<li>6 - z konta klienta</li>
<li>7 - waluta</li>
<li>8 - przelew</li>
</ul>
<li>paymentMethodName1..16 - nazwa patnoci, ilo taka jak w paymentMethodsCount</li>
<li>bailInName1..32 - nazwa kaucji pobranej, ilo taka jak w bailInCount</li>
<li>bailOutName1..32 - nazwa kaucji wydanej, ilo taka jak w bailOutCount</li>
<li>paymentMethod1..16 - warto formy patnoci, ilo taka jak w paymentMethodsCount</li>
<li>bailInSum - suma wartoci wszystkich kaucji pobranej</li>
<li>bailIn1..32 - warto kaucji pobranej, ilo taka jak w bailInCount</li>
<li>bailOutSum - suma wartoci wszystkich kaucji wydanych</li>
<li>bailOut1..32 - warto kaucji wydanej, ilo taka jak w bailOutCount</li>
<li>income - przychd</li>
<li>outcome - rozchd</li>
<li>cash - gotwka</li>
<li>payment - wpata</li>
<li>payout - wypata</li>
<li>receiptCount - ilo paragonw</li>
<li>receiptAbortCount - ilo paragonw anulowanych</li>
<li>stornoCount - ilo storno</li>
<li>tillStatus - stan kasy, ilo gotwki</li>
</ul>
</td>
<td>
\code{.cpp}
TestLib::changeReportWithPayments2
\endcode
</td>
</tr>


<tr>
<td>Raport okresowy z zakresem okrelonym za pomoc dat</td>
<td>
Funkcja drukowania raportu okresowego z zakresem okrelonym za pomoc dat przyjmuje nastpujce argumenty:
<ul>
<li>beginYear - rok pocztkowy zakresu, dwie ostatnie cyfry roku</li>
<li>beginMonth - miesic pocztkowy zakresu</li>
<li>beginDay - dzie pocztkowy zakresu</li>
<li>endYear - rok kocowy zakresu, dwie ostatnie cyfry roku</li>
<li>endMonth - miesic kocowy zakresu</li>
<li>endDay - dzie kocowy zakresu</li>
<li>type - rodzaj raportu:
	<BR>0(lub brak): raport peny (dokument fiskalny) z zakresu podanych dat,
	<BR>1: podsumowanie sprzeday (dokument niefiskalny) z zakresu podanych dat,
	<BR>6: raport miesiczny peny (dokument fiskalny),
	<BR>7: miesiczne podsumowanie sprzeday (dokument niefiskalny),
	<BR>96: raport rozliczeniowy peny z zakresu podanych dat,
	<BR>97: podsumowanie rportu rozliczeniowego z zakresu podanych dat.
</li>
<li>cashier - nazwa kasjera (parametr opcjonalny, zatpuje podany podczas logowania kasjera)</li>
<li>cashNumber - numer kasy (parametr opcjonalny, zatpuje podany podczas logowania kasjera)</li>
</ul>
</td>
<td>
\code{.cpp}
TestLib::periodicReportByDate
\endcode
</td>
</tr>

<tr>
<td>Raport okresowy z zakresem okrelonym za pomoc numerw</td>
<td>
Funkcja drukowania raportu okresowego z zakresem okrelonym za pomoc dat przyjmuje nastpujce argumenty:
<ul>
<li>beginNr - numer pocztkowy zakresu</li>
<li>endNr - numer kocowy zakresu</li>
<li>type - rodzaj raportu:
	<BR>16: raport peny (dokument fiskalny) z zakresu podanych numerw,
	<BR>17: podsumowanie sprzeday (dokument niefiskalny) z zakresu podanych numerw,
	<BR>96: raport rozliczeniowy peny z zakresu podanych numerw,
	<BR>97: podsumowanie rportu rozliczeniowego z zakresu podanych numerw,
	<BR>100: niefiskalny raport odczytu pamici fiskalnej.
</li>
<li>cashier - nazwa kasjera (parametr opcjonalny, zatpuje podany podczas logowania kasjera)</li>
<li>cashNumber - numer kasy (parametr opcjonalny, zatpuje podany podczas logowania kasjera)</li>
</ul>
</td>
<td>
\code{.cpp}
TestLib::periodicReportByNr
\endcode
</td>
</tr>


<tr>
<td>Logowanie kasjera</td>
<td>
Funkcja logowanie kasjera przyjmuje nastpujce argumenty:
<ul>
<li>action - akcja: <BR>(0 lub brak): logowanie kasjera,<BR>1: odczyt zalogowanego kasjera.</li>
<li>cashier - nazwa kasjera </li>
<li>cashNumber - numer kasy </li>
</ul>
</td>
<td>
\code{.cpp}
TestLib::cashierLogin
\endcode
\image{inline} html ./images/wydruki/cashierLogin.png width=70%, height=60%<BR><BR>
</td>
</tr>

<tr>
<td>Wylogowanie kasjera</td>
<td>
Funkcja logowanie kasjera przyjmuje nastpujce argumenty:
<ul>
<li>cashier - nazwa kasjera </li>
<li>cashNumber - numer kasy </li>
</ul>
</td>
<td>
\code{.cpp}
TestLib::cashierLogoff
\endcode
\image{inline} html ./images/wydruki/cashierLogoff.png width=70%, height=60%<BR><BR>
</td>
</tr>


<tr>
<td>Wydruk z pamici chronionej</td>
<td>
Funkcja wydruk z pamici chronionej przyjmuje nastpujce argumenty:
<ul>
<li>type - typ zakresu: 
	<BR>0: zakres wydrukw wedug dat,
	<BR>1: zakres wydrukw wedug numerw,
	<BR>2: wszystko.</li>
<li>printoutFilter - filtr wydrukw: 
	<BR>0: paragony,
	<BR>1: faktury,
	<BR>2: raporty,
	<BR>3: wydruki niefiskalne,
	<BR>4: wszystkie.
</li>
<li>rangeFrom - zakres od (w zalenoci od typu zakresu, gdy typ zakresu 2 - wszystko to wpisujemy 0) </li>
<li>rangeTo - zakres do (w zalenoci od typu zakresu, gdy typ zakresu 2 - wszystko to wpisujemy 0) </li>
</ul>
</td>
<td>
\code{.cpp}
TestLib::printoutFromPM
\endcode
</td>
</tr>

<tr>
<td>Wydruk raportu zapisw w pamici fiskalnej w zakresie dat</td>
<td>
Funkcja wydruk raportu zapisw w pamici fiskalnej w zakresie dat przyjmuje nastpujce argumenty:
<ul>
<li>type - typ zakresu:
	<BR>6: raport szczegowy,
	<BR>7: tylko podsumowanie.
<BR><li>beginDate - data pocztkowa (Format: "RRRR-MM-DD") </li> 
<BR><li>endDate - data kocowa (Format: "RRRR-MM-DD") </li>
<BR><li>options - opcje raportu (liczba heksadecymalna, gdzie kolejny bit oznacza zapisy raportowane opcjonalnie):
	<BR>1: paragony,
	<BR>2: faktury,
	<BR>3: raporty dobowe,
	<BR>4: zmiany stawek,
	<BR>5: rozliczenia ulg (tylko w drukarkach z obsug funkcji bileterki),
</li>
</ul>
</td>
<td>
\code{.cpp}
TestLib::reportOfEntriesInFMByDate
\endcode
</td>
</tr>

<tr>
<td>Wydruk raportu zapisw w pamici fiskalnej w zakresie numerw</td>
<td>
Funkcja wydruk raportu zapisw w pamici fiskalnej w zakresie numerw przyjmuje nastpujce argumenty:
<ul>
<li>type - typ zakresu:
	<BR>4: raport szczegowy,
	<BR>5: tylko podsumowanie.
<li>beginNr - numer pocztkowy</li>
<li>endNr - numer kocowy</li>
<li>options - opcje raportu (liczba heksadecymalna, gdzie kolejny bit oznacza zapisy raportowane opcjonalnie):
	<BR>1: paragony,
	<BR>2: faktury,
	<BR>3: raporty dobowe,
	<BR>4: zmiany stawek,
	<BR>5: rozliczenia ulg (tylko w drukarkach z obsug funkcji bileterki),
</li>
</ul>
</td>
<td>
\code{.cpp}
TestLib::reportOfEntriesInFMByNr
\endcode
</td>
</tr>

<tr>
<td>Wydruk danych dokumentu - JPK</td>
<td>
Funkcja wydruk danych dokumentu - JPK przyjmuje nastpujce argumenty:
<ul>
<li>rangeType - typ zakresu:
	<BR>1: zakres wydrukw wedug dat,
	<BR>2: zakres wydrukw wedug numerw wydrukw,
	<BR>3: zakres wydrukw wedug numerw jpk.
<li>documentType - typ dokumentu,<BR>Wartoci bitowe:
	<BR>1: Raport Fiskalny RF,
	<BR>2: Paragon PR,
	<BR>4: Paragon Anulowany PA,
	<BR>8: Faktura FK,
	<BR>16: Faktura Anulowana FA,
	<BR>32: Raport Dobowy RD,
	<BR>64: Wydruk Niefiskalny WN,
	<BR>128: Zdarzenie ZE,
	<BR>256: Grafika GA,
	<BR>512: Kopia Wydruku,
	<BR>1024: Metadane,
	<BR>4095: Wszystkie Typy ALL.
</li>
<li>rangeFrom - zakres od (w zalenoci od typu zakresu)</li>
<li>rangeTo - zakres do (w zalenoci od typu zakresu)</li>
</ul>
</td>
<td>
\code{.cpp}
TestLib::printoutDataJPK
\endcode
</td>
</tr>

<tr>
<td>Raport z przegldw serwisowych</td>
<td>
Funkcja drukowania raportu z przegladw serwisowych nie przyjmuje argumentw.
</td>
<td>
\code{.cpp}
TestLib::serviceReviewReport
\endcode
</td>
</tr>

<tr>
<td>Przykadowy wydruk niefiskalny</td>
<td>
<b>Aby rozpocz wydruk niefiskalny naley poda nastpujce parametry:</b>
<ul>
<li>printOutNumber - numer wydruku(Akceptowane numery wymienione s w specyfikacji wydrukw zamieszczonej w opisie protokou komunikacyjnego.)</li>
<li>headerNumber - numer nagwka (0, gdy wydruk ma tylko jeden rodzaj nagwka)</li>
<li>printOutOption - opcje wydruku, gdzie kolejne bity oznaczaj:
	<BR>	1: lewy margines na wydruku,
	<BR>	2: bez wydruku na papierze,
	<BR>	3: bez wydruku tekstu nagwka,
	<BR>	4: bez wydruku marginesw "NIEFISKALNY".
</li>
</ul>
<b>Aby doda lini wydruku naley poda nastpujce parametry:</b>
<ul>
<li>printOutNumber - numer wydruku, gdy wynosi 254 to w linii bdzie drukowany kod kreskowy</li>
<li>lineNumber - numer linii:
		<BR>	249: linia bdzie QR kodem,
		<BR>	255: linia bdzie pusta,
		<BR>	254: linia bdzie podkreleniem,
		<BR>	253: linia bdzie numer ostatniego paragonu,
		<BR>	250: linia bdzie grafik (w 1 argumencie podajemy indeks grafiki).
</li>
<li>textBoldFormat - formatowanie tekstu, Parametr opcjonalny, 1: tekst pogrubiony (zmniejsza o poow ilo znakw mieszczcych si w linii)</li>
<li>textInversFormat - formatowanie tekstu, 1: tekst invers</li>
<li>font - formatowanie tekstu:
		<BR>	0: czcionka podstawowa,
		<BR>	1: czcionka 2,
		<BR>	2: czcionka 3 (maa).
</li>
<li>textCenterFormat - formatowanie tekstu, 0:brak wycentrowania, 1: wycentrowanie</li>
<li>fontAtributes - atrybuty czcionki ustawiane na bitach:
		<BR>	1: czcionka powikszona (zmniejszona o poow ilo znakw w linii),
		<BR>	2: czcionka podwyszona,
		<BR>	3: czcionka poszerzona (zmniejszona o poow ilo znakw w linii),
		<BR>	4: inwers,
		<BR>	5: czcionka podwyszona 4x,
		<BR>	6: czcionka poszerzona 4x.
</li>
<li>line... - dowolny cig znakw, argument opcjonalny, ilo maksymalnie 8 linii.</li>
</li>
</ul>
<b>Aby zakoczy wydruk niefiskalny naley poda nastpujce parametry:</b>
<ul>
<li>printOutNumber - numer wydruku, gdy 255 to wysanie tej sekwencji przed dowolnym wydrukiem niefiskalnym</li>
		spowoduje wydrukowanie po nim numeru systemowego oraz dodatkowych linii</li>
<li>isSystemNumber - wystpuje numer systemowy, 0: NIE, 1: TAK</li>
<li>additionalLineNumber - ilo linii dodatkowych</li>
<li>systemNumber - numer systemowy, argument opcjonalny</li>
<li>additionalLine1 - linia dodatkowa nr 1, argument opcjonalny</li>
<li>additionalLine2 - linia dodatkowa nr 2, argument opcjonalny</li>
<li>additionalLine3 - linia dodatkowa nr 3, argument opcjonalny</li>
</ul>
</td>
<td>
\code{.cpp}
TestLib::nonFiscalPrintout
\endcode
\image{inline} html ./images/wydruki/nonFiscalPrintout.png width=70%, height=60%<BR><BR> 
</td>
</tr>

<tr>
<td>Przykad odczytu informacji o urzdzeniu.</td>
<td>
<b>Aby odczytac informacje o urzdzeniu naley najpierw wywoa funkcje adajc odesania informacji. Dla funkcji tej ustawiamy parametr:</b>
<ul>
<li>infoType - typ informacji:
		<BR> 0  Informacje oglne,
		<BR> 1  Informacje szczegowe dla pamici fiskalnej,
		<BR> 2 - Szczegy dotyczce stanu zasilania , akumulatora i baterii,
		<BR> 4  Stan wydruku,
		<BR> 5  Stan szuflady,
		<BR> 6  Informacje o stanie pamici podrcznej,
		<BR> 7  Informacje szczegowe dla pamici fiskalnej wersja 3,
		<BR> 8  Informacje dodatkowe dla pamici fiskalnej wersja 4,
		<BR> 10  Informacje szczegowe dla pamici fiskalnej wersja 2,
		<BR> 20  Stan akumulatora i zasilania,
</ul>
<b>Nastpnie wywoujemy funkcje odczytujc informacje w zalenoci od wybranego typu informacji.</b><BR>
<BR><b>Informacje odczytywane s odpowiednio do struktur:</b><BR>
<BR><b>1. Dla informacji oglnych DeviceGeneralInfo:</b>
<ul>
	<li>deviceName - nazwa urzdzenia,</li>
	<li>programVersion - wersja programu,</li>
	<li>printingModuleVersion - wersja moduu drukujcego,</li>
	<li>systemName - nazwa systemu,</li>
	<li>systemVersion - wersja systemu,</li>
	<li>numberOfDisplays - liczba wywietlaczy,</li>
	<li>printWidth - szeroko wydruku - maksymalna liczba znakw w linii,</li>
	<li>electronicCopy - kopia elektroniczna, 0 - brak dla Online,</li>
	<li>fiscalMemorySize - rozmiar pamici fiskalnej</li>
</ul>

<BR><b>2. Dla informacji szczegowych dla pamici fiskalnej DetailedForFMInfo:</b>
<ul>
	<li>FMSize - rozmiar pamici fiskalnej(w bajtach),</li>
	<li>recordSize - rozmiar rekordu(w bajtach),</li>
	<li>operatingMode - tryb dziaania:
	<BR>0 - niefiskalny
	<BR>1 - fiskalny,
	</li>
	<li>uniqueNumber - numer unikatowy,</li>
	<li>NIP - numer NIP,</li>
	<li>maxNumberOfRecords - maksymalna liczba rekordw,</li>
	<li>numberOfRecords - liczba rekordw,</li>
	<li>maxNumberOfDailyReports - maksymalna liczba raportw dobowych</li>
	<li>numberOfDailyReports - liczba raportw dobowych</li>
	<li>maxNumberOfRAMResets - maksymalna liczba zerowa RAM</li>
	<li>numebrOfRAMResets - liczba zerowa RAM</li>
	<li>maxNumberOfPTUChanges - maksymalna liczba zmian stawek PTU</li>
	<li>numberOfPTUChanges - liczba zmian stawek PTU</li>
	<li>maxNumberOfCurrencyChanges -  maksymalna liczba zmian waluty</li>
	<li>numberOfCurrencyChanges - liczba zmian waluty</li>
	<li>dateOfFiscalisation - data fiskalizacji(Format: RRRR-MM-DD GG:MM:SS)</li>
	<li>dateOfClosingFiscalMode - data zamknicia trybu fiskalnego(Format: RRRR-MM-DD GG:MM:SS)</li>
	<li>currentCurrencyName - nazwa biecej waluty</li>
</ul>

<BR><b>3. Dla informacji dotyczcych stanu zasilania, baterii i akumulatora DetailedAboutPower:</b>
<ul>
	<li>powerSupplyConnected - podczony zasilacz,</li>
	<li>powerSupplyVoltage - napicie zasilacza,</li>
	<li>accumulatorVoltage - napicie akumulatora,</li>
	<li>batteryVlotage - napicie bateryjki</li>
</ul>

<BR><b>4. Dla informacji o stanie wydruku PrintoutStatusInfo:</b>
<ul>
	<li>printoutModuleVersion - wersja moduu drukujcego,</li>
	<li>printoutMaxNumberOfSigns - szeroko wydruku w znakach,</li>
	<li>printoutWidth - szeroko wydruku:
	<BR>0 - 57[mm]
	<BR>1 - 80[mm],
	</li>
	<li>font - czcionka:
	<BR>0 - normalna
	<BR>1 - powiekszona,
	</li>
	<li>paperCutter - obcinacz papieru:
	<BR>0 - wyczony
	<BR>1 - wczony
	<BR>2 - brak,
	</li>
	<li>amountOfPaper - ilo papieru:
	<BR>0 - poniej poziomu krytycznego
	<BR>1 - powyej poziomu krytycznego
	<BR>2 - nie obsugiwane,
	</li>
</ul>

<BR><b>5. Dla informacji o stanie szuflady DrawerState:</b>
<ul>
	<li>drawerState - stan szuflady:
	<BR>0 - otwarta
	<BR>1 - zamknita
	<BR>2 - nie obsugiwane,
	</li>
</ul>

<BR><b>6. Dla informacji o stanie pamici podrcznej CacheInfo:</b>
<ul>
	<li>fullByteSize - rozmiar cakowity w bajtach,</li>
	<li>fullPrintoutLinesSize - rozmiar cakowity w liniach wydruku,</li>
	<li>criticalByteSize - rozmiar krytyczny w bajtach,</li>
	<li>criticalPrintoutLinesSize - rozmiar krytyczny w liniach wydruku,</li>
	<li>occupiedSize - rozmiar zajty w bajtach,</li>
	<li>occupiedPrintoutLinesSize - rozmiar zajty w liniach wydruku,</li>
</ul>

<BR><b>7. Dla informacji o stanie bazy towarw StateOfGoodsBase:</b>
<ul>
	<li>goodsQuantity - ilo towarw w bazie</li>
</ul>

<BR><b>8. Dla informacji szczegowych dla pamici fiskalnej wersja 2 DeviceFMInfoVersion2:</b>
<ul>
	<li>FMSize - rozmiar pamici fiskalnej(w bajtach),</li>
	<li>recordSize - rozmiar rekordu(w bajtach),</li>
	<li>operatingMode - tryb dziaania:
	<BR>0 - niefiskalny
	<BR>1 - fiskalny
	<BR>2 - fiskalny zamknity,
	</li>
	<li>uniqueNumber - numer unikatowy,</li>
	<li>NIP - numer NIP,</li>
	<li>maxNumberOfRecords - maksymalna liczba rekordw,</li>
	<li>numberOfRecords - liczba rekordw,</li>
	<li>maxNumberOfDailyReports - maksymalna liczba raportw dobowych</li>
	<li>numberOfDailyReports - liczba raportw dobowych</li>
	<li>maxNumberOfRAMResets - maksymalna liczba zerowa RAM</li>
	<li>numebrOfRAMResets - liczba zerowa RAM</li>
	<li>maxNumberOfPTUChanges - maksymalna liczba zmian stawek PTU</li>
	<li>numberOfPTUChanges - liczba zmian stawek PTU</li>
	<li>maxNumberOfCurrencyChanges -  maksymalna liczba zmian waluty</li>
	<li>numberOfCurrencyChanges - liczba zmian waluty</li>
	<li>dateOfFiscalisation - data fiskalizacji(Format: RRRR-MM-DD GG:MM:SS)</li>
	<li>dateOfClosingFiscalMode - data zamknicia trybu fiskalnego(Format: RRRR-MM-DD GG:MM:SS)</li>
	<li>currentCurrencyName - nazwa biecej waluty</li>
	<li>lastDailyReportDate - data ostatniego raportu dobowego(Format: RRRR-MM-DD GG:MM:SS)</li>
	<li>lastFMRecordDate - data ostatniego zapisu do pamici fiskalnej(Format: RRRR-MM-DD GG:MM:SS)</li>
</ul>

<BR><b>9. Dla informacji szczegowych dla pamici fiskalnej wersja 3 DeviceFMInfoVersion3:</b>
<ul>
	<li>numberOfGeneralEvents - liczba zdarze oglnych,</li>
	<li>maxNumberOfGeneralEvents - maksymalna liczba zdarze oglnych,</li>
	<li>numberOfFiscalDocs - liczba dokumentw fiskalnych:
	<BR>-paragony
	<BR>-paragony anulowane
	<BR>-faktury
	<BR>-faktury anulowane,
	</li>
	<li>maxNumberOfFiscalDocs - maksymalna liczba dokumentw fiskalnych,</li>
	<li>numberOfPublicKeyChanges - liczba zmian klucza publicznego,</li>
	<li>numberOfDiscountRatesChanges - liczba zmian tablicy stawek ulg,</li>
	<li>numberOfDiscountGroupsChanges - liczba zmian grup ulg,</li>
	<li>numberOfServicesInspection - liczba przegldw serwisowych,</li>
	<li>eventsDataSize - rozmiar danych zdarze w bajtach,</li>
	<li>maxEventsDataSize - maksymalny rozmiar danych zdarze w bajtach,</li>
	<li>registrationNumber - numer ewidencyjny</li>
</ul>

<BR><b>10. Dla informacji szczegowych dla pamici fiskalnej wersja 4 DeviceFMInfoVersion4:</b>
<ul>
	<li>numberOfRecords - liczba zapisw,</li>
	<li>maxNumberOfRecords - maksymalna liczba zapisw,</li>
	<li>numberOfDiscountRatesChanges - liczba zmian stawek ulg,</li>
	<li>numberOfDiscountGroupsChanges - liczba zmian grup ulg,</li>
	<li>numberOfServicesInspection - liczba przegldw serwisowych,</li>
	<li>maxNumberOfServicesInspection - maksymalna liczba przegldw serwisowych,</li>
	<li>dataSize - rozmiar zapisanych danych,</li>
	<li>maxDataSize - maksymalny rozmiar zapisanych danych,</li>
	<li>producerOptions - opcje producenta:
	<BR>Bit 1  obsuga funkcji aptecznych
	<BR>Bit 2  obsuga funkcji bileterki,</li>
</ul>

<BR><b>11. Dla informacji o stanie akumulatora i zasilaniu PowerSupplyInfo:</b>
<ul>
	<li>powerSupplyMode - tryb zasilania:
	<BR>0 - praca na akumulatorze
	<BR>1 - praca na zasilaczu,
	</li>
	<li>powerSupplyVoltage - napicie zasilacza[mV],</li>
	<li>accumulatorVoltage - napicie akumulatora[mV],</li>
	<li>batteryVoltage - napicie baterii do podtrzymywania RAM/Zegara,</li>
	<li>accumulatorState - stan akumulatora:
	<BR>0  cakiem rozadowany
	<BR>1  niski poziom naadowania
	<BR>2  naadowany i dziaa poprawnie
	<BR>3  adowanie akumulatora
	<BR>4  napicie akumulatora poza zakresem
	<BR>5- akumulator uszkodzony,
	</li>
	<li>batteryStatus - status baterii podtrzymujcej RAM/Zegar:
	<BR>0  rozadowana / uszkodzona
	<BR>1  kwalifikuje si do naadowania
	<BR>2 - Stan baterii dobry,
	</li>
	<li>accumulatorLevel - poziom naadowania akumulatora,</li>
</ul>

<BR><b>11. Dla informacji o fiscalizacji FiscalizationInfo:</b>
<ul>
	<li>status - status:
	<BR>0 - niefiskalna,
	<BR>1 - fiskalna,
	<BR>2 - tryb "tylko odczyt",
	</li>
	<li>fiscalizationDate - data fiskalizacji, format: RRRR-MM-DD GG:MM:SS,</li>
	<li>nip - numer nip,</li>
	<li>registrationNumber - numer ewidencyjny,</li>
	<li>PMId - Identyfikator pamici chronionej,</li>
	<li>deviceType - typ urzdzenia:
	<BR>0  Oglna,
	<BR>1  Takswkowa,
	<BR>2  Apteczna,
	<BR>3  Biletowa,
	<BR>4  Gastronomiczna,
	<BR>5 - Automaty,
	<BR>6 - Wolnocowa,
	</li>
	<li>numberingType - typ numeracji paragonw:
	<BR>0  Globalny,
	<BR>1  Dobowy,
	</li>
	<li>ownershipType - typ wasnoci:
	<BR>0  Wasna,
	<BR>1  Dzierawiona,
	<BR>2  Leasing,
	<BR>3  Wynajem,
	<BR>4  Inny,
	</li>
</ul>


</td>
<td>
\code{.cpp}
TestLib::testReadGeneralDeviceInfo
TestLib::testReadDetailedForFMInfo
TestLib::testReadDetailedAboutPower
TestLib::testReadPrintoutStatusInfo
TestLib::testReadDrawerState
TestLib::testReadCacheInfo
TestLib::testReadStateOfGoodsBase
TestLib::testReadDeviceFMInfoVersion2
TestLib::testReadDeviceFMInfoVersion3
TestLib::testReadDeviceFMInfoVersion4
TestLib::testReadPowerSupplyInfo
TestLib::testReadFiscalizationInfo
\endcode
</td>
</tr>

<tr>
<td>Przykad odczytu pamici fiskalnej w trybie rekordowym</td>
<td>
<b>Aby ustawi zdarzenie pocztkowe i kocowe wedug dat naley poda nastepujce parametry:</b>
<ul>
<li>startDate - data pocztkowa(Format: RRRR-MM-DD)</li>
<li>endDate -  data kocowa(Format: RRRR-MM-DD)</li>
</ul>
<b>Nastpnie wywoujemy funkcje ustawiajc dat poczatkow i kocow na urzdzeniu.</b><BR>
<BR><b>Aby ustawi zdarzenie pocztkowe i kocowe wedug numerw naley poda nastepujce parametry:</b>
<ul>
<li>startNumber - numer pocztkowy</li>
<li>endNumber -  numer kocowy</li>
</ul>
<b>Aby ustawi numer kocowy na ostatni rekord z pamici, najpierw odczytujemy informacje o urzdzeniu dla pamici fisklanej(wersja 4). Odczyt tych informacji zosta juz opisany powyej w dokumentacji(Przykad odczytu informacji o urzdzeniu)</b><BR>
<BR><b>Nastpnie wywoujemy funkcje ustawiajc numer poczatkowy i kocowy na urzdzeniu.</b></b>

<BR><b>Aby odczyta biecy rekord z pamici fiskalnej, naley w pierwszej kolejnoci wywoa funkcj dajc odesania biezcego rekordu.</b><BR>
<BR><b>Nastpnie wywoujemy funkcje odczytujc biecy rekord. Dane odczytywane s do struktury FMReadRecord i s to:</b>
<ul>
	<li>recordNumber - numer rekordu,</li>
	<li>recordID - identyfikator rekordu:
		<BR> 1 Raport dobowy,
		<BR> 2 Zerowanie RAM,
		<BR> 3 Zerowanie bazy towarw,
		<BR> 4 Stawki VAT,
		<BR> 7 Reset,
		<BR> 11 Ustawienie zmiany waluty,
		<BR> 12 Zmiana waluty,
		<BR> 16 Dane producenta,
		<BR> 17 Fiskalizacja,
		<BR> 18 Zakoczenie trybu fiskalnego,
		<BR> 19 Dane aplikacji,
		<BR> 20 Paragon,
		<BR> 21 Anulowanie paragonu,
		<BR> 22 Faktura,
		<BR> 23 Anulowanie faktury,
		<BR> 24 Tablica stawek zniek,
		<BR> 25 Tablica grup zniek,
		<BR> 26 Rozliczenie zniek,
		<BR> 27 Zmiana daty/czasu,
		<BR> 28 Adres serwera repozytorium,
		<BR> 29 Interwencja serwisowa,
		<BR> 30 Zmiana pamici chronionej,
		<BR> 31 Adres serwera aktualizacji aplikacji,
		<BR> 32 Klucz,
		<BR> 33 Bd pamici chronionej,
		<BR> 34 Awaria zasilania,
		<BR> 35 Blokada sprzeday,
		<BR> 36 Bd aktualizacji aplikacji,
		<BR> 37 Bd licznika wydrukw,
		<BR> 38 Dane aplikacji pamici fiskalnej,
		<BR> 39 Zmiana aplikacji,
		<BR> 40 Przegld serwisowy,
		<BR> 41 Tryb ONLINE aktywny,
		<BR> 42 Tryb ONLINE nieaktywny,
		<BR> 43 Klucz publiczny kasy,
		<BR> 44 Certyfikat repozytorium,
		<BR> 45 Odblokowanie sprzeday,
		<BR> 46 Adres punktu sprzeday,
		<BR> 47 Parametr oglny,
		<BR> 48 Nagwek wydrukw,
		<BR> 49 Certyfikat SSL
</li>
	<li>fullDataSiza - cakowity rozmiar danych w reprezentacji binarnej,</li>
	<li>data - dane w postaci heksadecymalnej-tekstowe,</li>
	</ul>
</td>
<td>
\code{.cpp}
TestLib::ReadFiscalMemoryRecordsByDate
TestLib::ReadFiscalMemoryRecordsByNumber
\endcode
</td>
</tr>

<tr>
<td>Przykad odczytu pamici chronionej trybie dokumentowym</td>
<td>
<b>W pierwszej kolejnoi odczytujemy informacje o pamici chronionej. Odczyt informacji o pamici chronionej zosta ju opisany powyej w dokumentacji.</b><BR>
<BR><b>Aby odczyta dokument z pamici chronionej nalezy podac parametry:</b>
<ul>
<li>state - stan: 
<BR>0  wyszukaj,
<BR>1  podaj kolejne dane
</li>
<li>JPK_ID -  jpk ID</li>
<li>IDZ - czy z IDZ</li>
<li>content -  zawarto:
<BR>0 - jpk,
<BR>1-kopia wydruku, <BR>2 - metadane
<BR>Uwaga! Gdy danie odesania kopii, metadanych ignorowany jest pole Typ dokumentu.
</li>
<li>docType - typ dokumentu( wartoci bitowe):
<BR>1 -Raport Fiskalny RF
<BR>2 -Paragon PR
<BR>4 -Paragon Anulowany PA
<BR>8 -Faktura FK
<BR>16 -Faktura Anulowana FA
<BR>32 -Raport Dobowy RD
<BR>64 -Wydruk Niefiskalny WN
<BR>128 -Zdarzenie ZE
</li>
</ul>
<b>Nastpnie wywoujemy funkcje dajc odesania imformacji o bieacym dokumencie i funkcje odczytujc te informacje.<BR>Dane zostaj zapisane w strukturze JPKDocRead i s to:</b><BR>
<ul>
<li>status - status:
<BR> 0 wysyanie danych, 
<BR> 1 koniec danych, 
<BR> 2 brak danych(w przypadku zapytania o kopi wydruku dokumentu lub metadane),
<BR> 9 -bd</li>
<li>docType -  typ dokumentu( takie jak wyej )</li>
<li>size - rozmiar w bajtach (przed konwersj)</li>
<li>position - pozycja w bajtach (przed konwersj)</li>
<li>JPK_ID - numer JPK_ID odsyanego dokumentu</li>
<li>buyerCode - kod nabywcy, jeeli do danego dokumentu przypisany kod nabywcy, to wysyany jest w tym polu</li>
<li>data - dane skonwertowane  w formacie : 
<BR>- Spakowane algorytmem DEFLATE,
<BR>- Zakodowane algorytmem Base64URL 
</li>
</ul>
</td>
<td>
\code{.cpp}
TestLib::ReadProtectedMemoryRecords
\endcode
</td>
</tr>

<tr>
<td>Przykad odczytu informacji o adresach serwerw</td>
<td>
<b>Aby odczyta informacji o adresach serwerw naley poda parametr:</b>
<ul>
<li>type - typ serwera:
<BR>1  serwer cpd,
<BR>2  serwer WebApi,
</li>
</ul>
<b>Nastpnie wywoujemy funkcje dajc odesania imformacji o adresach serwerw i funkcje odczytujc te informacje.<BR>Dane zostaj zapisane w strukturze ServerInfo i s to:</b><BR>
<ul>
<li>type - typ serwera:
<BR>1  serwer cpd,
<BR>2  serwer WebApi,
</li>
<li>serverAdress - adres serwera</li>
</ul>
</td>
<td>
\code{.cpp}
TestLib::testReadServerInfo
\endcode
</td>
</tr>


<tr>
<td>Przykad odczytu statusu ostatniego ePragonu</td>
<td>
<b>Wywoujemy funkcje dajc odesania imformacji statusie ostatniego eParagonu i funkcje odczytujc te informacje.<BR>Dane zostaj zapisane w strukturze EreceiptStatus i s to:</b><BR>
<ul>
<li>status - status eparagonu:
<BR>0  status nieznany,
<BR>1  wysano eParagon,
<BR>2  wydrukowano paragon,
<BR>4  dodano do pniejszego wysania,
<BR>6  paragon zosta wydrukowany i dodany do wysania,
<BR>10  paragon zosta wydrukowany ale wymagane jest pobranie nowego numeru kid,
</li>
<li>printoutNumber - numer wydruku</li>
</ul>
</td>
<td>
\code{.cpp}
TestLib::testReadLastEreceiptStatus
\endcode
</td>
</tr>

<tr>
<td>Przykad odczytu daty blokady serwisowej</td>
<td>
<b>Wywoujemy funkcje dajc odesania imformacji statusie ostatniego eParagonu i funkcje odczytujc te informacje.<BR>Dane zostaj zapisane w strukturze ServiceLock i s to:</b><BR>
<ul>
<li>year - rok,
</li>
<li>month - miesic,
</li>
<li>day - dzie,
</li>
<li>password - haso, jeeli jest puste, to blokada serwisowa zostaje usunita,
</li>
<li>text - numer telefoniczny punktu serwisowego, nadmiarowe znaki s ucinane,
</li>
</ul>
</td>
<td>
\code{.cpp}
TestLib::testReadServiceLockDate
\endcode
</td>
</tr>


<tr>
<th></th>
<th>Kontrola</th>
<th></th>
</tr>

<tr>
<td>Wejcie do menu</td>
<td>
<BR><b>Wywoujemy funkcje wejcia do menu</b><BR>
<td>
\code{.cpp}
TestLib::testDisplayMenu
\endcode
</td>
</tr>

<tr>
<td>Przykad wysunicia papieru</td>
<td>
<b>Aby dokona wysunicia papieru naley poda parametr:</b>
<ul>
<li>linesAmount - liczba linii do wysunicia</li>
</ul>
<BR><b>Nastpenie wywoujemy funkcje wysunicia papieru</b><BR>
<td>
\code{.cpp}
TestLib::testPaperEjection
\endcode
</td>
</tr>

<tr>
<td>Przykad odczytu konfiguracji USB</td>
<td>
<b>Wywoujemy funkcje dajc odesania imformacji o konfiguracji USB i funkcje odczytujc te informacje.<BR>Dane zostaj zapisane w strukturze USBConfig i s to:</b><BR>
<ul>
<li>usbModemPid - Usb Modem Pid:
</li>
<li>usbExtPid - Usb Ext Pid,
</li>
<li>usbModemVid - Usb Modem Vid:
</li>
<li>usbExtVid - Usb Ext Vid,
</li>
<li>usbModemType - Usb Modem Typ:
<BR>0  Acmx,
<BR>1  USBx,
</li>
<li>usbExtType - Usb Ext Typ:
<BR>0  Acmx,
<BR>1  USBx,
</li>
<li>usbModemInterface - Usb Modem Interfejs:
</li>
<li>usbExternInterface - Usb Ext Interfejs,
</li>
<li>usbModemProtocol - Usb Modem Protok:
</li>
<li>usbExternProtocol - Usb Ext Protok,
</li>
</ul>
</td>
<td>
\code{.cpp}
TestLib::testReadUSBConfig
\endcode
</td>
</tr>

<tr>
<td>Przykad programowania konfiguracji USB</td>
<td>
<b>Aby zaprogramowa konfiguracje USB naley poda parametry:</b>
<ul>
<li>action - akcja:
<BR>0  ustawienie konfiguracji USB,
<BR>1  kasowanie konfiguracji USB,
</li>
<li>usbModemPid - Usb Modem Pid:
</li>
<li>usbExtPid - Usb Ext Pid,
</li>
<li>usbModemVid - Usb Modem Vid:
</li>
<li>usbExtVid - Usb Ext Vid,
</li>
<li>usbModemType - Usb Modem Typ:
<BR>0  Acmx,
<BR>1  USBx,
</li>
<li>usbExtType - Usb Ext Typ:
<BR>0  Acmx,
<BR>1  USBx,
</li>
<li>usbModemInterface - Usb Modem Interfejs:
</li>
<li>usbExternInterface - Usb Ext Interfejs,
</li>
<li>usbModemProtocol - Usb Modem Protok:
</li>
<li>usbExternProtocol - Usb Ext Protok,
</li>
</ul>
<BR><b>Nastpnie wywoujemy funkcje programowania konfiguracji USB</b><BR>
</td>
<td>
\code{.cpp}
TestLib::testSendUsbConfig
\endcode
</td>
</tr>


<tr>
<td>Przykad programowania zmiany waluty.</td>
<td>
<b>Aby zaprogramowa zmien waluty naley poda parametry:</b>
<ul>
<li>year - rok</li>
<li>month - miesic</li>
<li>day - dzie</li>
<li>hour - godzina</li>
<li>minute - minuta</li>
<li>second - sekunda</li>
<li>currencyName - nazwa waluty,
</li>
<li>exchangeRate - kurs wymiany,
</li>
</ul>
<BR><b>Nastpnie wywoujemy funkcje programowania zmiany waluty</b><BR>
</td>
<td>
\code{.cpp}
TestLib::testCurrencyChange
\endcode
</td>
</tr>


<tr>
<td>Przykad odczytu moliwoci sprzeday.</td>
<td>
<b>Aby odczyta informacji o moliwoci sprzeday naley poda parametry:</b>
<ul>
<li>itemName - nazwa towaru,</li>
<li>PTU - stawka VAT,</li>
</ul>
<BR><b>Wywoujemy funkcje dajc odesania imformacji moliwoci sprzeday i funkcje odczytujc te informacje.<BR>Dane zostaj zapisane w strukturze SalePossibility i s to:</b><BR>
<ul>
<li>result - rezultat:
<BR>0  towar zablokowany,
<BR>1  towar niezablokowany,
</li>
<li>PTU - stawka PTU</li>
</ul>
</td>
<td>
\code{.cpp}
TestLib::testReadSalePossibility
\endcode
</td>
</tr>

<tr>
<td>Przykad wysunicia papieru.</td>
<td>
<b>Aby wykona wysuw papieru naley poda parametry:</b>
<ul>
<li>linesAmount - liczba linii,</li>
</ul>
<BR><b>Wywoujemy funkcje dajc wysunicia papieru o okrelon liczb linii.</b><BR>
</td>
<td>
\code{.cpp}
TestLib::testReadSalePossibility
\endcode
</td>
</tr>


<tr>
<td>Przykad wykonania kontroli bazy towarw.</td>
<td>
<b>Aby wykona kontrole bazy towarw naley poda parametry:</b>
<ul>
<li>action - akcja:
<BR>0 - pocztek testu,
<BR>1 - wysanie rekordu danych,
<BR>2 - koniec testu
</li>
<li>name - nazwa towaru(gdy akcja = 1)</li>
<li>PTU - stawka VAT(gdy akcja = 1)</li>
<li>cashier - nazwa kasjera(parametr opcjonalny gdy akcja = 2)</li>
<li>cashNumber - numer kasy(parametr opcjonalny gdy akcja = 2)</li>
</ul>
<BR><b>Nastpnie wywoujemy funkcje odpowiednio dla rozpoczcia kontroli, wysnia zapytania o towar oraz zakoczenia kontroli.</b><BR>
</td>
<td>
\code{.cpp}
TestLib::testPrintDatabaseControl
\endcode
</td>
</tr>


<tr>
<td>Przykad programowania trybu przeliczenia do waluty obcej</td>
<td>
<b>Aby zaprogramowa tryb przeliczenia do waluty obcej naley poda parametry:</b>
<ul>
<li>year - rok</li>
<li>month - miesic</li>
<li>day - dzie</li>
<li>hour - godzina</li>
<li>minute - minuta</li>
<li>second - sekunda</li>
<li>currencyName - nazwa waluty,
</li>
<li>exchangeRate - kurs wymiany,
</li>
<li>printoutMode - tryb wydruku,
</li>
</ul>
<BR><b>Nastpnie wywoujemy funkcje programowania  trybu przeliczenia do waluty obcej.</b><BR>
</td>
<td>
\code{.cpp}
TestLib::testRecountPrintMode
\endcode
</td>
</tr>



<tr>
<th></th>
<th>E-dokumenty</th>
<th></th>
</tr>

<tr>
<td>Przykad programowania i odczytu konfiguracji dla eDokumentw - wersja podstawowa</td>
<td>
<b>Aby zaprogramowa konfiguracj eDokumentw naley poda parametry:</b>
<ul>
<li>addres - adres serwera</li>
<li>encryption - szyfrowanie:
<BR>0 - nie,
<BR>1 - tak,
<li>format - format danych:
<BR>0 - Dane,
<BR>1 - Obraz + dane,
</li>
<li>protocol - protok:
<BR>0 - NOVITUS,
<BR>1 - MF,
</li>
<li>key - klucz do komunikacji z serwerem</li>
</ul>
<BR><b>Nastpnie wywoujemy funkcje programowania konfiguracji eDokumentw.</b><BR>

<b>Aby odczyta konfiguracje eDokumentw, naley poda parametr:</b>
<ul>
<li>type - typ ustawie:
<BR>0 - podstawowe dane ustawie,
<BR>1 - rozszerzone dane ustawie,
<BR>2 - rozszerzone dane ustawie + ustawienia z serwera producenta,
<BR>3 - rozszerzone dane ustawie + ustawienia z serwera producenta + typy wysyanych dokumentw,
</li>
</ul>
<BR><b>Nastpnie wywoujemy funkcje odczytu konfiguracji eDokumentw.</b><BR>
</td>
<td>
\code{.cpp}
TestLib::testERceiptCfg
\endcode
</td>
</tr>

<tr>
<td>Przykad programowania i odczytu konfiguracji dla eDokumentw - wersja rozszerzona</td>
<td>
<b>Aby zaprogramowa konfiguracj eDokumentw naley poda parametry:</b>
<ul>
<li>type - typ ustawie:
<BR>1 - programowanie adresu serwera,
<BR>2 - rozszerzone ustawienia eDokumentw,
<BR>3 - rozszerzone ustawienia eDokumentw z moliwoci wybrania typw wysyanych dokumentw,
</li>
<li>addres - adres serwera(ignorowane gdy typ 2)</li>
<li>encryption - szyfrowanie(ignorowane gdy typ 1):
<BR>0 - nie,
<BR>1 - tak,
<li>format - format danych(ignorowane gdy typ 1):
<BR>0 - Dane,
<BR>1 - Obraz + dane,
</li>
<li>protocol - protok(ignorowane gdy typ 1):
<BR>0 - NOVITUS,
<BR>1 - MF,
</li>
<li>key - klucz do komunikacji z serwerem(ignorowane gdy typ 1)</li>
<li>mode - tryb dziaania(wystpuje gdy typ 2 lub 3):
<BR>0 - drukuj i nie wysyaj,
<BR> 1 - nie drukuj i wylij,
<BR> 2 - drukuj i wylij,
<BR> 3 - zawsze drukuj i wylij.
</li>
<li>timeout - timeout oczekiwania na potwierdzenie z serwera(wystpuje gdy typ 2 lub 3)
</li>
<li>messageTimeout - timeout komunikatu o wysyce eDokumentu(wystpuje gdy typ 2 lub 3):
</li>
<li>checkConnection - flaga, czy sprawdza poaczenie z Internetem przed wysyk eDokumentu(wystpuje gdy typ 2 lub 3):
<BR>0 - nie sprawdza,
<BR> 1 - sprawdza,
</li>
<li>documentTypesAllowed - dopuszczane typy eDokumentw ustawiane bitowo(wystpuje gdy typ 3):
 <BR> 0x0001 - paragon,
<BR>  0x0002 - paragon anulowany,
<BR>  0x0004 - faktura,
<BR>  0x0008 - faktura anulowana,
<BR>  0x0010 - wydruk niefiskalny,
<BR>  0x0020 - rozliczenie opakowa.
</li>
</ul>
<BR><b>Nastpnie wywoujemy funkcje programowania konfiguracji eDokumentw.</b><BR>

<b>Aby odczyta konfiguracje eDokumentw, naley poda parametr:</b>
<ul>
<li>type - typ ustawie:
<BR>0 - podstawowe dane ustawie,
<BR>1 - rozszerzone dane ustawie,
<BR>2 - rozszerzone dane ustawie + ustawienia z serwera producenta,
<BR>3 - rozszerzone dane ustawie + ustawienia z serwera producenta + typy wysyanych dokumentw,
</li>
</ul>
<BR><b>Nastpnie wywoujemy funkcje odczytu konfiguracji eDokumentw.</b><BR>
</td>
<td>
\code{.cpp}
TestLib::testERceiptCfgEx
\endcode
</td>
</tr>

<tr>
<td>Przykad programowania cerytfikatu eDokumentw</td>
<td>
<b>Aby zaprogramowa konfiguracj eDokumentw naley poda parametry:</b>
<ul>
<li>certType - rodzaj certyfikatu:
 <BR> 1 - cacert.pem,
<BR>  2 - client3 cert.pem,
<BR>  3 - client3 key.pem,
<BR>  5 - eParagon certyfikat 1(format DER).
</li>
<li>totalDataSize - cakowity rozmiar danych w formacie binarnym,</li>
<li>dataOffset - offset danych w formacie hex,</li>
<li>data - dane w formacie hex,</li>
</ul>
<BR><b>Nastpnie wywoujemy funkcje programowania certyfikatu eDokumentw.</b><BR>
</td>
<td>
\code{.cpp}
TestLib::testEDocumentCertProgramming
\endcode
</td>
</tr>

<tr>
<td>Przykad programowania ustawien HUBa paragonowego MF</td>
<td>
<b>Aby zaprogramowa ustawienia HUBa paragonowego MF naley poda parametry:</b>
<ul>
<li>isSizeField - flaga informujca czy wystpuje pole rozmiar eParagonu,</li>
<li>isDocumentTypeField - flaga informujca czy wystpuje pole wysyane typy dokumentw,</li>
<li>address - adres serwera,</li>
<li>size - rozmiar,</li>
<li>eDocumentTypes - typy eDokumentw ustawiane bitowo:
 <BR> 0x0001 - paragon,
<BR>  0x0002 - paragon anulowany,
<BR>  0x0004 - faktura,
<BR>  0x0008 - faktura anulowana,
<BR>  0x0010 - wydruk niefiskalny,
<BR>  0x0020 - rozliczenie opakowa.
</li>
</ul>
<BR><b>Nastpnie wywoujemy funkcje programowania certyfikatu eDokumentw.</b><BR>
</td>
<td>
\code{.cpp}
TestLib::testSetEDocumentMfHubSettings
\endcode
</td>
</tr>


<tr>
<td>Przykad odczytu ustawien HUBa paragonowego MF</td>
<td>
<b>Aby odczyta ustawienia HUBa paragonowego MF naley wywoa funkcj dajc odesanie ustawie</b>
<b>Nastpnie wywoujemy funkcje odczytu ustawie.</b>

<b>Odczytujemy parametry:</b>
<ul>
<li>address - adres serwera,</li>
<li>size - rozmiar,</li>
<li>eDocumentTypes - typy eDokumentw ustawiane bitowo:
 <BR> 0x0001 - paragon,
<BR>  0x0002 - paragon anulowany,
<BR>  0x0004 - faktura,
<BR>  0x0008 - faktura anulowana,
<BR>  0x0010 - wydruk niefiskalny,
<BR>  0x0020 - rozliczenie opakowa.
</li>
</ul>
</td>
<td>
\code{.cpp}
TestLib::testReadEDocumentMfHubSettings
\endcode
</td>
</tr>

<tr>
<td>Przykad dodania id transakcji - eParagon - wersja podstawowa</td>
<td>
<b>Aby doda ID transakcji do eParagonu naley ustawi parametry:</b>

<ul>
<li>type - typ:
 <BR> brak - dodanie id transakcji,
<BR>  2 - kasowanie id transakcji,
<BR>  3 - rozszerzone id transakcji,
</li>
<li>data - id transakcji(ignorowane gdy typ 2),</li>
</li>
</ul>

<BR><b>Nastpnie wywoujemy funkcje dodajc id transakcji pomidzy rozpoczciem a zakoczeniem paragonu.</b><BR>

</td>
<td>
\code{.cpp}
TestLib::testERceipt
\endcode
</td>
</tr>


<tr>
<td>Przykad dodania id transakcji - eParagon - wersja rozszerzona</td>
<td>
<b>Aby doda ID transakcji do eParagonu naley ustawi parametry:</b>

<ul>
<li>type - typ:
<BR>  3 - rozszerzone id transakcji,
</li>
<li>isProtocol - Flaga informujca czy wystpuje pole protok.(wystpuje gdy typ 3),</li>
<li>isProtocol - Flaga informujca czy wystpuje pole tryb dziaania.(wystpuje gdy typ 3),</li>
<li>data - id transakcji,</li>
<li>protocol - protok(wystepuje gdy typ 3):
<BR>0 - NOVITUS,
<BR>1 - MF,
</li>
<li>mode - tryb dziaania(wystpuje gdy typ 3):
<BR>0 - drukuj i nie wysyaj,
<BR> 1 - nie drukuj i wylij,
<BR> 2 - drukuj i wylij,
<BR> 3 - zawsze drukuj i wylij.
</li>
</ul>

<BR><b>Nastpnie wywoujemy funkcje dodajc id transakcji pomidzy rozpoczciem a zakoczeniem paragonu.</b><BR>

</td>
<td>
\code{.cpp}
TestLib::testERceiptEx
\endcode
</td>
</tr>


<tr>
<td>Przykad dodania id transakcji w rozpoczciu wydruku niefiskalnego - wersja podstawowa</td>
<td>

<b>Aby rozpocz wydruk niefiskalny naley poda nastpujce parametry:</b>
<ul>
<li>printOutNumber - numer wydruku(Akceptowane numery wymienione s w specyfikacji wydrukw zamieszczonej w opisie protokou komunikacyjnego.)</li>
<li>headerNumber - numer nagwka (0, gdy wydruk ma tylko jeden rodzaj nagwka)</li>
<li>printOutOption - opcje wydruku, gdzie kolejne bity oznaczaj:
	<BR>	1: lewy margines na wydruku,
	<BR>	2: bez wydruku na papierze,
	<BR>	3: bez wydruku tekstu nagwka,
	<BR>	4: bez wydruku marginesw "NIEFISKALNY".
</li>
</ul>

<b>Aby doda ID transakcji w rozpoczciu wydruku niefiskalnego naley ustawi parametry:</b>
<ul>
<li>isIdTransaction - flaga informujca czy wystpuje pole id transakcji,</li>
<li>idTransaction - id transakcji,</li>
</ul>

<BR><b>Nastpnie wywoujemy funkcje rozpoczcia wydruku niefiskalnego.</b><BR>

</td>
<td>
\code{.cpp}
TestLib::nonFiscalPrintoutWithIdTransaction
\endcode
</td>
</tr>


<tr>
<td>Przykad dodania id transakcji w rozpoczciu wydruku niefiskalnego - wersja rozszerzona</td>
<td>

<b>Aby rozpocz wydruk niefiskalny naley poda nastpujce parametry:</b>
<ul>
<li>printOutNumber - numer wydruku(Akceptowane numery wymienione s w specyfikacji wydrukw zamieszczonej w opisie protokou komunikacyjnego.)</li>
<li>headerNumber - numer nagwka (0, gdy wydruk ma tylko jeden rodzaj nagwka)</li>
<li>printOutOption - opcje wydruku, gdzie kolejne bity oznaczaj:
	<BR>	1: lewy margines na wydruku,
	<BR>	2: bez wydruku na papierze,
	<BR>	3: bez wydruku tekstu nagwka,
	<BR>	4: bez wydruku marginesw "NIEFISKALNY".
</li>
</ul>

<b>Aby doda ID transakcji w rozpoczciu wydruku niefiskalnego naley ustawi parametry:</b>
<ul>
<li>isIdTransaction - flaga informujca czy wystpuje pole id transakcji,</li>
<li>protocol - protok:
<BR>0 lub pole nie wystpuje - domylny protok z konfiguracji,
<BR>1 - NOVITUS,
<BR>2 - MF,
</li>
<li>idTransaction - id transakcji,</li>
</ul>

<BR><b>Nastpnie wywoujemy funkcje rozpoczcia wydruku niefiskalnego.</b><BR>

</td>
<td>
\code{.cpp}
TestLib::nonFiscalPrintoutWithIdTransaction
\endcode
</td>
</tr>


<tr>
<td>Tryb wysyki eDokumentu w zakoczeniu wydruku niefiskalnego</td>
<td>

<b>Aby ustawi tryb wysyki eDokumentw w zakoczeniu wydruk niefiskalnego naley poda nastpujce parametry:</b>
<ul>
<li>isEDocumentSendMode -  0: NIE, 1: TAK</li>
<li>eDocumentSendMode - tryb wysyki eDokumentw, argument opcjonalny, pojawia si gdy pole 6 Wystpuje tryb wysyania eDokumentu jest na 1 - Tak. Przyjmuje wartoci:
 <BR> 0 - drukuj i nie wysyaj,
<BR>  1 - nie drukuj i wylij,
 <BR> 2 - drukuj i wylij,
<BR> 3 - zawsze drukuj i wylij.
</li>
</ul>

<BR><b>Nastpnie wywoujemy funkcje zakoczenia wydruku niefiskalnego.</b><BR>

</td>
<td>
\code{.cpp}
TestLib::nonFiscalPrintoutWithIdTransaction
\endcode
</td>
</tr>

<tr>
<td>Przykad odczytu informacji z bazy eDokumentw</td>
<td>
<b>Aby odczyta informacje z bazy eDokumentw naley poda nastpujce parametry:</b>

<ul>
<li>mode - tryb:
 <BR> 0 - ilo dokumentw w bazie,
<BR>  1 - pocztek odczytu,
<BR>  2 - kolejny rekord,
</li>
<li>protocol - protok:
<BR>0 - NOVITUS,
<BR>1 - MF,
<BR>2 - dowolny,
</li>
<li>status - status eDokumentu:
 <BR> 0 - oczekujcy na wysanie i nie wydrukowany,
<BR>  1 - oczekujcy na wysanie i wydrukowany,
<BR>  2 - odrzucony przez serwer i nie wydrukowany,
<BR>  3 - odrzucony przez serwer i wydrukowany,
<BR>  4 - oczekujcy na wysanie,
<BR>  5 - odrzucony przez serwer,
<BR>  6 - dowolny.
</li>
</ul>

<b>Wywoujemy zapytanie o informacje z bazy eDokumentw.</b>
<b>Nastpnie wywoujemy funkcje odczytu informacji z bazy eDokumentw.</b>

<b>Odczytujemy parametry:</b>
<ul>
<li>protocol - protok(wystpuje gdy tryb 0):
<BR>0 - NOVITUS,
<BR>1 - MF,
<BR>2 - dowolny,
</li>
<li>status - status eDokumentu(wystpuje gdy tryb 0):
 <BR> 0 - oczekujcy na wysanie i nie wydrukowany,
<BR>  1 - oczekujcy na wysanie i wydrukowany,
<BR>  2 - odrzucony przez serwer i nie wydrukowany,
<BR>  3 - odrzucony przez serwer i wydrukowany,
<BR>  4 - oczekujcy na wysanie,
<BR>  5 - odrzucony przez serwer,
<BR>  6 - dowolny.
</li>
<li>count - ilo dokumentw w bazie o danym protokole i statusie( wystepuje gdy tryb zero)</li>
<li>JPKID - JPKID dokumentu(wystepuje gdy tryb 0)</li>
</ul>
</td>
<td>
\code{.cpp}
TestLib::testReadEDocumentBaseInfo
\endcode
</td>
</tr>

<tr>
<td>Usuwanie odrzuconych eDokumentw z bazy</td>
<td>

<b>Aby Aby usunc odrzucony eDokument z bazy naley poda nastpujce parametr:</b>
<ul>
<li>JPKID - JPKID dokumentu ktry ma zosta usunity</li>
</ul>

<BR><b>Nastpnie wywoujemy funkcje usuwajc eDokument z bazy.</b><BR>

</td>
<td>
\code{.cpp}
TestLib::testRemoveEDocumentFromBase
\endcode
</td>
</tr>



<tr>
<td>Przykad programowania parametrw do generowania wizualizacji</td>
<td>
<b>Aby zaprogramowa parametry generowania wizualizacji, naley poda nastpujce parametry:</b>

<ul>
<li>strategy - strategia:
 <BR> 0 - Z_DEFAULT_STRATEGY,
<BR>  1 - Z FILTERED,
<BR>  2 - Z_HUFFMAN_ONLY,
<BR>  3 - Z RLE,
<BR>  4 - Z FIXED.
</li>
<li>compression - poziom kompresji:
<BR>-1 - Z_DEFAULT_COMPRESSION,
<BR>0 - Z_NO_COMPRESSION,
<BR>1 - Z_BEST_COMPRESSION.
</li>
<li>filter - filtrowanie:
 <BR> 0 - PNG_NO_FILTERS,
<BR>  1 - PNG_FILTER_NONE,
<BR>  2 - PNG_FILTER_SUB,
<BR>  3 - PNG FILTER_UP,
<BR>  4 - PNG FILTER AVG,
<BR>  5 - NG_FILTER_ PAETH,

</li>
</ul>

<b>Nastpnie wywoujemy funkcje programowania parametrw wizualizacji.</b>

</td>
<td>
\code{.cpp}
TestLib::testSetEDocumentVisualizationParams
\endcode
</td>
</tr>


<tr>
<td>Przykad odczytu parametrw do generowania wizualizacji</td>
<td>


<b>Wywoujemy zapytanie o parametry generowania wizualizacji, a nastpnie funkcje odczytu tych parametrw.</b>

<b>Odczytujemy nastpujce parametry:</b>

<ul>
<li>strategy - strategia:
 <BR> 0 - Z_DEFAULT_STRATEGY,
<BR>  1 - Z FILTERED,
<BR>  2 - Z_HUFFMAN_ONLY,
<BR>  3 - Z RLE,
<BR>  4 - Z FIXED.
</li>
<li>compression - poziom kompresji:
<BR>-1 - Z_DEFAULT_COMPRESSION,
<BR>0 - Z_NO_COMPRESSION,
<BR>1 - Z_BEST_COMPRESSION.
</li>
<li>filter - filtrowanie:
 <BR> 0 - PNG_NO_FILTERS,
<BR>  1 - PNG_FILTER_NONE,
<BR>  2 - PNG_FILTER_SUB,
<BR>  3 - PNG FILTER_UP,
<BR>  4 - PNG FILTER AVG,
<BR>  5 - NG_FILTER_ PAETH,

</li>
</ul>

</td>
<td>
\code{.cpp}
TestLib::testReadEDocumentVisualizationParams
\endcode
</td>
</tr>

</table>
</div>
*/

