package pl.novitus.androidexample;

import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;

import java.io.File;
import java.util.Calendar;

import pl.novitus.nfpdrv.*;

public class MainActivity extends AppCompatActivity {

    EditText ipText;
    EditText portText;
    Button runTest, receiptWithDiscount, report, login, cancel;

    protected int handle_error()
    {
        //obsługa błędów
        int result;
        do
        {
            result = jnfpdrv.ndrv_ioctrl(jnfpdrv.NDRV_COMPLETE_CHECK, null, 0, 0);

            if (result == 0)
                break; //paragon zakończony

            if (result != 0)
            {
                LastError lastError = new LastError();

                jnfpdrv.ndrv_get_last_error(lastError);
                try {
                    if (lastError.getDle().getIsPaperOut()==1)
                    {
                        //pokaż informację: brak papieru
                        Toast.makeText(this, "pokaż informację: brak papieru\n", Toast.LENGTH_LONG).show();
                        Thread.sleep(1000);
                    }
                    else if (lastError.getDle().getIsOnline() == 0)
                    {
                        //drukarka jest offline
                        Toast.makeText(this, "drukarka jest offline\n", Toast.LENGTH_LONG).show();
                        Thread.sleep(1000);
                    }
                    else if (lastError.getDle().getIsPrinterErr()==1)
                    {
                        //błąd mechanizmu drukującego
                        Toast.makeText(this, "błąd mechanizmu drukującego\n", Toast.LENGTH_LONG).show();
                        Thread.sleep(1000);
                    }
                    else if (lastError.getErrorCodeFromDevice() != 0)
                    {
                        Toast.makeText(this, lastError.getErrorDescriptionDevice(), Toast.LENGTH_LONG).show();

                        //anulujemy paragon
                        AbortTransaction abortTransaction = new AbortTransaction();
                        jnfpdrv.ndrv_ioctrl(jnfpdrv.NDRV_ABORT, abortTransaction, jnfpdrv.NDRV_LEN_IGNORE, 0);

                        return jnfpdrv.NDRV_ERROR;
                    }
                    else
                    {
                        Toast.makeText(this, "nieznany błąd\n", Toast.LENGTH_LONG).show();
                        //diagnostykę błędu należy przeprowadzić samodzielnie

                        AbortTransaction abortTransaction = new AbortTransaction() ;
                        jnfpdrv.ndrv_ioctrl(jnfpdrv.NDRV_ABORT, abortTransaction, jnfpdrv.NDRV_LEN_IGNORE, 0);

                        return jnfpdrv.NDRV_ERROR; //błąd nie otwarto paragonu - nie kontynuujemy
                    }

                }catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        } while (result != 0);
        return jnfpdrv.NDRV_OK;
    }
    protected int check_error()
    {
        LastError lastError = new LastError();

        //błąd otwarcia paragonu - nie kontynuujemy, pobieramy stan drukarki
        System.out.println("check_error\n");

        jnfpdrv.ndrv_ioctrl(jnfpdrv.NDRV_CHECK_STATUS, lastError, 0, jnfpdrv.NFLAGS_CHECK_STATUS);
        jnfpdrv.ndrv_get_last_error(lastError);
        try {
            if (lastError.getDle().getIsPaperOut()==1)
            {
                //pokaż informację: brak papieru
                Toast.makeText(this, "pokaż informację: brak papieru\n", Toast.LENGTH_LONG).show();
                System.out.println("pokaż informację: brak papieru\n");

                Thread.sleep(1000);
            }
            else if (lastError.getDle().getIsOnline() == 0)
            {
                //drukarka jest offline
                System.out.println("drukarka jest offline\n");
                Thread.sleep(1000);
            }
            else if (lastError.getDle().getIsPrinterErr()==1)
            {
                //błąd mechanizmu drukującego
                System.out.println("błąd mechanizmu drukującego\n");
                Thread.sleep(1000);
            }
            else if (lastError.getErrorCodeFromDevice() != 0)
            {
                System.out.println(lastError.getErrorDescriptionDevice());
            }
            else
            {
                System.out.println("nieznany błąd\n");
                //diagnostykę błędu należy przeprowadzić samodzielnie
            }

        }catch (InterruptedException e) {
            e.printStackTrace();
        }
        AbortTransaction abortTransaction = new AbortTransaction() ;
        jnfpdrv.ndrv_ioctrl(jnfpdrv.NDRV_ABORT, abortTransaction, jnfpdrv.NDRV_LEN_IGNORE, 0);

        return jnfpdrv.NDRV_ERROR; //błąd nie otwarto paragonu - nie kontynuujemy
    }

    protected int testNfPrn() {
        NonFiscalPrintout startPrint = new NonFiscalPrintout();

        startPrint.setPrintOutNumber(200);
        startPrint.setIdTransaction("1234567890");

        NonFiscalPrintout line1 = new NonFiscalPrintout();
        NonFiscalPrintout line2 = new NonFiscalPrintout();
        NonFiscalPrintout line3 = new NonFiscalPrintout();
        NonFiscalPrintout line4 = new NonFiscalPrintout();
        NonFiscalPrintout line5 = new NonFiscalPrintout();

        line1.setPrintOutNumber(200);
        line2.setPrintOutNumber(200);
        line3.setPrintOutNumber(200);
        line4.setPrintOutNumber(200);
        line5.setPrintOutNumber(200);

        line1.setLineNumber(0);
        line2.setLineNumber(0);
        line3.setLineNumber(254);
        line4.setLineNumber(255);
        line5.setLineNumber(253);

        line1.setLine1("Cześć Cześć Cześć Cześć Cześć Cześć Cześć Cześć Cześć Cześć ");
        line2.setLine1("ąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąą");

        NonFiscalPrintout endPrint = new NonFiscalPrintout();
        endPrint.setPrintOutNumber(200);
        endPrint.setIsEDocumentSendMode(1);
        endPrint.setProtocol(1);
        endPrint.setEDocumentSendMode(2);

        jnfpdrv.ndrv_ioctrl(jnfpdrv.NDRV_NONFISCAL_PRINTOUT_OPEN, startPrint, jnfpdrv.NDRV_LEN_IGNORE, 0);
        jnfpdrv.ndrv_ioctrl(jnfpdrv.NDRV_NONFISCAL_PRINTOUT_LINE, line1, jnfpdrv.NDRV_LEN_IGNORE, 0);
        jnfpdrv.ndrv_ioctrl(jnfpdrv.NDRV_NONFISCAL_PRINTOUT_LINE, line2, jnfpdrv.NDRV_LEN_IGNORE, 0);
        jnfpdrv.ndrv_ioctrl(jnfpdrv.NDRV_NONFISCAL_PRINTOUT_LINE, line3, jnfpdrv.NDRV_LEN_IGNORE, 0);
        jnfpdrv.ndrv_ioctrl(jnfpdrv.NDRV_NONFISCAL_PRINTOUT_LINE, line4, jnfpdrv.NDRV_LEN_IGNORE, 0);
        jnfpdrv.ndrv_ioctrl(jnfpdrv.NDRV_NONFISCAL_PRINTOUT_LINE, line5, jnfpdrv.NDRV_LEN_IGNORE, 0);
        jnfpdrv.ndrv_ioctrl(jnfpdrv.NDRV_NONFISCAL_PRINTOUT_CLOSE, endPrint, jnfpdrv.NDRV_LEN_IGNORE, 0);

        return jnfpdrv.NDRV_OK;
    }
    //Paragony
    protected int testRCP()
    {
        //Stworzenie obiektu  StartReceipt i ustawienie wartości pól dla rozpoczęcia paragonu;
        StartReceipt startReceipt = new StartReceipt();
        startReceipt.setNumberOfLines(0);
        startReceipt.setId("123-123-12-12");

        //Stworzenie obiektu  Item i ustawienie wartości pól dla pozycji paragonu;
        Item item = new Item();
        item.setNumberOfLine(1);
        item.setName("ąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąąą");
        item.setUnit("kg");
        item.setQtty("1.234");
        item.setPtu("A");
        item.setPrice(200);
        item.setBrutto(247);

        //Stworzenie obiektu EndReceipt i ustawienie wartości pól dla zakończenia paragonu;
        EndReceipt endReceipt = new EndReceipt();
        endReceipt.setAction(1);
        endReceipt.setTotal(247);
        endReceipt.setValue(300);

        //Ustawienie kodowania znaków pola tekstowego na UTF-8
        jnfpdrv.ndrv_ioctrl(jnfpdrv.NDRV_UTF_8, null, jnfpdrv.NDRV_LEN_IGNORE, 0);

        //Wysłanie rozpoczęcia paragonu;
        if(jnfpdrv.ndrv_ioctrl(jnfpdrv.NDRV_RCP_START, startReceipt,  jnfpdrv.NDRV_LEN_IGNORE, jnfpdrv.NFLAGS_CASH_CONTROL)==jnfpdrv.NDRV_ERROR)
        {
            //Obsługa błędów w rozpoczęciu paragonu. Przykładowy kod funkcji check_error() zajduje się w dokumentacji.
            check_error();
            return jnfpdrv.NDRV_ERROR;
        }
        //Wysłanie pozycji paragonu;
        jnfpdrv.ndrv_ioctrl(jnfpdrv.NDRV_RCP_ITEM, item, jnfpdrv.NDRV_LEN_IGNORE, 0);
        //Wysłanie zakończenia paragonu;
        if(jnfpdrv.ndrv_ioctrl(jnfpdrv.NDRV_RCP_END, endReceipt, jnfpdrv.NDRV_LEN_IGNORE, 0) == jnfpdrv.NDRV_ERROR)
        {
            //Obsługa błędów w zakończeniu paragonu. Przykładowy kod funkcji handle_error() zajduje się w dokumentacji.
            handle_error();
            return jnfpdrv.NDRV_ERROR;
        }

        return jnfpdrv.NDRV_OK;
    }


    protected int testRCPCancel()
    {
        AbortTransaction abort = new AbortTransaction();
        jnfpdrv.ndrv_ioctrl(jnfpdrv.NDRV_ABORT, abort,  jnfpdrvConstants.NDRV_LEN_IGNORE,  0);

        jnfpdrv.ndrv_close();
        return 0;
    }

    protected int testLogin()
    {
        Packet packetHdr = new Packet();
        //<ESC>P6#pAdministrator<CR>1<CR>admin<CR>92<ESC>\
        packetHdr.setPacketSend("6#pAdministrator\r1\radmin\r");
        packetHdr.setIsCrc(1);
        jnfpdrv.ndrv_ioctrl(jnfpdrv.NDRV_SEND_PACKET, packetHdr,  jnfpdrvConstants.NDRV_LEN_IGNORE,  0);
        jnfpdrv.ndrv_close();
        return 0;
    }




    protected int testReport()
    {

        DailyReport report = new DailyReport();
        Calendar cal = Calendar.getInstance();
        report.setDay(String.valueOf( cal.get(Calendar.DAY_OF_MONTH)));
        report.setMonth(String.valueOf( cal.get(Calendar.MONTH) + 1));
        report.setYear(String.valueOf( cal.get(Calendar.YEAR)- 2000));
        jnfpdrv.ndrv_ioctrl(jnfpdrv.NDRV_RUN_DAILY_REPORT, report, jnfpdrv.NDRV_LEN_IGNORE, 0);
        return 0;
    }

    protected int testRCPWithDiscount()
    {
        //Stworzenie obiektu  StartReceipt i ustawienie wartości pól dla rozpoczęcia paragonu;
        StartReceipt startReceipt = new StartReceipt();
        startReceipt.setNumberOfLines(0);
        startReceipt.setId("123-123-12-12");

        //Stworzenie obiektu  Item i ustawienie wartości pól dla pozycji paragonu;
        Item item = new Item();
        item.setNumberOfLine(1);
        item.setName("Sok");
        item.setUnit("szt.");
        item.setQtty("1");
        item.setPtu("A");
        item.setPrice(1000);
        item.setBrutto(1000); //10PLN
        item.setDiscount(100);
        item.setDiscountType(1);

        Payment paymentCard = new Payment();
        paymentCard.setAction(1);
        paymentCard.setName("EuroKarta");
        paymentCard.setPaymentMethod(1);
        paymentCard.setValue(1000);

        EndReceiptWithPaymentMethods2 endReceipt2 = new EndReceiptWithPaymentMethods2();
        endReceipt2.setEnd(1);
        endReceipt2.setTotal(900);
        endReceipt2.setPayment(1000);

        //Rodzaj rabatu:
        //0: brak,
        //1: rabat procentowy,
        //2: dopłata procentowa,
        //3: rabat kwotowy,
        //4: dopłata kwotowa,


        endReceipt2.setPaymentMethodType1(1);
        endReceipt2.setPaymentMethodName1("EuroKarta");

        //Ustawienie kodowania znaków pola tekstowego na UTF-8
        jnfpdrv.ndrv_ioctrl(jnfpdrv.NDRV_UTF_8, null, jnfpdrv.NDRV_LEN_IGNORE, 0);

        //Wysłanie rozpoczęcia paragonu;
        if(jnfpdrv.ndrv_ioctrl(jnfpdrv.NDRV_RCP_START, startReceipt,  jnfpdrv.NDRV_LEN_IGNORE, jnfpdrv.NFLAGS_CASH_CONTROL)==jnfpdrv.NDRV_ERROR)
        {
            //Obsługa błędów w rozpoczęciu paragonu. Przykładowy kod funkcji check_error() zajduje się w dokumentacji.
            //check_error();
            return jnfpdrv.NDRV_ERROR;
        }
        //Wysłanie pozycji paragonu;
        jnfpdrv.ndrv_ioctrl(jnfpdrv.NDRV_RCP_ITEM, item, jnfpdrv.NDRV_LEN_IGNORE, 0);
        jnfpdrv.ndrv_ioctrl(jnfpdrv.NDRV_RCP_PAYMENT,paymentCard, jnfpdrv.NDRV_LEN_IGNORE, 0);
        //Wysłanie zakończenia paragonu;
        if(jnfpdrv.ndrv_ioctrl(jnfpdrv.NDRV_RCP_END2, endReceipt2, jnfpdrv.NDRV_LEN_IGNORE, 0) == jnfpdrv.NDRV_ERROR)
        {
            //Obsługa błędów w zakończeniu paragonu. Przykładowy kod funkcji handle_error() zajduje się w dokumentacji.
            //handle_error();
            return jnfpdrv.NDRV_ERROR;
        }

        return jnfpdrv.NDRV_OK;

    }


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        ipText = findViewById(R.id.editTextIp);
        portText = findViewById(R.id.editTextPort);
        runTest = findViewById(R.id.buttonTest);
        receiptWithDiscount = findViewById(R.id.buttonTest2);
        report = findViewById(R.id.buttonTest3);
        login = findViewById(R.id.buttonTest4);
        cancel = findViewById(R.id.buttonTest5);


        //System.loadLibrary("hello-libs");
        System.loadLibrary("nfpdrv");
        System.loadLibrary("jnfpdrv");

        String root = getApplicationInfo().dataDir + "/log";
        try {

            File myDir = new File( root );
            if (!myDir.exists()) {
                 myDir.mkdirs();
            }

            jnfpdrv.ndrv_init(jnfpdrv.DEV_TYPE_PRN_ONLINE);
            jnfpdrv.ndrv_enable_log(root);
            //Ustawienie kodowania.
            jnfpdrv.ndrv_ioctrl(jnfpdrv.NDRV_UTF_8, null, 0, 0);

        } catch (Exception ex) {
            System.out.println(ex.getMessage());
        }

        runTest.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                if (jnfpdrv.ndrv_open_tcpip(ipText.getText().toString(), Integer.parseInt(portText.getText().toString())) == 0) {
                    System.out.println("Brak połączenia\n");
                    return;
                } else {

                    DLE2Status status = new DLE2Status();
                    jnfpdrv.ndrv_ioctrl(jnfpdrv.NDRV_SEND_DLE2, null, 0, 0);
                    jnfpdrv.ndrv_ioctrl(jnfpdrv.NDRV_READ_DLE2, status, 0,0);


                    System.out.println(status.getLastPrintoutNr() + "\n");


                    testRCP();
                    jnfpdrv.ndrv_close();
                }
            }
        });

        receiptWithDiscount.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (jnfpdrv.ndrv_open_tcpip(ipText.getText().toString(), Integer.parseInt(portText.getText().toString())) == 0) {
                    System.out.println("Brak połączenia\n");
                    return;
                } else {
                    testRCPWithDiscount();
                    jnfpdrv.ndrv_close();
                }
            }
        });

        report.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (jnfpdrv.ndrv_open_tcpip(ipText.getText().toString(), Integer.parseInt(portText.getText().toString())) == 0) {
                    System.out.println("Brak połączenia\n");
                    return;
                } else {
                    testReport();
                    jnfpdrv.ndrv_close();
                }
            }
        });

        login.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (jnfpdrv.ndrv_open_tcpip(ipText.getText().toString(), Integer.parseInt(portText.getText().toString())) == 0) {
                    System.out.println("Brak połączenia\n");
                    return;
                } else {
                    testLogin();
                    jnfpdrv.ndrv_close();
                }
            }
        });

        cancel.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (jnfpdrv.ndrv_open_tcpip(ipText.getText().toString(), Integer.parseInt(portText.getText().toString())) == 0) {
                    System.out.println("Brak połączenia\n");
                    return;
                } else {
                    testRCPCancel();
                    jnfpdrv.ndrv_close();
                }
            }
        });

    }
}
