#ifndef C_PROG_DATAFORMAT_H
#define C_PROG_DATAFORMAT_H

#if defined _WIN32 || defined _WIN64
#ifdef API_EXPORTS  
#define DLLEXPORT __declspec(dllexport)  
#define EXPIMP_TEMPLATE
#else  
#define DLLEXPORT __declspec(dllimport)
#define EXPIMP_TEMPLATE extern
#endif 
#else
#define DLLEXPORT
#endif

#include <string>
#include <list>
#include "DataFormat.h"
#include "GeneralEnumeration.h" 
#include "RecordField.h"


using namespace std; 

namespace CipherLab
{
	namespace DataConverter
	{
		class  CProgDataFormat : public DataFormat
		{
		private:
			int MinFieldPosition;
			int MaxFieldPosition;
			int MinFieldLength;
			int MaxFieldLength;
			int MaxRecordField;
			int MaxDbfName; 

			void init(string path, const char* dbfFileName, char delimiter); 
		public: 
			const char* DbfFileName; 
			DLLEXPORT CProgDataFormat(); 
			DLLEXPORT CProgDataFormat(const char* path, const char* dbfFileName); 
			DLLEXPORT CProgDataFormat(const char* path, const char* dbfFileName, char delimiter); 
			DLLEXPORT ~CProgDataFormat(){}
		};
	}
}
#endif
