#ifndef CONVERSIONRESULT_H
#define CONVERSIONRESULT_H

#if defined _WIN32 || defined _WIN64
#ifdef API_EXPORTS
#define DLLEXPORT __declspec(dllexport)
#define EXPIMP_TEMPLATE
#else
#define DLLEXPORT __declspec(dllimport)
#define EXPIMP_TEMPLATE extern
#endif
#else
#define DLLEXPORT
#endif

#include "GeneralEnumeration.h"
#include "ErrorRecord.h"
#include <iostream>
#include <vector>
#include <list>
#include <string>

using namespace std;



namespace CipherLab
{
	namespace DataConverter
	{
        #if defined _WIN32 || defined _WIN64
		EXPIMP_TEMPLATE template class DLLEXPORT std::vector<ErrorRecord>;
		EXPIMP_TEMPLATE template class DLLEXPORT std::vector<string>;
		#endif
		class DLLEXPORT ConversionResult
		{
		public:
			ConversionStatus status;

			static std::vector<ErrorRecord> errorRecordList;
			/*DLLEXPORT*/ ErrorRecord getErrorRecord(int index);
			/*DLLEXPORT*/ int getNumberOfErrorRecords() { return errorRecordList.size(); }

			static std::vector<string> outputFilePaths;
			/*DLLEXPORT*/ const char* getOutputFilePaths(int index);
			/*DLLEXPORT*/ int getNumberOfOutputFiles();

			/*DLLEXPORT*/ ConversionResult();
			/*DLLEXPORT*/ ~ConversionResult();
		};
	}
}
#endif
