::    @ZZ_VER   = 1.00

@echo off


::=============================================
:: 1.zz                     (No parms)
::
::   Use default LinkFile & default FileName
::
::  [default FileName]:User
::  [default LinkFile]:User.ld
::---------------------------------------------
set LinkFile=User.ld
set FileName=User

::=============================================
:: 2.zz [parms1][parms2]        (have parms)    
::   
::   User define [parms1]:LinkFile
::               [parms2]:FileName   
::---------------------------------------------
if {%1} == {} goto noparms1
set LinkFile=%1

:noparms1
if {%2} == {} goto noparms2
set FileName=%2

:noparms2

::==============================================
::      Clear
::----------------------------------------------
if exist %FileName%.elf del %FileName%.elf
if exist %FileName%.Map del %FileName%.Map
if exist %FileName%.SHX del %FileName%.SHX




::==============================================
:: 1. find machine type
:: %ERRORLEVEL% = 0 , found
::----------------------------------------------
set M_type=" "

:: 8600
findstr /i "8600lib" "%LinkFile%" >nul
if %ERRORLEVEL% == 0 (
    arm-none-eabi-ar -t "%GHOME%\lib\8600lib.a" >"%GHOME%\lib\8600VER.txt"    
    set M_type="%GHOME%\lib\8600VER.txt"
)

::==============================================
::      LINK information
::---------------------------------------------- 
echo Process...
echo.
echo ===== LINK INFO =====

for /f "delims=. tokens=1" %%i in ('findstr "LIB_VER" %M_type%') do echo %%i 
if exist %M_type% del %M_type%
type "%GHOME%\arm-none-eabi\include\INC.txt"
for /f "delims=@ tokens=2" %%i in ('findstr "XX_VER" "%GHOME%\bin\xx.bat"') do echo %%i 
for /f "delims=@ tokens=2" %%i in ('findstr "YY_VER" "%GHOME%\bin\yy.bat"') do echo %%i 
for /f "eol=f delims=@ tokens=2" %%i in ('findstr "ZZ_VER" "%GHOME%\bin\zz.bat"') do echo %%i 

for /f "delims=* tokens=2" %%i in ('findstr "LD_VER" "%LinkFile%"') do echo %%i 

findstr "LD_VER" "%LinkFile%" > nul
if %ERRORLEVEL% == 1 (
    for /f "delims=* tokens=2" %%i in ('findstr "LINK_VER" "%LinkFile%"') do echo %%i 
)
echo =====================



::==============================================
::      LINK START
::---------------------------------------------- 
echo [ Build ELF ]
:: @echo on -print-search-dirs
arm-none-eabi-gcc  -T"%LinkFile%" -Xlinker --gc-sections -Wl,-Map,%FileName%.map -mcpu=cortex-m3 -mthumb -I"%GHOME%\include" -L"%GHOME%\lib" -o"%FileName%.elf"

if exist %FileName%.elf goto Link_success
echo ***** Link	Error, Try Again *****
pause
goto end

:Link_success
::==============================================
::      Translate ELF to BIN
::---------------------------------------------- 
arm-none-eabi-objcopy -O binary %FileName%.elf "%FileName%.bin"
arm-none-eabi-objdump -h -S %FileName%.elf >"%FileName%.lst"

::==============================================
::      Translate BIN to SHX
::      bin2shxN  [start_addr] [Input] [Output]
::---------------------------------------------- 
echo [ Translate SHX ]
BINtoSHX 0x14440000   %FileName%.bin %FileName%.SHX

del %FileName%.bin
del %FileName%.elf


:end