#ifndef PROGRESSCALLBACK_H
#define PROGRESSCALLBACK_H

#if defined _WIN32 || defined _WIN64
#ifdef API_EXPORTS  
#define DLLEXPORT __declspec(dllexport)  
#else  
#define DLLEXPORT __declspec(dllimport)  
#endif  
#else
#define DLLEXPORT
#endif

#include "GeneralEnumeration.h"
#include <string>

using namespace std; 

namespace CipherLab
{
	namespace DataConverter
	{
		class ProgressCallBack
		{
			typedef void (*CBFun)(float k, int recordCount, const char* status); 
			CBFun pCBFun; 		
		public:
			DLLEXPORT ProgressCallBack(void);
			DLLEXPORT void SetCallBack(CBFun fun);
			void reportProgress(float k, int recordCount, const char* status);
		};
	}
}

#endif