#ifndef FORGEAG_DATAFORMAT_H
#define FORGEAG_DATAFORMAT_H

#if defined _WIN32 || defined _WIN64
#ifdef API_EXPORTS  
#define DLLEXPORT __declspec(dllexport)  
#else  
#define DLLEXPORT __declspec(dllimport)
#endif 
#else
#define DLLEXPORT
#endif

#define MaxAGXLookup 3
#define FORGE_MAX_FIELDS 12

#include <string>
#include "DataFormat.h"
#include "GeneralEnumeration.h" 
#include "RecordField.h"


using namespace std; 

namespace CipherLab
{
	namespace DataConverter
	{

		class ForgeAgProgDataFormat : public DataFormat
		{
		private: 
			int MinFieldPosition; 
			int MaxFieldPosition;
			int MinFieldLength;	
			int MaxFieldLength;
			int MaxRecordField;  //for 8600 series => MaxRecordField = 12; 

			void init(string path, ForgeAgProgDbfFileName dbfFileName, char delimiter); 

		public: 
			ForgeAgProgDbfFileName DbfFileName;
			WrongFormatAction actionTakenWhenFormatIsWrong;
			DLLEXPORT int getKeyIndex(); 
			DLLEXPORT RecordField getKeyRecordField(); 
			DLLEXPORT void AddRecordField(RecordField recordField); 
			DLLEXPORT ForgeAgProgDataFormat(); 
			DLLEXPORT ForgeAgProgDataFormat(const char* path, ForgeAgProgDbfFileName dbfFileName); 
			DLLEXPORT ForgeAgProgDataFormat(const char* path, ForgeAgProgDbfFileName dbfFileName, char delimiter);
			DLLEXPORT ~ForgeAgProgDataFormat(){}
		}; 

	}
}

#endif