#ifndef BASIC_PROG_DATAFORMAT_H
#define BASIC_PROG_DATAFORMAT_H

#if defined _WIN32 || defined _WIN64
	#ifdef API_EXPORTS  
	#define DLLEXPORT __declspec(dllexport)  
	#else  
	#define DLLEXPORT __declspec(dllimport)
	#endif 
#else
#define DLLEXPORT
#endif

#define MaxAGXLookup 3
#define FORGE_MAX_FIELDS 12

#include <string>
#include <list>
#include "DataFormat.h"
#include "GeneralEnumeration.h" 
#include "RecordField.h"


using namespace std; 

namespace CipherLab
{
	namespace DataConverter
	{
	class  BasicProgDataFormat : public DataFormat
	{
	private:
        int MinFieldPosition;
        int MaxFieldPosition;
        int MinFieldLength;
        int MaxFieldLength;
        int MaxRecordField;

		void init(string path, BasicProgDbfFileName dbfFileName, char delimiter); 

	public: 
		BasicProgDbfFileName DbfFileName; 
		DLLEXPORT BasicProgDataFormat(); 
		DLLEXPORT BasicProgDataFormat(const char* path, BasicProgDbfFileName dbfFileName); 
		DLLEXPORT BasicProgDataFormat(const char* path, BasicProgDbfFileName dbfFileName, char delimiter); 
		DLLEXPORT ~BasicProgDataFormat(){}
	};
}
}
#endif
