#ifndef DBF2TXTCONVERTER_H
#define DBF2TXTCONVERTER_H

#if defined _WIN32 || defined _WIN64
#ifdef API_EXPORTS  
#define DLLEXPORT __declspec(dllexport)  
#else  
#define DLLEXPORT __declspec(dllimport)
#endif 
#include <windows.h>
#include <tchar.h>
#include <strsafe.h>
#else
#define DLLEXPORT
#include <pthread.h>
#endif

#include "GeneralEnumeration.h"
#include "ProgressCallBack.h"
#include "ConversionResult.h"
#include <string>

using namespace std;

namespace CipherLab
{
	namespace DataConverter
	{
		class Dbf2TxtConverter
		{
		private:
			ProgrammingTool tool;
			const char* source;
			const char* target;
			ProgressCallBack* cbPtr;
		public:
			ConversionResult* result;
			DLLEXPORT Dbf2TxtConverter(ProgrammingTool tool,  const char* source, const char* target);
			DLLEXPORT void Convert(ProgressCallBack* cbPtr);
#if defined _WIN32 || defined _WIN64
			HANDLE  hThread;
			bool isCancel;
			DLLEXPORT void ConvertAsync(ProgressCallBack* cb);
			DLLEXPORT void CancelAsync();
			void DoConvertAsyncWork();
#else
			pthread_t thread;
			pthread_attr_t attr;

			bool isCancel;
			DLLEXPORT void ConvertAsync(ProgressCallBack* cbPtr);
			DLLEXPORT void CancelAsync();
			void *DoConvertAsyncWork();			
#endif


		};
	}
}
#endif
